/*
  Symbol.C
  
  Symbols, Macros and that's all.
  Uros Platise, dec. 1998
*/

#ifdef WIN32
#pragma warning( disable : 4786)
#endif
#include "Preproc.h"
#include "Lexer.h"
#include "Syntax.h"
#include "Segment.h"
#include "Symbol.h"
#include "Reports.h"
#include "Object.h"

#define stRec (*symI).second

bool TSymbol::addMacro(){
  TSymbolRec tmpRec;
  string macroName;
  parseFlags(&tmpRec,TlxData::STRING);
  if (archp()){
    if (archp->is_Arch()){
      throw syntax_error("Instruction cannot be a macro: ", lxP->string);
    }
  }
  macroName=lxP->string; parseMacro(&tmpRec);
  if (tmpRec.attr()!=TSymbolRec::Extern){
    tmpRec.segNo=segment.getSegNo();
  }    
  if (test(&tmpRec,macroName)==Define){storeSym(&tmpRec, macroName);}
  if (macroName[0]=='_' && macroName[1]=='_'){return true;}
  return false;
}

void TSymbol::addMacro(const char* macroName, const char* label,
                       TSymbolRec::TAttr macro_attr){
  if (label==NULL){label=macroName;}
  TSymbolRec tmpRec;
  tmpRec.attr(macro_attr);
  tmpRec.label=false; 
  tmpRec.internal=false;
  tmpRec.macro=label;
  if (tmpRec.attr()!=TSymbolRec::Extern){
    tmpRec.segNo=segment.getSegNo();
  }  
  if (test(&tmpRec,macroName)==Define){storeSym(&tmpRec, macroName);}
}

int TSymbol::addLabel(){
  TSymbolRec tmpRec;
  string labelName;
  char buf[128]; 	/* buf is used below by the getPC() */
  PUT_TOKENBACK;	/* parseFlags routine immediately calls GET_TOKEN */
  
  parseFlags(&tmpRec,TlxData::LABEL);
  if (archp()){
    if (archp->is_Arch()){
      throw syntax_error("Instruction cannot be a label: ", lxP->string);
    }
  }        
  labelName=lxP->string; tmpRec.label=true;
  
  if (tmpRec.attr()!=TSymbolRec::Extern){
    tmpRec.macro=segment.getPC(buf);
    tmpRec.segNo=segment.getSegNo();
  }else{tmpRec.macro=labelName;}
  
  if (test(&tmpRec,labelName)==Define){storeSym(&tmpRec, labelName);}
  return 1;
}

/*
  AVA Internal Labels are intented for segment purposes.
  These labels are always marked external, since linker defines
  them later and are never put into object file.
  
  Special flag protected disallaws modifying the value from
  the assembler source.
*/
void TSymbol::addInternalLabel(const char* macroName, const char* label){
  if (label==NULL){label=macroName;}
  TSymbolRec tmpRec;
  tmpRec.attr(TSymbolRec::Extern);
  tmpRec.label=true; 
  tmpRec.internal=true;
  tmpRec.macro=label;
  test(&tmpRec,macroName);
  sym[label]=tmpRec;
}

/* 
  TODO: combine storySym and test functions into single - readable 
        function.
*/	
/* if sym is already present, updates refs and then store it. */
void TSymbol::storeSym(TSymbolRec* tmpRec, const string& macroName){
  TsymI symI;
  if ((symI=sym.find(macroName))!=sym.end()){
    if (tmpRec->attr() & TSymbolRec::Extern){
      if ((*symI).second.attr() & TSymbolRec::Extern){
/*      
        printf("storeSym(%s): MergeDep\n", macroName.c_str());
	tmpRec->dep->Print(5);
*/	
        MergeDependencies(&(*symI).second, tmpRec);
      } else {
/*      
        fprintf(stderr, 
	 "storeSym(%s): segment.MergeDep\nupdating segment: %s\n", 
	  macroName.c_str(), segment.TellSegmentName((*symI).second.segNo));
	tmpRec->dep->Print(5);
*/	
        segment.MergeDep((*symI).second.segNo, *tmpRec->dep);
      }
    } else {
      /* If new symbol is not extern anymore, update segment dep first
         before they are overwritten by the new "tmpRec" 
      */
/*      
      printf("else { ... storeSym(%s): MergeDep\n", macroName.c_str()); 
      printf("segment.MergeDep(%d)\n",tmpRec->segNo);
*/      
      segment.MergeDep(tmpRec->segNo, *(*symI).second.dep);
      
      /* update settings, clear dep map if symbol is not extern anymore */
      (*symI).second = *tmpRec;      
    }
    
    if (stRec.attr()&TSymbolRec::Virtual){
      /* override current but keep existing segment dep. pointer */
      tmpRec->dep = stRec.dep;
      stRec = *tmpRec;
    }
    
  } else{   
    /* Add New! */
    sym[macroName] = *tmpRec;
  }  
}

void TSymbol::MergeDependencies(TSymbolRec* dest, TSymbolRec* src){
  assert(src->dep()!=NULL);
  if (dest->dep() != NULL){dest->dep->Merge(*src->dep);}
}

void TSymbol::SetAllExternVirtualDependencies(){
  TsymCI symI;
  /* export public, extern with deps and extern virtual */
  for (symI=sym.begin(); symI != sym.end(); symI++){   
    if (stRec.attr()==(TSymbolRec::Extern | TSymbolRec::Virtual)){
/*	
      printf("updating: %s\n", (*symI).first.c_str());
      stRec.dep->Print(5);
*/      
      segment.MergeDep(stRec.segNo, *stRec.dep);
    }
  }  
}

void TSymbol::modifyValue(const char* macroName, const char* macroString){
  TsymI symI;
  if ((symI=sym.find(macroName))==sym.end()){
    throw syntax_error("Label is not defined: ", macroName);}
  (*symI).second.macro = macroString; 
}

bool TSymbol::ifexpr(){
  GiveUndefinedSymVal(true);
  lexer.gettoken();
  syntax.Parse_GAS();
  GiveUndefinedSymVal(false);
  if (gas.status!=TGAS::Solved){
    throw syntax_error("Bad format: ", gas.eqstr);}
  return gas.result()>0;
}

bool TSymbol::ifdef(){
  lexer._gettoken();
  if (lxP->type!=TlxData::STRING){
    throw syntax_error("Bad format: ", lxP->string);}
  return findMacro(lxP->string)!=NULL;
}

string* TSymbol::findMacro(const string& macroName){
  TsymI symI;
  if ((symI=sym.find(macroName))==sym.end()){return NULL;}
  return &(*symI).second.macro;
}

/*
  Ask if macro (macro_name) is defined with (macro_str).
  Returns true if macro in the database with the same macro_str exists.
*/  
bool TSymbol::QueryMacro(const string& macro_name, const string& macro_str){
  string* strp;
  if ((strp=findMacro(macro_name))!=NULL){
    if (*strp==macro_str){return true;}
  }
  return false;
}

/*
  Compare with number.
*/
bool TSymbol::QueryMacro(const string& macro_name, long val){
  string* strp;
  if ((strp=findMacro(macro_name))!=NULL){
    if (strtol((*strp).c_str(), NULL, 0)==val){return true;}
  }
  return false;
}

void TSymbol::undefine(){
  lexer._gettoken();
  if (lxP->type!=TlxData::STRING){
    throw syntax_error("Invalid macro declaration.");}
  undefine(lxP->string);
}

void TSymbol::undefine(const string& macroName){
  TsymI symI;
  if ((symI=sym.find(macroName))==sym.end()){
    throw syntax_error("Cannot erase macro that is not defined: ", 
                       macroName.c_str());}
  sym.erase(symI);
}

int TSymbol::Replace2Zero(){
  if (undefEqZero==false){return 0;}
  TMemBlock* macroSource = new TMemBlock;
  macroSource->append("0");
  preproc.insert(macroSource);
  return 1;
}

int TSymbol::replaceWithMacro(){
  TsymI symI;
  char macroName [LX_STRLEN], macro [LX_LINEBUF];
  char buf [LX_LINEBUF];
  int psi_chk=0;
  int parethLevel;		/* i.e.: ((( ... ))) */
  TMacroParam mps;
  
  /* SPECIAL CASE: for #ifdef parser, all undefined macros should return
     zero; this is handled by the second if clause! 
     
     Exceptions to which zero is assigned too:
       * labels
  */ 
  if (lxP->type!=TlxData::STRING){return 0;}
  if ((symI=sym.find(lxP->string))==sym.end()){return Replace2Zero();}
  if ((*symI).second.label==true && undefEqZero==true){return Replace2Zero();}
    
  strcpy(macroName, lxP->string);
  strcpy(macro,     (*symI).second.macro.c_str());
  psi_chk     =     (*symI).second.noArgs;

  /* -----------------------------------------------------------------------
     (Macros are used only durring PASS1, otherwise produce ERROR!)
     Further test showed up that macros can be used in both passes, 1 and 2!
     -----------------------------------------------------------------------          
TODO:  
     Add error report on every unknown symbol to replace seeking for 
     undefined symbol in Object.C::obj2exe() 
   
  if (HaltOnMacro==true && (*symI).second.label==false &&
      avasta.operation==TAVAStatus::LINKING_PASS1){
    if ((*symI).second.attr()&TSymbolRec::Extern){
      throw syntax_error("Undefined symbol: ", macroName);}
    else{
      throw syntax_error("Macro should be declared before it is used: ",
        macroName);
    }   
  }
  */
    
  /* Segment Dependencies:
  
       * non-extern symbols update segment's depmap directly
       
       * extern symbols update their _own_ _symbol_ segmap list
         which is read and processed by the linker.
	 
       * extern virtual symbols are treated the same as extern, 
         what enables later updates by the linker. 
  
     Not internal Extern macros should tell the system that macro 
     is present - but string is not replaced 
  */
  if (((*symI).second.attr() & TSymbolRec::Extern) && 
      !((*symI).second.internal) && psi_chk==0){
    lxP->macro=true;
    //printf("symDep: %s (seg=%d)\n", macroName, segment.getSegNo());
    (*symI).second.dep->Add(segment.getSegNo());
    return 0;
  } else {
    //printf("segDep: %s (seg=%d)\n", macroName, segment.getSegNo());
    if (avasta.IsAssembling()){
      segment.AddDep(segment.getSegNo(), (*symI).second.segNo);
    }
  }

  /* SPECIAL CASE: if macroname equals macro, skip it */
  if (strcmp(macro,macroName)==0 && psi_chk==0){lxP->macro=true;return 0;}

  /* check for parameters in form (A0+B0+C0+...+n0,A1+B1+C1+...+n1,...) 
     where A,B and C may MATH, STRING and LVAL */
  if (psi_chk>0){
    lexer._gettoken();
    if (lxP->type==TlxData::CONTROL && lxP->string[0]=='('){
      while(lexer._gettoken()){
        /* load parameter string terminated by a >new line<, #, THEEND
	   NEWLINE or CONTROL ... except ( and ) */
        buf[0]=parethLevel=0;
	do{
          if (lxP->type==TlxData::PREPROC || lxP->type==TlxData::THEEND){break;}
          if (lxP->type==TlxData::NEWLINE){continue;}
	  if (lxP->type==TlxData::CONTROL){	    
	    if (lxP->string[0]=='('){parethLevel++;}
	    else if (lxP->string[0]==')'){
	      if (parethLevel==0){break;}	/* end of parameters */
	      parethLevel--;
	    }else{break;}	/* if none of above CONTROL ch is found */
	  }
          strcat(buf,lxP->string);
        }while(lexer._gettoken());

        if (buf[0]==0){throw syntax_error("Parameter is expected.");}      
        mps.Add(buf);
        if (lxP->type==TlxData::CONTROL && lxP->string[0]==')'){break;}
        if (lxP->type!=TlxData::CONTROL || lxP->string[0]!=','){
         throw syntax_error("Invalid delimiter after parameter: ",lxP->string);}
      } 
    }
    if (psi_chk!=mps.Psi()){throw syntax_error("Invalid parameter count.");}
    mps.ReplaceAll(macro);
  }
 
  TMemBlock* macroSource = new TMemBlock;
  macroSource->append(macro);
  preproc.insert(macroSource);
  return 1;
}

/*
  Error Table tests attributes of stored and new (template) symbol.
  Template symbol is represented in rows and stored symbol in columns.
*/
TSymbol::TOperation TSymbol::ErrorTable[16] = {
	Define,	Define,	Define,	Error1,
	Define,	Common,	Error2,	Error2,
	Define,	Define,	Define,	Error1,
	Error1,	Define,	Error1,	Define
};

TSymbol::TOperation TSymbol::test(TSymbolRec* pRec, const string& macroName){
  TsymI symI;
  /* Calculate offset for error check table */
  pRec->tbl_offset = pRec->attr();
  if (pRec->attr() & TSymbolRec::Extern && pRec->attr() & TSymbolRec::Virtual){
    pRec->tbl_offset-=2;}
  pRec->tbl_offset--;
  
  if ((symI=sym.find(macroName))==sym.end()){return Define;}

  if ((stRec.internal==true)^(pRec->internal==true)){
    throw syntax_error("Source contains symbols that are used by segments: ",
      macroName.c_str());
  }
  int opRes;
  if (stRec.attr()&TSymbolRec::Virtual){
    reports.Warnning(TReports::Symbols,
      "Virtual symbol `%s' is assigned new value.",macroName.c_str());
  }    
  if (stRec.attr()==TSymbolRec::Internal){
    throw syntax_error("Symbol already defined: ",macroName.c_str());}
  if (pRec->attr()==TSymbolRec::Internal){
    if (stRec.attr()==TSymbolRec::Virtual ||
        stRec.attr()==TSymbolRec::Extern){return Define;}
    else{opRes=Error1;}
  }else{opRes = ErrorTable[pRec->tbl_offset+(stRec.tbl_offset<<2)];}
  
  /* Test func() already handles the following cases */
  switch(opRes){
  case Common:
    if (stRec.macro != pRec->macro){
      reports.Warnning(TReports::Symbols,
        "Previously declared symbol `%s' as `%s'\n"
        "         is now redefined to `%s'", 
	macroName.c_str(), stRec.macro.c_str(), pRec->macro.c_str());
      throw syntax_error("Symbol already defined: ", macroName.c_str());
    }
    break;      
  case Error1:
    throw syntax_error("Attributes missmatch with"
                       " previously declared symbol: ",macroName.c_str());
  case Error2:
    throw syntax_error("Symbol already defined: ",macroName.c_str());
  }
  return (TSymbol::TOperation)opRes;
}

/* returns macro name in lxP->string */ 
void TSymbol::parseFlags(TSymbolRec* pRec, int terminator_type){
  while(lexer._gettoken()){    
    if (lxP->type!=TlxData::STRING && lxP->type!=terminator_type){
      throw syntax_error("Invalid macro declaration.");}
      
    if (strcmp(lxP->string,"extern")==0){pRec->attr_add(TSymbolRec::Extern);}
    else if (strcmp(lxP->string,"public")==0){
      pRec->attr_add(TSymbolRec::Public);
    }
    else if (strcmp(lxP->string,"virtual")==0){
      pRec->attr_add(TSymbolRec::Virtual);
    }
    else if (strcmp(lxP->string,"ref")==0){parseReference(pRec);}
    else if (lxP->type==terminator_type){break;}
    else{
      /* if label own attributes, listed just before, : is not
         needed - otherwise semicolon : is required. */
      if (terminator_type==TlxData::LABEL){
        if (pRec->attr()==0){
          throw syntax_error("Semicolon : is missing after label: ",
	                      lxP->string);}
        break; 
      }else{throw syntax_error("Invalid macro attribute.");}
    }
  }
  /* check relations between flags */
  if (pRec->attr()==0||
      pRec->attr()==TSymbolRec::Extern||
      pRec->attr()==TSymbolRec::Public||
      pRec->attr()==TSymbolRec::Virtual||
      (pRec->attr()&TSymbolRec::Extern && pRec->attr()&TSymbolRec::Virtual)){
    return;}    
  throw syntax_error("Symbol attributes are excluding each other.");
}

void TSymbol::parseMacro(TSymbolRec* pRec){
  bool newLineExpected=false;		/* if macro is extended with \ */
  TMacroParam mps;
  
  /* check for parameters in form (a0,a1,...,an) */
  lexer._gettoken();
  if (lxP->type==TlxData::CONTROL && lxP->string[0]=='(' && lxdata.stick){
    while(lexer._gettoken()){
      while (lxP->type==TlxData::NEWLINE){lexer._gettoken();}
      if (lxP->type!=TlxData::STRING){
        throw syntax_error("Parameter is expected.");
      }
      mps.Add(lxP->string);
      lexer._gettoken();
      while (lxP->type==TlxData::NEWLINE){lexer._gettoken();}      
      if (lxP->type==TlxData::CONTROL && lxP->string[0]==')'){break;}
      if (lxP->type!=TlxData::CONTROL || lxP->string[0]!=','){
        throw syntax_error("Invalid delimiter after macro parameter: ",
                           lxP->string);
      }
    } 
  }else{PUT_TOKENBACK;}
  pRec->noArgs = mps.Psi();

  /* load macro string terminated by a new line, # or THEEND */  
  while(lexer.gettoken()){
    if (lxP->type==TlxData::PREPROC || lxP->type==TlxData::THEEND){break;}
    if (lxP->type==TlxData::NEWLINE){
      if (newLineExpected==true){newLineExpected=false;}else{break;}}
    if (lxP->type==TlxData::CONTROL && lxP->string[0]=='\\'){
      newLineExpected=true;continue;
    }      
    mps.Replace(lxP->string);
    
    if (lxP->type==TlxData::QSTRING){
      pRec->macro = pRec->macro + '"' + lxP->string + '"';
    } 
    else if (lxP->type==TlxData::STRING){
      if (pRec->macro.size()>0){pRec->macro += ' ';}
      pRec->macro = pRec->macro + lxP->string + ' ';
    }
    else if (lxP->type==TlxData::LABEL){
      if (pRec->macro.size()>0){pRec->macro += ' ';}
      pRec->macro = pRec->macro + lxP->string + ": ";    
    }
    else{pRec->macro = pRec->macro + lxP->string;}
  }
  /* add default value 1 */
  if (pRec->macro.size()==0){pRec->macro="1";}
}

void TSymbol::reparseMacro(TSymbolRec* pRec){
  /* load macro string terminated by a new line, # or THEEND */
  while(lexer.gettoken()){
    if (lxP->type==TlxData::PREPROC || lxP->type==TlxData::THEEND){break;}
    if (lxP->type==TlxData::QSTRING){
      pRec->macro = pRec->macro + '"' + lxP->string + '"';
    }else{pRec->macro = pRec->macro + lxP->string + ' ';}
  }
}

void TSymbol::parseReference(TSymbolRec* pRec){
  /* expecting = */
  GET_TOKEN;
  if (lxP->type!=TlxData::CONTROL || strcmp(lxP->string,"=")){
    throw syntax_error("Bad format at ",lxP->string);}
    
  char fn_buf [LX_STRLEN];
  syntax.Parse_FileName(fn_buf);
  pRec->ref = fn_buf;
}

void TSymbol::saveSymbols(){
  TsymCI symI;
  /* export public, extern with deps and extern virtual */
  for (symI=sym.begin(); symI != sym.end(); symI++){  
  
    if (stRec.attr()==TSymbolRec::Internal ||
	stRec.attr()==TSymbolRec::Virtual ||
        stRec.internal==true){continue;}
      
    if (stRec.attr()==TSymbolRec::Extern){
      if (stRec.dep->Empty()){continue;}
    }     
    if (stRec.attr()&TSymbolRec::Extern){stRec.dep->SaveObj();}
    object.outOperand(stRec.segNo);
    object.outOperand(stRec.attr());    
    object.outStringOperand((*symI).first.c_str());
    object.outStringOperand(stRec.macro.c_str());
    object.outSymbolData();
  }  
  object.outTerminator();
  
  /* export internal and virtual */
  for(symI=sym.begin(); symI != sym.end(); symI++){
  
    if (!(stRec.attr()==TSymbolRec::Internal ||
        stRec.attr()==TSymbolRec::Virtual) ||
	stRec.label==false || stRec.internal==true){continue;}
	
    object.outOperand(stRec.segNo);
    object.outOperand(stRec.attr());
    object.outStringOperand((*symI).first.c_str());
    object.outStringOperand(stRec.macro.c_str());    
    object.outSymbolData();
  }  
}

/* Load public and extern virtual. */
void TSymbol::loadSymbols(){
  TSymbolRec tmpRec;
  tmpRec.label     = true;
  tmpRec.segP      = preproc.csrc->segP;
  tmpRec.attr((TSymbolRec::TAttr)object.popOperand());
  tmpRec.segNo     = preproc.csrc->segP->seg[object.popOperand()].newNo;
  if (tmpRec.attr()&TSymbolRec::Extern){  
    tmpRec.dep->LoadObj(*preproc.csrc->segP);
//    tmpRec.dep->Print(1);
  }
  tmpRec.macro     = object.popStringOperand();
  string macroName = object.popStringOperand();
/*
  fprintf(stderr, "adding `%s' = `%s' (segNo=%d, attr=%d)\n",
    macroName.c_str(), 
    tmpRec.macro.c_str(),
    tmpRec.segNo, tmpRec.attr()); 
*/
  if (test(&tmpRec,macroName)==Define){storeSym(&tmpRec,macroName);}
}

/* Load non-public symbols and save them back immediatelly - debug support */
void TSymbol::loadNonPublicSymbols(){
  TSymbolRec tmpRec;
  string macroString = object.popStringOperand();
  string macroName = object.popStringOperand();
  tmpRec.attr((TSymbolRec::TAttr)object.popOperand());
  tmpRec.segNo = preproc.csrc->segP->seg[object.popOperand()].newNo;
  if (segment.isEnabled(tmpRec.segNo)==false){return;}
  object.outOperand(tmpRec.segNo);
  object.outOperand(tmpRec.attr());
  object.outStringOperand(macroName.c_str());
  object.outStringOperand(macroString.c_str());
  object.outSymbolData();
}

/* After segments are fitted, public symbols need to be updated.
   A pass is required for each file seperately, because segment labels
   need to be adjusted every turn. 
   
   Extern virtual syms are changed to internal ones.
   
   Every memory block ends with # character! 
   While updatePublic() is called continously, this character is
   removed by first get_token in the reparseMacro() func. 
   
   For the last time, Object.C must take care, that this
   character does not confuse it. 
*/
void TSymbol::updatePublic(){
  TsymI symI;
  /* compare segP to find current file */
  for(symI=sym.begin(); symI != sym.end(); symI++){
    if (!(stRec.segP == preproc.csrc->segP)){continue;}
    /* copy macroString and reparse it */ 
    TMemBlock* macroSource = new TMemBlock;
    macroSource->append(stRec.macro.c_str());
    macroSource->append(" #");	/* add delimiter so we know where to stop */
    preproc.insert(macroSource);
    TSymbolRec tmp; reparseMacro(&tmp); stRec.macro=tmp.macro;
    if (stRec.attr()==(TSymbolRec::Extern+TSymbolRec::Virtual)){
      stRec.attr(TSymbolRec::Internal);
    }
  }
}


/*------------------*/
/* MacroParam Class */
/*==================*/

void TMacroParam::Add(char *s){
  if (psi==SYM_MAX_PARAM){
    throw generic_error("Parameter stack too small."
      " Increase SYM_MAX_PARAM in Symbol.h.");}
  /* SPECIAL CASE: NEGATIVE VALUES MUST BE IN BRACKETS! */
  if (s[0]=='-'){
    param_stack[psi][0]='(';
    strcpy(&param_stack[psi][1],s); strcat(param_stack[psi++],")");
  }else{strcpy(param_stack[psi++], s);}
}
 
/* 
  Replace parameter with sequent number - before storing it to the
  database.
*/
void TMacroParam::Replace(char *s){
  for (int i=0;i<psi;i++){
    if (strcmp(s,param_stack[i])==0){sprintf(s,"g%.2x",i);}}
}

void TMacroParam::ReplaceAll(char* s){
  char *needle,*src,buf [LX_LINEBUF],pnum [5];
  int pi;
  for (pi=0;pi<psi;pi++){
    buf[0]=0;src=s; sprintf(pnum,"g%.2x",pi);
    while ((needle=strstr(src,pnum))!=NULL){
      strncat(buf,src,needle-src); strcat(buf,param_stack[pi]);
      src+=needle-src+3;
    }
    /* copy rest of it and update s */
    strcat(buf,src); strcpy(s,buf);
  }
}
