/*
 * IBM Ultimotion Video Decoder
 * copyright (C) 2004 Konstantin Shishkov
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef AVCODEC_ULTI_CB_H
#define AVCODEC_ULTI_CB_H

static const unsigned char ulti_codebook[16384]={
    0x00, 0x01, 0x01, 0x02,
    0x00, 0x01, 0x02, 0x03,
    0x00, 0x02, 0x03, 0x04,
    0x00, 0x01, 0x03, 0x04,
    0x00, 0x01, 0x02, 0x04,
    0x00, 0x02, 0x03, 0x05,
    0x00, 0x02, 0x04, 0x05,
    0x00, 0x01, 0x04, 0x05,
    0x00, 0x01, 0x03, 0x05,
    0x00, 0x02, 0x04, 0x06,
    0x00, 0x03, 0x05, 0x06,
    0x00, 0x01, 0x05, 0x06,
    0x00, 0x01, 0x03, 0x06,
    0x00, 0x06, 0x06, 0x06,
    0x00, 0x00, 0x06, 0x06,
    0x00, 0x00, 0x00, 0x06,
    0x00, 0x03, 0x04, 0x07,
    0x00, 0x03, 0x06, 0x07,
    0x00, 0x01, 0x06, 0x07,
    0x00, 0x01, 0x04, 0x07,
    0x00, 0x03, 0x05, 0x08,
    0x00, 0x04, 0x06, 0x08,
    0x00, 0x02, 0x06, 0x08,
    0x00, 0x02, 0x04, 0x08,
    0x00, 0x08, 0x08, 0x08,
    0x00, 0x00, 0x08, 0x08,
    0x00, 0x00, 0x00, 0x08,
    0x00, 0x04, 0x07, 0x0B,
    0x00, 0x05, 0x09, 0x0B,
    0x00, 0x02, 0x09, 0x0B,
    0x00, 0x02, 0x06, 0x0B,
    0x00, 0x0B, 0x0B, 0x0B,
    0x00, 0x00, 0x0B, 0x0B,
    0x00, 0x00, 0x00, 0x0B,
    0x00, 0x05, 0x09, 0x0E,
    0x00, 0x07, 0x0B, 0x0E,
    0x00, 0x03, 0x0B, 0x0E,
    0x00, 0x03, 0x07, 0x0E,
    0x00, 0x0E, 0x0E, 0x0E,
    0x00, 0x00, 0x0E, 0x0E,
    0x00, 0x00, 0x00, 0x0E,
    0x00, 0x06, 0x0B, 0x11,
    0x00, 0x08, 0x0D, 0x11,
    0x00, 0x04, 0x0D, 0x11,
    0x00, 0x04, 0x09, 0x11,
    0x00, 0x11, 0x11, 0x11,
    0x00, 0x00, 0x11, 0x11,
    0x00, 0x00, 0x00, 0x11,
    0x00, 0x07, 0x0D, 0x14,
    0x00, 0x0A, 0x0F, 0x14,
    0x00, 0x05, 0x0F, 0x14,
    0x00, 0x05, 0x0A, 0x14,
    0x00, 0x14, 0x14, 0x14,
    0x00, 0x00, 0x14, 0x14,
    0x00, 0x00, 0x00, 0x14,
    0x00, 0x0B, 0x12, 0x17,
    0x00, 0x05, 0x12, 0x17,
    0x00, 0x05, 0x0C, 0x17,
    0x00, 0x17, 0x17, 0x17,
    0x00, 0x00, 0x17, 0x17,
    0x00, 0x00, 0x00, 0x17,
    0x00, 0x0D, 0x14, 0x1A,
    0x00, 0x06, 0x14, 0x1A,
    0x00, 0x06, 0x0D, 0x1A,
    0x00, 0x1A, 0x1A, 0x1A,
    0x00, 0x00, 0x1A, 0x1A,
    0x00, 0x00, 0x00, 0x1A,
    0x00, 0x0E, 0x16, 0x1D,
    0x00, 0x07, 0x16, 0x1D,
    0x00, 0x07, 0x0F, 0x1D,
    0x00, 0x1D, 0x1D, 0x1D,
    0x00, 0x00, 0x1D, 0x1D,
    0x00, 0x00, 0x00, 0x1D,
    0x00, 0x10, 0x18, 0x20,
    0x00, 0x08, 0x18, 0x20,
    0x00, 0x08, 0x10, 0x20,
    0x00, 0x20, 0x20, 0x20,
    0x00, 0x00, 0x20, 0x20,
    0x00, 0x00, 0x00, 0x20,
    0x00, 0x23, 0x23, 0x23,
    0x00, 0x00, 0x23, 0x23,
    0x00, 0x00, 0x00, 0x23,
    0x00, 0x12, 0x1B, 0x24,
    0x00, 0x09, 0x1B, 0x24,
    0x00, 0x09, 0x12, 0x24,
    0x00, 0x28, 0x28, 0x28,
    0x00, 0x00, 0x28, 0x28,
    0x00, 0x00, 0x00, 0x28,
    0x00, 0x2E, 0x2E, 0x2E,
    0x00, 0x00, 0x2E, 0x2E,
    0x00, 0x00, 0x00, 0x2E,
    0x01, 0x02, 0x02, 0x03,
    0x01, 0x02, 0x03, 0x04,
    0x01, 0x03, 0x04, 0x05,
    0x01, 0x02, 0x04, 0x05,
    0x01, 0x02, 0x03, 0x05,
    0x01, 0x03, 0x04, 0x06,
    0x01, 0x03, 0x05, 0x06,
    0x01, 0x02, 0x05, 0x06,
    0x01, 0x02, 0x04, 0x06,
    0x01, 0x03, 0x05, 0x07,
    0x01, 0x04, 0x06, 0x07,
    0x01, 0x02, 0x06, 0x07,
    0x01, 0x02, 0x04, 0x07,
    0x01, 0x07, 0x07, 0x07,
    0x01, 0x01, 0x07, 0x07,
    0x01, 0x01, 0x01, 0x07,
    0x01, 0x04, 0x05, 0x08,
    0x01, 0x04, 0x07, 0x08,
    0x01, 0x02, 0x07, 0x08,
    0x01, 0x02, 0x05, 0x08,
    0x01, 0x04, 0x06, 0x09,
    0x01, 0x05, 0x07, 0x09,
    0x01, 0x03, 0x07, 0x09,
    0x01, 0x03, 0x05, 0x09,
    0x01, 0x09, 0x09, 0x09,
    0x01, 0x01, 0x09, 0x09,
    0x01, 0x01, 0x01, 0x09,
    0x01, 0x05, 0x08, 0x0C,
    0x01, 0x06, 0x0A, 0x0C,
    0x01, 0x03, 0x0A, 0x0C,
    0x01, 0x03, 0x07, 0x0C,
    0x01, 0x0C, 0x0C, 0x0C,
    0x01, 0x01, 0x0C, 0x0C,
    0x01, 0x01, 0x01, 0x0C,
    0x01, 0x06, 0x0A, 0x0F,
    0x01, 0x08, 0x0C, 0x0F,
    0x01, 0x04, 0x0C, 0x0F,
    0x01, 0x04, 0x08, 0x0F,
    0x01, 0x0F, 0x0F, 0x0F,
    0x01, 0x01, 0x0F, 0x0F,
    0x01, 0x01, 0x01, 0x0F,
    0x01, 0x07, 0x0C, 0x12,
    0x01, 0x09, 0x0E, 0x12,
    0x01, 0x05, 0x0E, 0x12,
    0x01, 0x05, 0x0A, 0x12,
    0x01, 0x12, 0x12, 0x12,
    0x01, 0x01, 0x12, 0x12,
    0x01, 0x01, 0x01, 0x12,
    0x01, 0x08, 0x0E, 0x15,
    0x01, 0x0B, 0x10, 0x15,
    0x01, 0x06, 0x10, 0x15,
    0x01, 0x06, 0x0B, 0x15,
    0x01, 0x15, 0x15, 0x15,
    0x01, 0x01, 0x15, 0x15,
    0x01, 0x01, 0x01, 0x15,
    0x01, 0x0C, 0x13, 0x18,
    0x01, 0x06, 0x13, 0x18,
    0x01, 0x06, 0x0D, 0x18,
    0x01, 0x18, 0x18, 0x18,
    0x01, 0x01, 0x18, 0x18,
    0x01, 0x01, 0x01, 0x18,
    0x01, 0x0E, 0x15, 0x1B,
    0x01, 0x07, 0x15, 0x1B,
    0x01, 0x07, 0x0E, 0x1B,
    0x01, 0x1B, 0x1B, 0x1B,
    0x01, 0x01, 0x1B, 0x1B,
    0x01, 0x01, 0x01, 0x1B,
    0x01, 0x0F, 0x17, 0x1E,
    0x01, 0x08, 0x17, 0x1E,
    0x01, 0x08, 0x10, 0x1E,
    0x01, 0x1E, 0x1E, 0x1E,
    0x01, 0x01, 0x1E, 0x1E,
    0x01, 0x01, 0x01, 0x1E,
    0x01, 0x11, 0x19, 0x21,
    0x01, 0x09, 0x19, 0x21,
    0x01, 0x09, 0x11, 0x21,
    0x01, 0x21, 0x21, 0x21,
    0x01, 0x01, 0x21, 0x21,
    0x01, 0x01, 0x01, 0x21,
    0x01, 0x24, 0x24, 0x24,
    0x01, 0x01, 0x24, 0x24,
    0x01, 0x01, 0x01, 0x24,
    0x01, 0x13, 0x1C, 0x25,
    0x01, 0x0A, 0x1C, 0x25,
    0x01, 0x0A, 0x13, 0x25,
    0x01, 0x29, 0x29, 0x29,
    0x01, 0x01, 0x29, 0x29,
    0x01, 0x01, 0x01, 0x29,
    0x01, 0x2F, 0x2F, 0x2F,
    0x01, 0x01, 0x2F, 0x2F,
    0x01, 0x01, 0x01, 0x2F,
    0x02, 0x03, 0x03, 0x04,
    0x02, 0x03, 0x04, 0x05,
    0x02, 0x04, 0x05, 0x06,
    0x02, 0x03, 0x05, 0x06,
    0x02, 0x03, 0x04, 0x06,
    0x02, 0x04, 0x05, 0x07,
    0x02, 0x04, 0x06, 0x07,
    0x02, 0x03, 0x06, 0x07,
    0x02, 0x03, 0x05, 0x07,
    0x02, 0x04, 0x06, 0x08,
    0x02, 0x05, 0x07, 0x08,
    0x02, 0x03, 0x07, 0x08,
    0x02, 0x03, 0x05, 0x08,
    0x02, 0x08, 0x08, 0x08,
    0x02, 0x02, 0x08, 0x08,
    0x02, 0x02, 0x02, 0x08,
    0x02, 0x05, 0x06, 0x09,
    0x02, 0x05, 0x08, 0x09,
    0x02, 0x03, 0x08, 0x09,
    0x02, 0x03, 0x06, 0x09,
    0x02, 0x05, 0x07, 0x0A,
    0x02, 0x06, 0x08, 0x0A,
    0x02, 0x04, 0x08, 0x0A,
    0x02, 0x04, 0x06, 0x0A,
    0x02, 0x0A, 0x0A, 0x0A,
    0x02, 0x02, 0x0A, 0x0A,
    0x02, 0x02, 0x02, 0x0A,
    0x02, 0x06, 0x09, 0x0D,
    0x02, 0x07, 0x0B, 0x0D,
    0x02, 0x04, 0x0B, 0x0D,
    0x02, 0x04, 0x08, 0x0D,
    0x02, 0x0D, 0x0D, 0x0D,
    0x02, 0x02, 0x0D, 0x0D,
    0x02, 0x02, 0x02, 0x0D,
    0x02, 0x07, 0x0B, 0x10,
    0x02, 0x09, 0x0D, 0x10,
    0x02, 0x05, 0x0D, 0x10,
    0x02, 0x05, 0x09, 0x10,
    0x02, 0x10, 0x10, 0x10,
    0x02, 0x02, 0x10, 0x10,
    0x02, 0x02, 0x02, 0x10,
    0x02, 0x08, 0x0D, 0x13,
    0x02, 0x0A, 0x0F, 0x13,
    0x02, 0x06, 0x0F, 0x13,
    0x02, 0x06, 0x0B, 0x13,
    0x02, 0x13, 0x13, 0x13,
    0x02, 0x02, 0x13, 0x13,
    0x02, 0x02, 0x02, 0x13,
    0x02, 0x09, 0x0F, 0x16,
    0x02, 0x0C, 0x11, 0x16,
    0x02, 0x07, 0x11, 0x16,
    0x02, 0x07, 0x0C, 0x16,
    0x02, 0x16, 0x16, 0x16,
    0x02, 0x02, 0x16, 0x16,
    0x02, 0x02, 0x02, 0x16,
    0x02, 0x0D, 0x14, 0x19,
    0x02, 0x07, 0x14, 0x19,
    0x02, 0x07, 0x0E, 0x19,
    0x02, 0x19, 0x19, 0x19,
    0x02, 0x02, 0x19, 0x19,
    0x02, 0x02, 0x02, 0x19,
    0x02, 0x0F, 0x16, 0x1C,
    0x02, 0x08, 0x16, 0x1C,
    0x02, 0x08, 0x0F, 0x1C,
    0x02, 0x1C, 0x1C, 0x1C,
    0x02, 0x02, 0x1C, 0x1C,
    0x02, 0x02, 0x02, 0x1C,
    0x02, 0x10, 0x18, 0x1F,
    0x02, 0x09, 0x18, 0x1F,
    0x02, 0x09, 0x11, 0x1F,
    0x02, 0x1F, 0x1F, 0x1F,
    0x02, 0x02, 0x1F, 0x1F,
    0x02, 0x02, 0x02, 0x1F,
    0x02, 0x12, 0x1A, 0x22,
    0x02, 0x0A, 0x1A, 0x22,
    0x02, 0x0A, 0x12, 0x22,
    0x02, 0x22, 0x22, 0x22,
    0x02, 0x02, 0x22, 0x22,
    0x02, 0x02, 0x02, 0x22,
    0x02, 0x25, 0x25, 0x25,
    0x02, 0x02, 0x25, 0x25,
    0x02, 0x02, 0x02, 0x25,
    0x02, 0x14, 0x1D, 0x26,
    0x02, 0x0B, 0x1D, 0x26,
    0x02, 0x0B, 0x14, 0x26,
    0x02, 0x2A, 0x2A, 0x2A,
    0x02, 0x02, 0x2A, 0x2A,
    0x02, 0x02, 0x02, 0x2A,
    0x02, 0x30, 0x30, 0x30,
    0x02, 0x02, 0x30, 0x30,
    0x02, 0x02, 0x02, 0x30,
    0x03, 0x04, 0x04, 0x05,
    0x03, 0x04, 0x05, 0x06,
    0x03, 0x05, 0x06, 0x07,
    0x03, 0x04, 0x06, 0x07,
    0x03, 0x04, 0x05, 0x07,
    0x03, 0x05, 0x06, 0x08,
    0x03, 0x05, 0x07, 0x08,
    0x03, 0x04, 0x07, 0x08,
    0x03, 0x04, 0x06, 0x08,
    0x03, 0x05, 0x07, 0x09,
    0x03, 0x06, 0x08, 0x09,
    0x03, 0x04, 0x08, 0x09,
    0x03, 0x04, 0x06, 0x09,
    0x03, 0x09, 0x09, 0x09,
    0x03, 0x03, 0x09, 0x09,
    0x03, 0x03, 0x03, 0x09,
    0x03, 0x06, 0x07, 0x0A,
    0x03, 0x06, 0x09, 0x0A,
    0x03, 0x04, 0x09, 0x0A,
    0x03, 0x04, 0x07, 0x0A,
    0x03, 0x06, 0x08, 0x0B,
    0x03, 0x07, 0x09, 0x0B,
    0x03, 0x05, 0x09, 0x0B,
    0x03, 0x05, 0x07, 0x0B,
    0x03, 0x0B, 0x0B, 0x0B,
    0x03, 0x03, 0x0B, 0x0B,
    0x03, 0x03, 0x03, 0x0B,
    0x03, 0x07, 0x0A, 0x0E,
    0x03, 0x08, 0x0C, 0x0E,
    0x03, 0x05, 0x0C, 0x0E,
    0x03, 0x05, 0x09, 0x0E,
    0x03, 0x0E, 0x0E, 0x0E,
    0x03, 0x03, 0x0E, 0x0E,
    0x03, 0x03, 0x03, 0x0E,
    0x03, 0x08, 0x0C, 0x11,
    0x03, 0x0A, 0x0E, 0x11,
    0x03, 0x06, 0x0E, 0x11,
    0x03, 0x06, 0x0A, 0x11,
    0x03, 0x11, 0x11, 0x11,
    0x03, 0x03, 0x11, 0x11,
    0x03, 0x03, 0x03, 0x11,
    0x03, 0x09, 0x0E, 0x14,
    0x03, 0x0B, 0x10, 0x14,
    0x03, 0x07, 0x10, 0x14,
    0x03, 0x07, 0x0C, 0x14,
    0x03, 0x14, 0x14, 0x14,
    0x03, 0x03, 0x14, 0x14,
    0x03, 0x03, 0x03, 0x14,
    0x03, 0x0A, 0x10, 0x17,
    0x03, 0x0D, 0x12, 0x17,
    0x03, 0x08, 0x12, 0x17,
    0x03, 0x08, 0x0D, 0x17,
    0x03, 0x17, 0x17, 0x17,
    0x03, 0x03, 0x17, 0x17,
    0x03, 0x03, 0x03, 0x17,
    0x03, 0x0E, 0x15, 0x1A,
    0x03, 0x08, 0x15, 0x1A,
    0x03, 0x08, 0x0F, 0x1A,
    0x03, 0x1A, 0x1A, 0x1A,
    0x03, 0x03, 0x1A, 0x1A,
    0x03, 0x03, 0x03, 0x1A,
    0x03, 0x10, 0x17, 0x1D,
    0x03, 0x09, 0x17, 0x1D,
    0x03, 0x09, 0x10, 0x1D,
    0x03, 0x1D, 0x1D, 0x1D,
    0x03, 0x03, 0x1D, 0x1D,
    0x03, 0x03, 0x03, 0x1D,
    0x03, 0x11, 0x19, 0x20,
    0x03, 0x0A, 0x19, 0x20,
    0x03, 0x0A, 0x12, 0x20,
    0x03, 0x20, 0x20, 0x20,
    0x03, 0x03, 0x20, 0x20,
    0x03, 0x03, 0x03, 0x20,
    0x03, 0x13, 0x1B, 0x23,
    0x03, 0x0B, 0x1B, 0x23,
    0x03, 0x0B, 0x13, 0x23,
    0x03, 0x23, 0x23, 0x23,
    0x03, 0x03, 0x23, 0x23,
    0x03, 0x03, 0x03, 0x23,
    0x03, 0x26, 0x26, 0x26,
    0x03, 0x03, 0x26, 0x26,
    0x03, 0x03, 0x03, 0x26,
    0x03, 0x15, 0x1E, 0x27,
    0x03, 0x0C, 0x1E, 0x27,
    0x03, 0x0C, 0x15, 0x27,
    0x03, 0x2B, 0x2B, 0x2B,
    0x03, 0x03, 0x2B, 0x2B,
    0x03, 0x03, 0x03, 0x2B,
    0x03, 0x31, 0x31, 0x31,
    0x03, 0x03, 0x31, 0x31,
    0x03, 0x03, 0x03, 0x31,
    0x04, 0x05, 0x05, 0x06,
    0x04, 0x05, 0x06, 0x07,
    0x04, 0x06, 0x07, 0x08,
    0x04, 0x05, 0x07, 0x08,
    0x04, 0x05, 0x06, 0x08,
    0x04, 0x06, 0x07, 0x09,
    0x04, 0x06, 0x08, 0x09,
    0x04, 0x05, 0x08, 0x09,
    0x04, 0x05, 0x07, 0x09,
    0x04, 0x06, 0x08, 0x0A,
    0x04, 0x07, 0x09, 0x0A,
    0x04, 0x05, 0x09, 0x0A,
    0x04, 0x05, 0x07, 0x0A,
    0x04, 0x0A, 0x0A, 0x0A,
    0x04, 0x04, 0x0A, 0x0A,
    0x04, 0x04, 0x04, 0x0A,
    0x04, 0x07, 0x08, 0x0B,
    0x04, 0x07, 0x0A, 0x0B,
    0x04, 0x05, 0x0A, 0x0B,
    0x04, 0x05, 0x08, 0x0B,
    0x04, 0x07, 0x09, 0x0C,
    0x04, 0x08, 0x0A, 0x0C,
    0x04, 0x06, 0x0A, 0x0C,
    0x04, 0x06, 0x08, 0x0C,
    0x04, 0x0C, 0x0C, 0x0C,
    0x04, 0x04, 0x0C, 0x0C,
    0x04, 0x04, 0x04, 0x0C,
    0x04, 0x08, 0x0B, 0x0F,
    0x04, 0x09, 0x0D, 0x0F,
    0x04, 0x06, 0x0D, 0x0F,
    0x04, 0x06, 0x0A, 0x0F,
    0x04, 0x0F, 0x0F, 0x0F,
    0x04, 0x04, 0x0F, 0x0F,
    0x04, 0x04, 0x04, 0x0F,
    0x04, 0x09, 0x0D, 0x12,
    0x04, 0x0B, 0x0F, 0x12,
    0x04, 0x07, 0x0F, 0x12,
    0x04, 0x07, 0x0B, 0x12,
    0x04, 0x12, 0x12, 0x12,
    0x04, 0x04, 0x12, 0x12,
    0x04, 0x04, 0x04, 0x12,
    0x04, 0x0A, 0x0F, 0x15,
    0x04, 0x0C, 0x11, 0x15,
    0x04, 0x08, 0x11, 0x15,
    0x04, 0x08, 0x0D, 0x15,
    0x04, 0x15, 0x15, 0x15,
    0x04, 0x04, 0x15, 0x15,
    0x04, 0x04, 0x04, 0x15,
    0x04, 0x0B, 0x11, 0x18,
    0x04, 0x0E, 0x13, 0x18,
    0x04, 0x09, 0x13, 0x18,
    0x04, 0x09, 0x0E, 0x18,
    0x04, 0x18, 0x18, 0x18,
    0x04, 0x04, 0x18, 0x18,
    0x04, 0x04, 0x04, 0x18,
    0x04, 0x0F, 0x16, 0x1B,
    0x04, 0x09, 0x16, 0x1B,
    0x04, 0x09, 0x10, 0x1B,
    0x04, 0x1B, 0x1B, 0x1B,
    0x04, 0x04, 0x1B, 0x1B,
    0x04, 0x04, 0x04, 0x1B,
    0x04, 0x11, 0x18, 0x1E,
    0x04, 0x0A, 0x18, 0x1E,
    0x04, 0x0A, 0x11, 0x1E,
    0x04, 0x1E, 0x1E, 0x1E,
    0x04, 0x04, 0x1E, 0x1E,
    0x04, 0x04, 0x04, 0x1E,
    0x04, 0x12, 0x1A, 0x21,
    0x04, 0x0B, 0x1A, 0x21,
    0x04, 0x0B, 0x13, 0x21,
    0x04, 0x21, 0x21, 0x21,
    0x04, 0x04, 0x21, 0x21,
    0x04, 0x04, 0x04, 0x21,
    0x04, 0x14, 0x1C, 0x24,
    0x04, 0x0C, 0x1C, 0x24,
    0x04, 0x0C, 0x14, 0x24,
    0x04, 0x24, 0x24, 0x24,
    0x04, 0x04, 0x24, 0x24,
    0x04, 0x04, 0x04, 0x24,
    0x04, 0x27, 0x27, 0x27,
    0x04, 0x04, 0x27, 0x27,
    0x04, 0x04, 0x04, 0x27,
    0x04, 0x16, 0x1F, 0x28,
    0x04, 0x0D, 0x1F, 0x28,
    0x04, 0x0D, 0x16, 0x28,
    0x04, 0x2C, 0x2C, 0x2C,
    0x04, 0x04, 0x2C, 0x2C,
    0x04, 0x04, 0x04, 0x2C,
    0x04, 0x32, 0x32, 0x32,
    0x04, 0x04, 0x32, 0x32,
    0x04, 0x04, 0x04, 0x32,
    0x05, 0x06, 0x06, 0x07,
    0x05, 0x06, 0x07, 0x08,
    0x05, 0x07, 0x08, 0x09,
    0x05, 0x06, 0x08, 0x09,
    0x05, 0x06, 0x07, 0x09,
    0x05, 0x07, 0x08, 0x0A,
    0x05, 0x07, 0x09, 0x0A,
    0x05, 0x06, 0x09, 0x0A,
    0x05, 0x06, 0x08, 0x0A,
    0x05, 0x07, 0x09, 0x0B,
    0x05, 0x08, 0x0A, 0x0B,
    0x05, 0x06, 0x0A, 0x0B,
    0x05, 0x06, 0x08, 0x0B,
    0x05, 0x0B, 0x0B, 0x0B,
    0x05, 0x05, 0x0B, 0x0B,
    0x05, 0x05, 0x05, 0x0B,
    0x05, 0x08, 0x09, 0x0C,
    0x05, 0x08, 0x0B, 0x0C,
    0x05, 0x06, 0x0B, 0x0C,
    0x05, 0x06, 0x09, 0x0C,
    0x05, 0x08, 0x0A, 0x0D,
    0x05, 0x09, 0x0B, 0x0D,
    0x05, 0x07, 0x0B, 0x0D,
    0x05, 0x07, 0x09, 0x0D,
    0x05, 0x0D, 0x0D, 0x0D,
    0x05, 0x05, 0x0D, 0x0D,
    0x05, 0x05, 0x05, 0x0D,
    0x05, 0x09, 0x0C, 0x10,
    0x05, 0x0A, 0x0E, 0x10,
    0x05, 0x07, 0x0E, 0x10,
    0x05, 0x07, 0x0B, 0x10,
    0x05, 0x10, 0x10, 0x10,
    0x05, 0x05, 0x10, 0x10,
    0x05, 0x05, 0x05, 0x10,
    0x05, 0x0A, 0x0E, 0x13,
    0x05, 0x0C, 0x10, 0x13,
    0x05, 0x08, 0x10, 0x13,
    0x05, 0x08, 0x0C, 0x13,
    0x05, 0x13, 0x13, 0x13,
    0x05, 0x05, 0x13, 0x13,
    0x05, 0x05, 0x05, 0x13,
    0x05, 0x0B, 0x10, 0x16,
    0x05, 0x0D, 0x12, 0x16,
    0x05, 0x09, 0x12, 0x16,
    0x05, 0x09, 0x0E, 0x16,
    0x05, 0x16, 0x16, 0x16,
    0x05, 0x05, 0x16, 0x16,
    0x05, 0x05, 0x05, 0x16,
    0x05, 0x0C, 0x12, 0x19,
    0x05, 0x0F, 0x14, 0x19,
    0x05, 0x0A, 0x14, 0x19,
    0x05, 0x0A, 0x0F, 0x19,
    0x05, 0x19, 0x19, 0x19,
    0x05, 0x05, 0x19, 0x19,
    0x05, 0x05, 0x05, 0x19,
    0x05, 0x10, 0x17, 0x1C,
    0x05, 0x0A, 0x17, 0x1C,
    0x05, 0x0A, 0x11, 0x1C,
    0x05, 0x1C, 0x1C, 0x1C,
    0x05, 0x05, 0x1C, 0x1C,
    0x05, 0x05, 0x05, 0x1C,
    0x05, 0x12, 0x19, 0x1F,
    0x05, 0x0B, 0x19, 0x1F,
    0x05, 0x0B, 0x12, 0x1F,
    0x05, 0x1F, 0x1F, 0x1F,
    0x05, 0x05, 0x1F, 0x1F,
    0x05, 0x05, 0x05, 0x1F,
    0x05, 0x13, 0x1B, 0x22,
    0x05, 0x0C, 0x1B, 0x22,
    0x05, 0x0C, 0x14, 0x22,
    0x05, 0x22, 0x22, 0x22,
    0x05, 0x05, 0x22, 0x22,
    0x05, 0x05, 0x05, 0x22,
    0x05, 0x15, 0x1D, 0x25,
    0x05, 0x0D, 0x1D, 0x25,
    0x05, 0x0D, 0x15, 0x25,
    0x05, 0x25, 0x25, 0x25,
    0x05, 0x05, 0x25, 0x25,
    0x05, 0x05, 0x05, 0x25,
    0x05, 0x28, 0x28, 0x28,
    0x05, 0x05, 0x28, 0x28,
    0x05, 0x05, 0x05, 0x28,
    0x05, 0x17, 0x20, 0x29,
    0x05, 0x0E, 0x20, 0x29,
    0x05, 0x0E, 0x17, 0x29,
    0x05, 0x2D, 0x2D, 0x2D,
    0x05, 0x05, 0x2D, 0x2D,
    0x05, 0x05, 0x05, 0x2D,
    0x05, 0x33, 0x33, 0x33,
    0x05, 0x05, 0x33, 0x33,
    0x05, 0x05, 0x05, 0x33,
    0x06, 0x07, 0x07, 0x08,
    0x06, 0x07, 0x08, 0x09,
    0x06, 0x08, 0x09, 0x0A,
    0x06, 0x07, 0x09, 0x0A,
    0x06, 0x07, 0x08, 0x0A,
    0x06, 0x08, 0x09, 0x0B,
    0x06, 0x08, 0x0A, 0x0B,
    0x06, 0x07, 0x0A, 0x0B,
    0x06, 0x07, 0x09, 0x0B,
    0x06, 0x08, 0x0A, 0x0C,
    0x06, 0x09, 0x0B, 0x0C,
    0x06, 0x07, 0x0B, 0x0C,
    0x06, 0x07, 0x09, 0x0C,
    0x06, 0x0C, 0x0C, 0x0C,
    0x06, 0x06, 0x0C, 0x0C,
    0x06, 0x06, 0x06, 0x0C,
    0x06, 0x09, 0x0A, 0x0D,
    0x06, 0x09, 0x0C, 0x0D,
    0x06, 0x07, 0x0C, 0x0D,
    0x06, 0x07, 0x0A, 0x0D,
    0x06, 0x09, 0x0B, 0x0E,
    0x06, 0x0A, 0x0C, 0x0E,
    0x06, 0x08, 0x0C, 0x0E,
    0x06, 0x08, 0x0A, 0x0E,
    0x06, 0x0E, 0x0E, 0x0E,
    0x06, 0x06, 0x0E, 0x0E,
    0x06, 0x06, 0x06, 0x0E,
    0x06, 0x0A, 0x0D, 0x11,
    0x06, 0x0B, 0x0F, 0x11,
    0x06, 0x08, 0x0F, 0x11,
    0x06, 0x08, 0x0C, 0x11,
    0x06, 0x11, 0x11, 0x11,
    0x06, 0x06, 0x11, 0x11,
    0x06, 0x06, 0x06, 0x11,
    0x06, 0x0B, 0x0F, 0x14,
    0x06, 0x0D, 0x11, 0x14,
    0x06, 0x09, 0x11, 0x14,
    0x06, 0x09, 0x0D, 0x14,
    0x06, 0x14, 0x14, 0x14,
    0x06, 0x06, 0x14, 0x14,
    0x06, 0x06, 0x06, 0x14,
    0x06, 0x0C, 0x11, 0x17,
    0x06, 0x0E, 0x13, 0x17,
    0x06, 0x0A, 0x13, 0x17,
    0x06, 0x0A, 0x0F, 0x17,
    0x06, 0x17, 0x17, 0x17,
    0x06, 0x06, 0x17, 0x17,
    0x06, 0x06, 0x06, 0x17,
    0x06, 0x0D, 0x13, 0x1A,
    0x06, 0x10, 0x15, 0x1A,
    0x06, 0x0B, 0x15, 0x1A,
    0x06, 0x0B, 0x10, 0x1A,
    0x06, 0x1A, 0x1A, 0x1A,
    0x06, 0x06, 0x1A, 0x1A,
    0x06, 0x06, 0x06, 0x1A,
    0x06, 0x11, 0x18, 0x1D,
    0x06, 0x0B, 0x18, 0x1D,
    0x06, 0x0B, 0x12, 0x1D,
    0x06, 0x1D, 0x1D, 0x1D,
    0x06, 0x06, 0x1D, 0x1D,
    0x06, 0x06, 0x06, 0x1D,
    0x06, 0x13, 0x1A, 0x20,
    0x06, 0x0C, 0x1A, 0x20,
    0x06, 0x0C, 0x13, 0x20,
    0x06, 0x20, 0x20, 0x20,
    0x06, 0x06, 0x20, 0x20,
    0x06, 0x06, 0x06, 0x20,
    0x06, 0x14, 0x1C, 0x23,
    0x06, 0x0D, 0x1C, 0x23,
    0x06, 0x0D, 0x15, 0x23,
    0x06, 0x23, 0x23, 0x23,
    0x06, 0x06, 0x23, 0x23,
    0x06, 0x06, 0x06, 0x23,
    0x06, 0x16, 0x1E, 0x26,
    0x06, 0x0E, 0x1E, 0x26,
    0x06, 0x0E, 0x16, 0x26,
    0x06, 0x26, 0x26, 0x26,
    0x06, 0x06, 0x26, 0x26,
    0x06, 0x06, 0x06, 0x26,
    0x06, 0x29, 0x29, 0x29,
    0x06, 0x06, 0x29, 0x29,
    0x06, 0x06, 0x06, 0x29,
    0x06, 0x18, 0x21, 0x2A,
    0x06, 0x0F, 0x21, 0x2A,
    0x06, 0x0F, 0x18, 0x2A,
    0x06, 0x2E, 0x2E, 0x2E,
    0x06, 0x06, 0x2E, 0x2E,
    0x06, 0x06, 0x06, 0x2E,
    0x06, 0x34, 0x34, 0x34,
    0x06, 0x06, 0x34, 0x34,
    0x06, 0x06, 0x06, 0x34,
    0x07, 0x08, 0x08, 0x09,
    0x07, 0x08, 0x09, 0x0A,
    0x07, 0x09, 0x0A, 0x0B,
    0x07, 0x08, 0x0A, 0x0B,
    0x07, 0x08, 0x09, 0x0B,
    0x07, 0x09, 0x0A, 0x0C,
    0x07, 0x09, 0x0B, 0x0C,
    0x07, 0x08, 0x0B, 0x0C,
    0x07, 0x08, 0x0A, 0x0C,
    0x07, 0x09, 0x0B, 0x0D,
    0x07, 0x0A, 0x0C, 0x0D,
    0x07, 0x08, 0x0C, 0x0D,
    0x07, 0x08, 0x0A, 0x0D,
    0x07, 0x0D, 0x0D, 0x0D,
    0x07, 0x07, 0x0D, 0x0D,
    0x07, 0x07, 0x07, 0x0D,
    0x07, 0x0A, 0x0B, 0x0E,
    0x07, 0x0A, 0x0D, 0x0E,
    0x07, 0x08, 0x0D, 0x0E,
    0x07, 0x08, 0x0B, 0x0E,
    0x07, 0x0A, 0x0C, 0x0F,
    0x07, 0x0B, 0x0D, 0x0F,
    0x07, 0x09, 0x0D, 0x0F,
    0x07, 0x09, 0x0B, 0x0F,
    0x07, 0x0F, 0x0F, 0x0F,
    0x07, 0x07, 0x0F, 0x0F,
    0x07, 0x07, 0x07, 0x0F,
    0x07, 0x0B, 0x0E, 0x12,
    0x07, 0x0C, 0x10, 0x12,
    0x07, 0x09, 0x10, 0x12,
    0x07, 0x09, 0x0D, 0x12,
    0x07, 0x12, 0x12, 0x12,
    0x07, 0x07, 0x12, 0x12,
    0x07, 0x07, 0x07, 0x12,
    0x07, 0x0C, 0x10, 0x15,
    0x07, 0x0E, 0x12, 0x15,
    0x07, 0x0A, 0x12, 0x15,
    0x07, 0x0A, 0x0E, 0x15,
    0x07, 0x15, 0x15, 0x15,
    0x07, 0x07, 0x15, 0x15,
    0x07, 0x07, 0x07, 0x15,
    0x07, 0x0D, 0x12, 0x18,
    0x07, 0x0F, 0x14, 0x18,
    0x07, 0x0B, 0x14, 0x18,
    0x07, 0x0B, 0x10, 0x18,
    0x07, 0x18, 0x18, 0x18,
    0x07, 0x07, 0x18, 0x18,
    0x07, 0x07, 0x07, 0x18,
    0x07, 0x0E, 0x14, 0x1B,
    0x07, 0x11, 0x16, 0x1B,
    0x07, 0x0C, 0x16, 0x1B,
    0x07, 0x0C, 0x11, 0x1B,
    0x07, 0x1B, 0x1B, 0x1B,
    0x07, 0x07, 0x1B, 0x1B,
    0x07, 0x07, 0x07, 0x1B,
    0x07, 0x12, 0x19, 0x1E,
    0x07, 0x0C, 0x19, 0x1E,
    0x07, 0x0C, 0x13, 0x1E,
    0x07, 0x1E, 0x1E, 0x1E,
    0x07, 0x07, 0x1E, 0x1E,
    0x07, 0x07, 0x07, 0x1E,
    0x07, 0x14, 0x1B, 0x21,
    0x07, 0x0D, 0x1B, 0x21,
    0x07, 0x0D, 0x14, 0x21,
    0x07, 0x21, 0x21, 0x21,
    0x07, 0x07, 0x21, 0x21,
    0x07, 0x07, 0x07, 0x21,
    0x07, 0x15, 0x1D, 0x24,
    0x07, 0x0E, 0x1D, 0x24,
    0x07, 0x0E, 0x16, 0x24,
    0x07, 0x24, 0x24, 0x24,
    0x07, 0x07, 0x24, 0x24,
    0x07, 0x07, 0x07, 0x24,
    0x07, 0x17, 0x1F, 0x27,
    0x07, 0x0F, 0x1F, 0x27,
    0x07, 0x0F, 0x17, 0x27,
    0x07, 0x27, 0x27, 0x27,
    0x07, 0x07, 0x27, 0x27,
    0x07, 0x07, 0x07, 0x27,
    0x07, 0x2A, 0x2A, 0x2A,
    0x07, 0x07, 0x2A, 0x2A,
    0x07, 0x07, 0x07, 0x2A,
    0x07, 0x19, 0x22, 0x2B,
    0x07, 0x10, 0x22, 0x2B,
    0x07, 0x10, 0x19, 0x2B,
    0x07, 0x2F, 0x2F, 0x2F,
    0x07, 0x07, 0x2F, 0x2F,
    0x07, 0x07, 0x07, 0x2F,
    0x07, 0x35, 0x35, 0x35,
    0x07, 0x07, 0x35, 0x35,
    0x07, 0x07, 0x07, 0x35,
    0x08, 0x09, 0x09, 0x0A,
    0x08, 0x09, 0x0A, 0x0B,
    0x08, 0x0A, 0x0B, 0x0C,
    0x08, 0x09, 0x0B, 0x0C,
    0x08, 0x09, 0x0A, 0x0C,
    0x08, 0x0A, 0x0B, 0x0D,
    0x08, 0x0A, 0x0C, 0x0D,
    0x08, 0x09, 0x0C, 0x0D,
    0x08, 0x09, 0x0B, 0x0D,
    0x08, 0x0A, 0x0C, 0x0E,
    0x08, 0x0B, 0x0D, 0x0E,
    0x08, 0x09, 0x0D, 0x0E,
    0x08, 0x09, 0x0B, 0x0E,
    0x08, 0x0E, 0x0E, 0x0E,
    0x08, 0x08, 0x0E, 0x0E,
    0x08, 0x08, 0x08, 0x0E,
    0x08, 0x0B, 0x0C, 0x0F,
    0x08, 0x0B, 0x0E, 0x0F,
    0x08, 0x09, 0x0E, 0x0F,
    0x08, 0x09, 0x0C, 0x0F,
    0x08, 0x0B, 0x0D, 0x10,
    0x08, 0x0C, 0x0E, 0x10,
    0x08, 0x0A, 0x0E, 0x10,
    0x08, 0x0A, 0x0C, 0x10,
    0x08, 0x10, 0x10, 0x10,
    0x08, 0x08, 0x10, 0x10,
    0x08, 0x08, 0x08, 0x10,
    0x08, 0x0C, 0x0F, 0x13,
    0x08, 0x0D, 0x11, 0x13,
    0x08, 0x0A, 0x11, 0x13,
    0x08, 0x0A, 0x0E, 0x13,
    0x08, 0x13, 0x13, 0x13,
    0x08, 0x08, 0x13, 0x13,
    0x08, 0x08, 0x08, 0x13,
    0x08, 0x0D, 0x11, 0x16,
    0x08, 0x0F, 0x13, 0x16,
    0x08, 0x0B, 0x13, 0x16,
    0x08, 0x0B, 0x0F, 0x16,
    0x08, 0x16, 0x16, 0x16,
    0x08, 0x08, 0x16, 0x16,
    0x08, 0x08, 0x08, 0x16,
    0x08, 0x0E, 0x13, 0x19,
    0x08, 0x10, 0x15, 0x19,
    0x08, 0x0C, 0x15, 0x19,
    0x08, 0x0C, 0x11, 0x19,
    0x08, 0x19, 0x19, 0x19,
    0x08, 0x08, 0x19, 0x19,
    0x08, 0x08, 0x08, 0x19,
    0x08, 0x0F, 0x15, 0x1C,
    0x08, 0x12, 0x17, 0x1C,
    0x08, 0x0D, 0x17, 0x1C,
    0x08, 0x0D, 0x12, 0x1C,
    0x08, 0x1C, 0x1C, 0x1C,
    0x08, 0x08, 0x1C, 0x1C,
    0x08, 0x08, 0x08, 0x1C,
    0x08, 0x13, 0x1A, 0x1F,
    0x08, 0x0D, 0x1A, 0x1F,
    0x08, 0x0D, 0x14, 0x1F,
    0x08, 0x1F, 0x1F, 0x1F,
    0x08, 0x08, 0x1F, 0x1F,
    0x08, 0x08, 0x08, 0x1F,
    0x08, 0x15, 0x1C, 0x22,
    0x08, 0x0E, 0x1C, 0x22,
    0x08, 0x0E, 0x15, 0x22,
    0x08, 0x22, 0x22, 0x22,
    0x08, 0x08, 0x22, 0x22,
    0x08, 0x08, 0x08, 0x22,
    0x08, 0x16, 0x1E, 0x25,
    0x08, 0x0F, 0x1E, 0x25,
    0x08, 0x0F, 0x17, 0x25,
    0x08, 0x25, 0x25, 0x25,
    0x08, 0x08, 0x25, 0x25,
    0x08, 0x08, 0x08, 0x25,
    0x08, 0x18, 0x20, 0x28,
    0x08, 0x10, 0x20, 0x28,
    0x08, 0x10, 0x18, 0x28,
    0x08, 0x28, 0x28, 0x28,
    0x08, 0x08, 0x28, 0x28,
    0x08, 0x08, 0x08, 0x28,
    0x08, 0x2B, 0x2B, 0x2B,
    0x08, 0x08, 0x2B, 0x2B,
    0x08, 0x08, 0x08, 0x2B,
    0x08, 0x1A, 0x23, 0x2C,
    0x08, 0x11, 0x23, 0x2C,
    0x08, 0x11, 0x1A, 0x2C,
    0x08, 0x30, 0x30, 0x30,
    0x08, 0x08, 0x30, 0x30,
    0x08, 0x08, 0x08, 0x30,
    0x08, 0x36, 0x36, 0x36,
    0x08, 0x08, 0x36, 0x36,
    0x08, 0x08, 0x08, 0x36,
    0x09, 0x0A, 0x0A, 0x0B,
    0x09, 0x0A, 0x0B, 0x0C,
    0x09, 0x0B, 0x0C, 0x0D,
    0x09, 0x0A, 0x0C, 0x0D,
    0x09, 0x0A, 0x0B, 0x0D,
    0x09, 0x0B, 0x0C, 0x0E,
    0x09, 0x0B, 0x0D, 0x0E,
    0x09, 0x0A, 0x0D, 0x0E,
    0x09, 0x0A, 0x0C, 0x0E,
    0x09, 0x0B, 0x0D, 0x0F,
    0x09, 0x0C, 0x0E, 0x0F,
    0x09, 0x0A, 0x0E, 0x0F,
    0x09, 0x0A, 0x0C, 0x0F,
    0x09, 0x0F, 0x0F, 0x0F,
    0x09, 0x09, 0x0F, 0x0F,
    0x09, 0x09, 0x09, 0x0F,
    0x09, 0x0C, 0x0D, 0x10,
    0x09, 0x0C, 0x0F, 0x10,
    0x09, 0x0A, 0x0F, 0x10,
    0x09, 0x0A, 0x0D, 0x10,
    0x09, 0x0C, 0x0E, 0x11,
    0x09, 0x0D, 0x0F, 0x11,
    0x09, 0x0B, 0x0F, 0x11,
    0x09, 0x0B, 0x0D, 0x11,
    0x09, 0x11, 0x11, 0x11,
    0x09, 0x09, 0x11, 0x11,
    0x09, 0x09, 0x09, 0x11,
    0x09, 0x0D, 0x10, 0x14,
    0x09, 0x0E, 0x12, 0x14,
    0x09, 0x0B, 0x12, 0x14,
    0x09, 0x0B, 0x0F, 0x14,
    0x09, 0x14, 0x14, 0x14,
    0x09, 0x09, 0x14, 0x14,
    0x09, 0x09, 0x09, 0x14,
    0x09, 0x0E, 0x12, 0x17,
    0x09, 0x10, 0x14, 0x17,
    0x09, 0x0C, 0x14, 0x17,
    0x09, 0x0C, 0x10, 0x17,
    0x09, 0x17, 0x17, 0x17,
    0x09, 0x09, 0x17, 0x17,
    0x09, 0x09, 0x09, 0x17,
    0x09, 0x0F, 0x14, 0x1A,
    0x09, 0x11, 0x16, 0x1A,
    0x09, 0x0D, 0x16, 0x1A,
    0x09, 0x0D, 0x12, 0x1A,
    0x09, 0x1A, 0x1A, 0x1A,
    0x09, 0x09, 0x1A, 0x1A,
    0x09, 0x09, 0x09, 0x1A,
    0x09, 0x10, 0x16, 0x1D,
    0x09, 0x13, 0x18, 0x1D,
    0x09, 0x0E, 0x18, 0x1D,
    0x09, 0x0E, 0x13, 0x1D,
    0x09, 0x1D, 0x1D, 0x1D,
    0x09, 0x09, 0x1D, 0x1D,
    0x09, 0x09, 0x09, 0x1D,
    0x09, 0x14, 0x1B, 0x20,
    0x09, 0x0E, 0x1B, 0x20,
    0x09, 0x0E, 0x15, 0x20,
    0x09, 0x20, 0x20, 0x20,
    0x09, 0x09, 0x20, 0x20,
    0x09, 0x09, 0x09, 0x20,
    0x09, 0x16, 0x1D, 0x23,
    0x09, 0x0F, 0x1D, 0x23,
    0x09, 0x0F, 0x16, 0x23,
    0x09, 0x23, 0x23, 0x23,
    0x09, 0x09, 0x23, 0x23,
    0x09, 0x09, 0x09, 0x23,
    0x09, 0x17, 0x1F, 0x26,
    0x09, 0x10, 0x1F, 0x26,
    0x09, 0x10, 0x18, 0x26,
    0x09, 0x26, 0x26, 0x26,
    0x09, 0x09, 0x26, 0x26,
    0x09, 0x09, 0x09, 0x26,
    0x09, 0x19, 0x21, 0x29,
    0x09, 0x11, 0x21, 0x29,
    0x09, 0x11, 0x19, 0x29,
    0x09, 0x29, 0x29, 0x29,
    0x09, 0x09, 0x29, 0x29,
    0x09, 0x09, 0x09, 0x29,
    0x09, 0x2C, 0x2C, 0x2C,
    0x09, 0x09, 0x2C, 0x2C,
    0x09, 0x09, 0x09, 0x2C,
    0x09, 0x1B, 0x24, 0x2D,
    0x09, 0x12, 0x24, 0x2D,
    0x09, 0x12, 0x1B, 0x2D,
    0x09, 0x31, 0x31, 0x31,
    0x09, 0x09, 0x31, 0x31,
    0x09, 0x09, 0x09, 0x31,
    0x09, 0x37, 0x37, 0x37,
    0x09, 0x09, 0x37, 0x37,
    0x09, 0x09, 0x09, 0x37,
    0x0A, 0x0B, 0x0B, 0x0C,
    0x0A, 0x0B, 0x0C, 0x0D,
    0x0A, 0x0C, 0x0D, 0x0E,
    0x0A, 0x0B, 0x0D, 0x0E,
    0x0A, 0x0B, 0x0C, 0x0E,
    0x0A, 0x0C, 0x0D, 0x0F,
    0x0A, 0x0C, 0x0E, 0x0F,
    0x0A, 0x0B, 0x0E, 0x0F,
    0x0A, 0x0B, 0x0D, 0x0F,
    0x0A, 0x0C, 0x0E, 0x10,
    0x0A, 0x0D, 0x0F, 0x10,
    0x0A, 0x0B, 0x0F, 0x10,
    0x0A, 0x0B, 0x0D, 0x10,
    0x0A, 0x10, 0x10, 0x10,
    0x0A, 0x0A, 0x10, 0x10,
    0x0A, 0x0A, 0x0A, 0x10,
    0x0A, 0x0D, 0x0E, 0x11,
    0x0A, 0x0D, 0x10, 0x11,
    0x0A, 0x0B, 0x10, 0x11,
    0x0A, 0x0B, 0x0E, 0x11,
    0x0A, 0x0D, 0x0F, 0x12,
    0x0A, 0x0E, 0x10, 0x12,
    0x0A, 0x0C, 0x10, 0x12,
    0x0A, 0x0C, 0x0E, 0x12,
    0x0A, 0x12, 0x12, 0x12,
    0x0A, 0x0A, 0x12, 0x12,
    0x0A, 0x0A, 0x0A, 0x12,
    0x0A, 0x0E, 0x11, 0x15,
    0x0A, 0x0F, 0x13, 0x15,
    0x0A, 0x0C, 0x13, 0x15,
    0x0A, 0x0C, 0x10, 0x15,
    0x0A, 0x15, 0x15, 0x15,
    0x0A, 0x0A, 0x15, 0x15,
    0x0A, 0x0A, 0x0A, 0x15,
    0x0A, 0x0F, 0x13, 0x18,
    0x0A, 0x11, 0x15, 0x18,
    0x0A, 0x0D, 0x15, 0x18,
    0x0A, 0x0D, 0x11, 0x18,
    0x0A, 0x18, 0x18, 0x18,
    0x0A, 0x0A, 0x18, 0x18,
    0x0A, 0x0A, 0x0A, 0x18,
    0x0A, 0x10, 0x15, 0x1B,
    0x0A, 0x12, 0x17, 0x1B,
    0x0A, 0x0E, 0x17, 0x1B,
    0x0A, 0x0E, 0x13, 0x1B,
    0x0A, 0x1B, 0x1B, 0x1B,
    0x0A, 0x0A, 0x1B, 0x1B,
    0x0A, 0x0A, 0x0A, 0x1B,
    0x0A, 0x11, 0x17, 0x1E,
    0x0A, 0x14, 0x19, 0x1E,
    0x0A, 0x0F, 0x19, 0x1E,
    0x0A, 0x0F, 0x14, 0x1E,
    0x0A, 0x1E, 0x1E, 0x1E,
    0x0A, 0x0A, 0x1E, 0x1E,
    0x0A, 0x0A, 0x0A, 0x1E,
    0x0A, 0x15, 0x1C, 0x21,
    0x0A, 0x0F, 0x1C, 0x21,
    0x0A, 0x0F, 0x16, 0x21,
    0x0A, 0x21, 0x21, 0x21,
    0x0A, 0x0A, 0x21, 0x21,
    0x0A, 0x0A, 0x0A, 0x21,
    0x0A, 0x17, 0x1E, 0x24,
    0x0A, 0x10, 0x1E, 0x24,
    0x0A, 0x10, 0x17, 0x24,
    0x0A, 0x24, 0x24, 0x24,
    0x0A, 0x0A, 0x24, 0x24,
    0x0A, 0x0A, 0x0A, 0x24,
    0x0A, 0x18, 0x20, 0x27,
    0x0A, 0x11, 0x20, 0x27,
    0x0A, 0x11, 0x19, 0x27,
    0x0A, 0x27, 0x27, 0x27,
    0x0A, 0x0A, 0x27, 0x27,
    0x0A, 0x0A, 0x0A, 0x27,
    0x0A, 0x1A, 0x22, 0x2A,
    0x0A, 0x12, 0x22, 0x2A,
    0x0A, 0x12, 0x1A, 0x2A,
    0x0A, 0x2A, 0x2A, 0x2A,
    0x0A, 0x0A, 0x2A, 0x2A,
    0x0A, 0x0A, 0x0A, 0x2A,
    0x0A, 0x2D, 0x2D, 0x2D,
    0x0A, 0x0A, 0x2D, 0x2D,
    0x0A, 0x0A, 0x0A, 0x2D,
    0x0A, 0x1C, 0x25, 0x2E,
    0x0A, 0x13, 0x25, 0x2E,
    0x0A, 0x13, 0x1C, 0x2E,
    0x0A, 0x32, 0x32, 0x32,
    0x0A, 0x0A, 0x32, 0x32,
    0x0A, 0x0A, 0x0A, 0x32,
    0x0A, 0x38, 0x38, 0x38,
    0x0A, 0x0A, 0x38, 0x38,
    0x0A, 0x0A, 0x0A, 0x38,
    0x0B, 0x0C, 0x0C, 0x0D,
    0x0B, 0x0C, 0x0D, 0x0E,
    0x0B, 0x0D, 0x0E, 0x0F,
    0x0B, 0x0C, 0x0E, 0x0F,
    0x0B, 0x0C, 0x0D, 0x0F,
    0x0B, 0x0D, 0x0E, 0x10,
    0x0B, 0x0D, 0x0F, 0x10,
    0x0B, 0x0C, 0x0F, 0x10,
    0x0B, 0x0C, 0x0E, 0x10,
    0x0B, 0x0D, 0x0F, 0x11,
    0x0B, 0x0E, 0x10, 0x11,
    0x0B, 0x0C, 0x10, 0x11,
    0x0B, 0x0C, 0x0E, 0x11,
    0x0B, 0x11, 0x11, 0x11,
    0x0B, 0x0B, 0x11, 0x11,
    0x0B, 0x0B, 0x0B, 0x11,
    0x0B, 0x0E, 0x0F, 0x12,
    0x0B, 0x0E, 0x11, 0x12,
    0x0B, 0x0C, 0x11, 0x12,
    0x0B, 0x0C, 0x0F, 0x12,
    0x0B, 0x0E, 0x10, 0x13,
    0x0B, 0x0F, 0x11, 0x13,
    0x0B, 0x0D, 0x11, 0x13,
    0x0B, 0x0D, 0x0F, 0x13,
    0x0B, 0x13, 0x13, 0x13,
    0x0B, 0x0B, 0x13, 0x13,
    0x0B, 0x0B, 0x0B, 0x13,
    0x0B, 0x0F, 0x12, 0x16,
    0x0B, 0x10, 0x14, 0x16,
    0x0B, 0x0D, 0x14, 0x16,
    0x0B, 0x0D, 0x11, 0x16,
    0x0B, 0x16, 0x16, 0x16,
    0x0B, 0x0B, 0x16, 0x16,
    0x0B, 0x0B, 0x0B, 0x16,
    0x0B, 0x10, 0x14, 0x19,
    0x0B, 0x12, 0x16, 0x19,
    0x0B, 0x0E, 0x16, 0x19,
    0x0B, 0x0E, 0x12, 0x19,
    0x0B, 0x19, 0x19, 0x19,
    0x0B, 0x0B, 0x19, 0x19,
    0x0B, 0x0B, 0x0B, 0x19,
    0x0B, 0x11, 0x16, 0x1C,
    0x0B, 0x13, 0x18, 0x1C,
    0x0B, 0x0F, 0x18, 0x1C,
    0x0B, 0x0F, 0x14, 0x1C,
    0x0B, 0x1C, 0x1C, 0x1C,
    0x0B, 0x0B, 0x1C, 0x1C,
    0x0B, 0x0B, 0x0B, 0x1C,
    0x0B, 0x12, 0x18, 0x1F,
    0x0B, 0x15, 0x1A, 0x1F,
    0x0B, 0x10, 0x1A, 0x1F,
    0x0B, 0x10, 0x15, 0x1F,
    0x0B, 0x1F, 0x1F, 0x1F,
    0x0B, 0x0B, 0x1F, 0x1F,
    0x0B, 0x0B, 0x0B, 0x1F,
    0x0B, 0x16, 0x1D, 0x22,
    0x0B, 0x10, 0x1D, 0x22,
    0x0B, 0x10, 0x17, 0x22,
    0x0B, 0x22, 0x22, 0x22,
    0x0B, 0x0B, 0x22, 0x22,
    0x0B, 0x0B, 0x0B, 0x22,
    0x0B, 0x18, 0x1F, 0x25,
    0x0B, 0x11, 0x1F, 0x25,
    0x0B, 0x11, 0x18, 0x25,
    0x0B, 0x25, 0x25, 0x25,
    0x0B, 0x0B, 0x25, 0x25,
    0x0B, 0x0B, 0x0B, 0x25,
    0x0B, 0x19, 0x21, 0x28,
    0x0B, 0x12, 0x21, 0x28,
    0x0B, 0x12, 0x1A, 0x28,
    0x0B, 0x28, 0x28, 0x28,
    0x0B, 0x0B, 0x28, 0x28,
    0x0B, 0x0B, 0x0B, 0x28,
    0x0B, 0x1B, 0x23, 0x2B,
    0x0B, 0x13, 0x23, 0x2B,
    0x0B, 0x13, 0x1B, 0x2B,
    0x0B, 0x2B, 0x2B, 0x2B,
    0x0B, 0x0B, 0x2B, 0x2B,
    0x0B, 0x0B, 0x0B, 0x2B,
    0x0B, 0x2E, 0x2E, 0x2E,
    0x0B, 0x0B, 0x2E, 0x2E,
    0x0B, 0x0B, 0x0B, 0x2E,
    0x0B, 0x1D, 0x26, 0x2F,
    0x0B, 0x14, 0x26, 0x2F,
    0x0B, 0x14, 0x1D, 0x2F,
    0x0B, 0x33, 0x33, 0x33,
    0x0B, 0x0B, 0x33, 0x33,
    0x0B, 0x0B, 0x0B, 0x33,
    0x0B, 0x39, 0x39, 0x39,
    0x0B, 0x0B, 0x39, 0x39,
    0x0B, 0x0B, 0x0B, 0x39,
    0x0C, 0x0D, 0x0D, 0x0E,
    0x0C, 0x0D, 0x0E, 0x0F,
    0x0C, 0x0E, 0x0F, 0x10,
    0x0C, 0x0D, 0x0F, 0x10,
    0x0C, 0x0D, 0x0E, 0x10,
    0x0C, 0x0E, 0x0F, 0x11,
    0x0C, 0x0E, 0x10, 0x11,
    0x0C, 0x0D, 0x10, 0x11,
    0x0C, 0x0D, 0x0F, 0x11,
    0x0C, 0x0E, 0x10, 0x12,
    0x0C, 0x0F, 0x11, 0x12,
    0x0C, 0x0D, 0x11, 0x12,
    0x0C, 0x0D, 0x0F, 0x12,
    0x0C, 0x12, 0x12, 0x12,
    0x0C, 0x0C, 0x12, 0x12,
    0x0C, 0x0C, 0x0C, 0x12,
    0x0C, 0x0F, 0x10, 0x13,
    0x0C, 0x0F, 0x12, 0x13,
    0x0C, 0x0D, 0x12, 0x13,
    0x0C, 0x0D, 0x10, 0x13,
    0x0C, 0x0F, 0x11, 0x14,
    0x0C, 0x10, 0x12, 0x14,
    0x0C, 0x0E, 0x12, 0x14,
    0x0C, 0x0E, 0x10, 0x14,
    0x0C, 0x14, 0x14, 0x14,
    0x0C, 0x0C, 0x14, 0x14,
    0x0C, 0x0C, 0x0C, 0x14,
    0x0C, 0x10, 0x13, 0x17,
    0x0C, 0x11, 0x15, 0x17,
    0x0C, 0x0E, 0x15, 0x17,
    0x0C, 0x0E, 0x12, 0x17,
    0x0C, 0x17, 0x17, 0x17,
    0x0C, 0x0C, 0x17, 0x17,
    0x0C, 0x0C, 0x0C, 0x17,
    0x0C, 0x11, 0x15, 0x1A,
    0x0C, 0x13, 0x17, 0x1A,
    0x0C, 0x0F, 0x17, 0x1A,
    0x0C, 0x0F, 0x13, 0x1A,
    0x0C, 0x1A, 0x1A, 0x1A,
    0x0C, 0x0C, 0x1A, 0x1A,
    0x0C, 0x0C, 0x0C, 0x1A,
    0x0C, 0x12, 0x17, 0x1D,
    0x0C, 0x14, 0x19, 0x1D,
    0x0C, 0x10, 0x19, 0x1D,
    0x0C, 0x10, 0x15, 0x1D,
    0x0C, 0x1D, 0x1D, 0x1D,
    0x0C, 0x0C, 0x1D, 0x1D,
    0x0C, 0x0C, 0x0C, 0x1D,
    0x0C, 0x13, 0x19, 0x20,
    0x0C, 0x16, 0x1B, 0x20,
    0x0C, 0x11, 0x1B, 0x20,
    0x0C, 0x11, 0x16, 0x20,
    0x0C, 0x20, 0x20, 0x20,
    0x0C, 0x0C, 0x20, 0x20,
    0x0C, 0x0C, 0x0C, 0x20,
    0x0C, 0x17, 0x1E, 0x23,
    0x0C, 0x11, 0x1E, 0x23,
    0x0C, 0x11, 0x18, 0x23,
    0x0C, 0x23, 0x23, 0x23,
    0x0C, 0x0C, 0x23, 0x23,
    0x0C, 0x0C, 0x0C, 0x23,
    0x0C, 0x19, 0x20, 0x26,
    0x0C, 0x12, 0x20, 0x26,
    0x0C, 0x12, 0x19, 0x26,
    0x0C, 0x26, 0x26, 0x26,
    0x0C, 0x0C, 0x26, 0x26,
    0x0C, 0x0C, 0x0C, 0x26,
    0x0C, 0x1A, 0x22, 0x29,
    0x0C, 0x13, 0x22, 0x29,
    0x0C, 0x13, 0x1B, 0x29,
    0x0C, 0x29, 0x29, 0x29,
    0x0C, 0x0C, 0x29, 0x29,
    0x0C, 0x0C, 0x0C, 0x29,
    0x0C, 0x1C, 0x24, 0x2C,
    0x0C, 0x14, 0x24, 0x2C,
    0x0C, 0x14, 0x1C, 0x2C,
    0x0C, 0x2C, 0x2C, 0x2C,
    0x0C, 0x0C, 0x2C, 0x2C,
    0x0C, 0x0C, 0x0C, 0x2C,
    0x0C, 0x2F, 0x2F, 0x2F,
    0x0C, 0x0C, 0x2F, 0x2F,
    0x0C, 0x0C, 0x0C, 0x2F,
    0x0C, 0x1E, 0x27, 0x30,
    0x0C, 0x15, 0x27, 0x30,
    0x0C, 0x15, 0x1E, 0x30,
    0x0C, 0x34, 0x34, 0x34,
    0x0C, 0x0C, 0x34, 0x34,
    0x0C, 0x0C, 0x0C, 0x34,
    0x0C, 0x3A, 0x3A, 0x3A,
    0x0C, 0x0C, 0x3A, 0x3A,
    0x0C, 0x0C, 0x0C, 0x3A,
    0x0D, 0x0E, 0x0E, 0x0F,
    0x0D, 0x0E, 0x0F, 0x10,
    0x0D, 0x0F, 0x10, 0x11,
    0x0D, 0x0E, 0x10, 0x11,
    0x0D, 0x0E, 0x0F, 0x11,
    0x0D, 0x0F, 0x10, 0x12,
    0x0D, 0x0F, 0x11, 0x12,
    0x0D, 0x0E, 0x11, 0x12,
    0x0D, 0x0E, 0x10, 0x12,
    0x0D, 0x0F, 0x11, 0x13,
    0x0D, 0x10, 0x12, 0x13,
    0x0D, 0x0E, 0x12, 0x13,
    0x0D, 0x0E, 0x10, 0x13,
    0x0D, 0x13, 0x13, 0x13,
    0x0D, 0x0D, 0x13, 0x13,
    0x0D, 0x0D, 0x0D, 0x13,
    0x0D, 0x10, 0x11, 0x14,
    0x0D, 0x10, 0x13, 0x14,
    0x0D, 0x0E, 0x13, 0x14,
    0x0D, 0x0E, 0x11, 0x14,
    0x0D, 0x10, 0x12, 0x15,
    0x0D, 0x11, 0x13, 0x15,
    0x0D, 0x0F, 0x13, 0x15,
    0x0D, 0x0F, 0x11, 0x15,
    0x0D, 0x15, 0x15, 0x15,
    0x0D, 0x0D, 0x15, 0x15,
    0x0D, 0x0D, 0x0D, 0x15,
    0x0D, 0x11, 0x14, 0x18,
    0x0D, 0x12, 0x16, 0x18,
    0x0D, 0x0F, 0x16, 0x18,
    0x0D, 0x0F, 0x13, 0x18,
    0x0D, 0x18, 0x18, 0x18,
    0x0D, 0x0D, 0x18, 0x18,
    0x0D, 0x0D, 0x0D, 0x18,
    0x0D, 0x12, 0x16, 0x1B,
    0x0D, 0x14, 0x18, 0x1B,
    0x0D, 0x10, 0x18, 0x1B,
    0x0D, 0x10, 0x14, 0x1B,
    0x0D, 0x1B, 0x1B, 0x1B,
    0x0D, 0x0D, 0x1B, 0x1B,
    0x0D, 0x0D, 0x0D, 0x1B,
    0x0D, 0x13, 0x18, 0x1E,
    0x0D, 0x15, 0x1A, 0x1E,
    0x0D, 0x11, 0x1A, 0x1E,
    0x0D, 0x11, 0x16, 0x1E,
    0x0D, 0x1E, 0x1E, 0x1E,
    0x0D, 0x0D, 0x1E, 0x1E,
    0x0D, 0x0D, 0x0D, 0x1E,
    0x0D, 0x14, 0x1A, 0x21,
    0x0D, 0x17, 0x1C, 0x21,
    0x0D, 0x12, 0x1C, 0x21,
    0x0D, 0x12, 0x17, 0x21,
    0x0D, 0x21, 0x21, 0x21,
    0x0D, 0x0D, 0x21, 0x21,
    0x0D, 0x0D, 0x0D, 0x21,
    0x0D, 0x18, 0x1F, 0x24,
    0x0D, 0x12, 0x1F, 0x24,
    0x0D, 0x12, 0x19, 0x24,
    0x0D, 0x24, 0x24, 0x24,
    0x0D, 0x0D, 0x24, 0x24,
    0x0D, 0x0D, 0x0D, 0x24,
    0x0D, 0x1A, 0x21, 0x27,
    0x0D, 0x13, 0x21, 0x27,
    0x0D, 0x13, 0x1A, 0x27,
    0x0D, 0x27, 0x27, 0x27,
    0x0D, 0x0D, 0x27, 0x27,
    0x0D, 0x0D, 0x0D, 0x27,
    0x0D, 0x1B, 0x23, 0x2A,
    0x0D, 0x14, 0x23, 0x2A,
    0x0D, 0x14, 0x1C, 0x2A,
    0x0D, 0x2A, 0x2A, 0x2A,
    0x0D, 0x0D, 0x2A, 0x2A,
    0x0D, 0x0D, 0x0D, 0x2A,
    0x0D, 0x1D, 0x25, 0x2D,
    0x0D, 0x15, 0x25, 0x2D,
    0x0D, 0x15, 0x1D, 0x2D,
    0x0D, 0x2D, 0x2D, 0x2D,
    0x0D, 0x0D, 0x2D, 0x2D,
    0x0D, 0x0D, 0x0D, 0x2D,
    0x0D, 0x30, 0x30, 0x30,
    0x0D, 0x0D, 0x30, 0x30,
    0x0D, 0x0D, 0x0D, 0x30,
    0x0D, 0x1F, 0x28, 0x31,
    0x0D, 0x16, 0x28, 0x31,
    0x0D, 0x16, 0x1F, 0x31,
    0x0D, 0x35, 0x35, 0x35,
    0x0D, 0x0D, 0x35, 0x35,
    0x0D, 0x0D, 0x0D, 0x35,
    0x0D, 0x3B, 0x3B, 0x3B,
    0x0D, 0x0D, 0x3B, 0x3B,
    0x0D, 0x0D, 0x0D, 0x3B,
    0x0E, 0x0F, 0x0F, 0x10,
    0x0E, 0x0F, 0x10, 0x11,
    0x0E, 0x10, 0x11, 0x12,
    0x0E, 0x0F, 0x11, 0x12,
    0x0E, 0x0F, 0x10, 0x12,
    0x0E, 0x10, 0x11, 0x13,
    0x0E, 0x10, 0x12, 0x13,
    0x0E, 0x0F, 0x12, 0x13,
    0x0E, 0x0F, 0x11, 0x13,
    0x0E, 0x10, 0x12, 0x14,
    0x0E, 0x11, 0x13, 0x14,
    0x0E, 0x0F, 0x13, 0x14,
    0x0E, 0x0F, 0x11, 0x14,
    0x0E, 0x14, 0x14, 0x14,
    0x0E, 0x0E, 0x14, 0x14,
    0x0E, 0x0E, 0x0E, 0x14,
    0x0E, 0x11, 0x12, 0x15,
    0x0E, 0x11, 0x14, 0x15,
    0x0E, 0x0F, 0x14, 0x15,
    0x0E, 0x0F, 0x12, 0x15,
    0x0E, 0x11, 0x13, 0x16,
    0x0E, 0x12, 0x14, 0x16,
    0x0E, 0x10, 0x14, 0x16,
    0x0E, 0x10, 0x12, 0x16,
    0x0E, 0x16, 0x16, 0x16,
    0x0E, 0x0E, 0x16, 0x16,
    0x0E, 0x0E, 0x0E, 0x16,
    0x0E, 0x12, 0x15, 0x19,
    0x0E, 0x13, 0x17, 0x19,
    0x0E, 0x10, 0x17, 0x19,
    0x0E, 0x10, 0x14, 0x19,
    0x0E, 0x19, 0x19, 0x19,
    0x0E, 0x0E, 0x19, 0x19,
    0x0E, 0x0E, 0x0E, 0x19,
    0x0E, 0x13, 0x17, 0x1C,
    0x0E, 0x15, 0x19, 0x1C,
    0x0E, 0x11, 0x19, 0x1C,
    0x0E, 0x11, 0x15, 0x1C,
    0x0E, 0x1C, 0x1C, 0x1C,
    0x0E, 0x0E, 0x1C, 0x1C,
    0x0E, 0x0E, 0x0E, 0x1C,
    0x0E, 0x14, 0x19, 0x1F,
    0x0E, 0x16, 0x1B, 0x1F,
    0x0E, 0x12, 0x1B, 0x1F,
    0x0E, 0x12, 0x17, 0x1F,
    0x0E, 0x1F, 0x1F, 0x1F,
    0x0E, 0x0E, 0x1F, 0x1F,
    0x0E, 0x0E, 0x0E, 0x1F,
    0x0E, 0x15, 0x1B, 0x22,
    0x0E, 0x18, 0x1D, 0x22,
    0x0E, 0x13, 0x1D, 0x22,
    0x0E, 0x13, 0x18, 0x22,
    0x0E, 0x22, 0x22, 0x22,
    0x0E, 0x0E, 0x22, 0x22,
    0x0E, 0x0E, 0x0E, 0x22,
    0x0E, 0x19, 0x20, 0x25,
    0x0E, 0x13, 0x20, 0x25,
    0x0E, 0x13, 0x1A, 0x25,
    0x0E, 0x25, 0x25, 0x25,
    0x0E, 0x0E, 0x25, 0x25,
    0x0E, 0x0E, 0x0E, 0x25,
    0x0E, 0x1B, 0x22, 0x28,
    0x0E, 0x14, 0x22, 0x28,
    0x0E, 0x14, 0x1B, 0x28,
    0x0E, 0x28, 0x28, 0x28,
    0x0E, 0x0E, 0x28, 0x28,
    0x0E, 0x0E, 0x0E, 0x28,
    0x0E, 0x1C, 0x24, 0x2B,
    0x0E, 0x15, 0x24, 0x2B,
    0x0E, 0x15, 0x1D, 0x2B,
    0x0E, 0x2B, 0x2B, 0x2B,
    0x0E, 0x0E, 0x2B, 0x2B,
    0x0E, 0x0E, 0x0E, 0x2B,
    0x0E, 0x1E, 0x26, 0x2E,
    0x0E, 0x16, 0x26, 0x2E,
    0x0E, 0x16, 0x1E, 0x2E,
    0x0E, 0x2E, 0x2E, 0x2E,
    0x0E, 0x0E, 0x2E, 0x2E,
    0x0E, 0x0E, 0x0E, 0x2E,
    0x0E, 0x31, 0x31, 0x31,
    0x0E, 0x0E, 0x31, 0x31,
    0x0E, 0x0E, 0x0E, 0x31,
    0x0E, 0x20, 0x29, 0x32,
    0x0E, 0x17, 0x29, 0x32,
    0x0E, 0x17, 0x20, 0x32,
    0x0E, 0x36, 0x36, 0x36,
    0x0E, 0x0E, 0x36, 0x36,
    0x0E, 0x0E, 0x0E, 0x36,
    0x0E, 0x3C, 0x3C, 0x3C,
    0x0E, 0x0E, 0x3C, 0x3C,
    0x0E, 0x0E, 0x0E, 0x3C,
    0x0F, 0x10, 0x10, 0x11,
    0x0F, 0x10, 0x11, 0x12,
    0x0F, 0x11, 0x12, 0x13,
    0x0F, 0x10, 0x12, 0x13,
    0x0F, 0x10, 0x11, 0x13,
    0x0F, 0x11, 0x12, 0x14,
    0x0F, 0x11, 0x13, 0x14,
    0x0F, 0x10, 0x13, 0x14,
    0x0F, 0x10, 0x12, 0x14,
    0x0F, 0x11, 0x13, 0x15,
    0x0F, 0x12, 0x14, 0x15,
    0x0F, 0x10, 0x14, 0x15,
    0x0F, 0x10, 0x12, 0x15,
    0x0F, 0x15, 0x15, 0x15,
    0x0F, 0x0F, 0x15, 0x15,
    0x0F, 0x0F, 0x0F, 0x15,
    0x0F, 0x12, 0x13, 0x16,
    0x0F, 0x12, 0x15, 0x16,
    0x0F, 0x10, 0x15, 0x16,
    0x0F, 0x10, 0x13, 0x16,
    0x0F, 0x12, 0x14, 0x17,
    0x0F, 0x13, 0x15, 0x17,
    0x0F, 0x11, 0x15, 0x17,
    0x0F, 0x11, 0x13, 0x17,
    0x0F, 0x17, 0x17, 0x17,
    0x0F, 0x0F, 0x17, 0x17,
    0x0F, 0x0F, 0x0F, 0x17,
    0x0F, 0x13, 0x16, 0x1A,
    0x0F, 0x14, 0x18, 0x1A,
    0x0F, 0x11, 0x18, 0x1A,
    0x0F, 0x11, 0x15, 0x1A,
    0x0F, 0x1A, 0x1A, 0x1A,
    0x0F, 0x0F, 0x1A, 0x1A,
    0x0F, 0x0F, 0x0F, 0x1A,
    0x0F, 0x14, 0x18, 0x1D,
    0x0F, 0x16, 0x1A, 0x1D,
    0x0F, 0x12, 0x1A, 0x1D,
    0x0F, 0x12, 0x16, 0x1D,
    0x0F, 0x1D, 0x1D, 0x1D,
    0x0F, 0x0F, 0x1D, 0x1D,
    0x0F, 0x0F, 0x0F, 0x1D,
    0x0F, 0x15, 0x1A, 0x20,
    0x0F, 0x17, 0x1C, 0x20,
    0x0F, 0x13, 0x1C, 0x20,
    0x0F, 0x13, 0x18, 0x20,
    0x0F, 0x20, 0x20, 0x20,
    0x0F, 0x0F, 0x20, 0x20,
    0x0F, 0x0F, 0x0F, 0x20,
    0x0F, 0x16, 0x1C, 0x23,
    0x0F, 0x19, 0x1E, 0x23,
    0x0F, 0x14, 0x1E, 0x23,
    0x0F, 0x14, 0x19, 0x23,
    0x0F, 0x23, 0x23, 0x23,
    0x0F, 0x0F, 0x23, 0x23,
    0x0F, 0x0F, 0x0F, 0x23,
    0x0F, 0x1A, 0x21, 0x26,
    0x0F, 0x14, 0x21, 0x26,
    0x0F, 0x14, 0x1B, 0x26,
    0x0F, 0x26, 0x26, 0x26,
    0x0F, 0x0F, 0x26, 0x26,
    0x0F, 0x0F, 0x0F, 0x26,
    0x0F, 0x1C, 0x23, 0x29,
    0x0F, 0x15, 0x23, 0x29,
    0x0F, 0x15, 0x1C, 0x29,
    0x0F, 0x29, 0x29, 0x29,
    0x0F, 0x0F, 0x29, 0x29,
    0x0F, 0x0F, 0x0F, 0x29,
    0x0F, 0x1D, 0x25, 0x2C,
    0x0F, 0x16, 0x25, 0x2C,
    0x0F, 0x16, 0x1E, 0x2C,
    0x0F, 0x2C, 0x2C, 0x2C,
    0x0F, 0x0F, 0x2C, 0x2C,
    0x0F, 0x0F, 0x0F, 0x2C,
    0x0F, 0x1F, 0x27, 0x2F,
    0x0F, 0x17, 0x27, 0x2F,
    0x0F, 0x17, 0x1F, 0x2F,
    0x0F, 0x2F, 0x2F, 0x2F,
    0x0F, 0x0F, 0x2F, 0x2F,
    0x0F, 0x0F, 0x0F, 0x2F,
    0x0F, 0x32, 0x32, 0x32,
    0x0F, 0x0F, 0x32, 0x32,
    0x0F, 0x0F, 0x0F, 0x32,
    0x0F, 0x21, 0x2A, 0x33,
    0x0F, 0x18, 0x2A, 0x33,
    0x0F, 0x18, 0x21, 0x33,
    0x0F, 0x37, 0x37, 0x37,
    0x0F, 0x0F, 0x37, 0x37,
    0x0F, 0x0F, 0x0F, 0x37,
    0x0F, 0x3D, 0x3D, 0x3D,
    0x0F, 0x0F, 0x3D, 0x3D,
    0x0F, 0x0F, 0x0F, 0x3D,
    0x10, 0x11, 0x11, 0x12,
    0x10, 0x11, 0x12, 0x13,
    0x10, 0x12, 0x13, 0x14,
    0x10, 0x11, 0x13, 0x14,
    0x10, 0x11, 0x12, 0x14,
    0x10, 0x12, 0x13, 0x15,
    0x10, 0x12, 0x14, 0x15,
    0x10, 0x11, 0x14, 0x15,
    0x10, 0x11, 0x13, 0x15,
    0x10, 0x12, 0x14, 0x16,
    0x10, 0x13, 0x15, 0x16,
    0x10, 0x11, 0x15, 0x16,
    0x10, 0x11, 0x13, 0x16,
    0x10, 0x16, 0x16, 0x16,
    0x10, 0x10, 0x16, 0x16,
    0x10, 0x10, 0x10, 0x16,
    0x10, 0x13, 0x14, 0x17,
    0x10, 0x13, 0x16, 0x17,
    0x10, 0x11, 0x16, 0x17,
    0x10, 0x11, 0x14, 0x17,
    0x10, 0x13, 0x15, 0x18,
    0x10, 0x14, 0x16, 0x18,
    0x10, 0x12, 0x16, 0x18,
    0x10, 0x12, 0x14, 0x18,
    0x10, 0x18, 0x18, 0x18,
    0x10, 0x10, 0x18, 0x18,
    0x10, 0x10, 0x10, 0x18,
    0x10, 0x14, 0x17, 0x1B,
    0x10, 0x15, 0x19, 0x1B,
    0x10, 0x12, 0x19, 0x1B,
    0x10, 0x12, 0x16, 0x1B,
    0x10, 0x1B, 0x1B, 0x1B,
    0x10, 0x10, 0x1B, 0x1B,
    0x10, 0x10, 0x10, 0x1B,
    0x10, 0x15, 0x19, 0x1E,
    0x10, 0x17, 0x1B, 0x1E,
    0x10, 0x13, 0x1B, 0x1E,
    0x10, 0x13, 0x17, 0x1E,
    0x10, 0x1E, 0x1E, 0x1E,
    0x10, 0x10, 0x1E, 0x1E,
    0x10, 0x10, 0x10, 0x1E,
    0x10, 0x16, 0x1B, 0x21,
    0x10, 0x18, 0x1D, 0x21,
    0x10, 0x14, 0x1D, 0x21,
    0x10, 0x14, 0x19, 0x21,
    0x10, 0x21, 0x21, 0x21,
    0x10, 0x10, 0x21, 0x21,
    0x10, 0x10, 0x10, 0x21,
    0x10, 0x17, 0x1D, 0x24,
    0x10, 0x1A, 0x1F, 0x24,
    0x10, 0x15, 0x1F, 0x24,
    0x10, 0x15, 0x1A, 0x24,
    0x10, 0x24, 0x24, 0x24,
    0x10, 0x10, 0x24, 0x24,
    0x10, 0x10, 0x10, 0x24,
    0x10, 0x1B, 0x22, 0x27,
    0x10, 0x15, 0x22, 0x27,
    0x10, 0x15, 0x1C, 0x27,
    0x10, 0x27, 0x27, 0x27,
    0x10, 0x10, 0x27, 0x27,
    0x10, 0x10, 0x10, 0x27,
    0x10, 0x1D, 0x24, 0x2A,
    0x10, 0x16, 0x24, 0x2A,
    0x10, 0x16, 0x1D, 0x2A,
    0x10, 0x2A, 0x2A, 0x2A,
    0x10, 0x10, 0x2A, 0x2A,
    0x10, 0x10, 0x10, 0x2A,
    0x10, 0x1E, 0x26, 0x2D,
    0x10, 0x17, 0x26, 0x2D,
    0x10, 0x17, 0x1F, 0x2D,
    0x10, 0x2D, 0x2D, 0x2D,
    0x10, 0x10, 0x2D, 0x2D,
    0x10, 0x10, 0x10, 0x2D,
    0x10, 0x20, 0x28, 0x30,
    0x10, 0x18, 0x28, 0x30,
    0x10, 0x18, 0x20, 0x30,
    0x10, 0x30, 0x30, 0x30,
    0x10, 0x10, 0x30, 0x30,
    0x10, 0x10, 0x10, 0x30,
    0x10, 0x33, 0x33, 0x33,
    0x10, 0x10, 0x33, 0x33,
    0x10, 0x10, 0x10, 0x33,
    0x10, 0x22, 0x2B, 0x34,
    0x10, 0x19, 0x2B, 0x34,
    0x10, 0x19, 0x22, 0x34,
    0x10, 0x38, 0x38, 0x38,
    0x10, 0x10, 0x38, 0x38,
    0x10, 0x10, 0x10, 0x38,
    0x10, 0x3E, 0x3E, 0x3E,
    0x10, 0x10, 0x3E, 0x3E,
    0x10, 0x10, 0x10, 0x3E,
    0x11, 0x12, 0x12, 0x13,
    0x11, 0x12, 0x13, 0x14,
    0x11, 0x13, 0x14, 0x15,
    0x11, 0x12, 0x14, 0x15,
    0x11, 0x12, 0x13, 0x15,
    0x11, 0x13, 0x14, 0x16,
    0x11, 0x13, 0x15, 0x16,
    0x11, 0x12, 0x15, 0x16,
    0x11, 0x12, 0x14, 0x16,
    0x11, 0x13, 0x15, 0x17,
    0x11, 0x14, 0x16, 0x17,
    0x11, 0x12, 0x16, 0x17,
    0x11, 0x12, 0x14, 0x17,
    0x11, 0x17, 0x17, 0x17,
    0x11, 0x11, 0x17, 0x17,
    0x11, 0x11, 0x11, 0x17,
    0x11, 0x14, 0x15, 0x18,
    0x11, 0x14, 0x17, 0x18,
    0x11, 0x12, 0x17, 0x18,
    0x11, 0x12, 0x15, 0x18,
    0x11, 0x14, 0x16, 0x19,
    0x11, 0x15, 0x17, 0x19,
    0x11, 0x13, 0x17, 0x19,
    0x11, 0x13, 0x15, 0x19,
    0x11, 0x19, 0x19, 0x19,
    0x11, 0x11, 0x19, 0x19,
    0x11, 0x11, 0x11, 0x19,
    0x11, 0x15, 0x18, 0x1C,
    0x11, 0x16, 0x1A, 0x1C,
    0x11, 0x13, 0x1A, 0x1C,
    0x11, 0x13, 0x17, 0x1C,
    0x11, 0x1C, 0x1C, 0x1C,
    0x11, 0x11, 0x1C, 0x1C,
    0x11, 0x11, 0x11, 0x1C,
    0x11, 0x16, 0x1A, 0x1F,
    0x11, 0x18, 0x1C, 0x1F,
    0x11, 0x14, 0x1C, 0x1F,
    0x11, 0x14, 0x18, 0x1F,
    0x11, 0x1F, 0x1F, 0x1F,
    0x11, 0x11, 0x1F, 0x1F,
    0x11, 0x11, 0x11, 0x1F,
    0x11, 0x17, 0x1C, 0x22,
    0x11, 0x19, 0x1E, 0x22,
    0x11, 0x15, 0x1E, 0x22,
    0x11, 0x15, 0x1A, 0x22,
    0x11, 0x22, 0x22, 0x22,
    0x11, 0x11, 0x22, 0x22,
    0x11, 0x11, 0x11, 0x22,
    0x11, 0x18, 0x1E, 0x25,
    0x11, 0x1B, 0x20, 0x25,
    0x11, 0x16, 0x20, 0x25,
    0x11, 0x16, 0x1B, 0x25,
    0x11, 0x25, 0x25, 0x25,
    0x11, 0x11, 0x25, 0x25,
    0x11, 0x11, 0x11, 0x25,
    0x11, 0x1C, 0x23, 0x28,
    0x11, 0x16, 0x23, 0x28,
    0x11, 0x16, 0x1D, 0x28,
    0x11, 0x28, 0x28, 0x28,
    0x11, 0x11, 0x28, 0x28,
    0x11, 0x11, 0x11, 0x28,
    0x11, 0x1E, 0x25, 0x2B,
    0x11, 0x17, 0x25, 0x2B,
    0x11, 0x17, 0x1E, 0x2B,
    0x11, 0x2B, 0x2B, 0x2B,
    0x11, 0x11, 0x2B, 0x2B,
    0x11, 0x11, 0x11, 0x2B,
    0x11, 0x1F, 0x27, 0x2E,
    0x11, 0x18, 0x27, 0x2E,
    0x11, 0x18, 0x20, 0x2E,
    0x11, 0x2E, 0x2E, 0x2E,
    0x11, 0x11, 0x2E, 0x2E,
    0x11, 0x11, 0x11, 0x2E,
    0x11, 0x21, 0x29, 0x31,
    0x11, 0x19, 0x29, 0x31,
    0x11, 0x19, 0x21, 0x31,
    0x11, 0x31, 0x31, 0x31,
    0x11, 0x11, 0x31, 0x31,
    0x11, 0x11, 0x11, 0x31,
    0x11, 0x34, 0x34, 0x34,
    0x11, 0x11, 0x34, 0x34,
    0x11, 0x11, 0x11, 0x34,
    0x11, 0x23, 0x2C, 0x35,
    0x11, 0x1A, 0x2C, 0x35,
    0x11, 0x1A, 0x23, 0x35,
    0x11, 0x39, 0x39, 0x39,
    0x11, 0x11, 0x39, 0x39,
    0x11, 0x11, 0x11, 0x39,
    0x11, 0x3F, 0x3F, 0x3F,
    0x11, 0x11, 0x3F, 0x3F,
    0x11, 0x11, 0x11, 0x3F,
    0x12, 0x13, 0x13, 0x14,
    0x12, 0x13, 0x14, 0x15,
    0x12, 0x14, 0x15, 0x16,
    0x12, 0x13, 0x15, 0x16,
    0x12, 0x13, 0x14, 0x16,
    0x12, 0x14, 0x15, 0x17,
    0x12, 0x14, 0x16, 0x17,
    0x12, 0x13, 0x16, 0x17,
    0x12, 0x13, 0x15, 0x17,
    0x12, 0x14, 0x16, 0x18,
    0x12, 0x15, 0x17, 0x18,
    0x12, 0x13, 0x17, 0x18,
    0x12, 0x13, 0x15, 0x18,
    0x12, 0x18, 0x18, 0x18,
    0x12, 0x12, 0x18, 0x18,
    0x12, 0x12, 0x12, 0x18,
    0x12, 0x15, 0x16, 0x19,
    0x12, 0x15, 0x18, 0x19,
    0x12, 0x13, 0x18, 0x19,
    0x12, 0x13, 0x16, 0x19,
    0x12, 0x15, 0x17, 0x1A,
    0x12, 0x16, 0x18, 0x1A,
    0x12, 0x14, 0x18, 0x1A,
    0x12, 0x14, 0x16, 0x1A,
    0x12, 0x1A, 0x1A, 0x1A,
    0x12, 0x12, 0x1A, 0x1A,
    0x12, 0x12, 0x12, 0x1A,
    0x12, 0x16, 0x19, 0x1D,
    0x12, 0x17, 0x1B, 0x1D,
    0x12, 0x14, 0x1B, 0x1D,
    0x12, 0x14, 0x18, 0x1D,
    0x12, 0x1D, 0x1D, 0x1D,
    0x12, 0x12, 0x1D, 0x1D,
    0x12, 0x12, 0x12, 0x1D,
    0x12, 0x17, 0x1B, 0x20,
    0x12, 0x19, 0x1D, 0x20,
    0x12, 0x15, 0x1D, 0x20,
    0x12, 0x15, 0x19, 0x20,
    0x12, 0x20, 0x20, 0x20,
    0x12, 0x12, 0x20, 0x20,
    0x12, 0x12, 0x12, 0x20,
    0x12, 0x18, 0x1D, 0x23,
    0x12, 0x1A, 0x1F, 0x23,
    0x12, 0x16, 0x1F, 0x23,
    0x12, 0x16, 0x1B, 0x23,
    0x12, 0x23, 0x23, 0x23,
    0x12, 0x12, 0x23, 0x23,
    0x12, 0x12, 0x12, 0x23,
    0x12, 0x19, 0x1F, 0x26,
    0x12, 0x1C, 0x21, 0x26,
    0x12, 0x17, 0x21, 0x26,
    0x12, 0x17, 0x1C, 0x26,
    0x12, 0x26, 0x26, 0x26,
    0x12, 0x12, 0x26, 0x26,
    0x12, 0x12, 0x12, 0x26,
    0x12, 0x1D, 0x24, 0x29,
    0x12, 0x17, 0x24, 0x29,
    0x12, 0x17, 0x1E, 0x29,
    0x12, 0x29, 0x29, 0x29,
    0x12, 0x12, 0x29, 0x29,
    0x12, 0x12, 0x12, 0x29,
    0x12, 0x1F, 0x26, 0x2C,
    0x12, 0x18, 0x26, 0x2C,
    0x12, 0x18, 0x1F, 0x2C,
    0x12, 0x2C, 0x2C, 0x2C,
    0x12, 0x12, 0x2C, 0x2C,
    0x12, 0x12, 0x12, 0x2C,
    0x12, 0x20, 0x28, 0x2F,
    0x12, 0x19, 0x28, 0x2F,
    0x12, 0x19, 0x21, 0x2F,
    0x12, 0x2F, 0x2F, 0x2F,
    0x12, 0x12, 0x2F, 0x2F,
    0x12, 0x12, 0x12, 0x2F,
    0x12, 0x22, 0x2A, 0x32,
    0x12, 0x1A, 0x2A, 0x32,
    0x12, 0x1A, 0x22, 0x32,
    0x12, 0x32, 0x32, 0x32,
    0x12, 0x12, 0x32, 0x32,
    0x12, 0x12, 0x12, 0x32,
    0x12, 0x35, 0x35, 0x35,
    0x12, 0x12, 0x35, 0x35,
    0x12, 0x12, 0x12, 0x35,
    0x12, 0x24, 0x2D, 0x36,
    0x12, 0x1B, 0x2D, 0x36,
    0x12, 0x1B, 0x24, 0x36,
    0x12, 0x3A, 0x3A, 0x3A,
    0x12, 0x12, 0x3A, 0x3A,
    0x12, 0x12, 0x12, 0x3A,
    0x13, 0x14, 0x14, 0x15,
    0x13, 0x14, 0x15, 0x16,
    0x13, 0x15, 0x16, 0x17,
    0x13, 0x14, 0x16, 0x17,
    0x13, 0x14, 0x15, 0x17,
    0x13, 0x15, 0x16, 0x18,
    0x13, 0x15, 0x17, 0x18,
    0x13, 0x14, 0x17, 0x18,
    0x13, 0x14, 0x16, 0x18,
    0x13, 0x15, 0x17, 0x19,
    0x13, 0x16, 0x18, 0x19,
    0x13, 0x14, 0x18, 0x19,
    0x13, 0x14, 0x16, 0x19,
    0x13, 0x19, 0x19, 0x19,
    0x13, 0x13, 0x19, 0x19,
    0x13, 0x13, 0x13, 0x19,
    0x13, 0x16, 0x17, 0x1A,
    0x13, 0x16, 0x19, 0x1A,
    0x13, 0x14, 0x19, 0x1A,
    0x13, 0x14, 0x17, 0x1A,
    0x13, 0x16, 0x18, 0x1B,
    0x13, 0x17, 0x19, 0x1B,
    0x13, 0x15, 0x19, 0x1B,
    0x13, 0x15, 0x17, 0x1B,
    0x13, 0x1B, 0x1B, 0x1B,
    0x13, 0x13, 0x1B, 0x1B,
    0x13, 0x13, 0x13, 0x1B,
    0x13, 0x17, 0x1A, 0x1E,
    0x13, 0x18, 0x1C, 0x1E,
    0x13, 0x15, 0x1C, 0x1E,
    0x13, 0x15, 0x19, 0x1E,
    0x13, 0x1E, 0x1E, 0x1E,
    0x13, 0x13, 0x1E, 0x1E,
    0x13, 0x13, 0x13, 0x1E,
    0x13, 0x18, 0x1C, 0x21,
    0x13, 0x1A, 0x1E, 0x21,
    0x13, 0x16, 0x1E, 0x21,
    0x13, 0x16, 0x1A, 0x21,
    0x13, 0x21, 0x21, 0x21,
    0x13, 0x13, 0x21, 0x21,
    0x13, 0x13, 0x13, 0x21,
    0x13, 0x19, 0x1E, 0x24,
    0x13, 0x1B, 0x20, 0x24,
    0x13, 0x17, 0x20, 0x24,
    0x13, 0x17, 0x1C, 0x24,
    0x13, 0x24, 0x24, 0x24,
    0x13, 0x13, 0x24, 0x24,
    0x13, 0x13, 0x13, 0x24,
    0x13, 0x1A, 0x20, 0x27,
    0x13, 0x1D, 0x22, 0x27,
    0x13, 0x18, 0x22, 0x27,
    0x13, 0x18, 0x1D, 0x27,
    0x13, 0x27, 0x27, 0x27,
    0x13, 0x13, 0x27, 0x27,
    0x13, 0x13, 0x13, 0x27,
    0x13, 0x1E, 0x25, 0x2A,
    0x13, 0x18, 0x25, 0x2A,
    0x13, 0x18, 0x1F, 0x2A,
    0x13, 0x2A, 0x2A, 0x2A,
    0x13, 0x13, 0x2A, 0x2A,
    0x13, 0x13, 0x13, 0x2A,
    0x13, 0x20, 0x27, 0x2D,
    0x13, 0x19, 0x27, 0x2D,
    0x13, 0x19, 0x20, 0x2D,
    0x13, 0x2D, 0x2D, 0x2D,
    0x13, 0x13, 0x2D, 0x2D,
    0x13, 0x13, 0x13, 0x2D,
    0x13, 0x21, 0x29, 0x30,
    0x13, 0x1A, 0x29, 0x30,
    0x13, 0x1A, 0x22, 0x30,
    0x13, 0x30, 0x30, 0x30,
    0x13, 0x13, 0x30, 0x30,
    0x13, 0x13, 0x13, 0x30,
    0x13, 0x23, 0x2B, 0x33,
    0x13, 0x1B, 0x2B, 0x33,
    0x13, 0x1B, 0x23, 0x33,
    0x13, 0x33, 0x33, 0x33,
    0x13, 0x13, 0x33, 0x33,
    0x13, 0x13, 0x13, 0x33,
    0x13, 0x36, 0x36, 0x36,
    0x13, 0x13, 0x36, 0x36,
    0x13, 0x13, 0x13, 0x36,
    0x13, 0x25, 0x2E, 0x37,
    0x13, 0x1C, 0x2E, 0x37,
    0x13, 0x1C, 0x25, 0x37,
    0x13, 0x3B, 0x3B, 0x3B,
    0x13, 0x13, 0x3B, 0x3B,
    0x13, 0x13, 0x13, 0x3B,
    0x14, 0x15, 0x15, 0x16,
    0x14, 0x15, 0x16, 0x17,
    0x14, 0x16, 0x17, 0x18,
    0x14, 0x15, 0x17, 0x18,
    0x14, 0x15, 0x16, 0x18,
    0x14, 0x16, 0x17, 0x19,
    0x14, 0x16, 0x18, 0x19,
    0x14, 0x15, 0x18, 0x19,
    0x14, 0x15, 0x17, 0x19,
    0x14, 0x16, 0x18, 0x1A,
    0x14, 0x17, 0x19, 0x1A,
    0x14, 0x15, 0x19, 0x1A,
    0x14, 0x15, 0x17, 0x1A,
    0x14, 0x1A, 0x1A, 0x1A,
    0x14, 0x14, 0x1A, 0x1A,
    0x14, 0x14, 0x14, 0x1A,
    0x14, 0x17, 0x18, 0x1B,
    0x14, 0x17, 0x1A, 0x1B,
    0x14, 0x15, 0x1A, 0x1B,
    0x14, 0x15, 0x18, 0x1B,
    0x14, 0x17, 0x19, 0x1C,
    0x14, 0x18, 0x1A, 0x1C,
    0x14, 0x16, 0x1A, 0x1C,
    0x14, 0x16, 0x18, 0x1C,
    0x14, 0x1C, 0x1C, 0x1C,
    0x14, 0x14, 0x1C, 0x1C,
    0x14, 0x14, 0x14, 0x1C,
    0x14, 0x18, 0x1B, 0x1F,
    0x14, 0x19, 0x1D, 0x1F,
    0x14, 0x16, 0x1D, 0x1F,
    0x14, 0x16, 0x1A, 0x1F,
    0x14, 0x1F, 0x1F, 0x1F,
    0x14, 0x14, 0x1F, 0x1F,
    0x14, 0x14, 0x14, 0x1F,
    0x14, 0x19, 0x1D, 0x22,
    0x14, 0x1B, 0x1F, 0x22,
    0x14, 0x17, 0x1F, 0x22,
    0x14, 0x17, 0x1B, 0x22,
    0x14, 0x22, 0x22, 0x22,
    0x14, 0x14, 0x22, 0x22,
    0x14, 0x14, 0x14, 0x22,
    0x14, 0x1A, 0x1F, 0x25,
    0x14, 0x1C, 0x21, 0x25,
    0x14, 0x18, 0x21, 0x25,
    0x14, 0x18, 0x1D, 0x25,
    0x14, 0x25, 0x25, 0x25,
    0x14, 0x14, 0x25, 0x25,
    0x14, 0x14, 0x14, 0x25,
    0x14, 0x1B, 0x21, 0x28,
    0x14, 0x1E, 0x23, 0x28,
    0x14, 0x19, 0x23, 0x28,
    0x14, 0x19, 0x1E, 0x28,
    0x14, 0x28, 0x28, 0x28,
    0x14, 0x14, 0x28, 0x28,
    0x14, 0x14, 0x14, 0x28,
    0x14, 0x1F, 0x26, 0x2B,
    0x14, 0x19, 0x26, 0x2B,
    0x14, 0x19, 0x20, 0x2B,
    0x14, 0x2B, 0x2B, 0x2B,
    0x14, 0x14, 0x2B, 0x2B,
    0x14, 0x14, 0x14, 0x2B,
    0x14, 0x21, 0x28, 0x2E,
    0x14, 0x1A, 0x28, 0x2E,
    0x14, 0x1A, 0x21, 0x2E,
    0x14, 0x2E, 0x2E, 0x2E,
    0x14, 0x14, 0x2E, 0x2E,
    0x14, 0x14, 0x14, 0x2E,
    0x14, 0x22, 0x2A, 0x31,
    0x14, 0x1B, 0x2A, 0x31,
    0x14, 0x1B, 0x23, 0x31,
    0x14, 0x31, 0x31, 0x31,
    0x14, 0x14, 0x31, 0x31,
    0x14, 0x14, 0x14, 0x31,
    0x14, 0x24, 0x2C, 0x34,
    0x14, 0x1C, 0x2C, 0x34,
    0x14, 0x1C, 0x24, 0x34,
    0x14, 0x34, 0x34, 0x34,
    0x14, 0x14, 0x34, 0x34,
    0x14, 0x14, 0x14, 0x34,
    0x14, 0x37, 0x37, 0x37,
    0x14, 0x14, 0x37, 0x37,
    0x14, 0x14, 0x14, 0x37,
    0x14, 0x26, 0x2F, 0x38,
    0x14, 0x1D, 0x2F, 0x38,
    0x14, 0x1D, 0x26, 0x38,
    0x14, 0x3C, 0x3C, 0x3C,
    0x14, 0x14, 0x3C, 0x3C,
    0x14, 0x14, 0x14, 0x3C,
    0x15, 0x16, 0x16, 0x17,
    0x15, 0x16, 0x17, 0x18,
    0x15, 0x17, 0x18, 0x19,
    0x15, 0x16, 0x18, 0x19,
    0x15, 0x16, 0x17, 0x19,
    0x15, 0x17, 0x18, 0x1A,
    0x15, 0x17, 0x19, 0x1A,
    0x15, 0x16, 0x19, 0x1A,
    0x15, 0x16, 0x18, 0x1A,
    0x15, 0x17, 0x19, 0x1B,
    0x15, 0x18, 0x1A, 0x1B,
    0x15, 0x16, 0x1A, 0x1B,
    0x15, 0x16, 0x18, 0x1B,
    0x15, 0x1B, 0x1B, 0x1B,
    0x15, 0x15, 0x1B, 0x1B,
    0x15, 0x15, 0x15, 0x1B,
    0x15, 0x18, 0x19, 0x1C,
    0x15, 0x18, 0x1B, 0x1C,
    0x15, 0x16, 0x1B, 0x1C,
    0x15, 0x16, 0x19, 0x1C,
    0x15, 0x18, 0x1A, 0x1D,
    0x15, 0x19, 0x1B, 0x1D,
    0x15, 0x17, 0x1B, 0x1D,
    0x15, 0x17, 0x19, 0x1D,
    0x15, 0x1D, 0x1D, 0x1D,
    0x15, 0x15, 0x1D, 0x1D,
    0x15, 0x15, 0x15, 0x1D,
    0x15, 0x19, 0x1C, 0x20,
    0x15, 0x1A, 0x1E, 0x20,
    0x15, 0x17, 0x1E, 0x20,
    0x15, 0x17, 0x1B, 0x20,
    0x15, 0x20, 0x20, 0x20,
    0x15, 0x15, 0x20, 0x20,
    0x15, 0x15, 0x15, 0x20,
    0x15, 0x1A, 0x1E, 0x23,
    0x15, 0x1C, 0x20, 0x23,
    0x15, 0x18, 0x20, 0x23,
    0x15, 0x18, 0x1C, 0x23,
    0x15, 0x23, 0x23, 0x23,
    0x15, 0x15, 0x23, 0x23,
    0x15, 0x15, 0x15, 0x23,
    0x15, 0x1B, 0x20, 0x26,
    0x15, 0x1D, 0x22, 0x26,
    0x15, 0x19, 0x22, 0x26,
    0x15, 0x19, 0x1E, 0x26,
    0x15, 0x26, 0x26, 0x26,
    0x15, 0x15, 0x26, 0x26,
    0x15, 0x15, 0x15, 0x26,
    0x15, 0x1C, 0x22, 0x29,
    0x15, 0x1F, 0x24, 0x29,
    0x15, 0x1A, 0x24, 0x29,
    0x15, 0x1A, 0x1F, 0x29,
    0x15, 0x29, 0x29, 0x29,
    0x15, 0x15, 0x29, 0x29,
    0x15, 0x15, 0x15, 0x29,
    0x15, 0x20, 0x27, 0x2C,
    0x15, 0x1A, 0x27, 0x2C,
    0x15, 0x1A, 0x21, 0x2C,
    0x15, 0x2C, 0x2C, 0x2C,
    0x15, 0x15, 0x2C, 0x2C,
    0x15, 0x15, 0x15, 0x2C,
    0x15, 0x22, 0x29, 0x2F,
    0x15, 0x1B, 0x29, 0x2F,
    0x15, 0x1B, 0x22, 0x2F,
    0x15, 0x2F, 0x2F, 0x2F,
    0x15, 0x15, 0x2F, 0x2F,
    0x15, 0x15, 0x15, 0x2F,
    0x15, 0x23, 0x2B, 0x32,
    0x15, 0x1C, 0x2B, 0x32,
    0x15, 0x1C, 0x24, 0x32,
    0x15, 0x32, 0x32, 0x32,
    0x15, 0x15, 0x32, 0x32,
    0x15, 0x15, 0x15, 0x32,
    0x15, 0x25, 0x2D, 0x35,
    0x15, 0x1D, 0x2D, 0x35,
    0x15, 0x1D, 0x25, 0x35,
    0x15, 0x35, 0x35, 0x35,
    0x15, 0x15, 0x35, 0x35,
    0x15, 0x15, 0x15, 0x35,
    0x15, 0x38, 0x38, 0x38,
    0x15, 0x15, 0x38, 0x38,
    0x15, 0x15, 0x15, 0x38,
    0x15, 0x27, 0x30, 0x39,
    0x15, 0x1E, 0x30, 0x39,
    0x15, 0x1E, 0x27, 0x39,
    0x15, 0x3D, 0x3D, 0x3D,
    0x15, 0x15, 0x3D, 0x3D,
    0x15, 0x15, 0x15, 0x3D,
    0x16, 0x17, 0x17, 0x18,
    0x16, 0x17, 0x18, 0x19,
    0x16, 0x18, 0x19, 0x1A,
    0x16, 0x17, 0x19, 0x1A,
    0x16, 0x17, 0x18, 0x1A,
    0x16, 0x18, 0x19, 0x1B,
    0x16, 0x18, 0x1A, 0x1B,
    0x16, 0x17, 0x1A, 0x1B,
    0x16, 0x17, 0x19, 0x1B,
    0x16, 0x18, 0x1A, 0x1C,
    0x16, 0x19, 0x1B, 0x1C,
    0x16, 0x17, 0x1B, 0x1C,
    0x16, 0x17, 0x19, 0x1C,
    0x16, 0x1C, 0x1C, 0x1C,
    0x16, 0x16, 0x1C, 0x1C,
    0x16, 0x16, 0x16, 0x1C,
    0x16, 0x19, 0x1A, 0x1D,
    0x16, 0x19, 0x1C, 0x1D,
    0x16, 0x17, 0x1C, 0x1D,
    0x16, 0x17, 0x1A, 0x1D,
    0x16, 0x19, 0x1B, 0x1E,
    0x16, 0x1A, 0x1C, 0x1E,
    0x16, 0x18, 0x1C, 0x1E,
    0x16, 0x18, 0x1A, 0x1E,
    0x16, 0x1E, 0x1E, 0x1E,
    0x16, 0x16, 0x1E, 0x1E,
    0x16, 0x16, 0x16, 0x1E,
    0x16, 0x1A, 0x1D, 0x21,
    0x16, 0x1B, 0x1F, 0x21,
    0x16, 0x18, 0x1F, 0x21,
    0x16, 0x18, 0x1C, 0x21,
    0x16, 0x21, 0x21, 0x21,
    0x16, 0x16, 0x21, 0x21,
    0x16, 0x16, 0x16, 0x21,
    0x16, 0x1B, 0x1F, 0x24,
    0x16, 0x1D, 0x21, 0x24,
    0x16, 0x19, 0x21, 0x24,
    0x16, 0x19, 0x1D, 0x24,
    0x16, 0x24, 0x24, 0x24,
    0x16, 0x16, 0x24, 0x24,
    0x16, 0x16, 0x16, 0x24,
    0x16, 0x1C, 0x21, 0x27,
    0x16, 0x1E, 0x23, 0x27,
    0x16, 0x1A, 0x23, 0x27,
    0x16, 0x1A, 0x1F, 0x27,
    0x16, 0x27, 0x27, 0x27,
    0x16, 0x16, 0x27, 0x27,
    0x16, 0x16, 0x16, 0x27,
    0x16, 0x1D, 0x23, 0x2A,
    0x16, 0x20, 0x25, 0x2A,
    0x16, 0x1B, 0x25, 0x2A,
    0x16, 0x1B, 0x20, 0x2A,
    0x16, 0x2A, 0x2A, 0x2A,
    0x16, 0x16, 0x2A, 0x2A,
    0x16, 0x16, 0x16, 0x2A,
    0x16, 0x21, 0x28, 0x2D,
    0x16, 0x1B, 0x28, 0x2D,
    0x16, 0x1B, 0x22, 0x2D,
    0x16, 0x2D, 0x2D, 0x2D,
    0x16, 0x16, 0x2D, 0x2D,
    0x16, 0x16, 0x16, 0x2D,
    0x16, 0x23, 0x2A, 0x30,
    0x16, 0x1C, 0x2A, 0x30,
    0x16, 0x1C, 0x23, 0x30,
    0x16, 0x30, 0x30, 0x30,
    0x16, 0x16, 0x30, 0x30,
    0x16, 0x16, 0x16, 0x30,
    0x16, 0x24, 0x2C, 0x33,
    0x16, 0x1D, 0x2C, 0x33,
    0x16, 0x1D, 0x25, 0x33,
    0x16, 0x33, 0x33, 0x33,
    0x16, 0x16, 0x33, 0x33,
    0x16, 0x16, 0x16, 0x33,
    0x16, 0x26, 0x2E, 0x36,
    0x16, 0x1E, 0x2E, 0x36,
    0x16, 0x1E, 0x26, 0x36,
    0x16, 0x36, 0x36, 0x36,
    0x16, 0x16, 0x36, 0x36,
    0x16, 0x16, 0x16, 0x36,
    0x16, 0x39, 0x39, 0x39,
    0x16, 0x16, 0x39, 0x39,
    0x16, 0x16, 0x16, 0x39,
    0x16, 0x28, 0x31, 0x3A,
    0x16, 0x1F, 0x31, 0x3A,
    0x16, 0x1F, 0x28, 0x3A,
    0x16, 0x3E, 0x3E, 0x3E,
    0x16, 0x16, 0x3E, 0x3E,
    0x16, 0x16, 0x16, 0x3E,
    0x17, 0x18, 0x18, 0x19,
    0x17, 0x18, 0x19, 0x1A,
    0x17, 0x19, 0x1A, 0x1B,
    0x17, 0x18, 0x1A, 0x1B,
    0x17, 0x18, 0x19, 0x1B,
    0x17, 0x19, 0x1A, 0x1C,
    0x17, 0x19, 0x1B, 0x1C,
    0x17, 0x18, 0x1B, 0x1C,
    0x17, 0x18, 0x1A, 0x1C,
    0x17, 0x19, 0x1B, 0x1D,
    0x17, 0x1A, 0x1C, 0x1D,
    0x17, 0x18, 0x1C, 0x1D,
    0x17, 0x18, 0x1A, 0x1D,
    0x17, 0x1D, 0x1D, 0x1D,
    0x17, 0x17, 0x1D, 0x1D,
    0x17, 0x17, 0x17, 0x1D,
    0x17, 0x1A, 0x1B, 0x1E,
    0x17, 0x1A, 0x1D, 0x1E,
    0x17, 0x18, 0x1D, 0x1E,
    0x17, 0x18, 0x1B, 0x1E,
    0x17, 0x1A, 0x1C, 0x1F,
    0x17, 0x1B, 0x1D, 0x1F,
    0x17, 0x19, 0x1D, 0x1F,
    0x17, 0x19, 0x1B, 0x1F,
    0x17, 0x1F, 0x1F, 0x1F,
    0x17, 0x17, 0x1F, 0x1F,
    0x17, 0x17, 0x17, 0x1F,
    0x17, 0x1B, 0x1E, 0x22,
    0x17, 0x1C, 0x20, 0x22,
    0x17, 0x19, 0x20, 0x22,
    0x17, 0x19, 0x1D, 0x22,
    0x17, 0x22, 0x22, 0x22,
    0x17, 0x17, 0x22, 0x22,
    0x17, 0x17, 0x17, 0x22,
    0x17, 0x1C, 0x20, 0x25,
    0x17, 0x1E, 0x22, 0x25,
    0x17, 0x1A, 0x22, 0x25,
    0x17, 0x1A, 0x1E, 0x25,
    0x17, 0x25, 0x25, 0x25,
    0x17, 0x17, 0x25, 0x25,
    0x17, 0x17, 0x17, 0x25,
    0x17, 0x1D, 0x22, 0x28,
    0x17, 0x1F, 0x24, 0x28,
    0x17, 0x1B, 0x24, 0x28,
    0x17, 0x1B, 0x20, 0x28,
    0x17, 0x28, 0x28, 0x28,
    0x17, 0x17, 0x28, 0x28,
    0x17, 0x17, 0x17, 0x28,
    0x17, 0x1E, 0x24, 0x2B,
    0x17, 0x21, 0x26, 0x2B,
    0x17, 0x1C, 0x26, 0x2B,
    0x17, 0x1C, 0x21, 0x2B,
    0x17, 0x2B, 0x2B, 0x2B,
    0x17, 0x17, 0x2B, 0x2B,
    0x17, 0x17, 0x17, 0x2B,
    0x17, 0x22, 0x29, 0x2E,
    0x17, 0x1C, 0x29, 0x2E,
    0x17, 0x1C, 0x23, 0x2E,
    0x17, 0x2E, 0x2E, 0x2E,
    0x17, 0x17, 0x2E, 0x2E,
    0x17, 0x17, 0x17, 0x2E,
    0x17, 0x24, 0x2B, 0x31,
    0x17, 0x1D, 0x2B, 0x31,
    0x17, 0x1D, 0x24, 0x31,
    0x17, 0x31, 0x31, 0x31,
    0x17, 0x17, 0x31, 0x31,
    0x17, 0x17, 0x17, 0x31,
    0x17, 0x25, 0x2D, 0x34,
    0x17, 0x1E, 0x2D, 0x34,
    0x17, 0x1E, 0x26, 0x34,
    0x17, 0x34, 0x34, 0x34,
    0x17, 0x17, 0x34, 0x34,
    0x17, 0x17, 0x17, 0x34,
    0x17, 0x27, 0x2F, 0x37,
    0x17, 0x1F, 0x2F, 0x37,
    0x17, 0x1F, 0x27, 0x37,
    0x17, 0x37, 0x37, 0x37,
    0x17, 0x17, 0x37, 0x37,
    0x17, 0x17, 0x17, 0x37,
    0x17, 0x3A, 0x3A, 0x3A,
    0x17, 0x17, 0x3A, 0x3A,
    0x17, 0x17, 0x17, 0x3A,
    0x17, 0x29, 0x32, 0x3B,
    0x17, 0x20, 0x32, 0x3B,
    0x17, 0x20, 0x29, 0x3B,
    0x17, 0x3F, 0x3F, 0x3F,
    0x17, 0x17, 0x3F, 0x3F,
    0x17, 0x17, 0x17, 0x3F,
    0x18, 0x19, 0x19, 0x1A,
    0x18, 0x19, 0x1A, 0x1B,
    0x18, 0x1A, 0x1B, 0x1C,
    0x18, 0x19, 0x1B, 0x1C,
    0x18, 0x19, 0x1A, 0x1C,
    0x18, 0x1A, 0x1B, 0x1D,
    0x18, 0x1A, 0x1C, 0x1D,
    0x18, 0x19, 0x1C, 0x1D,
    0x18, 0x19, 0x1B, 0x1D,
    0x18, 0x1A, 0x1C, 0x1E,
    0x18, 0x1B, 0x1D, 0x1E,
    0x18, 0x19, 0x1D, 0x1E,
    0x18, 0x19, 0x1B, 0x1E,
    0x18, 0x1E, 0x1E, 0x1E,
    0x18, 0x18, 0x1E, 0x1E,
    0x18, 0x18, 0x18, 0x1E,
    0x18, 0x1B, 0x1C, 0x1F,
    0x18, 0x1B, 0x1E, 0x1F,
    0x18, 0x19, 0x1E, 0x1F,
    0x18, 0x19, 0x1C, 0x1F,
    0x18, 0x1B, 0x1D, 0x20,
    0x18, 0x1C, 0x1E, 0x20,
    0x18, 0x1A, 0x1E, 0x20,
    0x18, 0x1A, 0x1C, 0x20,
    0x18, 0x20, 0x20, 0x20,
    0x18, 0x18, 0x20, 0x20,
    0x18, 0x18, 0x18, 0x20,
    0x18, 0x1C, 0x1F, 0x23,
    0x18, 0x1D, 0x21, 0x23,
    0x18, 0x1A, 0x21, 0x23,
    0x18, 0x1A, 0x1E, 0x23,
    0x18, 0x23, 0x23, 0x23,
    0x18, 0x18, 0x23, 0x23,
    0x18, 0x18, 0x18, 0x23,
    0x18, 0x1D, 0x21, 0x26,
    0x18, 0x1F, 0x23, 0x26,
    0x18, 0x1B, 0x23, 0x26,
    0x18, 0x1B, 0x1F, 0x26,
    0x18, 0x26, 0x26, 0x26,
    0x18, 0x18, 0x26, 0x26,
    0x18, 0x18, 0x18, 0x26,
    0x18, 0x1E, 0x23, 0x29,
    0x18, 0x20, 0x25, 0x29,
    0x18, 0x1C, 0x25, 0x29,
    0x18, 0x1C, 0x21, 0x29,
    0x18, 0x29, 0x29, 0x29,
    0x18, 0x18, 0x29, 0x29,
    0x18, 0x18, 0x18, 0x29,
    0x18, 0x1F, 0x25, 0x2C,
    0x18, 0x22, 0x27, 0x2C,
    0x18, 0x1D, 0x27, 0x2C,
    0x18, 0x1D, 0x22, 0x2C,
    0x18, 0x2C, 0x2C, 0x2C,
    0x18, 0x18, 0x2C, 0x2C,
    0x18, 0x18, 0x18, 0x2C,
    0x18, 0x23, 0x2A, 0x2F,
    0x18, 0x1D, 0x2A, 0x2F,
    0x18, 0x1D, 0x24, 0x2F,
    0x18, 0x2F, 0x2F, 0x2F,
    0x18, 0x18, 0x2F, 0x2F,
    0x18, 0x18, 0x18, 0x2F,
    0x18, 0x25, 0x2C, 0x32,
    0x18, 0x1E, 0x2C, 0x32,
    0x18, 0x1E, 0x25, 0x32,
    0x18, 0x32, 0x32, 0x32,
    0x18, 0x18, 0x32, 0x32,
    0x18, 0x18, 0x18, 0x32,
    0x18, 0x26, 0x2E, 0x35,
    0x18, 0x1F, 0x2E, 0x35,
    0x18, 0x1F, 0x27, 0x35,
    0x18, 0x35, 0x35, 0x35,
    0x18, 0x18, 0x35, 0x35,
    0x18, 0x18, 0x18, 0x35,
    0x18, 0x28, 0x30, 0x38,
    0x18, 0x20, 0x30, 0x38,
    0x18, 0x20, 0x28, 0x38,
    0x18, 0x38, 0x38, 0x38,
    0x18, 0x18, 0x38, 0x38,
    0x18, 0x18, 0x18, 0x38,
    0x18, 0x3B, 0x3B, 0x3B,
    0x18, 0x18, 0x3B, 0x3B,
    0x18, 0x18, 0x18, 0x3B,
    0x18, 0x2A, 0x33, 0x3C,
    0x18, 0x21, 0x33, 0x3C,
    0x18, 0x21, 0x2A, 0x3C,
    0x19, 0x1A, 0x1A, 0x1B,
    0x19, 0x1A, 0x1B, 0x1C,
    0x19, 0x1B, 0x1C, 0x1D,
    0x19, 0x1A, 0x1C, 0x1D,
    0x19, 0x1A, 0x1B, 0x1D,
    0x19, 0x1B, 0x1C, 0x1E,
    0x19, 0x1B, 0x1D, 0x1E,
    0x19, 0x1A, 0x1D, 0x1E,
    0x19, 0x1A, 0x1C, 0x1E,
    0x19, 0x1B, 0x1D, 0x1F,
    0x19, 0x1C, 0x1E, 0x1F,
    0x19, 0x1A, 0x1E, 0x1F,
    0x19, 0x1A, 0x1C, 0x1F,
    0x19, 0x1F, 0x1F, 0x1F,
    0x19, 0x19, 0x1F, 0x1F,
    0x19, 0x19, 0x19, 0x1F,
    0x19, 0x1C, 0x1D, 0x20,
    0x19, 0x1C, 0x1F, 0x20,
    0x19, 0x1A, 0x1F, 0x20,
    0x19, 0x1A, 0x1D, 0x20,
    0x19, 0x1C, 0x1E, 0x21,
    0x19, 0x1D, 0x1F, 0x21,
    0x19, 0x1B, 0x1F, 0x21,
    0x19, 0x1B, 0x1D, 0x21,
    0x19, 0x21, 0x21, 0x21,
    0x19, 0x19, 0x21, 0x21,
    0x19, 0x19, 0x19, 0x21,
    0x19, 0x1D, 0x20, 0x24,
    0x19, 0x1E, 0x22, 0x24,
    0x19, 0x1B, 0x22, 0x24,
    0x19, 0x1B, 0x1F, 0x24,
    0x19, 0x24, 0x24, 0x24,
    0x19, 0x19, 0x24, 0x24,
    0x19, 0x19, 0x19, 0x24,
    0x19, 0x1E, 0x22, 0x27,
    0x19, 0x20, 0x24, 0x27,
    0x19, 0x1C, 0x24, 0x27,
    0x19, 0x1C, 0x20, 0x27,
    0x19, 0x27, 0x27, 0x27,
    0x19, 0x19, 0x27, 0x27,
    0x19, 0x19, 0x19, 0x27,
    0x19, 0x1F, 0x24, 0x2A,
    0x19, 0x21, 0x26, 0x2A,
    0x19, 0x1D, 0x26, 0x2A,
    0x19, 0x1D, 0x22, 0x2A,
    0x19, 0x2A, 0x2A, 0x2A,
    0x19, 0x19, 0x2A, 0x2A,
    0x19, 0x19, 0x19, 0x2A,
    0x19, 0x20, 0x26, 0x2D,
    0x19, 0x23, 0x28, 0x2D,
    0x19, 0x1E, 0x28, 0x2D,
    0x19, 0x1E, 0x23, 0x2D,
    0x19, 0x2D, 0x2D, 0x2D,
    0x19, 0x19, 0x2D, 0x2D,
    0x19, 0x19, 0x19, 0x2D,
    0x19, 0x24, 0x2B, 0x30,
    0x19, 0x1E, 0x2B, 0x30,
    0x19, 0x1E, 0x25, 0x30,
    0x19, 0x30, 0x30, 0x30,
    0x19, 0x19, 0x30, 0x30,
    0x19, 0x19, 0x19, 0x30,
    0x19, 0x26, 0x2D, 0x33,
    0x19, 0x1F, 0x2D, 0x33,
    0x19, 0x1F, 0x26, 0x33,
    0x19, 0x33, 0x33, 0x33,
    0x19, 0x19, 0x33, 0x33,
    0x19, 0x19, 0x19, 0x33,
    0x19, 0x27, 0x2F, 0x36,
    0x19, 0x20, 0x2F, 0x36,
    0x19, 0x20, 0x28, 0x36,
    0x19, 0x36, 0x36, 0x36,
    0x19, 0x19, 0x36, 0x36,
    0x19, 0x19, 0x19, 0x36,
    0x19, 0x29, 0x31, 0x39,
    0x19, 0x21, 0x31, 0x39,
    0x19, 0x21, 0x29, 0x39,
    0x19, 0x39, 0x39, 0x39,
    0x19, 0x19, 0x39, 0x39,
    0x19, 0x19, 0x19, 0x39,
    0x19, 0x3C, 0x3C, 0x3C,
    0x19, 0x19, 0x3C, 0x3C,
    0x19, 0x19, 0x19, 0x3C,
    0x19, 0x2B, 0x34, 0x3D,
    0x19, 0x22, 0x34, 0x3D,
    0x19, 0x22, 0x2B, 0x3D,
    0x1A, 0x1B, 0x1B, 0x1C,
    0x1A, 0x1B, 0x1C, 0x1D,
    0x1A, 0x1C, 0x1D, 0x1E,
    0x1A, 0x1B, 0x1D, 0x1E,
    0x1A, 0x1B, 0x1C, 0x1E,
    0x1A, 0x1C, 0x1D, 0x1F,
    0x1A, 0x1C, 0x1E, 0x1F,
    0x1A, 0x1B, 0x1E, 0x1F,
    0x1A, 0x1B, 0x1D, 0x1F,
    0x1A, 0x1C, 0x1E, 0x20,
    0x1A, 0x1D, 0x1F, 0x20,
    0x1A, 0x1B, 0x1F, 0x20,
    0x1A, 0x1B, 0x1D, 0x20,
    0x1A, 0x20, 0x20, 0x20,
    0x1A, 0x1A, 0x20, 0x20,
    0x1A, 0x1A, 0x1A, 0x20,
    0x1A, 0x1D, 0x1E, 0x21,
    0x1A, 0x1D, 0x20, 0x21,
    0x1A, 0x1B, 0x20, 0x21,
    0x1A, 0x1B, 0x1E, 0x21,
    0x1A, 0x1D, 0x1F, 0x22,
    0x1A, 0x1E, 0x20, 0x22,
    0x1A, 0x1C, 0x20, 0x22,
    0x1A, 0x1C, 0x1E, 0x22,
    0x1A, 0x22, 0x22, 0x22,
    0x1A, 0x1A, 0x22, 0x22,
    0x1A, 0x1A, 0x1A, 0x22,
    0x1A, 0x1E, 0x21, 0x25,
    0x1A, 0x1F, 0x23, 0x25,
    0x1A, 0x1C, 0x23, 0x25,
    0x1A, 0x1C, 0x20, 0x25,
    0x1A, 0x25, 0x25, 0x25,
    0x1A, 0x1A, 0x25, 0x25,
    0x1A, 0x1A, 0x1A, 0x25,
    0x1A, 0x1F, 0x23, 0x28,
    0x1A, 0x21, 0x25, 0x28,
    0x1A, 0x1D, 0x25, 0x28,
    0x1A, 0x1D, 0x21, 0x28,
    0x1A, 0x28, 0x28, 0x28,
    0x1A, 0x1A, 0x28, 0x28,
    0x1A, 0x1A, 0x1A, 0x28,
    0x1A, 0x20, 0x25, 0x2B,
    0x1A, 0x22, 0x27, 0x2B,
    0x1A, 0x1E, 0x27, 0x2B,
    0x1A, 0x1E, 0x23, 0x2B,
    0x1A, 0x2B, 0x2B, 0x2B,
    0x1A, 0x1A, 0x2B, 0x2B,
    0x1A, 0x1A, 0x1A, 0x2B,
    0x1A, 0x21, 0x27, 0x2E,
    0x1A, 0x24, 0x29, 0x2E,
    0x1A, 0x1F, 0x29, 0x2E,
    0x1A, 0x1F, 0x24, 0x2E,
    0x1A, 0x2E, 0x2E, 0x2E,
    0x1A, 0x1A, 0x2E, 0x2E,
    0x1A, 0x1A, 0x1A, 0x2E,
    0x1A, 0x25, 0x2C, 0x31,
    0x1A, 0x1F, 0x2C, 0x31,
    0x1A, 0x1F, 0x26, 0x31,
    0x1A, 0x31, 0x31, 0x31,
    0x1A, 0x1A, 0x31, 0x31,
    0x1A, 0x1A, 0x1A, 0x31,
    0x1A, 0x27, 0x2E, 0x34,
    0x1A, 0x20, 0x2E, 0x34,
    0x1A, 0x20, 0x27, 0x34,
    0x1A, 0x34, 0x34, 0x34,
    0x1A, 0x1A, 0x34, 0x34,
    0x1A, 0x1A, 0x1A, 0x34,
    0x1A, 0x28, 0x30, 0x37,
    0x1A, 0x21, 0x30, 0x37,
    0x1A, 0x21, 0x29, 0x37,
    0x1A, 0x37, 0x37, 0x37,
    0x1A, 0x1A, 0x37, 0x37,
    0x1A, 0x1A, 0x1A, 0x37,
    0x1A, 0x2A, 0x32, 0x3A,
    0x1A, 0x22, 0x32, 0x3A,
    0x1A, 0x22, 0x2A, 0x3A,
    0x1A, 0x3A, 0x3A, 0x3A,
    0x1A, 0x1A, 0x3A, 0x3A,
    0x1A, 0x1A, 0x1A, 0x3A,
    0x1A, 0x3D, 0x3D, 0x3D,
    0x1A, 0x1A, 0x3D, 0x3D,
    0x1A, 0x1A, 0x1A, 0x3D,
    0x1A, 0x2C, 0x35, 0x3E,
    0x1A, 0x23, 0x35, 0x3E,
    0x1A, 0x23, 0x2C, 0x3E,
    0x1B, 0x1C, 0x1C, 0x1D,
    0x1B, 0x1C, 0x1D, 0x1E,
    0x1B, 0x1D, 0x1E, 0x1F,
    0x1B, 0x1C, 0x1E, 0x1F,
    0x1B, 0x1C, 0x1D, 0x1F,
    0x1B, 0x1D, 0x1E, 0x20,
    0x1B, 0x1D, 0x1F, 0x20,
    0x1B, 0x1C, 0x1F, 0x20,
    0x1B, 0x1C, 0x1E, 0x20,
    0x1B, 0x1D, 0x1F, 0x21,
    0x1B, 0x1E, 0x20, 0x21,
    0x1B, 0x1C, 0x20, 0x21,
    0x1B, 0x1C, 0x1E, 0x21,
    0x1B, 0x21, 0x21, 0x21,
    0x1B, 0x1B, 0x21, 0x21,
    0x1B, 0x1B, 0x1B, 0x21,
    0x1B, 0x1E, 0x1F, 0x22,
    0x1B, 0x1E, 0x21, 0x22,
    0x1B, 0x1C, 0x21, 0x22,
    0x1B, 0x1C, 0x1F, 0x22,
    0x1B, 0x1E, 0x20, 0x23,
    0x1B, 0x1F, 0x21, 0x23,
    0x1B, 0x1D, 0x21, 0x23,
    0x1B, 0x1D, 0x1F, 0x23,
    0x1B, 0x23, 0x23, 0x23,
    0x1B, 0x1B, 0x23, 0x23,
    0x1B, 0x1B, 0x1B, 0x23,
    0x1B, 0x1F, 0x22, 0x26,
    0x1B, 0x20, 0x24, 0x26,
    0x1B, 0x1D, 0x24, 0x26,
    0x1B, 0x1D, 0x21, 0x26,
    0x1B, 0x26, 0x26, 0x26,
    0x1B, 0x1B, 0x26, 0x26,
    0x1B, 0x1B, 0x1B, 0x26,
    0x1B, 0x20, 0x24, 0x29,
    0x1B, 0x22, 0x26, 0x29,
    0x1B, 0x1E, 0x26, 0x29,
    0x1B, 0x1E, 0x22, 0x29,
    0x1B, 0x29, 0x29, 0x29,
    0x1B, 0x1B, 0x29, 0x29,
    0x1B, 0x1B, 0x1B, 0x29,
    0x1B, 0x21, 0x26, 0x2C,
    0x1B, 0x23, 0x28, 0x2C,
    0x1B, 0x1F, 0x28, 0x2C,
    0x1B, 0x1F, 0x24, 0x2C,
    0x1B, 0x2C, 0x2C, 0x2C,
    0x1B, 0x1B, 0x2C, 0x2C,
    0x1B, 0x1B, 0x1B, 0x2C,
    0x1B, 0x22, 0x28, 0x2F,
    0x1B, 0x25, 0x2A, 0x2F,
    0x1B, 0x20, 0x2A, 0x2F,
    0x1B, 0x20, 0x25, 0x2F,
    0x1B, 0x2F, 0x2F, 0x2F,
    0x1B, 0x1B, 0x2F, 0x2F,
    0x1B, 0x1B, 0x1B, 0x2F,
    0x1B, 0x26, 0x2D, 0x32,
    0x1B, 0x20, 0x2D, 0x32,
    0x1B, 0x20, 0x27, 0x32,
    0x1B, 0x32, 0x32, 0x32,
    0x1B, 0x1B, 0x32, 0x32,
    0x1B, 0x1B, 0x1B, 0x32,
    0x1B, 0x28, 0x2F, 0x35,
    0x1B, 0x21, 0x2F, 0x35,
    0x1B, 0x21, 0x28, 0x35,
    0x1B, 0x35, 0x35, 0x35,
    0x1B, 0x1B, 0x35, 0x35,
    0x1B, 0x1B, 0x1B, 0x35,
    0x1B, 0x29, 0x31, 0x38,
    0x1B, 0x22, 0x31, 0x38,
    0x1B, 0x22, 0x2A, 0x38,
    0x1B, 0x38, 0x38, 0x38,
    0x1B, 0x1B, 0x38, 0x38,
    0x1B, 0x1B, 0x1B, 0x38,
    0x1B, 0x2B, 0x33, 0x3B,
    0x1B, 0x23, 0x33, 0x3B,
    0x1B, 0x23, 0x2B, 0x3B,
    0x1B, 0x3B, 0x3B, 0x3B,
    0x1B, 0x1B, 0x3B, 0x3B,
    0x1B, 0x1B, 0x1B, 0x3B,
    0x1B, 0x3E, 0x3E, 0x3E,
    0x1B, 0x1B, 0x3E, 0x3E,
    0x1B, 0x1B, 0x1B, 0x3E,
    0x1B, 0x2D, 0x36, 0x3F,
    0x1B, 0x24, 0x36, 0x3F,
    0x1B, 0x24, 0x2D, 0x3F,
    0x1C, 0x1D, 0x1D, 0x1E,
    0x1C, 0x1D, 0x1E, 0x1F,
    0x1C, 0x1E, 0x1F, 0x20,
    0x1C, 0x1D, 0x1F, 0x20,
    0x1C, 0x1D, 0x1E, 0x20,
    0x1C, 0x1E, 0x1F, 0x21,
    0x1C, 0x1E, 0x20, 0x21,
    0x1C, 0x1D, 0x20, 0x21,
    0x1C, 0x1D, 0x1F, 0x21,
    0x1C, 0x1E, 0x20, 0x22,
    0x1C, 0x1F, 0x21, 0x22,
    0x1C, 0x1D, 0x21, 0x22,
    0x1C, 0x1D, 0x1F, 0x22,
    0x1C, 0x22, 0x22, 0x22,
    0x1C, 0x1C, 0x22, 0x22,
    0x1C, 0x1C, 0x1C, 0x22,
    0x1C, 0x1F, 0x20, 0x23,
    0x1C, 0x1F, 0x22, 0x23,
    0x1C, 0x1D, 0x22, 0x23,
    0x1C, 0x1D, 0x20, 0x23,
    0x1C, 0x1F, 0x21, 0x24,
    0x1C, 0x20, 0x22, 0x24,
    0x1C, 0x1E, 0x22, 0x24,
    0x1C, 0x1E, 0x20, 0x24,
    0x1C, 0x24, 0x24, 0x24,
    0x1C, 0x1C, 0x24, 0x24,
    0x1C, 0x1C, 0x1C, 0x24,
    0x1C, 0x20, 0x23, 0x27,
    0x1C, 0x21, 0x25, 0x27,
    0x1C, 0x1E, 0x25, 0x27,
    0x1C, 0x1E, 0x22, 0x27,
    0x1C, 0x27, 0x27, 0x27,
    0x1C, 0x1C, 0x27, 0x27,
    0x1C, 0x1C, 0x1C, 0x27,
    0x1C, 0x21, 0x25, 0x2A,
    0x1C, 0x23, 0x27, 0x2A,
    0x1C, 0x1F, 0x27, 0x2A,
    0x1C, 0x1F, 0x23, 0x2A,
    0x1C, 0x2A, 0x2A, 0x2A,
    0x1C, 0x1C, 0x2A, 0x2A,
    0x1C, 0x1C, 0x1C, 0x2A,
    0x1C, 0x22, 0x27, 0x2D,
    0x1C, 0x24, 0x29, 0x2D,
    0x1C, 0x20, 0x29, 0x2D,
    0x1C, 0x20, 0x25, 0x2D,
    0x1C, 0x2D, 0x2D, 0x2D,
    0x1C, 0x1C, 0x2D, 0x2D,
    0x1C, 0x1C, 0x1C, 0x2D,
    0x1C, 0x23, 0x29, 0x30,
    0x1C, 0x26, 0x2B, 0x30,
    0x1C, 0x21, 0x2B, 0x30,
    0x1C, 0x21, 0x26, 0x30,
    0x1C, 0x30, 0x30, 0x30,
    0x1C, 0x1C, 0x30, 0x30,
    0x1C, 0x1C, 0x1C, 0x30,
    0x1C, 0x27, 0x2E, 0x33,
    0x1C, 0x21, 0x2E, 0x33,
    0x1C, 0x21, 0x28, 0x33,
    0x1C, 0x33, 0x33, 0x33,
    0x1C, 0x1C, 0x33, 0x33,
    0x1C, 0x1C, 0x1C, 0x33,
    0x1C, 0x29, 0x30, 0x36,
    0x1C, 0x22, 0x30, 0x36,
    0x1C, 0x22, 0x29, 0x36,
    0x1C, 0x36, 0x36, 0x36,
    0x1C, 0x1C, 0x36, 0x36,
    0x1C, 0x1C, 0x1C, 0x36,
    0x1C, 0x2A, 0x32, 0x39,
    0x1C, 0x23, 0x32, 0x39,
    0x1C, 0x23, 0x2B, 0x39,
    0x1C, 0x39, 0x39, 0x39,
    0x1C, 0x1C, 0x39, 0x39,
    0x1C, 0x1C, 0x1C, 0x39,
    0x1C, 0x2C, 0x34, 0x3C,
    0x1C, 0x24, 0x34, 0x3C,
    0x1C, 0x24, 0x2C, 0x3C,
    0x1C, 0x3C, 0x3C, 0x3C,
    0x1C, 0x1C, 0x3C, 0x3C,
    0x1C, 0x1C, 0x1C, 0x3C,
    0x1C, 0x3F, 0x3F, 0x3F,
    0x1C, 0x1C, 0x3F, 0x3F,
    0x1C, 0x1C, 0x1C, 0x3F,
    0x1D, 0x1E, 0x1E, 0x1F,
    0x1D, 0x1E, 0x1F, 0x20,
    0x1D, 0x1F, 0x20, 0x21,
    0x1D, 0x1E, 0x20, 0x21,
    0x1D, 0x1E, 0x1F, 0x21,
    0x1D, 0x1F, 0x20, 0x22,
    0x1D, 0x1F, 0x21, 0x22,
    0x1D, 0x1E, 0x21, 0x22,
    0x1D, 0x1E, 0x20, 0x22,
    0x1D, 0x1F, 0x21, 0x23,
    0x1D, 0x20, 0x22, 0x23,
    0x1D, 0x1E, 0x22, 0x23,
    0x1D, 0x1E, 0x20, 0x23,
    0x1D, 0x23, 0x23, 0x23,
    0x1D, 0x1D, 0x23, 0x23,
    0x1D, 0x1D, 0x1D, 0x23,
    0x1D, 0x20, 0x21, 0x24,
    0x1D, 0x20, 0x23, 0x24,
    0x1D, 0x1E, 0x23, 0x24,
    0x1D, 0x1E, 0x21, 0x24,
    0x1D, 0x20, 0x22, 0x25,
    0x1D, 0x21, 0x23, 0x25,
    0x1D, 0x1F, 0x23, 0x25,
    0x1D, 0x1F, 0x21, 0x25,
    0x1D, 0x25, 0x25, 0x25,
    0x1D, 0x1D, 0x25, 0x25,
    0x1D, 0x1D, 0x1D, 0x25,
    0x1D, 0x21, 0x24, 0x28,
    0x1D, 0x22, 0x26, 0x28,
    0x1D, 0x1F, 0x26, 0x28,
    0x1D, 0x1F, 0x23, 0x28,
    0x1D, 0x28, 0x28, 0x28,
    0x1D, 0x1D, 0x28, 0x28,
    0x1D, 0x1D, 0x1D, 0x28,
    0x1D, 0x22, 0x26, 0x2B,
    0x1D, 0x24, 0x28, 0x2B,
    0x1D, 0x20, 0x28, 0x2B,
    0x1D, 0x20, 0x24, 0x2B,
    0x1D, 0x2B, 0x2B, 0x2B,
    0x1D, 0x1D, 0x2B, 0x2B,
    0x1D, 0x1D, 0x1D, 0x2B,
    0x1D, 0x23, 0x28, 0x2E,
    0x1D, 0x25, 0x2A, 0x2E,
    0x1D, 0x21, 0x2A, 0x2E,
    0x1D, 0x21, 0x26, 0x2E,
    0x1D, 0x2E, 0x2E, 0x2E,
    0x1D, 0x1D, 0x2E, 0x2E,
    0x1D, 0x1D, 0x1D, 0x2E,
    0x1D, 0x24, 0x2A, 0x31,
    0x1D, 0x27, 0x2C, 0x31,
    0x1D, 0x22, 0x2C, 0x31,
    0x1D, 0x22, 0x27, 0x31,
    0x1D, 0x31, 0x31, 0x31,
    0x1D, 0x1D, 0x31, 0x31,
    0x1D, 0x1D, 0x1D, 0x31,
    0x1D, 0x28, 0x2F, 0x34,
    0x1D, 0x22, 0x2F, 0x34,
    0x1D, 0x22, 0x29, 0x34,
    0x1D, 0x34, 0x34, 0x34,
    0x1D, 0x1D, 0x34, 0x34,
    0x1D, 0x1D, 0x1D, 0x34,
    0x1D, 0x2A, 0x31, 0x37,
    0x1D, 0x23, 0x31, 0x37,
    0x1D, 0x23, 0x2A, 0x37,
    0x1D, 0x37, 0x37, 0x37,
    0x1D, 0x1D, 0x37, 0x37,
    0x1D, 0x1D, 0x1D, 0x37,
    0x1D, 0x2B, 0x33, 0x3A,
    0x1D, 0x24, 0x33, 0x3A,
    0x1D, 0x24, 0x2C, 0x3A,
    0x1D, 0x3A, 0x3A, 0x3A,
    0x1D, 0x1D, 0x3A, 0x3A,
    0x1D, 0x1D, 0x1D, 0x3A,
    0x1D, 0x2D, 0x35, 0x3D,
    0x1D, 0x25, 0x35, 0x3D,
    0x1D, 0x25, 0x2D, 0x3D,
    0x1D, 0x3D, 0x3D, 0x3D,
    0x1D, 0x1D, 0x3D, 0x3D,
    0x1D, 0x1D, 0x1D, 0x3D,
    0x1E, 0x1F, 0x1F, 0x20,
    0x1E, 0x1F, 0x20, 0x21,
    0x1E, 0x20, 0x21, 0x22,
    0x1E, 0x1F, 0x21, 0x22,
    0x1E, 0x1F, 0x20, 0x22,
    0x1E, 0x20, 0x21, 0x23,
    0x1E, 0x20, 0x22, 0x23,
    0x1E, 0x1F, 0x22, 0x23,
    0x1E, 0x1F, 0x21, 0x23,
    0x1E, 0x20, 0x22, 0x24,
    0x1E, 0x21, 0x23, 0x24,
    0x1E, 0x1F, 0x23, 0x24,
    0x1E, 0x1F, 0x21, 0x24,
    0x1E, 0x24, 0x24, 0x24,
    0x1E, 0x1E, 0x24, 0x24,
    0x1E, 0x1E, 0x1E, 0x24,
    0x1E, 0x21, 0x22, 0x25,
    0x1E, 0x21, 0x24, 0x25,
    0x1E, 0x1F, 0x24, 0x25,
    0x1E, 0x1F, 0x22, 0x25,
    0x1E, 0x21, 0x23, 0x26,
    0x1E, 0x22, 0x24, 0x26,
    0x1E, 0x20, 0x24, 0x26,
    0x1E, 0x20, 0x22, 0x26,
    0x1E, 0x26, 0x26, 0x26,
    0x1E, 0x1E, 0x26, 0x26,
    0x1E, 0x1E, 0x1E, 0x26,
    0x1E, 0x22, 0x25, 0x29,
    0x1E, 0x23, 0x27, 0x29,
    0x1E, 0x20, 0x27, 0x29,
    0x1E, 0x20, 0x24, 0x29,
    0x1E, 0x29, 0x29, 0x29,
    0x1E, 0x1E, 0x29, 0x29,
    0x1E, 0x1E, 0x1E, 0x29,
    0x1E, 0x23, 0x27, 0x2C,
    0x1E, 0x25, 0x29, 0x2C,
    0x1E, 0x21, 0x29, 0x2C,
    0x1E, 0x21, 0x25, 0x2C,
    0x1E, 0x2C, 0x2C, 0x2C,
    0x1E, 0x1E, 0x2C, 0x2C,
    0x1E, 0x1E, 0x1E, 0x2C,
    0x1E, 0x24, 0x29, 0x2F,
    0x1E, 0x26, 0x2B, 0x2F,
    0x1E, 0x22, 0x2B, 0x2F,
    0x1E, 0x22, 0x27, 0x2F,
    0x1E, 0x2F, 0x2F, 0x2F,
    0x1E, 0x1E, 0x2F, 0x2F,
    0x1E, 0x1E, 0x1E, 0x2F,
    0x1E, 0x25, 0x2B, 0x32,
    0x1E, 0x28, 0x2D, 0x32,
    0x1E, 0x23, 0x2D, 0x32,
    0x1E, 0x23, 0x28, 0x32,
    0x1E, 0x32, 0x32, 0x32,
    0x1E, 0x1E, 0x32, 0x32,
    0x1E, 0x1E, 0x1E, 0x32,
    0x1E, 0x29, 0x30, 0x35,
    0x1E, 0x23, 0x30, 0x35,
    0x1E, 0x23, 0x2A, 0x35,
    0x1E, 0x35, 0x35, 0x35,
    0x1E, 0x1E, 0x35, 0x35,
    0x1E, 0x1E, 0x1E, 0x35,
    0x1E, 0x2B, 0x32, 0x38,
    0x1E, 0x24, 0x32, 0x38,
    0x1E, 0x24, 0x2B, 0x38,
    0x1E, 0x38, 0x38, 0x38,
    0x1E, 0x1E, 0x38, 0x38,
    0x1E, 0x1E, 0x1E, 0x38,
    0x1E, 0x2C, 0x34, 0x3B,
    0x1E, 0x25, 0x34, 0x3B,
    0x1E, 0x25, 0x2D, 0x3B,
    0x1E, 0x3B, 0x3B, 0x3B,
    0x1E, 0x1E, 0x3B, 0x3B,
    0x1E, 0x1E, 0x1E, 0x3B,
    0x1E, 0x2E, 0x36, 0x3E,
    0x1E, 0x26, 0x36, 0x3E,
    0x1E, 0x26, 0x2E, 0x3E,
    0x1E, 0x3E, 0x3E, 0x3E,
    0x1E, 0x1E, 0x3E, 0x3E,
    0x1E, 0x1E, 0x1E, 0x3E,
    0x1F, 0x20, 0x20, 0x21,
    0x1F, 0x20, 0x21, 0x22,
    0x1F, 0x21, 0x22, 0x23,
    0x1F, 0x20, 0x22, 0x23,
    0x1F, 0x20, 0x21, 0x23,
    0x1F, 0x21, 0x22, 0x24,
    0x1F, 0x21, 0x23, 0x24,
    0x1F, 0x20, 0x23, 0x24,
    0x1F, 0x20, 0x22, 0x24,
    0x1F, 0x21, 0x23, 0x25,
    0x1F, 0x22, 0x24, 0x25,
    0x1F, 0x20, 0x24, 0x25,
    0x1F, 0x20, 0x22, 0x25,
    0x1F, 0x25, 0x25, 0x25,
    0x1F, 0x1F, 0x25, 0x25,
    0x1F, 0x1F, 0x1F, 0x25,
    0x1F, 0x22, 0x23, 0x26,
    0x1F, 0x22, 0x25, 0x26,
    0x1F, 0x20, 0x25, 0x26,
    0x1F, 0x20, 0x23, 0x26,
    0x1F, 0x22, 0x24, 0x27,
    0x1F, 0x23, 0x25, 0x27,
    0x1F, 0x21, 0x25, 0x27,
    0x1F, 0x21, 0x23, 0x27,
    0x1F, 0x27, 0x27, 0x27,
    0x1F, 0x1F, 0x27, 0x27,
    0x1F, 0x1F, 0x1F, 0x27,
    0x1F, 0x23, 0x26, 0x2A,
    0x1F, 0x24, 0x28, 0x2A,
    0x1F, 0x21, 0x28, 0x2A,
    0x1F, 0x21, 0x25, 0x2A,
    0x1F, 0x2A, 0x2A, 0x2A,
    0x1F, 0x1F, 0x2A, 0x2A,
    0x1F, 0x1F, 0x1F, 0x2A,
    0x1F, 0x24, 0x28, 0x2D,
    0x1F, 0x26, 0x2A, 0x2D,
    0x1F, 0x22, 0x2A, 0x2D,
    0x1F, 0x22, 0x26, 0x2D,
    0x1F, 0x2D, 0x2D, 0x2D,
    0x1F, 0x1F, 0x2D, 0x2D,
    0x1F, 0x1F, 0x1F, 0x2D,
    0x1F, 0x25, 0x2A, 0x30,
    0x1F, 0x27, 0x2C, 0x30,
    0x1F, 0x23, 0x2C, 0x30,
    0x1F, 0x23, 0x28, 0x30,
    0x1F, 0x30, 0x30, 0x30,
    0x1F, 0x1F, 0x30, 0x30,
    0x1F, 0x1F, 0x1F, 0x30,
    0x1F, 0x26, 0x2C, 0x33,
    0x1F, 0x29, 0x2E, 0x33,
    0x1F, 0x24, 0x2E, 0x33,
    0x1F, 0x24, 0x29, 0x33,
    0x1F, 0x33, 0x33, 0x33,
    0x1F, 0x1F, 0x33, 0x33,
    0x1F, 0x1F, 0x1F, 0x33,
    0x1F, 0x2A, 0x31, 0x36,
    0x1F, 0x24, 0x31, 0x36,
    0x1F, 0x24, 0x2B, 0x36,
    0x1F, 0x36, 0x36, 0x36,
    0x1F, 0x1F, 0x36, 0x36,
    0x1F, 0x1F, 0x1F, 0x36,
    0x1F, 0x2C, 0x33, 0x39,
    0x1F, 0x25, 0x33, 0x39,
    0x1F, 0x25, 0x2C, 0x39,
    0x1F, 0x39, 0x39, 0x39,
    0x1F, 0x1F, 0x39, 0x39,
    0x1F, 0x1F, 0x1F, 0x39,
    0x1F, 0x2D, 0x35, 0x3C,
    0x1F, 0x26, 0x35, 0x3C,
    0x1F, 0x26, 0x2E, 0x3C,
    0x1F, 0x3C, 0x3C, 0x3C,
    0x1F, 0x1F, 0x3C, 0x3C,
    0x1F, 0x1F, 0x1F, 0x3C,
    0x1F, 0x2F, 0x37, 0x3F,
    0x1F, 0x27, 0x37, 0x3F,
    0x1F, 0x27, 0x2F, 0x3F,
    0x1F, 0x3F, 0x3F, 0x3F,
    0x1F, 0x1F, 0x3F, 0x3F,
    0x1F, 0x1F, 0x1F, 0x3F,
    0x20, 0x21, 0x21, 0x22,
    0x20, 0x21, 0x22, 0x23,
    0x20, 0x22, 0x23, 0x24,
    0x20, 0x21, 0x23, 0x24,
    0x20, 0x21, 0x22, 0x24,
    0x20, 0x22, 0x23, 0x25,
    0x20, 0x22, 0x24, 0x25,
    0x20, 0x21, 0x24, 0x25,
    0x20, 0x21, 0x23, 0x25,
    0x20, 0x22, 0x24, 0x26,
    0x20, 0x23, 0x25, 0x26,
    0x20, 0x21, 0x25, 0x26,
    0x20, 0x21, 0x23, 0x26,
    0x20, 0x26, 0x26, 0x26,
    0x20, 0x20, 0x26, 0x26,
    0x20, 0x20, 0x20, 0x26,
    0x20, 0x23, 0x24, 0x27,
    0x20, 0x23, 0x26, 0x27,
    0x20, 0x21, 0x26, 0x27,
    0x20, 0x21, 0x24, 0x27,
    0x20, 0x23, 0x25, 0x28,
    0x20, 0x24, 0x26, 0x28,
    0x20, 0x22, 0x26, 0x28,
    0x20, 0x22, 0x24, 0x28,
    0x20, 0x28, 0x28, 0x28,
    0x20, 0x20, 0x28, 0x28,
    0x20, 0x20, 0x20, 0x28,
    0x20, 0x24, 0x27, 0x2B,
    0x20, 0x25, 0x29, 0x2B,
    0x20, 0x22, 0x29, 0x2B,
    0x20, 0x22, 0x26, 0x2B,
    0x20, 0x2B, 0x2B, 0x2B,
    0x20, 0x20, 0x2B, 0x2B,
    0x20, 0x20, 0x20, 0x2B,
    0x20, 0x25, 0x29, 0x2E,
    0x20, 0x27, 0x2B, 0x2E,
    0x20, 0x23, 0x2B, 0x2E,
    0x20, 0x23, 0x27, 0x2E,
    0x20, 0x2E, 0x2E, 0x2E,
    0x20, 0x20, 0x2E, 0x2E,
    0x20, 0x20, 0x20, 0x2E,
    0x20, 0x26, 0x2B, 0x31,
    0x20, 0x28, 0x2D, 0x31,
    0x20, 0x24, 0x2D, 0x31,
    0x20, 0x24, 0x29, 0x31,
    0x20, 0x31, 0x31, 0x31,
    0x20, 0x20, 0x31, 0x31,
    0x20, 0x20, 0x20, 0x31,
    0x20, 0x27, 0x2D, 0x34,
    0x20, 0x2A, 0x2F, 0x34,
    0x20, 0x25, 0x2F, 0x34,
    0x20, 0x25, 0x2A, 0x34,
    0x20, 0x34, 0x34, 0x34,
    0x20, 0x20, 0x34, 0x34,
    0x20, 0x20, 0x20, 0x34,
    0x20, 0x2B, 0x32, 0x37,
    0x20, 0x25, 0x32, 0x37,
    0x20, 0x25, 0x2C, 0x37,
    0x20, 0x37, 0x37, 0x37,
    0x20, 0x20, 0x37, 0x37,
    0x20, 0x20, 0x20, 0x37,
    0x20, 0x2D, 0x34, 0x3A,
    0x20, 0x26, 0x34, 0x3A,
    0x20, 0x26, 0x2D, 0x3A,
    0x20, 0x3A, 0x3A, 0x3A,
    0x20, 0x20, 0x3A, 0x3A,
    0x20, 0x20, 0x20, 0x3A,
    0x20, 0x2E, 0x36, 0x3D,
    0x20, 0x27, 0x36, 0x3D,
    0x20, 0x27, 0x2F, 0x3D,
    0x20, 0x3D, 0x3D, 0x3D,
    0x20, 0x20, 0x3D, 0x3D,
    0x20, 0x20, 0x20, 0x3D,
    0x21, 0x22, 0x22, 0x23,
    0x21, 0x22, 0x23, 0x24,
    0x21, 0x23, 0x24, 0x25,
    0x21, 0x22, 0x24, 0x25,
    0x21, 0x22, 0x23, 0x25,
    0x21, 0x23, 0x24, 0x26,
    0x21, 0x23, 0x25, 0x26,
    0x21, 0x22, 0x25, 0x26,
    0x21, 0x22, 0x24, 0x26,
    0x21, 0x23, 0x25, 0x27,
    0x21, 0x24, 0x26, 0x27,
    0x21, 0x22, 0x26, 0x27,
    0x21, 0x22, 0x24, 0x27,
    0x21, 0x27, 0x27, 0x27,
    0x21, 0x21, 0x27, 0x27,
    0x21, 0x21, 0x21, 0x27,
    0x21, 0x24, 0x25, 0x28,
    0x21, 0x24, 0x27, 0x28,
    0x21, 0x22, 0x27, 0x28,
    0x21, 0x22, 0x25, 0x28,
    0x21, 0x24, 0x26, 0x29,
    0x21, 0x25, 0x27, 0x29,
    0x21, 0x23, 0x27, 0x29,
    0x21, 0x23, 0x25, 0x29,
    0x21, 0x29, 0x29, 0x29,
    0x21, 0x21, 0x29, 0x29,
    0x21, 0x21, 0x21, 0x29,
    0x21, 0x25, 0x28, 0x2C,
    0x21, 0x26, 0x2A, 0x2C,
    0x21, 0x23, 0x2A, 0x2C,
    0x21, 0x23, 0x27, 0x2C,
    0x21, 0x2C, 0x2C, 0x2C,
    0x21, 0x21, 0x2C, 0x2C,
    0x21, 0x21, 0x21, 0x2C,
    0x21, 0x26, 0x2A, 0x2F,
    0x21, 0x28, 0x2C, 0x2F,
    0x21, 0x24, 0x2C, 0x2F,
    0x21, 0x24, 0x28, 0x2F,
    0x21, 0x2F, 0x2F, 0x2F,
    0x21, 0x21, 0x2F, 0x2F,
    0x21, 0x21, 0x21, 0x2F,
    0x21, 0x27, 0x2C, 0x32,
    0x21, 0x29, 0x2E, 0x32,
    0x21, 0x25, 0x2E, 0x32,
    0x21, 0x25, 0x2A, 0x32,
    0x21, 0x32, 0x32, 0x32,
    0x21, 0x21, 0x32, 0x32,
    0x21, 0x21, 0x21, 0x32,
    0x21, 0x28, 0x2E, 0x35,
    0x21, 0x2B, 0x30, 0x35,
    0x21, 0x26, 0x30, 0x35,
    0x21, 0x26, 0x2B, 0x35,
    0x21, 0x35, 0x35, 0x35,
    0x21, 0x21, 0x35, 0x35,
    0x21, 0x21, 0x21, 0x35,
    0x21, 0x2C, 0x33, 0x38,
    0x21, 0x26, 0x33, 0x38,
    0x21, 0x26, 0x2D, 0x38,
    0x21, 0x38, 0x38, 0x38,
    0x21, 0x21, 0x38, 0x38,
    0x21, 0x21, 0x21, 0x38,
    0x21, 0x2E, 0x35, 0x3B,
    0x21, 0x27, 0x35, 0x3B,
    0x21, 0x27, 0x2E, 0x3B,
    0x21, 0x3B, 0x3B, 0x3B,
    0x21, 0x21, 0x3B, 0x3B,
    0x21, 0x21, 0x21, 0x3B,
    0x21, 0x2F, 0x37, 0x3E,
    0x21, 0x28, 0x37, 0x3E,
    0x21, 0x28, 0x30, 0x3E,
    0x21, 0x3E, 0x3E, 0x3E,
    0x21, 0x21, 0x3E, 0x3E,
    0x21, 0x21, 0x21, 0x3E,
    0x22, 0x23, 0x23, 0x24,
    0x22, 0x23, 0x24, 0x25,
    0x22, 0x24, 0x25, 0x26,
    0x22, 0x23, 0x25, 0x26,
    0x22, 0x23, 0x24, 0x26,
    0x22, 0x24, 0x25, 0x27,
    0x22, 0x24, 0x26, 0x27,
    0x22, 0x23, 0x26, 0x27,
    0x22, 0x23, 0x25, 0x27,
    0x22, 0x24, 0x26, 0x28,
    0x22, 0x25, 0x27, 0x28,
    0x22, 0x23, 0x27, 0x28,
    0x22, 0x23, 0x25, 0x28,
    0x22, 0x28, 0x28, 0x28,
    0x22, 0x22, 0x28, 0x28,
    0x22, 0x22, 0x22, 0x28,
    0x22, 0x25, 0x26, 0x29,
    0x22, 0x25, 0x28, 0x29,
    0x22, 0x23, 0x28, 0x29,
    0x22, 0x23, 0x26, 0x29,
    0x22, 0x25, 0x27, 0x2A,
    0x22, 0x26, 0x28, 0x2A,
    0x22, 0x24, 0x28, 0x2A,
    0x22, 0x24, 0x26, 0x2A,
    0x22, 0x2A, 0x2A, 0x2A,
    0x22, 0x22, 0x2A, 0x2A,
    0x22, 0x22, 0x22, 0x2A,
    0x22, 0x26, 0x29, 0x2D,
    0x22, 0x27, 0x2B, 0x2D,
    0x22, 0x24, 0x2B, 0x2D,
    0x22, 0x24, 0x28, 0x2D,
    0x22, 0x2D, 0x2D, 0x2D,
    0x22, 0x22, 0x2D, 0x2D,
    0x22, 0x22, 0x22, 0x2D,
    0x22, 0x27, 0x2B, 0x30,
    0x22, 0x29, 0x2D, 0x30,
    0x22, 0x25, 0x2D, 0x30,
    0x22, 0x25, 0x29, 0x30,
    0x22, 0x30, 0x30, 0x30,
    0x22, 0x22, 0x30, 0x30,
    0x22, 0x22, 0x22, 0x30,
    0x22, 0x28, 0x2D, 0x33,
    0x22, 0x2A, 0x2F, 0x33,
    0x22, 0x26, 0x2F, 0x33,
    0x22, 0x26, 0x2B, 0x33,
    0x22, 0x33, 0x33, 0x33,
    0x22, 0x22, 0x33, 0x33,
    0x22, 0x22, 0x22, 0x33,
    0x22, 0x29, 0x2F, 0x36,
    0x22, 0x2C, 0x31, 0x36,
    0x22, 0x27, 0x31, 0x36,
    0x22, 0x27, 0x2C, 0x36,
    0x22, 0x36, 0x36, 0x36,
    0x22, 0x22, 0x36, 0x36,
    0x22, 0x22, 0x22, 0x36,
    0x22, 0x2D, 0x34, 0x39,
    0x22, 0x27, 0x34, 0x39,
    0x22, 0x27, 0x2E, 0x39,
    0x22, 0x39, 0x39, 0x39,
    0x22, 0x22, 0x39, 0x39,
    0x22, 0x22, 0x22, 0x39,
    0x22, 0x2F, 0x36, 0x3C,
    0x22, 0x28, 0x36, 0x3C,
    0x22, 0x28, 0x2F, 0x3C,
    0x22, 0x3C, 0x3C, 0x3C,
    0x22, 0x22, 0x3C, 0x3C,
    0x22, 0x22, 0x22, 0x3C,
    0x22, 0x30, 0x38, 0x3F,
    0x22, 0x29, 0x38, 0x3F,
    0x22, 0x29, 0x31, 0x3F,
    0x22, 0x3F, 0x3F, 0x3F,
    0x22, 0x22, 0x3F, 0x3F,
    0x22, 0x22, 0x22, 0x3F,
    0x23, 0x24, 0x24, 0x25,
    0x23, 0x24, 0x25, 0x26,
    0x23, 0x25, 0x26, 0x27,
    0x23, 0x24, 0x26, 0x27,
    0x23, 0x24, 0x25, 0x27,
    0x23, 0x25, 0x26, 0x28,
    0x23, 0x25, 0x27, 0x28,
    0x23, 0x24, 0x27, 0x28,
    0x23, 0x24, 0x26, 0x28,
    0x23, 0x25, 0x27, 0x29,
    0x23, 0x26, 0x28, 0x29,
    0x23, 0x24, 0x28, 0x29,
    0x23, 0x24, 0x26, 0x29,
    0x23, 0x29, 0x29, 0x29,
    0x23, 0x23, 0x29, 0x29,
    0x23, 0x23, 0x23, 0x29,
    0x23, 0x26, 0x27, 0x2A,
    0x23, 0x26, 0x29, 0x2A,
    0x23, 0x24, 0x29, 0x2A,
    0x23, 0x24, 0x27, 0x2A,
    0x23, 0x26, 0x28, 0x2B,
    0x23, 0x27, 0x29, 0x2B,
    0x23, 0x25, 0x29, 0x2B,
    0x23, 0x25, 0x27, 0x2B,
    0x23, 0x2B, 0x2B, 0x2B,
    0x23, 0x23, 0x2B, 0x2B,
    0x23, 0x23, 0x23, 0x2B,
    0x23, 0x27, 0x2A, 0x2E,
    0x23, 0x28, 0x2C, 0x2E,
    0x23, 0x25, 0x2C, 0x2E,
    0x23, 0x25, 0x29, 0x2E,
    0x23, 0x2E, 0x2E, 0x2E,
    0x23, 0x23, 0x2E, 0x2E,
    0x23, 0x23, 0x23, 0x2E,
    0x23, 0x28, 0x2C, 0x31,
    0x23, 0x2A, 0x2E, 0x31,
    0x23, 0x26, 0x2E, 0x31,
    0x23, 0x26, 0x2A, 0x31,
    0x23, 0x31, 0x31, 0x31,
    0x23, 0x23, 0x31, 0x31,
    0x23, 0x23, 0x23, 0x31,
    0x23, 0x29, 0x2E, 0x34,
    0x23, 0x2B, 0x30, 0x34,
    0x23, 0x27, 0x30, 0x34,
    0x23, 0x27, 0x2C, 0x34,
    0x23, 0x34, 0x34, 0x34,
    0x23, 0x23, 0x34, 0x34,
    0x23, 0x23, 0x23, 0x34,
    0x23, 0x2A, 0x30, 0x37,
    0x23, 0x2D, 0x32, 0x37,
    0x23, 0x28, 0x32, 0x37,
    0x23, 0x28, 0x2D, 0x37,
    0x23, 0x37, 0x37, 0x37,
    0x23, 0x23, 0x37, 0x37,
    0x23, 0x23, 0x23, 0x37,
    0x23, 0x2E, 0x35, 0x3A,
    0x23, 0x28, 0x35, 0x3A,
    0x23, 0x28, 0x2F, 0x3A,
    0x23, 0x3A, 0x3A, 0x3A,
    0x23, 0x23, 0x3A, 0x3A,
    0x23, 0x23, 0x23, 0x3A,
    0x23, 0x30, 0x37, 0x3D,
    0x23, 0x29, 0x37, 0x3D,
    0x23, 0x29, 0x30, 0x3D,
    0x23, 0x3D, 0x3D, 0x3D,
    0x23, 0x23, 0x3D, 0x3D,
    0x23, 0x23, 0x23, 0x3D,
    0x24, 0x25, 0x25, 0x26,
    0x24, 0x25, 0x26, 0x27,
    0x24, 0x26, 0x27, 0x28,
    0x24, 0x25, 0x27, 0x28,
    0x24, 0x25, 0x26, 0x28,
    0x24, 0x26, 0x27, 0x29,
    0x24, 0x26, 0x28, 0x29,
    0x24, 0x25, 0x28, 0x29,
    0x24, 0x25, 0x27, 0x29,
    0x24, 0x26, 0x28, 0x2A,
    0x24, 0x27, 0x29, 0x2A,
    0x24, 0x25, 0x29, 0x2A,
    0x24, 0x25, 0x27, 0x2A,
    0x24, 0x2A, 0x2A, 0x2A,
    0x24, 0x24, 0x2A, 0x2A,
    0x24, 0x24, 0x24, 0x2A,
    0x24, 0x27, 0x28, 0x2B,
    0x24, 0x27, 0x2A, 0x2B,
    0x24, 0x25, 0x2A, 0x2B,
    0x24, 0x25, 0x28, 0x2B,
    0x24, 0x27, 0x29, 0x2C,
    0x24, 0x28, 0x2A, 0x2C,
    0x24, 0x26, 0x2A, 0x2C,
    0x24, 0x26, 0x28, 0x2C,
    0x24, 0x2C, 0x2C, 0x2C,
    0x24, 0x24, 0x2C, 0x2C,
    0x24, 0x24, 0x24, 0x2C,
    0x24, 0x28, 0x2B, 0x2F,
    0x24, 0x29, 0x2D, 0x2F,
    0x24, 0x26, 0x2D, 0x2F,
    0x24, 0x26, 0x2A, 0x2F,
    0x24, 0x2F, 0x2F, 0x2F,
    0x24, 0x24, 0x2F, 0x2F,
    0x24, 0x24, 0x24, 0x2F,
    0x24, 0x29, 0x2D, 0x32,
    0x24, 0x2B, 0x2F, 0x32,
    0x24, 0x27, 0x2F, 0x32,
    0x24, 0x27, 0x2B, 0x32,
    0x24, 0x32, 0x32, 0x32,
    0x24, 0x24, 0x32, 0x32,
    0x24, 0x24, 0x24, 0x32,
    0x24, 0x2A, 0x2F, 0x35,
    0x24, 0x2C, 0x31, 0x35,
    0x24, 0x28, 0x31, 0x35,
    0x24, 0x28, 0x2D, 0x35,
    0x24, 0x35, 0x35, 0x35,
    0x24, 0x24, 0x35, 0x35,
    0x24, 0x24, 0x24, 0x35,
    0x24, 0x2B, 0x31, 0x38,
    0x24, 0x2E, 0x33, 0x38,
    0x24, 0x29, 0x33, 0x38,
    0x24, 0x29, 0x2E, 0x38,
    0x24, 0x38, 0x38, 0x38,
    0x24, 0x24, 0x38, 0x38,
    0x24, 0x24, 0x24, 0x38,
    0x24, 0x2F, 0x36, 0x3B,
    0x24, 0x29, 0x36, 0x3B,
    0x24, 0x29, 0x30, 0x3B,
    0x24, 0x3B, 0x3B, 0x3B,
    0x24, 0x24, 0x3B, 0x3B,
    0x24, 0x24, 0x24, 0x3B,
    0x24, 0x31, 0x38, 0x3E,
    0x24, 0x2A, 0x38, 0x3E,
    0x24, 0x2A, 0x31, 0x3E,
    0x24, 0x3E, 0x3E, 0x3E,
    0x24, 0x24, 0x3E, 0x3E,
    0x24, 0x24, 0x24, 0x3E,
    0x25, 0x26, 0x26, 0x27,
    0x25, 0x26, 0x27, 0x28,
    0x25, 0x27, 0x28, 0x29,
    0x25, 0x26, 0x28, 0x29,
    0x25, 0x26, 0x27, 0x29,
    0x25, 0x27, 0x28, 0x2A,
    0x25, 0x27, 0x29, 0x2A,
    0x25, 0x26, 0x29, 0x2A,
    0x25, 0x26, 0x28, 0x2A,
    0x25, 0x27, 0x29, 0x2B,
    0x25, 0x28, 0x2A, 0x2B,
    0x25, 0x26, 0x2A, 0x2B,
    0x25, 0x26, 0x28, 0x2B,
    0x25, 0x2B, 0x2B, 0x2B,
    0x25, 0x25, 0x2B, 0x2B,
    0x25, 0x25, 0x25, 0x2B,
    0x25, 0x28, 0x29, 0x2C,
    0x25, 0x28, 0x2B, 0x2C,
    0x25, 0x26, 0x2B, 0x2C,
    0x25, 0x26, 0x29, 0x2C,
    0x25, 0x28, 0x2A, 0x2D,
    0x25, 0x29, 0x2B, 0x2D,
    0x25, 0x27, 0x2B, 0x2D,
    0x25, 0x27, 0x29, 0x2D,
    0x25, 0x2D, 0x2D, 0x2D,
    0x25, 0x25, 0x2D, 0x2D,
    0x25, 0x25, 0x25, 0x2D,
    0x25, 0x29, 0x2C, 0x30,
    0x25, 0x2A, 0x2E, 0x30,
    0x25, 0x27, 0x2E, 0x30,
    0x25, 0x27, 0x2B, 0x30,
    0x25, 0x30, 0x30, 0x30,
    0x25, 0x25, 0x30, 0x30,
    0x25, 0x25, 0x25, 0x30,
    0x25, 0x2A, 0x2E, 0x33,
    0x25, 0x2C, 0x30, 0x33,
    0x25, 0x28, 0x30, 0x33,
    0x25, 0x28, 0x2C, 0x33,
    0x25, 0x33, 0x33, 0x33,
    0x25, 0x25, 0x33, 0x33,
    0x25, 0x25, 0x25, 0x33,
    0x25, 0x2B, 0x30, 0x36,
    0x25, 0x2D, 0x32, 0x36,
    0x25, 0x29, 0x32, 0x36,
    0x25, 0x29, 0x2E, 0x36,
    0x25, 0x36, 0x36, 0x36,
    0x25, 0x25, 0x36, 0x36,
    0x25, 0x25, 0x25, 0x36,
    0x25, 0x2C, 0x32, 0x39,
    0x25, 0x2F, 0x34, 0x39,
    0x25, 0x2A, 0x34, 0x39,
    0x25, 0x2A, 0x2F, 0x39,
    0x25, 0x39, 0x39, 0x39,
    0x25, 0x25, 0x39, 0x39,
    0x25, 0x25, 0x25, 0x39,
    0x25, 0x30, 0x37, 0x3C,
    0x25, 0x2A, 0x37, 0x3C,
    0x25, 0x2A, 0x31, 0x3C,
    0x25, 0x3C, 0x3C, 0x3C,
    0x25, 0x25, 0x3C, 0x3C,
    0x25, 0x25, 0x25, 0x3C,
    0x25, 0x32, 0x39, 0x3F,
    0x25, 0x2B, 0x39, 0x3F,
    0x25, 0x2B, 0x32, 0x3F,
    0x25, 0x3F, 0x3F, 0x3F,
    0x25, 0x25, 0x3F, 0x3F,
    0x25, 0x25, 0x25, 0x3F,
    0x26, 0x27, 0x27, 0x28,
    0x26, 0x27, 0x28, 0x29,
    0x26, 0x28, 0x29, 0x2A,
    0x26, 0x27, 0x29, 0x2A,
    0x26, 0x27, 0x28, 0x2A,
    0x26, 0x28, 0x29, 0x2B,
    0x26, 0x28, 0x2A, 0x2B,
    0x26, 0x27, 0x2A, 0x2B,
    0x26, 0x27, 0x29, 0x2B,
    0x26, 0x28, 0x2A, 0x2C,
    0x26, 0x29, 0x2B, 0x2C,
    0x26, 0x27, 0x2B, 0x2C,
    0x26, 0x27, 0x29, 0x2C,
    0x26, 0x2C, 0x2C, 0x2C,
    0x26, 0x26, 0x2C, 0x2C,
    0x26, 0x26, 0x26, 0x2C,
    0x26, 0x29, 0x2A, 0x2D,
    0x26, 0x29, 0x2C, 0x2D,
    0x26, 0x27, 0x2C, 0x2D,
    0x26, 0x27, 0x2A, 0x2D,
    0x26, 0x29, 0x2B, 0x2E,
    0x26, 0x2A, 0x2C, 0x2E,
    0x26, 0x28, 0x2C, 0x2E,
    0x26, 0x28, 0x2A, 0x2E,
    0x26, 0x2E, 0x2E, 0x2E,
    0x26, 0x26, 0x2E, 0x2E,
    0x26, 0x26, 0x26, 0x2E,
    0x26, 0x2A, 0x2D, 0x31,
    0x26, 0x2B, 0x2F, 0x31,
    0x26, 0x28, 0x2F, 0x31,
    0x26, 0x28, 0x2C, 0x31,
    0x26, 0x31, 0x31, 0x31,
    0x26, 0x26, 0x31, 0x31,
    0x26, 0x26, 0x26, 0x31,
    0x26, 0x2B, 0x2F, 0x34,
    0x26, 0x2D, 0x31, 0x34,
    0x26, 0x29, 0x31, 0x34,
    0x26, 0x29, 0x2D, 0x34,
    0x26, 0x34, 0x34, 0x34,
    0x26, 0x26, 0x34, 0x34,
    0x26, 0x26, 0x26, 0x34,
    0x26, 0x2C, 0x31, 0x37,
    0x26, 0x2E, 0x33, 0x37,
    0x26, 0x2A, 0x33, 0x37,
    0x26, 0x2A, 0x2F, 0x37,
    0x26, 0x37, 0x37, 0x37,
    0x26, 0x26, 0x37, 0x37,
    0x26, 0x26, 0x26, 0x37,
    0x26, 0x2D, 0x33, 0x3A,
    0x26, 0x30, 0x35, 0x3A,
    0x26, 0x2B, 0x35, 0x3A,
    0x26, 0x2B, 0x30, 0x3A,
    0x26, 0x3A, 0x3A, 0x3A,
    0x26, 0x26, 0x3A, 0x3A,
    0x26, 0x26, 0x26, 0x3A,
    0x26, 0x31, 0x38, 0x3D,
    0x26, 0x2B, 0x38, 0x3D,
    0x26, 0x2B, 0x32, 0x3D,
    0x26, 0x3D, 0x3D, 0x3D,
    0x26, 0x26, 0x3D, 0x3D,
    0x26, 0x26, 0x26, 0x3D,
    0x27, 0x28, 0x28, 0x29,
    0x27, 0x28, 0x29, 0x2A,
    0x27, 0x29, 0x2A, 0x2B,
    0x27, 0x28, 0x2A, 0x2B,
    0x27, 0x28, 0x29, 0x2B,
    0x27, 0x29, 0x2A, 0x2C,
    0x27, 0x29, 0x2B, 0x2C,
    0x27, 0x28, 0x2B, 0x2C,
    0x27, 0x28, 0x2A, 0x2C,
    0x27, 0x29, 0x2B, 0x2D,
    0x27, 0x2A, 0x2C, 0x2D,
    0x27, 0x28, 0x2C, 0x2D,
    0x27, 0x28, 0x2A, 0x2D,
    0x27, 0x2D, 0x2D, 0x2D,
    0x27, 0x27, 0x2D, 0x2D,
    0x27, 0x27, 0x27, 0x2D,
    0x27, 0x2A, 0x2B, 0x2E,
    0x27, 0x2A, 0x2D, 0x2E,
    0x27, 0x28, 0x2D, 0x2E,
    0x27, 0x28, 0x2B, 0x2E,
    0x27, 0x2A, 0x2C, 0x2F,
    0x27, 0x2B, 0x2D, 0x2F,
    0x27, 0x29, 0x2D, 0x2F,
    0x27, 0x29, 0x2B, 0x2F,
    0x27, 0x2F, 0x2F, 0x2F,
    0x27, 0x27, 0x2F, 0x2F,
    0x27, 0x27, 0x27, 0x2F,
    0x27, 0x2B, 0x2E, 0x32,
    0x27, 0x2C, 0x30, 0x32,
    0x27, 0x29, 0x30, 0x32,
    0x27, 0x29, 0x2D, 0x32,
    0x27, 0x32, 0x32, 0x32,
    0x27, 0x27, 0x32, 0x32,
    0x27, 0x27, 0x27, 0x32,
    0x27, 0x2C, 0x30, 0x35,
    0x27, 0x2E, 0x32, 0x35,
    0x27, 0x2A, 0x32, 0x35,
    0x27, 0x2A, 0x2E, 0x35,
    0x27, 0x35, 0x35, 0x35,
    0x27, 0x27, 0x35, 0x35,
    0x27, 0x27, 0x27, 0x35,
    0x27, 0x2D, 0x32, 0x38,
    0x27, 0x2F, 0x34, 0x38,
    0x27, 0x2B, 0x34, 0x38,
    0x27, 0x2B, 0x30, 0x38,
    0x27, 0x38, 0x38, 0x38,
    0x27, 0x27, 0x38, 0x38,
    0x27, 0x27, 0x27, 0x38,
    0x27, 0x2E, 0x34, 0x3B,
    0x27, 0x31, 0x36, 0x3B,
    0x27, 0x2C, 0x36, 0x3B,
    0x27, 0x2C, 0x31, 0x3B,
    0x27, 0x3B, 0x3B, 0x3B,
    0x27, 0x27, 0x3B, 0x3B,
    0x27, 0x27, 0x27, 0x3B,
    0x27, 0x32, 0x39, 0x3E,
    0x27, 0x2C, 0x39, 0x3E,
    0x27, 0x2C, 0x33, 0x3E,
    0x27, 0x3E, 0x3E, 0x3E,
    0x27, 0x27, 0x3E, 0x3E,
    0x27, 0x27, 0x27, 0x3E,
    0x28, 0x29, 0x29, 0x2A,
    0x28, 0x29, 0x2A, 0x2B,
    0x28, 0x2A, 0x2B, 0x2C,
    0x28, 0x29, 0x2B, 0x2C,
    0x28, 0x29, 0x2A, 0x2C,
    0x28, 0x2A, 0x2B, 0x2D,
    0x28, 0x2A, 0x2C, 0x2D,
    0x28, 0x29, 0x2C, 0x2D,
    0x28, 0x29, 0x2B, 0x2D,
    0x28, 0x2A, 0x2C, 0x2E,
    0x28, 0x2B, 0x2D, 0x2E,
    0x28, 0x29, 0x2D, 0x2E,
    0x28, 0x29, 0x2B, 0x2E,
    0x28, 0x2E, 0x2E, 0x2E,
    0x28, 0x28, 0x2E, 0x2E,
    0x28, 0x28, 0x28, 0x2E,
    0x28, 0x2B, 0x2C, 0x2F,
    0x28, 0x2B, 0x2E, 0x2F,
    0x28, 0x29, 0x2E, 0x2F,
    0x28, 0x29, 0x2C, 0x2F,
    0x28, 0x2B, 0x2D, 0x30,
    0x28, 0x2C, 0x2E, 0x30,
    0x28, 0x2A, 0x2E, 0x30,
    0x28, 0x2A, 0x2C, 0x30,
    0x28, 0x30, 0x30, 0x30,
    0x28, 0x28, 0x30, 0x30,
    0x28, 0x28, 0x28, 0x30,
    0x28, 0x2C, 0x2F, 0x33,
    0x28, 0x2D, 0x31, 0x33,
    0x28, 0x2A, 0x31, 0x33,
    0x28, 0x2A, 0x2E, 0x33,
    0x28, 0x33, 0x33, 0x33,
    0x28, 0x28, 0x33, 0x33,
    0x28, 0x28, 0x28, 0x33,
    0x28, 0x2D, 0x31, 0x36,
    0x28, 0x2F, 0x33, 0x36,
    0x28, 0x2B, 0x33, 0x36,
    0x28, 0x2B, 0x2F, 0x36,
    0x28, 0x36, 0x36, 0x36,
    0x28, 0x28, 0x36, 0x36,
    0x28, 0x28, 0x28, 0x36,
    0x28, 0x2E, 0x33, 0x39,
    0x28, 0x30, 0x35, 0x39,
    0x28, 0x2C, 0x35, 0x39,
    0x28, 0x2C, 0x31, 0x39,
    0x28, 0x39, 0x39, 0x39,
    0x28, 0x28, 0x39, 0x39,
    0x28, 0x28, 0x28, 0x39,
    0x28, 0x2F, 0x35, 0x3C,
    0x28, 0x32, 0x37, 0x3C,
    0x28, 0x2D, 0x37, 0x3C,
    0x28, 0x2D, 0x32, 0x3C,
    0x28, 0x3C, 0x3C, 0x3C,
    0x28, 0x28, 0x3C, 0x3C,
    0x28, 0x28, 0x28, 0x3C,
    0x28, 0x33, 0x3A, 0x3F,
    0x28, 0x2D, 0x3A, 0x3F,
    0x28, 0x2D, 0x34, 0x3F,
    0x28, 0x3F, 0x3F, 0x3F,
    0x28, 0x28, 0x3F, 0x3F,
    0x28, 0x28, 0x28, 0x3F,
    0x29, 0x2A, 0x2A, 0x2B,
    0x29, 0x2A, 0x2B, 0x2C,
    0x29, 0x2B, 0x2C, 0x2D,
    0x29, 0x2A, 0x2C, 0x2D,
    0x29, 0x2A, 0x2B, 0x2D,
    0x29, 0x2B, 0x2C, 0x2E,
    0x29, 0x2B, 0x2D, 0x2E,
    0x29, 0x2A, 0x2D, 0x2E,
    0x29, 0x2A, 0x2C, 0x2E,
    0x29, 0x2B, 0x2D, 0x2F,
    0x29, 0x2C, 0x2E, 0x2F,
    0x29, 0x2A, 0x2E, 0x2F,
    0x29, 0x2A, 0x2C, 0x2F,
    0x29, 0x2F, 0x2F, 0x2F,
    0x29, 0x29, 0x2F, 0x2F,
    0x29, 0x29, 0x29, 0x2F,
    0x29, 0x2C, 0x2D, 0x30,
    0x29, 0x2C, 0x2F, 0x30,
    0x29, 0x2A, 0x2F, 0x30,
    0x29, 0x2A, 0x2D, 0x30,
    0x29, 0x2C, 0x2E, 0x31,
    0x29, 0x2D, 0x2F, 0x31,
    0x29, 0x2B, 0x2F, 0x31,
    0x29, 0x2B, 0x2D, 0x31,
    0x29, 0x31, 0x31, 0x31,
    0x29, 0x29, 0x31, 0x31,
    0x29, 0x29, 0x29, 0x31,
    0x29, 0x2D, 0x30, 0x34,
    0x29, 0x2E, 0x32, 0x34,
    0x29, 0x2B, 0x32, 0x34,
    0x29, 0x2B, 0x2F, 0x34,
    0x29, 0x34, 0x34, 0x34,
    0x29, 0x29, 0x34, 0x34,
    0x29, 0x29, 0x29, 0x34,
    0x29, 0x2E, 0x32, 0x37,
    0x29, 0x30, 0x34, 0x37,
    0x29, 0x2C, 0x34, 0x37,
    0x29, 0x2C, 0x30, 0x37,
    0x29, 0x37, 0x37, 0x37,
    0x29, 0x29, 0x37, 0x37,
    0x29, 0x29, 0x29, 0x37,
    0x29, 0x2F, 0x34, 0x3A,
    0x29, 0x31, 0x36, 0x3A,
    0x29, 0x2D, 0x36, 0x3A,
    0x29, 0x2D, 0x32, 0x3A,
    0x29, 0x3A, 0x3A, 0x3A,
    0x29, 0x29, 0x3A, 0x3A,
    0x29, 0x29, 0x29, 0x3A,
    0x29, 0x30, 0x36, 0x3D,
    0x29, 0x33, 0x38, 0x3D,
    0x29, 0x2E, 0x38, 0x3D,
    0x29, 0x2E, 0x33, 0x3D,
    0x29, 0x3D, 0x3D, 0x3D,
    0x29, 0x29, 0x3D, 0x3D,
    0x29, 0x29, 0x29, 0x3D,
    0x2A, 0x2B, 0x2B, 0x2C,
    0x2A, 0x2B, 0x2C, 0x2D,
    0x2A, 0x2C, 0x2D, 0x2E,
    0x2A, 0x2B, 0x2D, 0x2E,
    0x2A, 0x2B, 0x2C, 0x2E,
    0x2A, 0x2C, 0x2D, 0x2F,
    0x2A, 0x2C, 0x2E, 0x2F,
    0x2A, 0x2B, 0x2E, 0x2F,
    0x2A, 0x2B, 0x2D, 0x2F,
    0x2A, 0x2C, 0x2E, 0x30,
    0x2A, 0x2D, 0x2F, 0x30,
    0x2A, 0x2B, 0x2F, 0x30,
    0x2A, 0x2B, 0x2D, 0x30,
    0x2A, 0x30, 0x30, 0x30,
    0x2A, 0x2A, 0x30, 0x30,
    0x2A, 0x2A, 0x2A, 0x30,
    0x2A, 0x2D, 0x2E, 0x31,
    0x2A, 0x2D, 0x30, 0x31,
    0x2A, 0x2B, 0x30, 0x31,
    0x2A, 0x2B, 0x2E, 0x31,
    0x2A, 0x2D, 0x2F, 0x32,
    0x2A, 0x2E, 0x30, 0x32,
    0x2A, 0x2C, 0x30, 0x32,
    0x2A, 0x2C, 0x2E, 0x32,
    0x2A, 0x32, 0x32, 0x32,
    0x2A, 0x2A, 0x32, 0x32,
    0x2A, 0x2A, 0x2A, 0x32,
    0x2A, 0x2E, 0x31, 0x35,
    0x2A, 0x2F, 0x33, 0x35,
    0x2A, 0x2C, 0x33, 0x35,
    0x2A, 0x2C, 0x30, 0x35,
    0x2A, 0x35, 0x35, 0x35,
    0x2A, 0x2A, 0x35, 0x35,
    0x2A, 0x2A, 0x2A, 0x35,
    0x2A, 0x2F, 0x33, 0x38,
    0x2A, 0x31, 0x35, 0x38,
    0x2A, 0x2D, 0x35, 0x38,
    0x2A, 0x2D, 0x31, 0x38,
    0x2A, 0x38, 0x38, 0x38,
    0x2A, 0x2A, 0x38, 0x38,
    0x2A, 0x2A, 0x2A, 0x38,
    0x2A, 0x30, 0x35, 0x3B,
    0x2A, 0x32, 0x37, 0x3B,
    0x2A, 0x2E, 0x37, 0x3B,
    0x2A, 0x2E, 0x33, 0x3B,
    0x2A, 0x3B, 0x3B, 0x3B,
    0x2A, 0x2A, 0x3B, 0x3B,
    0x2A, 0x2A, 0x2A, 0x3B,
    0x2A, 0x31, 0x37, 0x3E,
    0x2A, 0x34, 0x39, 0x3E,
    0x2A, 0x2F, 0x39, 0x3E,
    0x2A, 0x2F, 0x34, 0x3E,
    0x2A, 0x3E, 0x3E, 0x3E,
    0x2A, 0x2A, 0x3E, 0x3E,
    0x2A, 0x2A, 0x2A, 0x3E,
    0x2B, 0x2C, 0x2C, 0x2D,
    0x2B, 0x2C, 0x2D, 0x2E,
    0x2B, 0x2D, 0x2E, 0x2F,
    0x2B, 0x2C, 0x2E, 0x2F,
    0x2B, 0x2C, 0x2D, 0x2F,
    0x2B, 0x2D, 0x2E, 0x30,
    0x2B, 0x2D, 0x2F, 0x30,
    0x2B, 0x2C, 0x2F, 0x30,
    0x2B, 0x2C, 0x2E, 0x30,
    0x2B, 0x2D, 0x2F, 0x31,
    0x2B, 0x2E, 0x30, 0x31,
    0x2B, 0x2C, 0x30, 0x31,
    0x2B, 0x2C, 0x2E, 0x31,
    0x2B, 0x31, 0x31, 0x31,
    0x2B, 0x2B, 0x31, 0x31,
    0x2B, 0x2B, 0x2B, 0x31,
    0x2B, 0x2E, 0x2F, 0x32,
    0x2B, 0x2E, 0x31, 0x32,
    0x2B, 0x2C, 0x31, 0x32,
    0x2B, 0x2C, 0x2F, 0x32,
    0x2B, 0x2E, 0x30, 0x33,
    0x2B, 0x2F, 0x31, 0x33,
    0x2B, 0x2D, 0x31, 0x33,
    0x2B, 0x2D, 0x2F, 0x33,
    0x2B, 0x33, 0x33, 0x33,
    0x2B, 0x2B, 0x33, 0x33,
    0x2B, 0x2B, 0x2B, 0x33,
    0x2B, 0x2F, 0x32, 0x36,
    0x2B, 0x30, 0x34, 0x36,
    0x2B, 0x2D, 0x34, 0x36,
    0x2B, 0x2D, 0x31, 0x36,
    0x2B, 0x36, 0x36, 0x36,
    0x2B, 0x2B, 0x36, 0x36,
    0x2B, 0x2B, 0x2B, 0x36,
    0x2B, 0x30, 0x34, 0x39,
    0x2B, 0x32, 0x36, 0x39,
    0x2B, 0x2E, 0x36, 0x39,
    0x2B, 0x2E, 0x32, 0x39,
    0x2B, 0x39, 0x39, 0x39,
    0x2B, 0x2B, 0x39, 0x39,
    0x2B, 0x2B, 0x2B, 0x39,
    0x2B, 0x31, 0x36, 0x3C,
    0x2B, 0x33, 0x38, 0x3C,
    0x2B, 0x2F, 0x38, 0x3C,
    0x2B, 0x2F, 0x34, 0x3C,
    0x2B, 0x3C, 0x3C, 0x3C,
    0x2B, 0x2B, 0x3C, 0x3C,
    0x2B, 0x2B, 0x2B, 0x3C,
    0x2B, 0x32, 0x38, 0x3F,
    0x2B, 0x35, 0x3A, 0x3F,
    0x2B, 0x30, 0x3A, 0x3F,
    0x2B, 0x30, 0x35, 0x3F,
    0x2B, 0x3F, 0x3F, 0x3F,
    0x2B, 0x2B, 0x3F, 0x3F,
    0x2B, 0x2B, 0x2B, 0x3F,
    0x2C, 0x2D, 0x2D, 0x2E,
    0x2C, 0x2D, 0x2E, 0x2F,
    0x2C, 0x2E, 0x2F, 0x30,
    0x2C, 0x2D, 0x2F, 0x30,
    0x2C, 0x2D, 0x2E, 0x30,
    0x2C, 0x2E, 0x2F, 0x31,
    0x2C, 0x2E, 0x30, 0x31,
    0x2C, 0x2D, 0x30, 0x31,
    0x2C, 0x2D, 0x2F, 0x31,
    0x2C, 0x2E, 0x30, 0x32,
    0x2C, 0x2F, 0x31, 0x32,
    0x2C, 0x2D, 0x31, 0x32,
    0x2C, 0x2D, 0x2F, 0x32,
    0x2C, 0x32, 0x32, 0x32,
    0x2C, 0x2C, 0x32, 0x32,
    0x2C, 0x2C, 0x2C, 0x32,
    0x2C, 0x2F, 0x30, 0x33,
    0x2C, 0x2F, 0x32, 0x33,
    0x2C, 0x2D, 0x32, 0x33,
    0x2C, 0x2D, 0x30, 0x33,
    0x2C, 0x2F, 0x31, 0x34,
    0x2C, 0x30, 0x32, 0x34,
    0x2C, 0x2E, 0x32, 0x34,
    0x2C, 0x2E, 0x30, 0x34,
    0x2C, 0x34, 0x34, 0x34,
    0x2C, 0x2C, 0x34, 0x34,
    0x2C, 0x2C, 0x2C, 0x34,
    0x2C, 0x30, 0x33, 0x37,
    0x2C, 0x31, 0x35, 0x37,
    0x2C, 0x2E, 0x35, 0x37,
    0x2C, 0x2E, 0x32, 0x37,
    0x2C, 0x37, 0x37, 0x37,
    0x2C, 0x2C, 0x37, 0x37,
    0x2C, 0x2C, 0x2C, 0x37,
    0x2C, 0x31, 0x35, 0x3A,
    0x2C, 0x33, 0x37, 0x3A,
    0x2C, 0x2F, 0x37, 0x3A,
    0x2C, 0x2F, 0x33, 0x3A,
    0x2C, 0x3A, 0x3A, 0x3A,
    0x2C, 0x2C, 0x3A, 0x3A,
    0x2C, 0x2C, 0x2C, 0x3A,
    0x2C, 0x32, 0x37, 0x3D,
    0x2C, 0x34, 0x39, 0x3D,
    0x2C, 0x30, 0x39, 0x3D,
    0x2C, 0x30, 0x35, 0x3D,
    0x2C, 0x3D, 0x3D, 0x3D,
    0x2C, 0x2C, 0x3D, 0x3D,
    0x2C, 0x2C, 0x2C, 0x3D,
    0x2D, 0x2E, 0x2E, 0x2F,
    0x2D, 0x2E, 0x2F, 0x30,
    0x2D, 0x2F, 0x30, 0x31,
    0x2D, 0x2E, 0x30, 0x31,
    0x2D, 0x2E, 0x2F, 0x31,
    0x2D, 0x2F, 0x30, 0x32,
    0x2D, 0x2F, 0x31, 0x32,
    0x2D, 0x2E, 0x31, 0x32,
    0x2D, 0x2E, 0x30, 0x32,
    0x2D, 0x2F, 0x31, 0x33,
    0x2D, 0x30, 0x32, 0x33,
    0x2D, 0x2E, 0x32, 0x33,
    0x2D, 0x2E, 0x30, 0x33,
    0x2D, 0x33, 0x33, 0x33,
    0x2D, 0x2D, 0x33, 0x33,
    0x2D, 0x2D, 0x2D, 0x33,
    0x2D, 0x30, 0x31, 0x34,
    0x2D, 0x30, 0x33, 0x34,
    0x2D, 0x2E, 0x33, 0x34,
    0x2D, 0x2E, 0x31, 0x34,
    0x2D, 0x30, 0x32, 0x35,
    0x2D, 0x31, 0x33, 0x35,
    0x2D, 0x2F, 0x33, 0x35,
    0x2D, 0x2F, 0x31, 0x35,
    0x2D, 0x35, 0x35, 0x35,
    0x2D, 0x2D, 0x35, 0x35,
    0x2D, 0x2D, 0x2D, 0x35,
    0x2D, 0x31, 0x34, 0x38,
    0x2D, 0x32, 0x36, 0x38,
    0x2D, 0x2F, 0x36, 0x38,
    0x2D, 0x2F, 0x33, 0x38,
    0x2D, 0x38, 0x38, 0x38,
    0x2D, 0x2D, 0x38, 0x38,
    0x2D, 0x2D, 0x2D, 0x38,
    0x2D, 0x32, 0x36, 0x3B,
    0x2D, 0x34, 0x38, 0x3B,
    0x2D, 0x30, 0x38, 0x3B,
    0x2D, 0x30, 0x34, 0x3B,
    0x2D, 0x3B, 0x3B, 0x3B,
    0x2D, 0x2D, 0x3B, 0x3B,
    0x2D, 0x2D, 0x2D, 0x3B,
    0x2D, 0x33, 0x38, 0x3E,
    0x2D, 0x35, 0x3A, 0x3E,
    0x2D, 0x31, 0x3A, 0x3E,
    0x2D, 0x31, 0x36, 0x3E,
    0x2D, 0x3E, 0x3E, 0x3E,
    0x2D, 0x2D, 0x3E, 0x3E,
    0x2D, 0x2D, 0x2D, 0x3E,
    0x2E, 0x2F, 0x2F, 0x30,
    0x2E, 0x2F, 0x30, 0x31,
    0x2E, 0x30, 0x31, 0x32,
    0x2E, 0x2F, 0x31, 0x32,
    0x2E, 0x2F, 0x30, 0x32,
    0x2E, 0x30, 0x31, 0x33,
    0x2E, 0x30, 0x32, 0x33,
    0x2E, 0x2F, 0x32, 0x33,
    0x2E, 0x2F, 0x31, 0x33,
    0x2E, 0x30, 0x32, 0x34,
    0x2E, 0x31, 0x33, 0x34,
    0x2E, 0x2F, 0x33, 0x34,
    0x2E, 0x2F, 0x31, 0x34,
    0x2E, 0x34, 0x34, 0x34,
    0x2E, 0x2E, 0x34, 0x34,
    0x2E, 0x2E, 0x2E, 0x34,
    0x2E, 0x31, 0x32, 0x35,
    0x2E, 0x31, 0x34, 0x35,
    0x2E, 0x2F, 0x34, 0x35,
    0x2E, 0x2F, 0x32, 0x35,
    0x2E, 0x31, 0x33, 0x36,
    0x2E, 0x32, 0x34, 0x36,
    0x2E, 0x30, 0x34, 0x36,
    0x2E, 0x30, 0x32, 0x36,
    0x2E, 0x36, 0x36, 0x36,
    0x2E, 0x2E, 0x36, 0x36,
    0x2E, 0x2E, 0x2E, 0x36,
    0x2E, 0x32, 0x35, 0x39,
    0x2E, 0x33, 0x37, 0x39,
    0x2E, 0x30, 0x37, 0x39,
    0x2E, 0x30, 0x34, 0x39,
    0x2E, 0x39, 0x39, 0x39,
    0x2E, 0x2E, 0x39, 0x39,
    0x2E, 0x2E, 0x2E, 0x39,
    0x2E, 0x33, 0x37, 0x3C,
    0x2E, 0x35, 0x39, 0x3C,
    0x2E, 0x31, 0x39, 0x3C,
    0x2E, 0x31, 0x35, 0x3C,
    0x2E, 0x3C, 0x3C, 0x3C,
    0x2E, 0x2E, 0x3C, 0x3C,
    0x2E, 0x2E, 0x2E, 0x3C,
    0x2E, 0x34, 0x39, 0x3F,
    0x2E, 0x36, 0x3B, 0x3F,
    0x2E, 0x32, 0x3B, 0x3F,
    0x2E, 0x32, 0x37, 0x3F,
    0x2E, 0x3F, 0x3F, 0x3F,
    0x2E, 0x2E, 0x3F, 0x3F,
    0x2E, 0x2E, 0x2E, 0x3F,
    0x2F, 0x30, 0x30, 0x31,
    0x2F, 0x30, 0x31, 0x32,
    0x2F, 0x31, 0x32, 0x33,
    0x2F, 0x30, 0x32, 0x33,
    0x2F, 0x30, 0x31, 0x33,
    0x2F, 0x31, 0x32, 0x34,
    0x2F, 0x31, 0x33, 0x34,
    0x2F, 0x30, 0x33, 0x34,
    0x2F, 0x30, 0x32, 0x34,
    0x2F, 0x31, 0x33, 0x35,
    0x2F, 0x32, 0x34, 0x35,
    0x2F, 0x30, 0x34, 0x35,
    0x2F, 0x30, 0x32, 0x35,
    0x2F, 0x35, 0x35, 0x35,
    0x2F, 0x2F, 0x35, 0x35,
    0x2F, 0x2F, 0x2F, 0x35,
    0x2F, 0x32, 0x33, 0x36,
    0x2F, 0x32, 0x35, 0x36,
    0x2F, 0x30, 0x35, 0x36,
    0x2F, 0x30, 0x33, 0x36,
    0x2F, 0x32, 0x34, 0x37,
    0x2F, 0x33, 0x35, 0x37,
    0x2F, 0x31, 0x35, 0x37,
    0x2F, 0x31, 0x33, 0x37,
    0x2F, 0x37, 0x37, 0x37,
    0x2F, 0x2F, 0x37, 0x37,
    0x2F, 0x2F, 0x2F, 0x37,
    0x2F, 0x33, 0x36, 0x3A,
    0x2F, 0x34, 0x38, 0x3A,
    0x2F, 0x31, 0x38, 0x3A,
    0x2F, 0x31, 0x35, 0x3A,
    0x2F, 0x3A, 0x3A, 0x3A,
    0x2F, 0x2F, 0x3A, 0x3A,
    0x2F, 0x2F, 0x2F, 0x3A,
    0x2F, 0x34, 0x38, 0x3D,
    0x2F, 0x36, 0x3A, 0x3D,
    0x2F, 0x32, 0x3A, 0x3D,
    0x2F, 0x32, 0x36, 0x3D,
    0x2F, 0x3D, 0x3D, 0x3D,
    0x2F, 0x2F, 0x3D, 0x3D,
    0x2F, 0x2F, 0x2F, 0x3D,
    0x30, 0x31, 0x31, 0x32,
    0x30, 0x31, 0x32, 0x33,
    0x30, 0x32, 0x33, 0x34,
    0x30, 0x31, 0x33, 0x34,
    0x30, 0x31, 0x32, 0x34,
    0x30, 0x32, 0x33, 0x35,
    0x30, 0x32, 0x34, 0x35,
    0x30, 0x31, 0x34, 0x35,
    0x30, 0x31, 0x33, 0x35,
    0x30, 0x32, 0x34, 0x36,
    0x30, 0x33, 0x35, 0x36,
    0x30, 0x31, 0x35, 0x36,
    0x30, 0x31, 0x33, 0x36,
    0x30, 0x36, 0x36, 0x36,
    0x30, 0x30, 0x36, 0x36,
    0x30, 0x30, 0x30, 0x36,
    0x30, 0x33, 0x34, 0x37,
    0x30, 0x33, 0x36, 0x37,
    0x30, 0x31, 0x36, 0x37,
    0x30, 0x31, 0x34, 0x37,
    0x30, 0x33, 0x35, 0x38,
    0x30, 0x34, 0x36, 0x38,
    0x30, 0x32, 0x36, 0x38,
    0x30, 0x32, 0x34, 0x38,
    0x30, 0x38, 0x38, 0x38,
    0x30, 0x30, 0x38, 0x38,
    0x30, 0x30, 0x30, 0x38,
    0x30, 0x34, 0x37, 0x3B,
    0x30, 0x35, 0x39, 0x3B,
    0x30, 0x32, 0x39, 0x3B,
    0x30, 0x32, 0x36, 0x3B,
    0x30, 0x3B, 0x3B, 0x3B,
    0x30, 0x30, 0x3B, 0x3B,
    0x30, 0x30, 0x30, 0x3B,
    0x30, 0x35, 0x39, 0x3E,
    0x30, 0x37, 0x3B, 0x3E,
    0x30, 0x33, 0x3B, 0x3E,
    0x30, 0x33, 0x37, 0x3E,
    0x30, 0x3E, 0x3E, 0x3E,
    0x30, 0x30, 0x3E, 0x3E,
    0x30, 0x30, 0x30, 0x3E,
    0x31, 0x32, 0x32, 0x33,
    0x31, 0x32, 0x33, 0x34,
    0x31, 0x33, 0x34, 0x35,
    0x31, 0x32, 0x34, 0x35,
    0x31, 0x32, 0x33, 0x35,
    0x31, 0x33, 0x34, 0x36,
    0x31, 0x33, 0x35, 0x36,
    0x31, 0x32, 0x35, 0x36,
    0x31, 0x32, 0x34, 0x36,
    0x31, 0x33, 0x35, 0x37,
    0x31, 0x34, 0x36, 0x37,
    0x31, 0x32, 0x36, 0x37,
    0x31, 0x32, 0x34, 0x37,
    0x31, 0x37, 0x37, 0x37,
    0x31, 0x31, 0x37, 0x37,
    0x31, 0x31, 0x31, 0x37,
    0x31, 0x34, 0x35, 0x38,
    0x31, 0x34, 0x37, 0x38,
    0x31, 0x32, 0x37, 0x38,
    0x31, 0x32, 0x35, 0x38,
    0x31, 0x34, 0x36, 0x39,
    0x31, 0x35, 0x37, 0x39,
    0x31, 0x33, 0x37, 0x39,
    0x31, 0x33, 0x35, 0x39,
    0x31, 0x39, 0x39, 0x39,
    0x31, 0x31, 0x39, 0x39,
    0x31, 0x31, 0x31, 0x39,
    0x31, 0x35, 0x38, 0x3C,
    0x31, 0x36, 0x3A, 0x3C,
    0x31, 0x33, 0x3A, 0x3C,
    0x31, 0x33, 0x37, 0x3C,
    0x31, 0x3C, 0x3C, 0x3C,
    0x31, 0x31, 0x3C, 0x3C,
    0x31, 0x31, 0x31, 0x3C,
    0x31, 0x36, 0x3A, 0x3F,
    0x31, 0x38, 0x3C, 0x3F,
    0x31, 0x34, 0x3C, 0x3F,
    0x31, 0x34, 0x38, 0x3F,
    0x31, 0x3F, 0x3F, 0x3F,
    0x31, 0x31, 0x3F, 0x3F,
    0x31, 0x31, 0x31, 0x3F,
    0x32, 0x33, 0x33, 0x34,
    0x32, 0x33, 0x34, 0x35,
    0x32, 0x34, 0x35, 0x36,
    0x32, 0x33, 0x35, 0x36,
    0x32, 0x33, 0x34, 0x36,
    0x32, 0x34, 0x35, 0x37,
    0x32, 0x34, 0x36, 0x37,
    0x32, 0x33, 0x36, 0x37,
    0x32, 0x33, 0x35, 0x37,
    0x32, 0x34, 0x36, 0x38,
    0x32, 0x35, 0x37, 0x38,
    0x32, 0x33, 0x37, 0x38,
    0x32, 0x33, 0x35, 0x38,
    0x32, 0x38, 0x38, 0x38,
    0x32, 0x32, 0x38, 0x38,
    0x32, 0x32, 0x32, 0x38,
    0x32, 0x35, 0x36, 0x39,
    0x32, 0x35, 0x38, 0x39,
    0x32, 0x33, 0x38, 0x39,
    0x32, 0x33, 0x36, 0x39,
    0x32, 0x35, 0x37, 0x3A,
    0x32, 0x36, 0x38, 0x3A,
    0x32, 0x34, 0x38, 0x3A,
    0x32, 0x34, 0x36, 0x3A,
    0x32, 0x3A, 0x3A, 0x3A,
    0x32, 0x32, 0x3A, 0x3A,
    0x32, 0x32, 0x32, 0x3A,
    0x32, 0x36, 0x39, 0x3D,
    0x32, 0x37, 0x3B, 0x3D,
    0x32, 0x34, 0x3B, 0x3D,
    0x32, 0x34, 0x38, 0x3D,
    0x32, 0x3D, 0x3D, 0x3D,
    0x32, 0x32, 0x3D, 0x3D,
    0x32, 0x32, 0x32, 0x3D,
    0x33, 0x34, 0x34, 0x35,
    0x33, 0x34, 0x35, 0x36,
    0x33, 0x35, 0x36, 0x37,
    0x33, 0x34, 0x36, 0x37,
    0x33, 0x34, 0x35, 0x37,
    0x33, 0x35, 0x36, 0x38,
    0x33, 0x35, 0x37, 0x38,
    0x33, 0x34, 0x37, 0x38,
    0x33, 0x34, 0x36, 0x38,
    0x33, 0x35, 0x37, 0x39,
    0x33, 0x36, 0x38, 0x39,
    0x33, 0x34, 0x38, 0x39,
    0x33, 0x34, 0x36, 0x39,
    0x33, 0x39, 0x39, 0x39,
    0x33, 0x33, 0x39, 0x39,
    0x33, 0x33, 0x33, 0x39,
    0x33, 0x36, 0x37, 0x3A,
    0x33, 0x36, 0x39, 0x3A,
    0x33, 0x34, 0x39, 0x3A,
    0x33, 0x34, 0x37, 0x3A,
    0x33, 0x36, 0x38, 0x3B,
    0x33, 0x37, 0x39, 0x3B,
    0x33, 0x35, 0x39, 0x3B,
    0x33, 0x35, 0x37, 0x3B,
    0x33, 0x3B, 0x3B, 0x3B,
    0x33, 0x33, 0x3B, 0x3B,
    0x33, 0x33, 0x33, 0x3B,
    0x33, 0x37, 0x3A, 0x3E,
    0x33, 0x38, 0x3C, 0x3E,
    0x33, 0x35, 0x3C, 0x3E,
    0x33, 0x35, 0x39, 0x3E,
    0x33, 0x3E, 0x3E, 0x3E,
    0x33, 0x33, 0x3E, 0x3E,
    0x33, 0x33, 0x33, 0x3E,
    0x34, 0x35, 0x35, 0x36,
    0x34, 0x35, 0x36, 0x37,
    0x34, 0x36, 0x37, 0x38,
    0x34, 0x35, 0x37, 0x38,
    0x34, 0x35, 0x36, 0x38,
    0x34, 0x36, 0x37, 0x39,
    0x34, 0x36, 0x38, 0x39,
    0x34, 0x35, 0x38, 0x39,
    0x34, 0x35, 0x37, 0x39,
    0x34, 0x36, 0x38, 0x3A,
    0x34, 0x37, 0x39, 0x3A,
    0x34, 0x35, 0x39, 0x3A,
    0x34, 0x35, 0x37, 0x3A,
    0x34, 0x3A, 0x3A, 0x3A,
    0x34, 0x34, 0x3A, 0x3A,
    0x34, 0x34, 0x34, 0x3A,
    0x34, 0x37, 0x38, 0x3B,
    0x34, 0x37, 0x3A, 0x3B,
    0x34, 0x35, 0x3A, 0x3B,
    0x34, 0x35, 0x38, 0x3B,
    0x34, 0x37, 0x39, 0x3C,
    0x34, 0x38, 0x3A, 0x3C,
    0x34, 0x36, 0x3A, 0x3C,
    0x34, 0x36, 0x38, 0x3C,
    0x34, 0x3C, 0x3C, 0x3C,
    0x34, 0x34, 0x3C, 0x3C,
    0x34, 0x34, 0x34, 0x3C,
    0x34, 0x38, 0x3B, 0x3F,
    0x34, 0x39, 0x3D, 0x3F,
    0x34, 0x36, 0x3D, 0x3F,
    0x34, 0x36, 0x3A, 0x3F,
    0x34, 0x3F, 0x3F, 0x3F,
    0x34, 0x34, 0x3F, 0x3F,
    0x34, 0x34, 0x34, 0x3F,
    0x35, 0x36, 0x36, 0x37,
    0x35, 0x36, 0x37, 0x38,
    0x35, 0x37, 0x38, 0x39,
    0x35, 0x36, 0x38, 0x39,
    0x35, 0x36, 0x37, 0x39,
    0x35, 0x37, 0x38, 0x3A,
    0x35, 0x37, 0x39, 0x3A,
    0x35, 0x36, 0x39, 0x3A,
    0x35, 0x36, 0x38, 0x3A,
    0x35, 0x37, 0x39, 0x3B,
    0x35, 0x38, 0x3A, 0x3B,
    0x35, 0x36, 0x3A, 0x3B,
    0x35, 0x36, 0x38, 0x3B,
    0x35, 0x3B, 0x3B, 0x3B,
    0x35, 0x35, 0x3B, 0x3B,
    0x35, 0x35, 0x35, 0x3B,
    0x35, 0x38, 0x39, 0x3C,
    0x35, 0x38, 0x3B, 0x3C,
    0x35, 0x36, 0x3B, 0x3C,
    0x35, 0x36, 0x39, 0x3C,
    0x35, 0x38, 0x3A, 0x3D,
    0x35, 0x39, 0x3B, 0x3D,
    0x35, 0x37, 0x3B, 0x3D,
    0x35, 0x37, 0x39, 0x3D,
    0x35, 0x3D, 0x3D, 0x3D,
    0x35, 0x35, 0x3D, 0x3D,
    0x35, 0x35, 0x35, 0x3D,
    0x36, 0x37, 0x37, 0x38,
    0x36, 0x37, 0x38, 0x39,
    0x36, 0x38, 0x39, 0x3A,
    0x36, 0x37, 0x39, 0x3A,
    0x36, 0x37, 0x38, 0x3A,
    0x36, 0x38, 0x39, 0x3B,
    0x36, 0x38, 0x3A, 0x3B,
    0x36, 0x37, 0x3A, 0x3B,
    0x36, 0x37, 0x39, 0x3B,
    0x36, 0x38, 0x3A, 0x3C,
    0x36, 0x39, 0x3B, 0x3C,
    0x36, 0x37, 0x3B, 0x3C,
    0x36, 0x37, 0x39, 0x3C,
    0x36, 0x3C, 0x3C, 0x3C,
    0x36, 0x36, 0x3C, 0x3C,
    0x36, 0x36, 0x36, 0x3C,
    0x36, 0x39, 0x3A, 0x3D,
    0x36, 0x39, 0x3C, 0x3D,
    0x36, 0x37, 0x3C, 0x3D,
    0x36, 0x37, 0x3A, 0x3D,
    0x36, 0x39, 0x3B, 0x3E,
    0x36, 0x3A, 0x3C, 0x3E,
    0x36, 0x38, 0x3C, 0x3E,
    0x36, 0x38, 0x3A, 0x3E,
    0x36, 0x3E, 0x3E, 0x3E,
    0x36, 0x36, 0x3E, 0x3E,
    0x36, 0x36, 0x36, 0x3E,
    0x37, 0x38, 0x38, 0x39,
    0x37, 0x38, 0x39, 0x3A,
    0x37, 0x39, 0x3A, 0x3B,
    0x37, 0x38, 0x3A, 0x3B,
    0x37, 0x38, 0x39, 0x3B,
    0x37, 0x39, 0x3A, 0x3C,
    0x37, 0x39, 0x3B, 0x3C,
    0x37, 0x38, 0x3B, 0x3C,
    0x37, 0x38, 0x3A, 0x3C,
    0x37, 0x39, 0x3B, 0x3D,
    0x37, 0x3A, 0x3C, 0x3D,
    0x37, 0x38, 0x3C, 0x3D,
    0x37, 0x38, 0x3A, 0x3D,
    0x37, 0x3D, 0x3D, 0x3D,
    0x37, 0x37, 0x3D, 0x3D,
    0x37, 0x37, 0x37, 0x3D,
    0x37, 0x3A, 0x3B, 0x3E,
    0x37, 0x3A, 0x3D, 0x3E,
    0x37, 0x38, 0x3D, 0x3E,
    0x37, 0x38, 0x3B, 0x3E,
    0x37, 0x3A, 0x3C, 0x3F,
    0x37, 0x3B, 0x3D, 0x3F,
    0x37, 0x39, 0x3D, 0x3F,
    0x37, 0x39, 0x3B, 0x3F,
    0x37, 0x3F, 0x3F, 0x3F,
    0x37, 0x37, 0x3F, 0x3F,
    0x37, 0x37, 0x37, 0x3F,
    0x38, 0x39, 0x39, 0x3A,
    0x38, 0x39, 0x3A, 0x3B,
    0x38, 0x3A, 0x3B, 0x3C,
    0x38, 0x39, 0x3B, 0x3C,
    0x38, 0x39, 0x3A, 0x3C,
    0x38, 0x3A, 0x3B, 0x3D,
    0x38, 0x3A, 0x3C, 0x3D,
    0x38, 0x39, 0x3C, 0x3D,
    0x38, 0x39, 0x3B, 0x3D,
    0x38, 0x3A, 0x3C, 0x3E,
    0x38, 0x3B, 0x3D, 0x3E,
    0x38, 0x39, 0x3D, 0x3E,
    0x38, 0x39, 0x3B, 0x3E,
    0x38, 0x3E, 0x3E, 0x3E,
    0x38, 0x38, 0x3E, 0x3E,
    0x38, 0x38, 0x38, 0x3E,
    0x38, 0x3B, 0x3C, 0x3F,
    0x38, 0x3B, 0x3E, 0x3F,
    0x38, 0x39, 0x3E, 0x3F,
    0x38, 0x39, 0x3C, 0x3F,
    0x39, 0x3A, 0x3A, 0x3B,
    0x39, 0x3A, 0x3B, 0x3C,
    0x39, 0x3B, 0x3C, 0x3D,
    0x39, 0x3A, 0x3C, 0x3D,
    0x39, 0x3A, 0x3B, 0x3D,
    0x39, 0x3B, 0x3C, 0x3E,
    0x39, 0x3B, 0x3D, 0x3E,
    0x39, 0x3A, 0x3D, 0x3E,
    0x39, 0x3A, 0x3C, 0x3E,
    0x39, 0x3B, 0x3D, 0x3F,
    0x39, 0x3C, 0x3E, 0x3F,
    0x39, 0x3A, 0x3E, 0x3F,
    0x39, 0x3A, 0x3C, 0x3F,
    0x39, 0x3F, 0x3F, 0x3F,
    0x39, 0x39, 0x3F, 0x3F,
    0x39, 0x39, 0x39, 0x3F,
    0x3A, 0x3B, 0x3B, 0x3C,
    0x3A, 0x3B, 0x3C, 0x3D,
    0x3A, 0x3C, 0x3D, 0x3E,
    0x3A, 0x3B, 0x3D, 0x3E,
    0x3A, 0x3B, 0x3C, 0x3E,
    0x3A, 0x3C, 0x3D, 0x3F,
    0x3A, 0x3C, 0x3E, 0x3F,
    0x3A, 0x3B, 0x3E, 0x3F,
    0x3A, 0x3B, 0x3D, 0x3F,
    0x3B, 0x3C, 0x3C, 0x3D,
    0x3B, 0x3C, 0x3D, 0x3E,
    0x3B, 0x3D, 0x3E, 0x3F,
    0x3B, 0x3C, 0x3E, 0x3F,
    0x3B, 0x3C, 0x3D, 0x3F,
    0x3C, 0x3D, 0x3D, 0x3E,
    0x3C, 0x3D, 0x3E, 0x3F,
    0x3D, 0x3E, 0x3E, 0x3F
};

#endif // AVCODEC_ULTI_CB_H
