/* Copyright (c) 2002, Joerg Wunsch
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:

   * Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in
     the documentation and/or other materials provided with the
     distribution.
   * Neither the name of the copyright holders nor the names of
     contributors may be used to endorse or promote products derived
     from this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
  POSSIBILITY OF SUCH DAMAGE.
*/

/* $Id: sscanf.c,v 1.2 2005/08/17 14:00:56 joerg_wunsch Exp $ */

#include <limits.h>
#include <stdarg.h>
#include <stdio.h>

#include "stdio_private.h"

int
sscanf(const char *s, const char *fmt, ...)
{
	va_list ap;
	FILE f;
	int i;

	f.flags = __SRD | __SSTR;
	/*
	 * It is OK to discard the "const" qualifier here.  f.buf is
	 * non-const as in the generic case, this buffer is obtained
	 * by malloc().  In the scanf case however, the buffer is
	 * really only be read (by getc()), and as this our FILE f we
	 * be discarded upon exiting sscanf(), nobody will ever get
	 * a chance to get write access to it again.
	 */
	f.buf = (char *)s;
	va_start(ap, fmt);
	i = vfscanf(&f, fmt, ap);
	va_end(ap);

	return i;
}
