/* $Id: preserve.h 301 2006-10-16 12:35:00Z steve $ */
#ifndef AWFFULL_PRESERVE_H
#define AWFFULL_PRESERVE_H

extern void get_history(void);                  /* load history file        */
extern void put_history(void);                  /* save history file        */
extern int save_state(void);                    /* save run state           */
extern int restore_state(void);                 /* restore run state        */

extern int hist_month[12];                      /* arrays for monthly total */
extern int hist_year[12];
extern unsigned long hist_hit[12];              /* calculations: used to    */
extern unsigned long hist_files[12];            /* produce index.html       */
extern unsigned long hist_site[12];             /* these are read and saved */
extern double hist_xfer[12];                    /* in the history file      */
extern unsigned long hist_page[12];
extern unsigned long hist_visit[12];

extern int hist_fday[12];                       /* first/last day arrays    */
extern int hist_lday[12];

struct history {
    int year;                                   /* Year                                         */
    int month;                                  /* Which Month              */
    unsigned long hit;                          /* Number of Hits           */
    unsigned long file;                         /* Number of Files          */
    unsigned long site;                         /* Number of Sites          */
    double xfer;                                /* Volume Transferred       */
    unsigned long page;                         /* Number of Pages          */
    unsigned long visit;                        /* Number of Visits         */
    int fday;                                   /* First Day                */
    int lday;                                   /* Last Day                 */
};

extern struct history history_list[MAXHISTLEN]; /* Complete Array for the history */

#endif          /* AWFFULL_PRESERVE_H */
