/*
 * Decompiled with CFR 0.152.
 */
package nz.net.catalyst.lucene.testclient;

import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Random;
import nz.net.catalyst.lucene.testclient.StressClient;

public class StressControl {
    public static long startTime = 0L;
    public static int timeToRun = 5;
    public static int requestsPerSecond = 50;
    public static int thread_count = requestsPerSecond * timeToRun;
    public static int errorCount = 0;
    public static int threadCountDown = thread_count;
    public static long threadTime = 0L;
    public static String[] queries = new String[]{"QUERY\nApplication: sos\nRange-Field: DisplayStartDate\nRange-From: 2002-01-10\nRange-To: 2002-10-10\nQuery: ((Name:cat  ^1) AND (Teaser:free) OR (Details:(pharoah AND egypt AND river))) AND Cancelled:N\nLimit: 5\nEND"};

    public static void main(String[] args) throws Exception {
        StressControl sc = new StressControl();
        sc.go();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void go() {
        Object t;
        startTime = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss S");
        GregorianCalendar c = new GregorianCalendar();
        System.out.println("It has begun: " + sdf.format(c.getTime()));
        Random r = new Random();
        Thread[] threads = new Thread[thread_count];
        long tBefore = System.currentTimeMillis();
        int i = 0;
        while (i < thread_count) {
            int query_number = r.nextInt(queries.length);
            threads[i] = t = new Thread(new StressClient("T" + i, query_number, 0));
            ++i;
        }
        long tCreated = System.currentTimeMillis();
        t = this;
        synchronized (t) {
            try {
                int i2 = 0;
                while (i2 < thread_count) {
                    long delay = 1000L / (long)requestsPerSecond;
                    this.wait(delay);
                    threads[i2].start();
                    ++i2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        long tAfter = System.currentTimeMillis();
        System.out.println(" TIme taken to create threads: " + (tCreated - tBefore));
        System.out.println(" TIme taken to start threads:  " + (tAfter - tCreated));
    }

    public static void printStats() {
        System.out.println("============= STATISTICS ==============");
        System.out.println(" Time to run test over: " + timeToRun + "seconds.");
        System.out.println(" Requests per second:   " + requestsPerSecond);
        System.out.println(" Total Threads Spawned: " + thread_count);
        System.out.println(" ");
        System.out.println("Total Time:             " + (System.currentTimeMillis() - startTime));
        System.out.println("Average time:           " + threadTime / (long)thread_count);
        System.out.println("Throughput:             " + (double)thread_count * 1000.0 / (double)(System.currentTimeMillis() - startTime) + " (requests per second)");
        System.out.println("Error Count:             " + errorCount);
        System.out.println("============= STATISTICS ==============");
    }
}

