/*
 * Decompiled with CFR 0.152.
 */
package nz.net.catalyst.lucene.testclient;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;
import java.net.UnknownHostException;

public class SocketTestXMLStuff {
    public static void main(String[] args) throws Exception {
        String serverOutput;
        long tStart = System.currentTimeMillis();
        long tOpenedConnection = 9999L;
        long tAfterExecuting = 9999L;
        long tClosedConnection = 9999L;
        Socket echoSocket = null;
        PrintWriter out = null;
        BufferedReader in = null;
        try {
            echoSocket = new Socket("localhost", 22222);
            OutputStreamWriter echoOut = new OutputStreamWriter(echoSocket.getOutputStream(), "UTF-8");
            out = new PrintWriter((Writer)echoOut, true);
            in = new BufferedReader(new InputStreamReader(echoSocket.getInputStream(), "UTF-8"));
        }
        catch (UnknownHostException e) {
            System.err.println("Unknown Host Exception. Cannot resolve host.");
            System.exit(1);
        }
        catch (IOException e) {
            System.err.println("Couldn't get I/O for the connection.");
            System.exit(1);
        }
        tOpenedConnection = System.currentTimeMillis();
        String index = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?><LuceneIndexRequest><Application>stuff</Application><Serial>abc123</Serial><Fields><Field name=\"Id\" type=\"text\" indexed=\"true\" stored=\"true\" >04</Field><Field name=\"Name\" type=\"text\" indexed=\"true\" stored=\"true\" >cat</Field><Field name=\"Details\" type=\"text\" indexed=\"false\" stored=\"false\" >\u015d free</Field><Field name=\"Teaser\">\u2665\u9421\u1ecb\u0110jjjj</Field><Field name=\"Location\">10</Field><Field name=\"Category\">10</Field><Field name=\"DisplayStartDate\">2002-12-10</Field><Field name=\"SaleStartDate\">2002-12-10</Field><Field name=\"EndDate\">2002-12-25</Field><Field name=\"Cancelled\">N</Field><Field name=\"Date3\" type=\"date\" indexed=\"true\" stored=\"false\">2003-12-25</Field></Fields></LuceneIndexRequest>\n\n";
        String query = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?><LuceneQueryRequest><Application>stuff</Application><Serial>123abc</Serial><Query><![CDATA[   Id:04\n]]></Query><Return>Name Details</Return><Limit>3</Limit></LuceneQueryRequest>";
        String query_all = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?><LuceneQueryRequest><Application>stuff</Application><Limit>0</Limit></LuceneQueryRequest>";
        String query_with_defined_fields = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?><LuceneQueryRequest><Application>stuff</Application><Query><![CDATA[   Title:cat  \n]]></Query><Return>Title Date3</Return><Limit>3</Limit><Fields><Field name=\"Details\" type=\"text\" indexed=\"yes\" stored=\"false\" /><Field name=\"Date3\" type=\"date\" indexed=\"false\" stored=\"true\" /></Fields></LuceneQueryRequest>";
        String old = "QUERY\nApplication:sos\nQuery: Name:cat\nLimit:0\nEND\n";
        String query_test = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?><LuceneQueryRequest><Serial><![CDATA[12<\"3\u014aa&bc]]></Serial><Application>stuff</Application><Query default-field=\"Name\">cat</Query><Return>Name</Return><Limit>1</Limit><Sort limit=\"10\">RANK:desc</Sort></LuceneQueryRequest>";
        String command = query_with_defined_fields;
        System.out.println("===================================================");
        out.println(command);
        echoSocket.getOutputStream().write(command.getBytes("UTF-8"));
        out.println("\n");
        BufferedReader br = new BufferedReader(in);
        while ((serverOutput = br.readLine()) != null) {
            System.out.println(serverOutput);
        }
        if (serverOutput != null) {
            System.out.println(serverOutput);
        }
        br.close();
        tAfterExecuting = System.currentTimeMillis();
        out.close();
        in.close();
        echoSocket.close();
        tClosedConnection = System.currentTimeMillis();
        System.out.println("================= Time Statistics =================");
        System.out.println(" Opening Connection: " + (tOpenedConnection - tStart));
        System.out.println(" Executing:          " + (tAfterExecuting - tOpenedConnection));
        System.out.println(" Closing Connection: " + (tClosedConnection - tAfterExecuting));
    }
}

