#!/bin/bash

# Install debian package in repository..

PACKAGE=`head -n 1 debian/control | cut -f2 -d' '`
USER=${1:-"${DEBFULLNAME} <${DEBEMAIL}>"}
if [ "$USER" = "" -o "$USER" = " " -o "$USER" = " <>" ] ; then
  USER=`dpkg-parsechangelog | sed -n 's/^Maintainer: //p'`
fi
VERSION=`head -n 1 debian/changelog | cut -f2 -d\( | cut -f1 -d')' | cut -f1 -d-`

# Ensure we have a repository..
REPOSITORY="../debian-repository"
if [ ! -d "$REPOSITORY" ]; then
  mkdir $REPOSITORY
fi
cd $REPOSITORY

FILECNT=`ls ${PACKAGE}_* | wc -l`
if [ $FILECNT -gt 0 ]; then
  echo "removing old package files.."
  rm ./${PACKAGE}_*
fi
echo "installing new package files.."
cp ../debian-builds/${PACKAGE}/${PACKAGE}_${VERSION}* .

if [ -f override ]; then
  echo "using override file provided"
  OVERRIDE_FILE=override
else
  echo "no override file present"
  OVERRIDE_FILE=/dev/null
fi

echo "packaging sources ${PACKAGE}.."
dpkg-scansources . $OVERRIDE_FILE | gzip -9c > Sources.gz
echo "done."

echo "packaging binaries ${PACKAGE}.."
dpkg-scanpackages . $OVERRIDE_FILE | gzip -9c > Packages.gz
echo "done."

# ENDS