# Copyright (C) 2002-2003 Hewlett Packard
# Licensed under the GNU General Public License

# This is to be pulled into the API to define tests
# currently these only work for HP-UX

$GLOBAL_TEST{'FTP'}{'ftpusers'} = 
    sub { 
	# location of ftpusers file
	my $ftpusers = &getGlobal('FILE',"ftpusers");

	# list users that should be restricted inside of the ftpusers file
	my @restrictedUser = ("root","daemon","bin","sys","adm","uucp","lp","nuucp","hpdb","guest");
	
	# if the ftpusers file exists then
	if(-e $ftpusers) {
	    # check and see if each resticted user is in the file
	    foreach my $user (@restrictedUser) {
		if(! &B_match_line($ftpusers,"\^\\s\*$user\\s\*\$")) {
		    # if a user is missing ask the question.
		    return 0;
		}
	    }
	}
	else {
	    # if the file does not exists ask the question
	    return 0;
	}	

	# if all resticted users are present inside of the 
        # ftpusers file then don't ask the question.
	return 1;

    };

1;
