/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef ATOMICCOUNTER_H_
#define ATOMICCOUNTER_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "NonCopyable.h"
#include "AtomicOps.h"
#include "types.h"

class ACE_NULL_SYNCH;
class ACE_MT_SYNCH;

template<typename SYNCH> class AtomicCounter;


// MT version
template<>
class AtomicCounter<ACE_MT_SYNCH>
{
	DECLARE_NON_COPYABLE(AtomicCounter)
public:
	AtomicCounter(int32_t initial = 0) : m_counter(initial) {}
	
	int32_t operator+=(int32_t delta) {
		return AtomicOps::add(&m_counter, delta);
	}
	
	int32_t operator-=(int32_t delta) {
		return AtomicOps::add(&m_counter, -delta); 
	}
	
	int32_t operator++() { return *this += 1; }
	
	int32_t operator--() { return *this -= 1; }
	
	int32_t operator++(int) { return ++*this - 1; }
	
	int32_t operator--(int) { return --*this + 1; }
private:
	volatile int32_t m_counter;
};


// Non-MT version
template<>
class AtomicCounter<ACE_NULL_SYNCH>
{
	DECLARE_NON_COPYABLE(AtomicCounter)
public:
	AtomicCounter(int32_t initial = 0) : m_counter(initial) {}
	
	int32_t operator+=(int32_t delta) { return m_counter += delta; }
	
	int32_t operator-=(int32_t delta) { return m_counter -= delta; }
	
	int32_t operator++() { return ++m_counter; }
	
	int32_t operator--() { return --m_counter; }
	
	int32_t operator++(int) { return m_counter++; }
	
	int32_t operator--(int) { return m_counter--; }
private:
	int32_t m_counter;
};

#endif
