/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2004  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "DataChunk.h"
#include <cstdlib>

using namespace std;

std::auto_ptr<DataChunk>
DataChunk::resize(std::auto_ptr<DataChunk> chunk, size_t size)
{
	DataChunk* new_chunk = reinterpret_cast<DataChunk*>(
		realloc(chunk.release(), sizeof(DataChunk) + size)
	);
	new_chunk->m_dataSize = size;
	return auto_ptr<DataChunk>(new_chunk);
}

void*
DataChunk::operator new(size_t size, size_t data_size)
{
	return malloc(size + data_size);
}

void
DataChunk::operator delete(void* addr)
{
	return free(addr);
}
