/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "JsRuntime.h"
#include <ace/config-lite.h>
#include <ace/Singleton.h>
#include <ace/Synch.h>
#include <jsapi.h>
#include <new> // for std::bad_alloc

class JsRuntime::Holder : public JsRuntime
{
};


JsRuntime::JsRuntime()
{
	m_pRep = JS_NewRuntime(MEM_LIMIT);
	if (!m_pRep) {
		throw std::bad_alloc();
	}
	JS_SetGCParameter(m_pRep, JSGC_MAX_MALLOC_BYTES, GC_INTERVAL);
}

JsRuntime::~JsRuntime()
{
	JS_DestroyRuntime(m_pRep);
	JS_ShutDown();
}

JsRuntime*
JsRuntime::instance()
{
	return ACE_Singleton<Holder, ACE_Recursive_Thread_Mutex>::instance();
}
