/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "FilterGroupFlags.h"

void
FilterGroupFlags::set(FilterGroupTag const& group, std::string const& name)
{
	m_items.insert(Item(group, name));
}

void
FilterGroupFlags::clear(FilterGroupTag const& group, std::string const& name)
{
	m_items.erase(Item(group, name));
}

bool
FilterGroupFlags::isSet(FilterGroupTag const& group, std::string const& name) const
{
	return (m_items.find(Item(group, name)) != m_items.end());
}

bool
FilterGroupFlags::Item::operator<(Item const& rhs) const
{
	FilterGroupTag::EquivComp before;
	if (before(group, rhs.group)) {
		return true;
	} else if (before(rhs.group, group)) {
		return false;
	} else {
		return name < rhs.name;
	}
}
