/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "JsEnvProxy.h"
#include "JsEnvironment.h"
#include "BString.h"
#include "Debug.h"

JsEnvProxy::JsEnvProxy()
:	m_pageURL(BString())
{
}

JsEnvProxy::JsEnvProxy(JsEnvProxy const& other)
:	m_ptrEnv(other.m_ptrEnv),
	m_pageURL(BString())
{
}

JsEnvProxy::~JsEnvProxy()
{
}

void
JsEnvProxy::setPageURL(URI const& url)
{
	if (!m_ptrEnv) {
		m_pageURL = url;
	} else {
		DEBUGLOG2("Changing page URL on existing JsEnvironment?");
	}
}

void
JsEnvProxy::reset()
{
	if (m_ptrEnv) {
		m_ptrEnv.reset(0);
	} else {
		BString empty_str;
		URI(empty_str).swap(m_pageURL);
	}
}

JsEnvironment*
JsEnvProxy::access()
{
	if (!m_ptrEnv) {
		m_ptrEnv.reset(new JsEnvironment(m_pageURL));
		BString empty_str;
		URI(empty_str).swap(m_pageURL);
	}
	return m_ptrEnv.get();
}
