/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "ConfigErrorHandler.h"
#include "ConfError.h"
#include "Log.h"
#include "OperationLog.h"
#include "EncOps.h"
#include <sstream>
#include <string>

using namespace std;

namespace GtkGUI
{

ConfigErrorHandler::ConfigErrorHandler(Glib::ustring const& fname)
:	m_fileName(fname),
	m_numErrors(0),
	m_numWarnings(0)
{
}

bool
ConfigErrorHandler::handleError(ConfError const& err)
{
	if (err.getType() == err.T_ERROR) {
		++m_numErrors;
	} else {
		++m_numWarnings;
	}
	
	if (m_numErrors + m_numWarnings > MAX_ENTRIES) {
		if (m_numErrors + m_numWarnings == MAX_ENTRIES + 1) {
			reportMoreErrors();
		}
		return true; // let it continue
	}
	
	writeToLog(err);
	return true;
}

void
ConfigErrorHandler::writeToLog(ConfError const& err)
{
	ostringstream text;
	text << '[' << m_fileName.raw();
	if (err.getLine()) {
		text << ':' << err.getLine();
		if (err.getCol()) {
			text << ':' << err.getCol();
		}
	}
	text << "] " << EncOps::localeToUtf8(err.getMessage()).raw();
	Log* log = OperationLog::instance();
	log->appendRecord(
		text.str(),
		err.getType() == err.T_WARNING
		? log->getWarningStyle()
		: log->getErrorStyle()
	);
}

void
ConfigErrorHandler::reportMoreErrors()
{
	ostringstream text;
	text << '[' << m_fileName.raw() << "] More errors follow";
	Log* log = OperationLog::instance();
	log->appendRecord(text.str(), log->getWarningStyle());
}

} // namespace GtkGUI
