/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef DEBUGWINDOW_H_
#define DEBUGWINDOW_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "DebugLayout.h"
#include "AutoScrollingWindow.h"
#include "AbstractDebugAgent.h"
#include <ace/config-lite.h>
#include <ace/OS_NS_Thread.h>
#include <gtkmm/window.h>
#include <gtkmm/adjustment.h>
#include <gtkmm/spinbutton.h>
#include <gtkmm/treeview.h>
#include <gtkmm/treeiter.h>
#include <gtkmm/box.h>
#include <gtkmm/alignment.h>
#include <gtkmm/table.h>
#include <glibmm/refptr.h>
#include <string>

class SplittableBuffer;

namespace GtkGUI
{

class DebugWindow : public Gtk::Window
{
public:
	typedef AbstractDebugAgent::TrafficDirection TrafficDirection;
	typedef AbstractDebugAgent::HttpMessageType HttpMessageType;
	
	DebugWindow();
	
	virtual ~DebugWindow();
	
	void clientConnectionBegin(ACE_thread_t thread_id);
	
	void clientConnectionEnd(ACE_thread_t thread_id);
	
	void registerClientRequest(ACE_thread_t thread_id,
		int request_id, std::string request_url);
	
	void httpMessageBegin(
		ACE_thread_t thread_id, int request_id,
		HttpMessageType type, std::string const& headers);
	
	void httpMessageEnd(ACE_thread_t thread_id,
		HttpMessageType type, bool error);
	
	void logMessage(ACE_thread_t thread_id, std::string const& msg);
	
	void logTraffic(ACE_thread_t thread_id,
		SplittableBuffer& traf, TrafficDirection dir);
private:
	class RequestListModel;
	class Legend;
	
	void onTrackConnectionsChange();
	
	void onTrafficLimitChange();
	
	void onRequestSelectionChange();
	
	void removeRequestFromList(Gtk::TreeIter const& iter);
	
	void selectRequestFromList(Gtk::TreeIter const& iter);
	
	static bool listIteratorsEqual(
		Gtk::TreeIter const& one, Gtk::TreeIter const& other);
	
	DebugLayout m_layout;
	Gtk::Adjustment m_connectionsAdj;
	Gtk::Adjustment m_trafficLimitAdj;
	Gtk::SpinButton m_connectionsSB;
	Gtk::SpinButton m_trafficLimitSB;
	Glib::RefPtr<RequestListModel> m_ptrRequestListModel;
	Gtk::TreeView m_requestList;
	Gtk::TreeIter m_lastSelection;
	Gtk::VBox m_vbox1;
	Gtk::HBox m_hbox1;
	Gtk::VBox m_vbox2;
	Gtk::Table m_table1;
	Gtk::Alignment m_table1Alignment;
	Gtk::Alignment m_legendAlignment;
	AutoScrollingWindow m_layoutScrollWnd;
	AutoScrollingWindow m_requestListScrollWnd;
};

} // namespace GtkGUI

#endif
