/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Date.h"
#include "BString.h"
#include "types.h"
#include <boost/test/auto_unit_test.hpp>
#include <time.h>
#include <stdlib.h>

static bool check_time(time_t time, Date::Style style)
{
	BString const formatted(Date::format(time, style));
	if (formatted.empty()) {
		// Windows doesn't support negative timestamps and timestamps
		// higher than a certain value.
		return true;
	}
	return Date::parse(formatted) == time;
}

BOOST_AUTO_UNIT_TEST(test)
{
	srand(0);
	
	BOOST_REQUIRE(Date::format(0, Date::RFC822) == BString("Thu, 01 Jan 1970 00:00:00 GMT"));
	BOOST_REQUIRE(Date::format(0, Date::RFC850) == BString("Thursday, 01-Jan-70 00:00:00 GMT"));
	BOOST_REQUIRE(Date::format(0, Date::ASCTIME) == BString("Thu Jan  1 00:00:00 1970"));
	
	time_t const low = Date::parse(BString("Sat, 14 Dec 1901 00:00:00 GMT"));
	time_t const y2k = Date::parse(BString("Thu, 01 Jan 2000 00:00:00 GMT"));
	
	for (int i = 0; i < 1000; ++i) {
		time_t const time = rand() - rand();
		BOOST_REQUIRE(check_time(time, Date::RFC822));
		BOOST_REQUIRE(check_time(time, Date::ASCTIME));
		if (time >= low && time < y2k) {
			BOOST_REQUIRE(check_time(time, Date::RFC850));
		}
	}
	
	if (sizeof(time_t) > 4) {
		// Ensure these don't crash.
		// See: http://www.securiteam.com/windowsntfocus/5MP0D0UKKO.html
		Date::format(static_cast<time_t>(INT64_C(0x793406fff)), Date::RFC822);
		Date::format(static_cast<time_t>(INT64_C(0x793406fff) + 1), Date::RFC822);
	}
}
