/*=====================================================================*/
/*    .../project/bigloo/api/ssl/src/Java/ssl_client_socket.java       */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Fri Jul  8 11:11:03 2005                          */
/*    Last change :  Thu Mar  2 15:28:56 2006 (serrano)                */
/*    Copyright   :  2005-06 Manuel Serrano                            */
/*    -------------------------------------------------------------    */
/*    SSL Java socket                                                  */
/*=====================================================================*/

package bigloo.ssl;
import bigloo.*;
import java.io.*;
import java.net.*;
import javax.net.ssl.*;

public class ssl_client_socket extends client_socket {
   public ssl_client_socket( final byte[] hostname,
			     final int port,
			     final boolean block,
			     final int ms ) {
      super();
      
      try {
	 SSLSocketFactory sslsocketfactory = (SSLSocketFactory) SSLSocketFactory.getDefault();
	 SSLSocket sslsocket = (SSLSocket)sslsocketfactory.createSocket( new String( hostname ), port );
      
	 blocking = block;
	 socket = sslsocket;

	 set_socket_io_ports( socket, blocking );
      }
      catch( final IOException _ ) {
	 socket_error( "make-ssl-client-socket",
		       "cannot create socket",
		       unspecified.unspecified );
      }
   }
}


   
