// ShellExt.h : Declaration of the CShellExt

#ifndef __SHELLEXT_H_
#define __SHELLEXT_H_

// {EAB841A0-9550-11cf-8C16-00805F1408F3}

#include "resource.h"       // main symbols

#include <shlobj.h>
#include <comdef.h>
#include <string>
#include <vector>

using namespace std;

/////////////////////////////////////////////////////////////////////////////
// CShellExt
class ATL_NO_VTABLE CShellExt : 
	public CComObjectRootEx<CComSingleThreadModel>,
	public CComCoClass<CShellExt, &CLSID_ShellExt>,
	public IDispatchImpl<IShellExt, &IID_IShellExt, &LIBID_BCSHELLEXTLib>,
    public IShellExtInit,
    public IContextMenu
{
public:
	CShellExt()
	{
	}

protected:

    vector<string> oFileList;
    void AnalyzeFiles(void);

public:
    // IShellExtInit
    STDMETHOD(Initialize)(LPCITEMIDLIST, LPDATAOBJECT, HKEY);

    // IContextMenu
    STDMETHOD(GetCommandString)(UINT, UINT, UINT*, LPSTR, UINT);
    STDMETHOD(InvokeCommand)(LPCMINVOKECOMMANDINFO);
    STDMETHOD(QueryContextMenu)(HMENU, UINT, UINT, UINT, UINT);

DECLARE_REGISTRY_RESOURCEID(IDR_SHELLEXT)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CShellExt)
	COM_INTERFACE_ENTRY(IShellExt)
	COM_INTERFACE_ENTRY(IDispatch)
    COM_INTERFACE_ENTRY(IShellExtInit)
    COM_INTERFACE_ENTRY(IContextMenu)
END_COM_MAP()

// IShellExt
public:
};

#endif //__SHELLEXT_H_
