/***************************************************************************
 *   Copyright (C) 2005-2006 Gao Xianchao                                  *
 *                 2007 Gao Xianchao gnap_an linux_lyb ahlongxp            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/*
 * Author:	gxc
 * Create data:	2005-10-12 20:09
 */

#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include "Socket.h"

CSocket::CSocket()
: _reactor(NULL)
, _handle(-1)
, _maskRead(false)
, _maskWrite(false)
, _inReactor(false)
{
}

CSocket::~CSocket()
{
	close();
}

void CSocket::setReactor(ISocketReactor* reactor)
{
	if(_reactor != NULL)
	{
		if(_inReactor)
		{
			_reactor->removeSocket(this);
			_inReactor = false;
		}
		_reactor = NULL;
	}
	
	if(reactor != NULL)
	{
		_reactor = reactor;
		_reactor->addSocket(this);
		_inReactor = true;
	}
}

ISocketReactor* CSocket::getReactor()
{
	return _reactor;
}

void CSocket::createTCPSocket()
{
	close();
	_handle = socket(AF_INET, SOCK_STREAM, 0);
	setNonBlock();
}

void CSocket::createUDPSocket()
{
	close();
	_handle = socket(AF_INET, SOCK_DGRAM, 0);
	setNonBlock();
}

void CSocket::close()
{
	if(_handle != -1)
	{
		::close(_handle);
		_handle = -1;
	}
}

void CSocket::attach(int fd)
{
	close();
	_handle = fd;
	setNonBlock();
}

int CSocket::getHandle()
{
	return _handle;
}

bool CSocket::bind(const char* ip, unsigned short port)
{
	struct sockaddr_in addr;
	memset(&addr, 0, sizeof(addr));

	addr.sin_family = AF_INET;
	
	if(ip != NULL)
	{
		addr.sin_addr.s_addr = inet_addr(ip);
	}
	else
	{
		
	}
	addr.sin_port = htons(port);

	return 0 == ::bind(_handle, (const sockaddr*)&addr, (socklen_t)(sizeof(addr)));	
}

void CSocket::listen()
{
	::listen(_handle, 5);
}

void CSocket::connect(const char* ip, unsigned short port)
{
	struct sockaddr_in addr;
	memset(&addr, 0, sizeof(addr));

	addr.sin_family = AF_INET;
	addr.sin_addr.s_addr = inet_addr(ip);
	addr.sin_port = htons(port);

	::connect(_handle, (const sockaddr*)&addr, (socklen_t)(sizeof(addr)));	
}

int CSocket::accept(std::string& ip, unsigned short& port)
{
	struct sockaddr_in addr;
	socklen_t len = (socklen_t)(sizeof(addr));
	memset(&addr, 0, sizeof(addr));
		
	int fd = ::accept(_handle, (struct sockaddr*)&addr, &len);
	if(fd != -1)
	{
		ip = inet_ntoa(addr.sin_addr);
		port = ntohs(addr.sin_port);
	}
	
	return fd;
}
	
void CSocket::maskRead(bool mask)
{
	_maskRead = mask;
	
	if(_reactor != NULL
		&& _inReactor)
	{
		_reactor->updateMask(this);
	}	
}

void CSocket::maskWrite(bool mask)
{
	_maskWrite = mask;
	
	if(_reactor != NULL
		&& _inReactor)
	{
		_reactor->updateMask(this);
	}	
}

bool CSocket::maskRead()
{
	return _maskRead;
}

bool CSocket::maskWrite()
{
	return _maskWrite;
}

void CSocket::setNonBlock()
{
	int flags = fcntl(_handle, F_GETFL, 0);
	fcntl(_handle, F_SETFL, flags | O_NONBLOCK);
}
