// Author: Jose M. Vidal
// $Id: iwebstream.H,v 1.6 2002/04/02 19:02:22 jmvidal Exp $
// This code is copyright of Jose M. Vidal and released under
// the GNU General Public License
//
// A class thats is meant to look like an istream, regardless of
//  whether it opens a local file or an http object.
//  Sometime later I might also add ftp.
//
#ifndef IWEBSTREAM_H
#define IWEBSTREAM_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <cctype>
//#include <ctime>
#include <sys/time.h>
#include <sys/socket.h>
#include <string>
#include <iostream>

// Objects of the http class can connect to WWW servers and get pages from
// those servers

using namespace std;

class iwebstream {
private:
  int socketDesc; // socket descriptor used in system calls
  fd_set read_map; // selects socket descriptors that are ready for reading
  struct timeval tval; // timeout for reading
  int defaultTimeout; // default value of tval
  string data; //the contents of the file
  unsigned int position; //the current position on data
  string http_proxy; // hostname of the HTTP proxy to be used
  int http_proxy_port; // port number of the HTTP proxy to be used
  string http_proxy_user; // user name for the HTTP proxy
  string http_proxy_password; // password for the HTTP proxy

  void readFile(string & filename);
  int connect(string hostName, unsigned short int port, int timeOut);
  int get(const string hostname, const string port, const string path, string& pageContents);
  unsigned int findNC(const string & s, unsigned int p);
	void init(const string& url);
	void string2base64Helper(unsigned char *, unsigned char *);
	string string2base64(const string&);

public:
  iwebstream(string url, int timeout = 30);
	iwebstream(const string& url, const string& proxy, int proxy_port, const string& proxy_user, const string& proxy_passwd, int timeout = 30);
  iwebstream & operator>>(long int & t);
  iwebstream & operator>>(int & t);
  iwebstream & operator>>(string & s);
  string getData() {
    return data;
  }
  char get();
  void putback(char & c);
  void getline(string & s);
  bool eof();
  void close(){};
  bool operator==(int x);
  bool operator!=(int x) {
    return !operator==(x);};

  //find the next occurance of s, set position to point to it
  bool iwebstream::find(const string & s);
  //find the next occurance of s, set position to point past it
  bool iwebstream::findAndPass(const string & s);

  //return whatever is between the next begin & end. If begin is not found,
  // return ""
  string findTag(const string & begin, const string & end, const string & after = "",
		 const string & before = "");
};

#endif // IWEBSTREAM_H
