/*
*
*  A2DPD - Bluetooth A2DP daemon for Linux
*
*  Copyright (C) 2006-2007  Frédéric DALLEAU <frederic.dalleau@palmsource.com>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
#include <bluetooth/bluetooth.h>
#include <bluetooth/rfcomm.h>
#include <bluetooth/l2cap.h>
#include <bluetooth/sdp.h>
#include <bluetooth/sdp_lib.h>

#include "a2dpd_protocol.h"

static sdp_session_t* g_sdpSessionP = NULL;
static sdp_record_t* g_recordA2DP = NULL;
static sdp_record_t* g_recordAVRTG = NULL;


// Straight from sdptool source with minor mods!
static sdp_record_t* add_avrtg(sdp_session_t *session)
{
	sdp_list_t *svclass_id, *pfseq, *apseq, *root;
	uuid_t root_uuid, l2cap, avctp, avrtg;
	sdp_profile_desc_t profile[1];
	sdp_list_t *aproto, *proto[2];
	sdp_record_t* record;
	sdp_data_t *psm, *version, *features;
	uint16_t lp = 0x0017, ver = 0x0100, feat = 0x000f;
	int ret = 0;

	DBG("");
	record = sdp_record_alloc();

	if(!record)
		return NULL;

	sdp_uuid16_create(&root_uuid, PUBLIC_BROWSE_GROUP);
	root = sdp_list_append(0, &root_uuid);
	sdp_set_browse_groups(record, root);

	sdp_uuid16_create(&avrtg, AV_REMOTE_TARGET_SVCLASS_ID);
	svclass_id = sdp_list_append(0, &avrtg);
	sdp_set_service_classes(record, svclass_id);

	sdp_uuid16_create(&profile[0].uuid, AV_REMOTE_PROFILE_ID);
	profile[0].version = 0x0100;
	pfseq = sdp_list_append(0, &profile[0]);
	sdp_set_profile_descs(record, pfseq);

	sdp_uuid16_create(&l2cap, L2CAP_UUID);
	proto[0] = sdp_list_append(0, &l2cap);
	psm = sdp_data_alloc(SDP_UINT16, &lp);
	proto[0] = sdp_list_append(proto[0], psm);
	apseq = sdp_list_append(0, proto[0]);

	sdp_uuid16_create(&avctp, AVCTP_UUID);
	proto[1] = sdp_list_append(0, &avctp);
	version = sdp_data_alloc(SDP_UINT16, &ver);
	proto[1] = sdp_list_append(proto[1], version);
	apseq = sdp_list_append(apseq, proto[1]);

	aproto = sdp_list_append(0, apseq);
	sdp_set_access_protos(record, aproto);

	features = sdp_data_alloc(SDP_UINT16, &feat);
	sdp_attr_add(record, SDP_ATTR_SUPPORTED_FEATURES, features);

	sdp_set_info_attr(record, "AVRCP TG", 0, 0);

	ret = sdp_record_register(session, record, 0);
	if (ret < 0) {
		DBG("Service Record registration failed");
		sdp_record_free(record);
		record = NULL;
	}

	sdp_list_free(proto[0], 0);
	sdp_list_free(proto[1], 0);
	sdp_list_free(apseq, 0);
	sdp_list_free(aproto, 0);
	sdp_list_free(root, 0);
	sdp_list_free(pfseq, 0);
	sdp_list_free(svclass_id, 0);
	sdp_data_free(psm);
	sdp_data_free(version);

	return record;
}

// Straight from sdptool source with minor mods!
static sdp_record_t* add_a2source(sdp_session_t *session)
{
	sdp_list_t *svclass_id, *pfseq, *apseq, *root;
	uuid_t root_uuid, l2cap, avdtp, a2src;
	sdp_profile_desc_t profile[1];
	sdp_list_t *aproto, *proto[2];
	sdp_record_t* record;
	sdp_data_t *psm, *version;
	uint16_t lp = 0x0019, ver = 0x0100;
	int ret = 0;

	DBG("");
	record = sdp_record_alloc();

	if(!record)
		return NULL;

	sdp_uuid16_create(&root_uuid, PUBLIC_BROWSE_GROUP);
	root = sdp_list_append(0, &root_uuid);
	sdp_set_browse_groups(record, root);

	sdp_uuid16_create(&a2src, AUDIO_SOURCE_SVCLASS_ID);
	svclass_id = sdp_list_append(0, &a2src);
	sdp_set_service_classes(record, svclass_id);

	sdp_uuid16_create(&profile[0].uuid, ADVANCED_AUDIO_PROFILE_ID);
	profile[0].version = 0x0100;
	pfseq = sdp_list_append(0, &profile[0]);
	sdp_set_profile_descs(record, pfseq);

	sdp_uuid16_create(&l2cap, L2CAP_UUID);
	proto[0] = sdp_list_append(0, &l2cap);
	psm = sdp_data_alloc(SDP_UINT16, &lp);
	proto[0] = sdp_list_append(proto[0], psm);
	apseq = sdp_list_append(0, proto[0]);

	sdp_uuid16_create(&avdtp, AVDTP_UUID);
	proto[1] = sdp_list_append(0, &avdtp);
	version = sdp_data_alloc(SDP_UINT16, &ver);
	proto[1] = sdp_list_append(proto[1], version);
	apseq = sdp_list_append(apseq, proto[1]);

	aproto = sdp_list_append(0, apseq);
	sdp_set_access_protos(record, aproto);

	sdp_set_info_attr(record, "Audio Source", 0, 0);

	ret = sdp_record_register(session, record, 0);

	if(ret < 0) {
		DBG("Service Record registration failed");
		sdp_record_free(record);
		record = NULL;
	}
	sdp_list_free(proto[0], 0);
	sdp_list_free(proto[1], 0);
	sdp_list_free(apseq, 0);
	sdp_list_free(aproto, 0);
	sdp_list_free(root, 0);
	sdp_list_free(pfseq, 0);
	sdp_list_free(svclass_id, 0);
	sdp_data_free(psm);
	sdp_data_free(version);

	return record;
}

void a2dpd_register_sdp()
{
	DBG("Start");

	// Start sdp advertising
	g_sdpSessionP = sdp_connect(BDADDR_ANY, BDADDR_LOCAL, SDP_RETRY_IF_BUSY);
	if(!g_sdpSessionP) {
		DBG("SDPD not running");
		return;
	}
	g_recordAVRTG = add_avrtg   (g_sdpSessionP);
	g_recordA2DP = add_a2source(g_sdpSessionP);
	DBG("OK");
}

void a2dpd_unregister_sdp()
{
	DBG("Start");
	if(g_sdpSessionP) {

		if(g_recordA2DP)
			sdp_record_unregister(g_sdpSessionP, g_recordA2DP);

		if(g_recordAVRTG)
			sdp_record_unregister(g_sdpSessionP, g_recordAVRTG);

		(void) sdp_close(g_sdpSessionP);
		g_sdpSessionP = NULL;
	}
	DBG("OK");
}

