/*
** font.h -- font table declarations used by fontutil.c and console.c
**
** Font file layout:
**   header
**     short version #
**     short # chars
**     byte width
**     byte length
**   characters
**     character number (if text)
**     one line/byte for each row
*/

#define	VERSION		1		/* version number */

#define	MAP_SIZE	512		/* # chars in map */
#define	ROM_MAP_SIZE	256		/* # chars in ROM map */
#define	CELL_WID	8		/* width of cell in bits */
#define	CELL_LEN	16		/* # bytes/lines per char */

typedef struct {
	short font_version;		/* version number */
	short font_num_chars;		/* number of charactes in font */
	char font_width;		/* cell width */
	char font_length;		/* cell height */
} font_header;

