// ChannelList.C  -*- C++ -*-
// Copyright (c) 1997, 1998 Etienne BERNARD

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "ChannelList.H"
#ifdef USESCRIPTS
#include "Interp.H"
#endif

ChannelList::ChannelList()
{
#ifdef HAVE_STL_CLEAR
  list.clear();
#endif
}

ChannelList::~ChannelList()
{
  Channel *c;
  map<String, Channel *, less<String> >::iterator it;

  while (list.size()!=0) {
    it = list.begin();
    c = (*it).second;
    list.erase(it);
    delete c;
  }
}

void
ChannelList::addChannel(ServerConnection *cnx, String name, String wantedModes = "")
{
  name = name.toLower();
  list[name] = new Channel(cnx, name, wantedModes);
}

void
ChannelList::delChannel(String name)
{
  name = name.toLower();
  Channel *c = list[name];
  if (c != 0) {
    list.erase(name);
    delete c;
  }
}

Channel *
ChannelList::getChannel(String name)
{
  name = name.toLower();
  Channel *c = list[name];

  if (c)
    return c;

  list.erase(name);
  return 0;
}

void
ChannelList::clear()
{
  Channel *c;
  map<String, Channel *, less<String> >::iterator it;

  while (list.size() != 0) {
    it = list.begin();
    c = (*it).second;
    list.erase(it);
    delete c;
  }
}
