// Person.H  -*- C++ -*-
// Copyright (c) 1998 Etienne BERNARD

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef PERSON_H
#define PERSON_H

#include "String.H"

class Bot;

class Person {
protected:
  Bot *bot;
  String address;
public:
  Person(Bot *, String = "");
  Person(Person &);

  virtual ~Person() { }

  virtual Person * copy();

  String getNick() const;
  String getAddress() const;

  virtual void keepAlive() { }

  virtual void sendNotice(String);

  Person & operator=(const String &);
};

#endif
