#region license
// Copyright (c) 2003, 2004, 2005 Rodrigo B. de Oliveira (rbo@acm.org)
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
// 
//     * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//     * Neither the name of Rodrigo B. de Oliveira nor the names of its
//     contributors may be used to endorse or promote products derived from this
//     software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#endregion

//
// DO NOT EDIT THIS FILE!
//
// This file was generated automatically by astgen.boo.
//
namespace Boo.Lang.Compiler.Ast
{	
	using System.Collections;
	using System.Runtime.Serialization;
	
	[System.Serializable]
	public partial class Import : Node
	{
		protected string _namespace;

		protected ReferenceExpression _assemblyReference;

		protected ReferenceExpression _alias;

	
		new public Import CloneNode()
		{
			return Clone() as Import;
		}
		override public NodeType NodeType
		{
			get
			{
				return NodeType.Import;
			}
		}
		
		override public void Accept(IAstVisitor visitor)
		{
			visitor.OnImport(this);
		}
		override public bool Matches(Node node)
		{	
			Import other = node as Import;
			if (null == other) return false;
			if (_namespace != other._namespace) return NoMatch("Import._namespace");
			if (!Node.Matches(_assemblyReference, other._assemblyReference)) return NoMatch("Import._assemblyReference");
			if (!Node.Matches(_alias, other._alias)) return NoMatch("Import._alias");
			return true;
		}
	
		override public bool Replace(Node existing, Node newNode)
		{
			if (base.Replace(existing, newNode))
			{
				return true;
			}
			if (_assemblyReference == existing)
			{
				this.AssemblyReference = (ReferenceExpression)newNode;
				return true;
			}
			if (_alias == existing)
			{
				this.Alias = (ReferenceExpression)newNode;
				return true;
			}
			return false;
		}
		
		override public object Clone()
		{
			Import clone = (Import)FormatterServices.GetUninitializedObject(typeof(Import));
			clone._lexicalInfo = _lexicalInfo;
			clone._endSourceLocation = _endSourceLocation;
			clone._documentation = _documentation;
			if (_annotations != null) clone._annotations = (Hashtable)_annotations.Clone();
		
			clone._namespace = _namespace;
			if (null != _assemblyReference)
			{
				clone._assemblyReference = _assemblyReference.Clone() as ReferenceExpression;
				clone._assemblyReference.InitializeParent(clone);
			}
			if (null != _alias)
			{
				clone._alias = _alias.Clone() as ReferenceExpression;
				clone._alias.InitializeParent(clone);
			}
			return clone;
		}
		
		override internal void ClearTypeSystemBindings()
		{
			_annotations = null;
			if (null != _assemblyReference)
			{
				_assemblyReference.ClearTypeSystemBindings();
			}
			if (null != _alias)
			{
				_alias.ClearTypeSystemBindings();
			}

		}
	

		[System.Xml.Serialization.XmlElement]
		public string Namespace
		{
			get
			{

				return _namespace;
			}

			set
			{
				_namespace = value;
			}

		}
		

		[System.Xml.Serialization.XmlElement]
		public ReferenceExpression AssemblyReference
		{
			get
			{

				return _assemblyReference;
			}

			set
			{
				if (_assemblyReference != value)
				{
					_assemblyReference = value;
					if (null != _assemblyReference)
					{
						_assemblyReference.InitializeParent(this);
					}
				}
			}

		}
		

		[System.Xml.Serialization.XmlElement]
		public ReferenceExpression Alias
		{
			get
			{

				return _alias;
			}

			set
			{
				if (_alias != value)
				{
					_alias = value;
					if (null != _alias)
					{
						_alias.InitializeParent(this);
					}
				}
			}

		}
		

	}
}

