/***************************************************************************
                          browserlist.cpp  -  description
                             -------------------
    begin                : Sat Nov 16 2002
    copyright            : (C) 2002 by Ken Schenke
    email                : kschenke at users dot sourceforge dot net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU      *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software           *
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA         *
 *   02110-1301, USA                                                       *
 *                                                                         *
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This is a place-holder for the BrowserList[] global array.  This      *
 *   contains information about each browser supported by BookmarkBridge.  *
 *                                                                         *
 ***************************************************************************/

#include "browserlist.h"
#include "bknode.h"
#include "iexplore.h"
#include "mozilla.h"
#include "opera.h"
#include "firebird.h"
#include "konqueror.h"

/***************************************************************************
 *                                                                         *
 *   IT IS VERY IMPORTANT TO NEVER REMOVE ELEMENTS FROM THIS LIST ! ! !    *
 *                                                                         *
 *   An element's position in this list determines its BRWSTYPE value.     *
 *   This value is saved in configuration files and used to figure out     *
 *   which browser class to use.                                           *
 *                                                                         *
 ***************************************************************************/

BROWSERLIST BrowserList[] = {
	{
		"Internet Explorer",
		IExplore::classFactory,
		IExplore::saveBookmarks
	},{
		"Mozilla Suite",
		Mozilla::classFactory,
		Mozilla::saveBookmarks
	},{
		"Opera",
		Opera::classFactory,
		Opera::saveBookmarks
	},{
		"Firefox",
		Firebird::classFactory,
		Firebird::saveBookmarks
	},{
		"Konqueror",
		Konqueror::classFactory,
		Konqueror::saveBookmarks
	},{
		NULL,
		NULL,
		NULL
	}
};
