#include "config.h"
/* A lexical scanner generated by flex */

/* Scanner skeleton version:
 * $Header: /home/daffy/u0/vern/flex/RCS/flex.skl,v 2.89 96/05/25 21:02:21 vern Exp $
 */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5

#include <stdio.h>


/* cfront 1.2 defines "c_plusplus" instead of "__cplusplus" */
#ifdef c_plusplus
#ifndef __cplusplus
#define __cplusplus
#endif
#endif


#ifdef __cplusplus

#include <stdlib.h>
#include <unistd.h>

/* Use prototypes in function declarations. */
#define YY_USE_PROTOS

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

#if __STDC__

#define YY_USE_PROTOS
#define YY_USE_CONST

#endif	/* __STDC__ */
#endif	/* ! __cplusplus */

#ifdef __TURBOC__
 #pragma warn -rch
 #pragma warn -use
#include <io.h>
#include <stdlib.h>
#define YY_USE_CONST
#define YY_USE_PROTOS
#endif

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif


#ifdef YY_USE_PROTOS
#define YY_PROTO(proto) proto
#else
#define YY_PROTO(proto) ()
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN yy_start = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START ((yy_start - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart( yyin )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#define YY_BUF_SIZE 16384

typedef struct yy_buffer_state *YY_BUFFER_STATE;

extern int yyleng;
extern FILE *yyin, *yyout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

/* The funky do-while in the following #define is used to turn the definition
 * int a single C statement (which needs a semi-colon terminator).  This
 * avoids problems with code like:
 *
 * 	if ( condition_holds )
 *		yyless( 5 );
 *	else
 *		do_something_else();
 *
 * Prior to using the do-while the compiler would get upset at the
 * "else" because it interpreted the "if" statement as being all
 * done when it reached the ';' after the yyless() call.
 */

/* Return all but the first 'n' matched characters back to the input stream. */

#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
		*yy_cp = yy_hold_char; \
		YY_RESTORE_YY_MORE_OFFSET \
		yy_c_buf_p = yy_cp = yy_bp + n - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, yytext_ptr )

/* The following is because we cannot portably get our hands on size_t
 * (without autoconf's help, which isn't available because we want
 * flex-generated scanners to compile on their own).
 */
typedef unsigned int yy_size_t;


struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;
#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2
	};

static YY_BUFFER_STATE yy_current_buffer = 0;

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 */
#define YY_CURRENT_BUFFER yy_current_buffer


/* yy_hold_char holds the character lost when yytext is formed. */
static char yy_hold_char;

static int yy_n_chars;		/* number of characters read into yy_ch_buf */


int yyleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = (char *) 0;
static int yy_init = 1;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void yyrestart YY_PROTO(( FILE *input_file ));

void yy_switch_to_buffer YY_PROTO(( YY_BUFFER_STATE new_buffer ));
void yy_load_buffer_state YY_PROTO(( void ));
YY_BUFFER_STATE yy_create_buffer YY_PROTO(( FILE *file, int size ));
void yy_delete_buffer YY_PROTO(( YY_BUFFER_STATE b ));
void yy_init_buffer YY_PROTO(( YY_BUFFER_STATE b, FILE *file ));
void yy_flush_buffer YY_PROTO(( YY_BUFFER_STATE b ));
#define YY_FLUSH_BUFFER yy_flush_buffer( yy_current_buffer )

YY_BUFFER_STATE yy_scan_buffer YY_PROTO(( char *base, yy_size_t size ));
YY_BUFFER_STATE yy_scan_string YY_PROTO(( yyconst char *str ));
YY_BUFFER_STATE yy_scan_bytes YY_PROTO(( yyconst char *bytes, int len ));

static void *yy_flex_alloc YY_PROTO(( yy_size_t ));
static void *yy_flex_realloc YY_PROTO(( void *, yy_size_t ));
static void yy_flex_free YY_PROTO(( void * ));

#define yy_new_buffer yy_create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! yy_current_buffer ) \
		yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE ); \
	yy_current_buffer->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! yy_current_buffer ) \
		yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE ); \
	yy_current_buffer->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (yy_current_buffer->yy_at_bol)


#define YY_USES_REJECT

#define yywrap() 1
#define YY_SKIP_YYWRAP
typedef unsigned char YY_CHAR;
FILE *yyin = (FILE *) 0, *yyout = (FILE *) 0;
typedef int yy_state_type;
extern char *yytext;
#define yytext_ptr yytext

static yy_state_type yy_get_previous_state YY_PROTO(( void ));
static yy_state_type yy_try_NUL_trans YY_PROTO(( yy_state_type current_state ));
static int yy_get_next_buffer YY_PROTO(( void ));
static void yy_fatal_error YY_PROTO(( yyconst char msg[] ));

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	yytext_ptr = yy_bp; \
	yytext_ptr -= yy_more_len; \
	yyleng = (int) (yy_cp - yytext_ptr); \
	yy_hold_char = *yy_cp; \
	*yy_cp = '\0'; \
	yy_c_buf_p = yy_cp;

#define YY_NUM_RULES 49
#define YY_END_OF_BUFFER 50
static yyconst short int yy_acclist[238] =
    {   0,
       50,   45,   49,    1,   45,   49,    2,   49,   45,   49,
       45,   49,   43,   45,   49,   45,   49,   42,   45,   49,
       41,   45,   49,   41,   45,   49,   41,   45,   49,   41,
       45,   49,   41,   45,   49,   41,   45,   49,   41,   45,
       49,   41,   45,   49,   41,   45,   49,   41,   45,   49,
       41,   45,   49,   41,   45,   49,   41,   45,   49,   41,
       45,   49,    8,   49,    6,   49,    8,   49,    8,   49,
       48,   49,   47,   49,   48,   49,    3,   49,    1,   49,
       27,   41,   45,   49,   23,   41,   45,   49,   31,   41,
       45,   49,   35,   41,   45,   49,   38,   43,   45,   49,

       37,   43,   45,   49,    4,   44,   42,   41,   41,   41,
       41,   41,   41,   41,   41,   41,   41,   41,   41,   41,
       41,   17,   41,   41,    3,   41,   41,   25,   41,   41,
       21,   41,   29,   41,   41,   33,   41,   41,   41,   41,
       12,   41,   41,   41,   41,   16,   41,   41,   41,   41,
       41,   41,   41,   41,   41,   41,   26,   41,   28,   41,
       24,   41,   22,   41,   30,   41,   32,   41,   36,   41,
       34,   41,   41,   41,   41,   41,   41,   41,   41,   20,
       41,   41,   41,   41,   41,   41,   41,   41,   18,   41,
       41,   41,   40,   41,   41,    9,   41,   41,   41,   41,

       41,   41,   41,   41,   41,    7,   46,   39,   41,   41,
       41,   41,   19,   41,   41,   41,   41,   41,   41,    5,
       41,   11,   41,   46,   41,   10,   41,   15,   41,   13,
       41,   14,   41,   41,   41,   40,   41
    } ;

static yyconst short int yy_accept[171] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    2,    4,    7,    9,   11,   13,   16,
       18,   21,   24,   27,   30,   33,   36,   39,   42,   45,
       48,   51,   54,   57,   60,   63,   65,   67,   69,   71,
       73,   75,   77,   79,   81,   85,   89,   93,   97,  101,
      105,  105,  106,  106,  107,  108,  109,  110,  111,  112,
      113,  114,  115,  116,  117,  118,  119,  120,  121,  122,
      124,  125,  125,  125,  125,  125,  126,  127,  128,  130,
      131,  133,  135,  136,  138,  139,  140,  141,  143,  144,
      145,  146,  148,  149,  150,  151,  152,  153,  154,  155,

      156,  157,  157,  157,  159,  161,  163,  165,  167,  169,
      171,  173,  174,  175,  176,  177,  178,  179,  180,  182,
      183,  184,  185,  186,  187,  188,  189,  191,  191,  191,
      192,  193,  195,  196,  196,  197,  198,  199,  200,  201,
      202,  203,  204,  205,  206,  206,  207,  208,  210,  211,
      212,  213,  215,  216,  217,  218,  219,  220,  222,  224,
      225,  226,  228,  230,  232,  234,  235,  236,  238,  238
    } ;

static yyconst int yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    4,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    5,    5,    6,    1,    5,    5,    5,    7,
        8,    5,    9,    7,   10,    5,    5,   11,   11,   11,
       11,   11,   11,   11,   11,   11,   11,    5,    5,    5,
        5,    5,    5,    5,   13,   14,   15,   16,   17,   18,
       19,   20,   21,   18,   18,   22,   23,   24,   25,   26,
       18,   27,   28,   29,   30,   31,   32,   33,   18,   18,
        1,    5,    1,    1,   12,    5,   13,   14,   15,   16,

       17,   18,   19,   20,   21,   18,   18,   22,   23,   24,
       25,   26,   18,   27,   28,   29,   30,   31,   32,   33,
       18,   18,    7,    5,   34,    5,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,   18,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,   18,    1,    1,    1,    1,    1,   18,
        1,    1,   12,    1,    1,    1,    1,   18,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,   18,    1,    1,    1,    1,
        1,   18,    1,    1,    1
    } ;

static yyconst int yy_meta[35] =
    {   0,
        1,    2,    2,    2,    1,    1,    1,    1,    1,    3,
        3,    3,    4,    4,    4,    4,    4,    4,    4,    4,
        4,    4,    4,    4,    4,    4,    4,    4,    4,    4,
        4,    4,    4,    1
    } ;

static yyconst short int yy_base[179] =
    {   0,
        0,    0,  236,   33,   34,   35,   37,   40,   28,   29,
       47,   50,  238,  240,  240,  240,  234,  233,  240,  224,
      223,  203,  207,  204,  213,   44,    0,  207,  204,  203,
      213,  208,   34,  199,  202,  240,  240,   63,  198,  240,
      240,  196,    0,  240,   48,   60,   68,   62,  240,  240,
      217,  240,  216,  240,  207,    0,  188,  183,  198,  192,
      200,  196,  186,  194,  194,  192,   63,  184,  193,    0,
      176,   85,  180,  187,  169,    0,   81,  184,    0,   74,
        0,    0,   76,    0,  168,  167,  178,    0,  184,  175,
      167,  166,  179,  175,  174,  174,  167,   88,  162,  161,

      166,  157,  108,    0,    0,    0,    0,    0,    0,    0,
        0,  159,  154,  159,  152,  111,  167,  155,    0,  157,
      164,  163,  148,  146,  151,  155,    0,  114,  117,  144,
      153,  148,  147,  120,  240,  145,  137,  141,  149,  134,
      134,  140,  143,  131,  123,  240,    0,    0,  139,  122,
       92,    0,   84,   84,   82,   78,   48,    0,    0,    0,
       52,    0,    0,    0,    0,   35,   24,    0,  240,  127,
      131,  135,  139,  143,  145,  149,  152,  154
    } ;

static yyconst short int yy_def[179] =
    {   0,
      169,    1,  170,  170,  171,  171,  172,  172,    1,    1,
        1,    1,  169,  169,  169,  169,  173,  174,  169,  169,
      169,  175,  175,  175,  175,  175,  175,  175,  175,  175,
      175,  175,  175,  175,  175,  169,  169,  169,  169,  169,
      169,  169,  176,  169,  175,  175,  175,  175,  169,  169,
      173,  169,  174,  169,  169,  175,  175,  175,  175,  175,
      175,  175,  175,  175,  175,  175,  175,  175,  175,  175,
      175,  169,  169,  169,  169,  176,  175,  175,  175,  175,
      175,  175,  175,  175,  175,  175,  175,  175,  175,  175,
      175,  175,  175,  175,  175,  175,  175,  175,  175,  175,

      175,  169,  169,  175,  175,  175,  175,  175,  175,  175,
      175,  175,  175,  175,  175,  175,  175,  175,  175,  175,
      175,  175,  175,  175,  175,  175,  175,  169,  177,  175,
      175,  175,  175,  169,  169,  175,  175,  175,  175,  175,
      175,  175,  175,  175,  169,  169,  178,  175,  175,  175,
      175,  175,  175,  175,  175,  175,  175,  175,  175,  178,
      175,  175,  175,  175,  175,  175,  175,  175,    0,  169,
      169,  169,  169,  169,  169,  169,  169,  169
    } ;

static yyconst short int yy_nxt[275] =
    {   0,
       14,   15,   16,   15,   17,   18,   19,   19,   20,   20,
       21,   14,   22,   23,   24,   25,   26,   27,   28,   27,
       29,   27,   27,   27,   30,   31,   32,   33,   34,   27,
       27,   35,   27,   19,   38,   37,   41,   41,   44,   16,
       44,   44,   16,   44,   45,   45,   68,   42,   42,   39,
      168,   46,   46,   69,   50,   47,   47,   50,  148,   48,
       48,   49,   49,   45,   72,   61,   45,   62,  167,   61,
       46,   77,  166,   46,   47,   78,   79,   47,   48,   73,
       68,   48,   71,   80,   82,   85,   72,   69,   97,   86,
      106,   81,  108,   98,  165,   83,   92,  104,  148,   84,

      164,   73,  163,  122,  123,  107,  162,  109,  124,  129,
      129,  129,  134,  135,  134,  145,  146,  145,  129,  129,
      129,  134,  135,  134,  145,  146,  145,   36,   36,   36,
       36,   40,   40,   40,   40,   43,   43,   43,   43,   51,
       51,   51,   51,   53,   53,   53,   53,   56,   56,   76,
      161,   76,   76,  147,  148,  147,  160,  160,  159,  158,
      157,  156,  155,  154,  153,  148,  152,  151,  150,  149,
      148,  144,  143,  142,  141,  140,  139,  138,  137,  136,
      133,  132,  131,  130,  128,  127,  126,  125,  121,  120,
      119,  118,  117,  116,  115,  114,  113,  112,  111,  110,

      105,  103,  102,   74,  101,  100,   99,   96,   95,   94,
       93,   92,   91,   90,   89,   88,   87,   55,   54,   52,
       75,   74,   71,   70,   67,   66,   65,   64,   63,   60,
       59,   58,   57,   55,   55,   54,   52,  169,   37,   13,
      169,  169,  169,  169,  169,  169,  169,  169,  169,  169,
      169,  169,  169,  169,  169,  169,  169,  169,  169,  169,
      169,  169,  169,  169,  169,  169,  169,  169,  169,  169,
      169,  169,  169,  169
    } ;

static yyconst short int yy_chk[275] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    4,    4,    5,    6,    7,    7,
        7,    8,    8,    8,    9,   10,   33,    5,    6,    4,
      167,    9,   10,   33,   11,    9,   10,   12,  166,    9,
       10,    9,   10,   11,   38,   26,   12,   26,  161,   45,
       11,   45,  157,   12,   11,   45,   46,   12,   11,   38,
       47,   12,   48,   46,   47,   48,   72,   47,   67,   48,
       80,   46,   83,   67,  156,   47,   77,   77,  155,   47,

      154,   72,  153,   98,   98,   80,  151,   83,   98,  103,
      103,  103,  116,  116,  116,  128,  128,  128,  129,  129,
      129,  134,  134,  134,  145,  145,  145,  170,  170,  170,
      170,  171,  171,  171,  171,  172,  172,  172,  172,  173,
      173,  173,  173,  174,  174,  174,  174,  175,  175,  176,
      150,  176,  176,  177,  149,  177,  178,  178,  144,  143,
      142,  141,  140,  139,  138,  137,  136,  133,  132,  131,
      130,  126,  125,  124,  123,  122,  121,  120,  118,  117,
      115,  114,  113,  112,  102,  101,  100,   99,   97,   96,
       95,   94,   93,   92,   91,   90,   89,   87,   86,   85,

       78,   75,   74,   73,   71,   69,   68,   66,   65,   64,
       63,   62,   61,   60,   59,   58,   57,   55,   53,   51,
       42,   39,   35,   34,   32,   31,   30,   29,   28,   25,
       24,   23,   22,   21,   20,   18,   17,   13,    3,  169,
      169,  169,  169,  169,  169,  169,  169,  169,  169,  169,
      169,  169,  169,  169,  169,  169,  169,  169,  169,  169,
      169,  169,  169,  169,  169,  169,  169,  169,  169,  169,
      169,  169,  169,  169
    } ;

static yy_state_type yy_state_buf[YY_BUF_SIZE + 2], *yy_state_ptr;
static char *yy_full_match;
static int yy_lp;
#define REJECT \
{ \
*yy_cp = yy_hold_char; /* undo effects of setting up yytext */ \
yy_cp = yy_full_match; /* restore poss. backed-over text */ \
++yy_lp; \
goto find_rule; \
}
static int yy_more_flag = 0;
static int yy_more_len = 0;
#define yymore() (yy_more_flag = 1)
#define YY_MORE_ADJ yy_more_len
#define YY_RESTORE_YY_MORE_OFFSET
char *yytext;
#line 1 "lexer.l"
#define INITIAL 0
#line 2 "lexer.l"
/*
 *  File:             lexer.l
 *  Date created:     March 15, 1999 (Monday, 17:16h)
 *  Author:           Copyright (C) 1999 Thomas Jensen
 *                    tsjensen@stud.informatik.uni-erlangen.de
 *  Version:          $Id: lexer.l,v 1.17 1999/08/20 19:51:12 tsjensen Exp tsjensen $
 *  Language:         lex (ANSI C)
 *  Purpose:          flex lexical analyzer for boxes configuration files
 *
 *  Remarks: o This program is free software; you can redistribute it and/or
 *             modify it under the terms of the GNU General Public License as
 *             published by the Free Software Foundation; either version 2 of
 *             the License, or (at your option) any later version.
 *           o This program is distributed in the hope that it will be useful,
 *             but WITHOUT ANY WARRANTY; without even the implied warranty of
 *             MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *             GNU General Public License for more details.
 *           o You should have received a copy of the GNU General Public
 *             License along with this program; if not, write to the Free
 *             Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *             MA 02111-1307  USA
 *           - We don't use the yylineno %option. It is not only inefficient,
 *             but also doesn't work. :-| *doh*
 *
 *  Revision History:
 *
 *    $Log: lexer.l,v $
 *    Revision 1.17  1999/08/20 19:51:12  tsjensen
 *    Moved contents of YY_USER_INIT definition into a separate function which
 *    is now called by YY_USER_INIT (better readability)
 *
 *    Revision 1.16  1999/08/18 18:23:41  tsjensen
 *    Declared yyerrcnt to be static
 *    Added YY_USER_INIT macro to set the input buffer size to the config file
 *    size (plus a bit). This is supposed to be a workaround for the REJECT
 *    problem.
 *
 *    Revision 1.15  1999/08/18 15:40:10  tsjensen
 *    Added %options never-interactive and caseless
 *    Added code for DELIMITER statements
 *    Rewrote string rules to deal with delimiter statements
 *
 *    Revision 1.14  1999/08/16 16:28:03  tsjensen
 *    Implemented new SAMPLE block syntax
 *    Replaced states SAMPLE1 and SAMPLE2 with new state SAMPLE - this is now
 *    much simpler code
 *
 *    Revision 1.13  1999/07/22 12:21:14  tsjensen
 *    Added GNU GPL disclaimer
 *    Renamed y.tab.h include to parser.h (same file)
 *    Renamed parser.h include to lexer.h (same file)
 *    Added config.h include
 *
 *    Revision 1.12  1999/07/02 11:58:15  tsjensen
 *    Added begin_speedmode() which is called by parser.y
 *    Added state SPEEDMODE for fast skipping of designs
 *    Introduced definitions for PWORD, PBOX, and PWHITE (whitespace)
 *    Added %options nounput and noyywrap for easier compilation/linking
 *
 *    Revision 1.11  1999/06/28 18:37:38  tsjensen
 *    Replaced DEBUG macro with LEXER_DEBUG, which is now activated in boxes.h
 *    New tokens to, with, global, once
 *    Added LEX_MAX_WARN macro to limit number of lex errors printed per design
 *    Replaced exit()s with return YUNREC where errors are not fatal
 *
 *    Revision 1.10  1999/06/28 12:17:46  tsjensen
 *    Added tokens YBOX and YEND (thus, BOX and END are no longer YKEYWORDs)
 *    Added #define FILE_LEXER_L around #include boxes.h to please compiler
 *
 *    Revision 1.9  1999/06/22 12:00:05  tsjensen
 *    Added #undef DEBUG, because DEBUGging is now activated in boxes.h
 *    Added #include tools.h
 *
 *    Revision 1.8  1999/06/20 14:17:58  tsjensen
 *    Added "padding" keyword and recognition of numbers (YNUMBER)
 *
 *    Revision 1.7  1999/06/17 19:05:46  tsjensen
 *    Bugfix: Sample block analysis didn't handle empty blocks
 *
 *    Revision 1.6  1999/06/14 12:13:41  tsjensen
 *    Added Reverse pattern
 *
 *    Revision 1.4  1999/04/09 13:31:13  tsjensen
 *    Removed all code related to OFFSET blocks (obsolete)
 *
 *    Revision 1.3  1999/04/04 16:11:39  tsjensen
 *    Added indent keyword
 *    Added Replace token
 *    Some fiddling which will hopefully fix a line counting bug
 *
 *    Revision 1.1  1999/03/18 15:09:48  tsjensen
 *    Initial revision
 *
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

#include "config.h"
#include <string.h>
#include <sys/stat.h>
#include <unistd.h>
#include "shape.h"
#define FILE_LEXER_L
#include "boxes.h"
#undef FILE_LEXER_L
#include "tools.h"
#include "parser.h"
#include "lexer.h"



#define LEX_MAX_WARN 3                   /* number of lex errors per design */


static const char rcsid_lexer_l[] =
    "$Id: lexer.l,v 1.17 1999/08/20 19:51:12 tsjensen Exp tsjensen $";


int yylineno = 1;
static int yyerrcnt = 0;

static char sdel = '\"';
static char sesc = '\\';


/*
 *  User-defined initializations for the lexer
 */
static void inflate_inbuf();
#define YY_USER_INIT  inflate_inbuf()


#define YY_NO_UNPUT 1
#define YY_NEVER_INTERACTIVE 1
#define SAMPLE 1

#define SPEEDMODE 2

#define DELWORD 3

#define SHAPES 4

#define ELASTIC 5


/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap YY_PROTO(( void ));
#else
extern int yywrap YY_PROTO(( void ));
#endif
#endif

#ifndef YY_NO_UNPUT
static void yyunput YY_PROTO(( int c, char *buf_ptr ));
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy YY_PROTO(( char *, yyconst char *, int ));
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen YY_PROTO(( yyconst char * ));
#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int yyinput YY_PROTO(( void ));
#else
static int input YY_PROTO(( void ));
#endif
#endif

#if YY_STACK_USED
static int yy_start_stack_ptr = 0;
static int yy_start_stack_depth = 0;
static int *yy_start_stack = 0;
#ifndef YY_NO_PUSH_STATE
static void yy_push_state YY_PROTO(( int new_state ));
#endif
#ifndef YY_NO_POP_STATE
static void yy_pop_state YY_PROTO(( void ));
#endif
#ifndef YY_NO_TOP_STATE
static int yy_top_state YY_PROTO(( void ));
#endif

#else
#define YY_NO_PUSH_STATE 1
#define YY_NO_POP_STATE 1
#define YY_NO_TOP_STATE 1
#endif

#ifdef YY_MALLOC_DECL
YY_MALLOC_DECL
#else
#if __STDC__
#ifndef __cplusplus
#include <stdlib.h>
#endif
#else
/* Just try to get by without declaring the routines.  This will fail
 * miserably on non-ANSI systems for which sizeof(size_t) != sizeof(int)
 * or sizeof(void*) != sizeof(int).
 */
#endif
#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */

#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO (void) fwrite( yytext, yyleng, 1, yyout )
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( yy_current_buffer->yy_is_interactive ) \
		{ \
		int c = '*', n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else if ( ((result = fread( buf, 1, max_size, yyin )) == 0) \
		  && ferror( yyin ) ) \
		YY_FATAL_ERROR( "input in flex scanner failed" );
#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL int yylex YY_PROTO(( void ))
#endif

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	if ( yyleng > 0 ) \
		yy_current_buffer->yy_at_bol = \
				(yytext[yyleng - 1] == '\n'); \
	YY_USER_ACTION

YY_DECL
	{
	register yy_state_type yy_current_state;
	register char *yy_cp, *yy_bp;
	register int yy_act;

#line 156 "lexer.l"





	if ( yy_init )
		{
		yy_init = 0;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! yy_start )
			yy_start = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! yy_current_buffer )
			yy_current_buffer =
				yy_create_buffer( yyin, YY_BUF_SIZE );

		yy_load_buffer_state();
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_more_len = 0;
		if ( yy_more_flag )
			{
			yy_more_len = yy_c_buf_p - yytext_ptr;
			yy_more_flag = 0;
			}
		yy_cp = yy_c_buf_p;

		/* Support of yytext. */
		*yy_cp = yy_hold_char;

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = yy_start;
		yy_current_state += YY_AT_BOL();
		yy_state_ptr = yy_state_buf;
		*yy_state_ptr++ = yy_current_state;
yy_match:
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 170 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			*yy_state_ptr++ = yy_current_state;
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 240 );

yy_find_action:
		yy_current_state = *--yy_state_ptr;
		yy_lp = yy_accept[yy_current_state];
find_rule: /* we branch to this label when backing up */
		for ( ; ; ) /* until we find what rule we matched */
			{
			if ( yy_lp && yy_lp < yy_accept[yy_current_state + 1] )
				{
				yy_act = yy_acclist[yy_lp];
					{
					yy_full_match = yy_cp;
					break;
					}
				}
			--yy_cp;
			yy_current_state = *--yy_state_ptr;
			yy_lp = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;


do_action:	/* This label is used only to access EOF actions. */


		switch ( yy_act )
	{ /* beginning of action switch */
case 1:
YY_RULE_SETUP
#line 160 "lexer.l"
/* ignore whitespace */
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 162 "lexer.l"
++yylineno;
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 165 "lexer.l"
{
    /*
     *  String delimiter spec - like WORD, but allow any character
     */
    #ifdef LEXER_DEBUG
        fprintf (stderr, "\nYDELWOR: %s -- STATE INITIAL", yytext);
    #endif
    yylval.s = (char *) strdup (yytext);
    if (yylval.s == NULL) {
        perror (PROJECT);
        exit (EXIT_FAILURE);
    }
    BEGIN INITIAL;
    return YDELWORD;
}
	YY_BREAK
case 4:
*yy_cp = yy_hold_char; /* undo effects of setting up yytext */
yy_c_buf_p = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 182 "lexer.l"
{
    /*
     *  Strings  --  first match everything starting from a potential
     *  string delimiter until the end of the line. We will give back what
     *  we don't need and also detect unterminated strings.
     */
    char *p;
    int rest_len = yyleng - 1;           /* length of string pointed to by p */
    int qcnt = 0;                        /* esc char count in current string */

    if (yytext[0] != sdel) {
        REJECT;                          /* that was not our delimiter */
    }

    yylval.s = (char *) strdup (yytext + 1);
    if (yylval.s == NULL) {
        perror (PROJECT);
        exit (EXIT_FAILURE);
    }
    p = yylval.s;

    while (*p) {
        if (*p == sesc) {
            memmove (p, p+1, rest_len);     /* incl. '\0' */
            ++qcnt;
            --rest_len;
            if (*p == '\0')
                break;
        }
        else if (*p == sdel) {
            *p = '\0';
            yyless ((p-yylval.s)+2+qcnt);   /* string plus quotes */
            #ifdef LEXER_DEBUG
                fprintf (stderr, "\n STRING: \"%s\"", yylval.s);
            #endif
            return STRING;
        }
        --rest_len;
        ++p;
    }
    if (yyerrcnt++ < 5)
        yyerror ("Unterminated String -- %s", yytext);
    return YUNREC;
}
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 229 "lexer.l"
{
    #ifdef LEXER_DEBUG
        fprintf (stderr, "\nYSAMPLE: %s -- STATE SAMPLE", yytext);
    #endif
    BEGIN SAMPLE;
    return YSAMPLE;
}
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 238 "lexer.l"
{
    ++yylineno;
    if (yyleng > 1)
        yymore();
}
	YY_BREAK
case 7:
*yy_cp = yy_hold_char; /* undo effects of setting up yytext */
yy_c_buf_p = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 245 "lexer.l"
{
    char *p = yytext + yyleng -1;
    size_t len;                          /* length of sample */

    while (*p == ' ' || *p == '\t' || *p == '\r')
        --p;                             /* skip trailing whitespace */
    p -= 2;                              /* almost skip "ends" statement */
    *p = '\0';                           /* p now points to 'n' */
    yylval.s = (char *) strdup (yytext);
    if (yylval.s == NULL) {
        perror (PROJECT);
        exit (EXIT_FAILURE);
    }
    *p-- = 'n';

    len = p - yytext;                    /* yyless(n): push back all but the first n */
    yyless (len);                        /* allow him to return YENDSAMPLE */

    yylval.s[len] = '\n';                /* replace 'e' with newline */
    btrim (yylval.s, &len);
    if (len > 0) {
        strcat (yylval.s, "\n");         /* memory was allocated with strdup */
        #ifdef LEXER_DEBUG
            fprintf (stderr, "\n STRING: \"%s\" -- STATE INITIAL", yylval.s);
        #endif
        BEGIN INITIAL;
        return STRING;
    }
    else {
        if (yyerrcnt++ < 5)
            yyerror ("SAMPLE block must not be empty");
        BFREE (yylval.s);
        return YUNREC;
    }
}
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 282 "lexer.l"
yymore();
	YY_BREAK
case 9:
*yy_cp = yy_hold_char; /* undo effects of setting up yytext */
yy_c_buf_p = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 285 "lexer.l"
{
    #ifdef LEXER_DEBUG
        fprintf (stderr, "\nYENDSAM: %s", yytext);
    #endif
    return YENDSAMPLE;
}
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 294 "lexer.l"
{
    #ifdef LEXER_DEBUG
        fprintf (stderr, "\nYELASTC: %s -- STATE ELASTIC", yytext);
    #endif
    BEGIN ELASTIC;
    return YELASTIC;
}
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 302 "lexer.l"
{
    #ifdef LEXER_DEBUG
        fprintf (stderr, "\nYSHAPES: %s -- STATE SHAPES", yytext);
    #endif
    BEGIN SHAPES;
    return YSHAPES;
}
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 310 "lexer.l"
{
    #ifdef LEXER_DEBUG
        fprintf (stderr, "\n   YBOX: %s", yytext);
    #endif
    yyerrcnt = 0;
    return YBOX;
}
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 318 "lexer.l"
{ return YREPLACE; }
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 319 "lexer.l"
{ return YREVERSE; }
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 320 "lexer.l"
{ return YPADDING; }
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 321 "lexer.l"
{ return YEND;     }
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 322 "lexer.l"
{ return YTO;      }
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 323 "lexer.l"
{ return YWITH;    }
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 324 "lexer.l"
{ yylval.c = 'g'; return YRXPFLAG; }
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 325 "lexer.l"
{ yylval.c = 'o'; return YRXPFLAG; }
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 328 "lexer.l"
{ yylval.shape = NW;  return SHAPE; }
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 329 "lexer.l"
{ yylval.shape = NNW; return SHAPE; }
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 330 "lexer.l"
{ yylval.shape = N;   return SHAPE; }
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 331 "lexer.l"
{ yylval.shape = NNE; return SHAPE; }
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 332 "lexer.l"
{ yylval.shape = NE;  return SHAPE; }
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 333 "lexer.l"
{ yylval.shape = ENE; return SHAPE; }
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 334 "lexer.l"
{ yylval.shape = E;   return SHAPE; }
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 335 "lexer.l"
{ yylval.shape = ESE; return SHAPE; }
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 336 "lexer.l"
{ yylval.shape = SE;  return SHAPE; }
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 337 "lexer.l"
{ yylval.shape = SSE; return SHAPE; }
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 338 "lexer.l"
{ yylval.shape = S;   return SHAPE; }
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 339 "lexer.l"
{ yylval.shape = SSW; return SHAPE; }
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 340 "lexer.l"
{ yylval.shape = SW;  return SHAPE; }
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 341 "lexer.l"
{ yylval.shape = WSW; return SHAPE; }
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 342 "lexer.l"
{ yylval.shape = W;   return SHAPE; }
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 343 "lexer.l"
{ yylval.shape = WNW; return SHAPE; }
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 345 "lexer.l"
{
    #ifdef LEXER_DEBUG
        fprintf (stderr, "\n SYMBOL: \'%c\' -- STATE INITIAL", yytext[0]);
    #endif
    BEGIN INITIAL;
    return yytext[0];
}
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 353 "lexer.l"
{
    #ifdef LEXER_DEBUG
        fprintf (stderr, "\n SYMBOL: \'%c\' -- STATE INITIAL", yytext[0]);
    #endif
    BEGIN INITIAL;
    return yytext[0];
}
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 362 "lexer.l"
{
    /*
     *  general key words
     */
    #ifdef LEXER_DEBUG
        fprintf (stderr, "\nKEYWORD: %s", yytext);
    #endif
    yylval.s = (char *) strdup (yytext);
    if (yylval.s == NULL) {
        perror (PROJECT);
        exit (EXIT_FAILURE);
    }
    return KEYWORD;
}
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 378 "lexer.l"
{
    /*
     *  Change string delimiting characters
     */
    #ifdef LEXER_DEBUG
        fprintf (stderr, "\nYCHGDEL: %s -- STATE DELWORD", yytext);
    #endif
    BEGIN DELWORD;
    return YCHGDEL;
}
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 390 "lexer.l"
{
    #ifdef LEXER_DEBUG
        fprintf (stderr, "\n   WORD: %s", yytext);
    #endif
    yylval.s = (char *) strdup (yytext);
    if (yylval.s == NULL) {
        perror (PROJECT);
        exit (EXIT_FAILURE);
    }
    return WORD;
}
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 403 "lexer.l"
{
    #ifdef LEXER_DEBUG
        fprintf (stderr, "\nYNUMBER: %s", yytext);
    #endif
    yylval.num = atoi (yytext);
    return YNUMBER;
}
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 412 "lexer.l"
{
    #ifdef LEXER_DEBUG
        fprintf (stderr, "\n SYMBOL: \'%c\'", yytext[0]);
    #endif
    return yytext[0];
}
	YY_BREAK
case 44:
*yy_cp = yy_hold_char; /* undo effects of setting up yytext */
yy_c_buf_p = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 420 "lexer.l"
{
    /* ignore comments */
    #ifdef LEXER_DEBUG
        fprintf (stderr, "\nCOMMENT: %s", yytext+1);
    #endif
}
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 428 "lexer.l"
{
    if (yyerrcnt++ < LEX_MAX_WARN)
        yyerror ("Unrecognized input char \'%s\'", yytext);
    return YUNREC;
}
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 435 "lexer.l"
{
    #ifdef LEXER_DEBUG
        fprintf (stderr, "\n STATUS: %s -- STATE INITIAL", yytext);
    #endif
    yyless (0);
    speeding = 0;
    BEGIN INITIAL;
}
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 444 "lexer.l"
++yylineno;
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 446 "lexer.l"
/* ignore anything else */
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 449 "lexer.l"
ECHO;
	YY_BREAK
			case YY_STATE_EOF(INITIAL):
			case YY_STATE_EOF(SAMPLE):
			case YY_STATE_EOF(SPEEDMODE):
			case YY_STATE_EOF(DELWORD):
			case YY_STATE_EOF(SHAPES):
			case YY_STATE_EOF(ELASTIC):
				yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - yytext_ptr) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = yy_hold_char;
		YY_RESTORE_YY_MORE_OFFSET

		if ( yy_current_buffer->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between yy_current_buffer and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			yy_n_chars = yy_current_buffer->yy_n_chars;
			yy_current_buffer->yy_input_file = yyin;
			yy_current_buffer->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( yy_c_buf_p <= &yy_current_buffer->yy_ch_buf[yy_n_chars] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			yy_c_buf_p = yytext_ptr + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state();

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = yytext_ptr + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++yy_c_buf_p;
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = yy_c_buf_p;
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer() )
			{
			case EOB_ACT_END_OF_FILE:
				{
				yy_did_buffer_switch_on_eof = 0;

				if ( yywrap() )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					yy_c_buf_p = yytext_ptr + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				yy_c_buf_p =
					yytext_ptr + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state();

				yy_cp = yy_c_buf_p;
				yy_bp = yytext_ptr + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				yy_c_buf_p =
				&yy_current_buffer->yy_ch_buf[yy_n_chars];

				yy_current_state = yy_get_previous_state();

				yy_cp = yy_c_buf_p;
				yy_bp = yytext_ptr + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of yylex */


/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */

static int yy_get_next_buffer()
	{
	register char *dest = yy_current_buffer->yy_ch_buf;
	register char *source = yytext_ptr;
	register int number_to_move, i;
	int ret_val;

	if ( yy_c_buf_p > &yy_current_buffer->yy_ch_buf[yy_n_chars + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( yy_current_buffer->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( yy_c_buf_p - yytext_ptr - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) (yy_c_buf_p - yytext_ptr) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( yy_current_buffer->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		yy_n_chars = 0;

	else
		{
		int num_to_read =
			yy_current_buffer->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */
#ifdef YY_USES_REJECT
			YY_FATAL_ERROR(
"input buffer overflow, can't enlarge buffer because scanner uses REJECT" );
#else

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = yy_current_buffer;

			int yy_c_buf_p_offset =
				(int) (yy_c_buf_p - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yy_flex_realloc( (void *) b->yy_ch_buf,
							 b->yy_buf_size + 2 );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			yy_c_buf_p = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = yy_current_buffer->yy_buf_size -
						number_to_move - 1;
#endif
			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&yy_current_buffer->yy_ch_buf[number_to_move]),
			yy_n_chars, num_to_read );
		}

	if ( yy_n_chars == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart( yyin );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			yy_current_buffer->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	yy_n_chars += number_to_move;
	yy_current_buffer->yy_ch_buf[yy_n_chars] = YY_END_OF_BUFFER_CHAR;
	yy_current_buffer->yy_ch_buf[yy_n_chars + 1] = YY_END_OF_BUFFER_CHAR;

	yytext_ptr = &yy_current_buffer->yy_ch_buf[0];

	return ret_val;
	}


/* yy_get_previous_state - get the state just before the EOB char was reached */

static yy_state_type yy_get_previous_state()
	{
	register yy_state_type yy_current_state;
	register char *yy_cp;

	yy_current_state = yy_start;
	yy_current_state += YY_AT_BOL();
	yy_state_ptr = yy_state_buf;
	*yy_state_ptr++ = yy_current_state;

	for ( yy_cp = yytext_ptr + YY_MORE_ADJ; yy_cp < yy_c_buf_p; ++yy_cp )
		{
		register YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 170 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		*yy_state_ptr++ = yy_current_state;
		}

	return yy_current_state;
	}


/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */

#ifdef YY_USE_PROTOS
static yy_state_type yy_try_NUL_trans( yy_state_type yy_current_state )
#else
static yy_state_type yy_try_NUL_trans( yy_current_state )
yy_state_type yy_current_state;
#endif
	{
	register int yy_is_jam;

	register YY_CHAR yy_c = 1;
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 170 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 169);
	if ( ! yy_is_jam )
		*yy_state_ptr++ = yy_current_state;

	return yy_is_jam ? 0 : yy_current_state;
	}


#ifndef YY_NO_UNPUT
#ifdef YY_USE_PROTOS
static void yyunput( int c, register char *yy_bp )
#else
static void yyunput( c, yy_bp )
int c;
register char *yy_bp;
#endif
	{
	register char *yy_cp = yy_c_buf_p;

	/* undo effects of setting up yytext */
	*yy_cp = yy_hold_char;

	if ( yy_cp < yy_current_buffer->yy_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		register int number_to_move = yy_n_chars + 2;
		register char *dest = &yy_current_buffer->yy_ch_buf[
					yy_current_buffer->yy_buf_size + 2];
		register char *source =
				&yy_current_buffer->yy_ch_buf[number_to_move];

		while ( source > yy_current_buffer->yy_ch_buf )
			*--dest = *--source;

		yy_cp += (int) (dest - source);
		yy_bp += (int) (dest - source);
		yy_n_chars = yy_current_buffer->yy_buf_size;

		if ( yy_cp < yy_current_buffer->yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--yy_cp = (char) c;


	yytext_ptr = yy_bp;
	yy_hold_char = *yy_cp;
	yy_c_buf_p = yy_cp;
	}
#endif	/* ifndef YY_NO_UNPUT */


#ifdef __cplusplus
static int yyinput()
#else
static int input()
#endif
	{
	int c;

	*yy_c_buf_p = yy_hold_char;

	if ( *yy_c_buf_p == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( yy_c_buf_p < &yy_current_buffer->yy_ch_buf[yy_n_chars] )
			/* This was really a NUL. */
			*yy_c_buf_p = '\0';

		else
			{ /* need more input */
			int offset = yy_c_buf_p - yytext_ptr;
			++yy_c_buf_p;

			switch ( yy_get_next_buffer() )
				{
				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap() )
						{
						yy_c_buf_p = yytext_ptr + offset;
						return EOF;
						}

					if ( ! yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					yy_c_buf_p = yytext_ptr + offset;
					break;

				case EOB_ACT_LAST_MATCH:
#ifdef __cplusplus
					YY_FATAL_ERROR(
					"unexpected last match in yyinput()" );
#else
					YY_FATAL_ERROR(
					"unexpected last match in input()" );
#endif
				}
			}
		}

	c = *(unsigned char *) yy_c_buf_p;	/* cast for 8-bit char's */
	*yy_c_buf_p = '\0';	/* preserve yytext */
	yy_hold_char = *++yy_c_buf_p;

	yy_current_buffer->yy_at_bol = (c == '\n');

	return c;
	}


#ifdef YY_USE_PROTOS
void yyrestart( FILE *input_file )
#else
void yyrestart( input_file )
FILE *input_file;
#endif
	{
	if ( ! yy_current_buffer )
		yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE );

	yy_init_buffer( yy_current_buffer, input_file );
	yy_load_buffer_state();
	}


#ifdef YY_USE_PROTOS
void yy_switch_to_buffer( YY_BUFFER_STATE new_buffer )
#else
void yy_switch_to_buffer( new_buffer )
YY_BUFFER_STATE new_buffer;
#endif
	{
	if ( yy_current_buffer == new_buffer )
		return;

	if ( yy_current_buffer )
		{
		/* Flush out information for old buffer. */
		*yy_c_buf_p = yy_hold_char;
		yy_current_buffer->yy_buf_pos = yy_c_buf_p;
		yy_current_buffer->yy_n_chars = yy_n_chars;
		}

	yy_current_buffer = new_buffer;
	yy_load_buffer_state();

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	yy_did_buffer_switch_on_eof = 1;
	}


#ifdef YY_USE_PROTOS
void yy_load_buffer_state( void )
#else
void yy_load_buffer_state()
#endif
	{
	yy_n_chars = yy_current_buffer->yy_n_chars;
	yytext_ptr = yy_c_buf_p = yy_current_buffer->yy_buf_pos;
	yyin = yy_current_buffer->yy_input_file;
	yy_hold_char = *yy_c_buf_p;
	}


#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_create_buffer( FILE *file, int size )
#else
YY_BUFFER_STATE yy_create_buffer( file, size )
FILE *file;
int size;
#endif
	{
	YY_BUFFER_STATE b;

	b = (YY_BUFFER_STATE) yy_flex_alloc( sizeof( struct yy_buffer_state ) );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yy_flex_alloc( b->yy_buf_size + 2 );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer( b, file );

	return b;
	}


#ifdef YY_USE_PROTOS
void yy_delete_buffer( YY_BUFFER_STATE b )
#else
void yy_delete_buffer( b )
YY_BUFFER_STATE b;
#endif
	{
	if ( ! b )
		return;

	if ( b == yy_current_buffer )
		yy_current_buffer = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yy_flex_free( (void *) b->yy_ch_buf );

	yy_flex_free( (void *) b );
	}


#ifndef YY_ALWAYS_INTERACTIVE
#ifndef YY_NEVER_INTERACTIVE
extern int isatty YY_PROTO(( int ));
#endif
#endif

#ifdef YY_USE_PROTOS
void yy_init_buffer( YY_BUFFER_STATE b, FILE *file )
#else
void yy_init_buffer( b, file )
YY_BUFFER_STATE b;
FILE *file;
#endif


	{
	yy_flush_buffer( b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

#if YY_ALWAYS_INTERACTIVE
	b->yy_is_interactive = 1;
#else
#if YY_NEVER_INTERACTIVE
	b->yy_is_interactive = 0;
#else
	b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
#endif
#endif
	}


#ifdef YY_USE_PROTOS
void yy_flush_buffer( YY_BUFFER_STATE b )
#else
void yy_flush_buffer( b )
YY_BUFFER_STATE b;
#endif

	{
	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == yy_current_buffer )
		yy_load_buffer_state();
	}


#ifndef YY_NO_SCAN_BUFFER
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_scan_buffer( char *base, yy_size_t size )
#else
YY_BUFFER_STATE yy_scan_buffer( base, size )
char *base;
yy_size_t size;
#endif
	{
	YY_BUFFER_STATE b;

	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) yy_flex_alloc( sizeof( struct yy_buffer_state ) );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer( b );

	return b;
	}
#endif


#ifndef YY_NO_SCAN_STRING
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_scan_string( yyconst char *str )
#else
YY_BUFFER_STATE yy_scan_string( str )
yyconst char *str;
#endif
	{
	int len;
	for ( len = 0; str[len]; ++len )
		;

	return yy_scan_bytes( str, len );
	}
#endif


#ifndef YY_NO_SCAN_BYTES
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_scan_bytes( yyconst char *bytes, int len )
#else
YY_BUFFER_STATE yy_scan_bytes( bytes, len )
yyconst char *bytes;
int len;
#endif
	{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;

	/* Get memory for full buffer, including space for trailing EOB's. */
	n = len + 2;
	buf = (char *) yy_flex_alloc( n );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < len; ++i )
		buf[i] = bytes[i];

	buf[len] = buf[len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer( buf, n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
	}
#endif


#ifndef YY_NO_PUSH_STATE
#ifdef YY_USE_PROTOS
static void yy_push_state( int new_state )
#else
static void yy_push_state( new_state )
int new_state;
#endif
	{
	if ( yy_start_stack_ptr >= yy_start_stack_depth )
		{
		yy_size_t new_size;

		yy_start_stack_depth += YY_START_STACK_INCR;
		new_size = yy_start_stack_depth * sizeof( int );

		if ( ! yy_start_stack )
			yy_start_stack = (int *) yy_flex_alloc( new_size );

		else
			yy_start_stack = (int *) yy_flex_realloc(
					(void *) yy_start_stack, new_size );

		if ( ! yy_start_stack )
			YY_FATAL_ERROR(
			"out of memory expanding start-condition stack" );
		}

	yy_start_stack[yy_start_stack_ptr++] = YY_START;

	BEGIN(new_state);
	}
#endif


#ifndef YY_NO_POP_STATE
static void yy_pop_state()
	{
	if ( --yy_start_stack_ptr < 0 )
		YY_FATAL_ERROR( "start-condition stack underflow" );

	BEGIN(yy_start_stack[yy_start_stack_ptr]);
	}
#endif


#ifndef YY_NO_TOP_STATE
static int yy_top_state()
	{
	return yy_start_stack[yy_start_stack_ptr - 1];
	}
#endif

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

#ifdef YY_USE_PROTOS
static void yy_fatal_error( yyconst char msg[] )
#else
static void yy_fatal_error( msg )
char msg[];
#endif
	{
	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
	}



/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
		yytext[yyleng] = yy_hold_char; \
		yy_c_buf_p = yytext + n; \
		yy_hold_char = *yy_c_buf_p; \
		*yy_c_buf_p = '\0'; \
		yyleng = n; \
		} \
	while ( 0 )


/* Internal utility routines. */

#ifndef yytext_ptr
#ifdef YY_USE_PROTOS
static void yy_flex_strncpy( char *s1, yyconst char *s2, int n )
#else
static void yy_flex_strncpy( s1, s2, n )
char *s1;
yyconst char *s2;
int n;
#endif
	{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
	}
#endif

#ifdef YY_NEED_STRLEN
#ifdef YY_USE_PROTOS
static int yy_flex_strlen( yyconst char *s )
#else
static int yy_flex_strlen( s )
yyconst char *s;
#endif
	{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
	}
#endif


#ifdef YY_USE_PROTOS
static void *yy_flex_alloc( yy_size_t size )
#else
static void *yy_flex_alloc( size )
yy_size_t size;
#endif
	{
	return (void *) malloc( size );
	}

#ifdef YY_USE_PROTOS
static void *yy_flex_realloc( void *ptr, yy_size_t size )
#else
static void *yy_flex_realloc( ptr, size )
void *ptr;
yy_size_t size;
#endif
	{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
	}

#ifdef YY_USE_PROTOS
static void yy_flex_free( void *ptr )
#else
static void yy_flex_free( ptr )
void *ptr;
#endif
	{
	free( ptr );
	}

#if YY_MAIN
int main()
	{
	yylex();
	return 0;
	}
#endif
#line 449 "lexer.l"



static void inflate_inbuf()
/*
 *  User-defined initializations for the lexer.
 *
 *  Since this scanner must use REJECT in order to be able to process the
 *  string delimiter commands, it cannot dynamically enlarge its input
 *  buffer to accomodate larger tokens. Thus, we simply set the buffer size
 *  to the input file size plus 10 bytes margin-of-error.
 *
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */
{
    struct stat sinf;

    if (stat(yyfilename, &sinf)) {
        perror (PROJECT);
        exit (EXIT_FAILURE);
    }
    yy_delete_buffer (YY_CURRENT_BUFFER);
    YY_CURRENT_BUFFER = yy_create_buffer (yyin, sinf.st_size+10);
}



void begin_speedmode()
{
    #ifdef LEXER_DEBUG
        fprintf (stderr, "\n STATUS: begin_speedmode() -- STATE SPEEDMODE");
    #endif
    BEGIN SPEEDMODE;
}



void chg_strdelims (const char asesc, const char asdel)
{
    #ifdef LEXER_DEBUG
        fprintf (stderr, "\n STATUS: chg_strdelims ('%c', '%c')", asesc, asdel);
    #endif
    sesc = asesc;
    sdel = asdel;
}



/*EOF*/                                         /* vim: set cindent sw=4: */
