
/*
 *  Diverse Bristol audio routines.
 *  Copyright (c) by Nick Copeland <nick.copeland@ntlworld.com> 1996,2002
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*
 * This code should open the midi device (working with ALSA raw midi only for
 * the moment (9/11/01)), and read data from it. Not sure how it will be read,
 * either buffers, events, or perhaps just raw data. At some point in the 
 * development this will become a separate thread in the synth code.
 */

/*
 * This should go into a library, is used from various places.
 */
bufmerge(register float *buf1, register float gain1, register float *buf2,
	register float gain2, register int size)
{
	for (;size > 0; size-=16)
	{
		*buf2++ = *buf2 * gain2 + *buf1++ * gain1;
		*buf2++ = *buf2 * gain2 + *buf1++ * gain1;
		*buf2++ = *buf2 * gain2 + *buf1++ * gain1;
		*buf2++ = *buf2 * gain2 + *buf1++ * gain1;
		*buf2++ = *buf2 * gain2 + *buf1++ * gain1;
		*buf2++ = *buf2 * gain2 + *buf1++ * gain1;
		*buf2++ = *buf2 * gain2 + *buf1++ * gain1;
		*buf2++ = *buf2 * gain2 + *buf1++ * gain1;
		*buf2++ = *buf2 * gain2 + *buf1++ * gain1;
		*buf2++ = *buf2 * gain2 + *buf1++ * gain1;
		*buf2++ = *buf2 * gain2 + *buf1++ * gain1;
		*buf2++ = *buf2 * gain2 + *buf1++ * gain1;
		*buf2++ = *buf2 * gain2 + *buf1++ * gain1;
		*buf2++ = *buf2 * gain2 + *buf1++ * gain1;
		*buf2++ = *buf2 * gain2 + *buf1++ * gain1;
		*buf2++ = *buf2 * gain2 + *buf1++ * gain1;
	}
}

