/******************************************************************
 * Copyright (C) 2005, 2006 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BSCommander (Beesoft Commander).
 *
 * BSCommander is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BSCommander is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/
#ifndef INCLUDED_DELETEQUESTION_H
#define INCLUDED_DELETEQUESTION_H

/*------- include files:
-------------------------------------------------------------------*/
#ifndef INCLUDED_QDIALOG_H
#include <qdialog.h>
#define INCLUDED_QDIALOG_H
#endif // INCLUDED_QDIALOG_H

#ifndef INCLUDED_QCHECKBOX_H
#include <qcheckbox.h>
#define INCLUDED_QCHECKBOX_H
#endif // INCLUDED_QCHECKBOX_H

#ifndef INCLUDED_VIEWTABLE_H
#include "ViewTable.h"
#endif // INCLUDED_VIEWTABLE_H

/*------- forward declarations:
-------------------------------------------------------------------*/
class QHBoxLayout;
class QVBoxLayout;
class QPushButton;
class QListView;
class QCheckBox;

/*------- class declaration:
-------------------------------------------------------------------*/
class DeleteQuestion : public QDialog
{
    Q_OBJECT

// ******* TYPES *******
private:
    class ListViewItem : public QListViewItem
    {
    public:
        ListViewItem( QListView* in_view, const QString& in_str ) : QListViewItem( in_view, in_str ) {}
        void paintCell( QPainter*, const QColorGroup&, int, int, int );
    };

// ******* CONSTRUCTION / DESTRUCTION *******
public:
    DeleteQuestion( QWidget*, const ViewTable::SelectedItems&, bool  );
private:
    DeleteQuestion( const DeleteQuestion& );
    DeleteQuestion& operator=( const DeleteQuestion& );

// ******* CONSTANTS *******
private:
    static const QString Caption;
    static const QString WipeFiles;

// ******* MEMBERS *******
private:
    QHBoxLayout* const d_main_layout;
    QVBoxLayout* const d_tbl_layout;
    QVBoxLayout* const d_btn_layout;
    QListView  * const d_table;
    QCheckBox  * const d_wipe_cb;
    QPushButton* const d_accept_btn;
    QPushButton* const d_cancel_btn;

// ******* METHODS *******
private:
    void show();
public:
    bool wipe() const;
};

//*******************************************************************
// wipe                                                PUBLIC inline
//*******************************************************************
inline bool DeleteQuestion::wipe() const
{
    return d_wipe_cb->isChecked();
}
// end of wipe

#endif // INCLUDED_DELETEQUESTION_H
