# Written by Henrik Nilsen Omma
# (C) Canonical, Ltd. Licensed under the GPL

import os
import re
import subprocess
import apt_pkg

try:
    from bzrlib.bzrdir import BzrDir
    HAVE_BZR = True    
except:
    HAVE_BZR = False

def find_version_number():
    path = os.path.join(os.path.dirname(__file__), "..")

    # We're using a package
    if path.startswith('/usr'):
        output = subprocess.Popen(["dpkg-query", "-W", "bughelper"], 
                                   stdout=subprocess.PIPE).communicate()[0]
        return output.split()[1]
    if HAVE_BZR:
        try:
            bzr_revno = BzrDir.open(path).open_branch().revno()
            head = open(os.path.join(path, "debian/changelog")).readline()
            match = re.compile(".*\((.*)\).*").match(head)
            if match:
                version = match.group(1).split("~")[0]
            return "%sr%s" % (version, bzr_revno)
        except:
            pass
    return "unknown"

def package_exists(package_name):
    try:
        apt_pkg.init()
        sources = apt_pkg.GetPkgSrcRecords()
        sources.Restart()
        if not sources.Lookup(str(package_name)):
            return False
        else:
            return True
    except:
        print "You must put some 'source' URIs in your sources.list"
        return False

def remove_obsolete_attachments(path, open_bugs):
    open_bug_nrs = set(map(lambda a: str(a.bugnumber), open_bugs))
    if os.path.exists(path):
        bugs = set(filter(lambda a: os.path.isdir(os.path.join(path, a)), 
                          os.listdir(path)))
        for bug in bugs.difference(bugs.intersection(open_bug_nrs)):
            bug_path = os.path.join(path, bug)
            if os.path.isdir(bug_path):
                os.system("rm -r %s" % bug_path)

