//
//  AppMain.m
//  CamelBones
//
//  Copyright (c) 2004 Sherm Pendley. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "AppMain.h"
#import "CBPerl.h"

extern int CBApplicationMain(int argc, const char *argv[]) {
    return CBApplicationMain2("main.pl", argc, argv);
}

extern int CBApplicationMain2(const char *scriptName, int argc, const char *argv[]) {
    NSAutoreleasePool *arPool = [[NSAutoreleasePool alloc] init];
    CBPerl *sp = [CBPerl sharedPerl];
    NSString *wrapperFolder = [[NSBundle mainBundle] resourcePath];
    NSString *mainPL = [NSString stringWithFormat: @"%@/%s", wrapperFolder, scriptName];
    NSString *perlcode = [NSString stringWithContentsOfFile: mainPL];

    // Run Perl startup code
    [sp eval: perlcode];

    // Clean up
    [arPool release];
    return 0;
}


