(*********************************************************************************)
(*                Cameleon                                                       *)
(*                                                                               *)
(*    Copyright (C) 2005,2006 Institut National de Recherche en Informatique     *)
(*    et en Automatique. All rights reserved.                                    *)
(*                                                                               *)
(*    This program is free software; you can redistribute it and/or modify       *)
(*    it under the terms of the GNU Library General Public License as            *)
(*    published by the Free Software Foundation; either version 2 of the         *)
(*    License, or  any later version.                                            *)
(*                                                                               *)
(*    This program is distributed in the hope that it will be useful,            *)
(*    but WITHOUT ANY WARRANTY; without even the implied warranty of             *)
(*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *)
(*    GNU Library General Public License for more details.                       *)
(*                                                                               *)
(*    You should have received a copy of the GNU Library General Public          *)
(*    License along with this program; if not, write to the Free Software        *)
(*    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA                   *)
(*    02111-1307  USA                                                            *)
(*                                                                               *)
(*    Contact: Maxence.Guesdon@inria.fr                                          *)
(*                                                                               *)
(*********************************************************************************)

let languages_manager = Gtksv_utils.source_languages_manager
let lang = languages_manager#get_language_from_mime_type "text/x-ocaml"

let create_source_view ?editable ?packing () =
  let source_view =
    GSourceView.source_view
      ?editable
      ~auto_indent:true
      ~insert_spaces_instead_of_tabs:true ~tabs_width:2
      ~show_line_numbers:false
      ~smart_home_end:true
      ?packing
      ()
  in
  (
   match lang with
     None -> ()
   | Some l -> source_view#source_buffer#set_language l
  );
  source_view#source_buffer#set_highlight true;
  (* set a style for bracket matching *)
  source_view#source_buffer#set_check_brackets true;
  Gtksv_utils.register_source_view source_view;
  Gtksv_utils.apply_sourceview_props source_view (Gtksv_utils.read_sourceview_props ()) ;
  source_view

let syntax_highlight_box () =
  let hb = GPack.hbox () in
  match lang with
    None ->
      ignore(GMisc.label ~text:"Syntax highlight for OCaml not available."
	       ~packing: hb#pack ());
      (Configwin.custom hb (fun () -> ()) false, fun () -> ())
  | Some lang ->
      let lang_box = new Gtksv_utils.lang_style_box () in
      lang_box#set_lang (Some lang);
      hb#pack ~expand: true ~fill: true lang_box#box;
      (Configwin.custom hb (fun () -> Gtksv_utils.store_lang_style lang) true,
       (fun () -> Gtksv_utils.read_lang_style lang)
      )

let source_view_props_box () =
  let hb = GPack.hbox () in
  let p = Gtksv_utils.read_sourceview_props () in
  let box = new Gtksv_utils.sourceview_props_box
      Gtksv_utils.apply_sourceview_props_to_registered
  in
  box#set_props (Some p);
  hb#pack ~expand: true ~fill: true box#box;
  (Configwin.custom hb
     (fun () ->
       match box#props with
	 None -> ()
       | Some p -> Gtksv_utils.store_sourceview_props p
     ) true,
   (fun () ->
     Gtksv_utils.apply_sourceview_props_to_registered
       (Gtksv_utils.read_sourceview_props ()))
  )
