#include <stdio.h>
#include <stdarg.h>

#include <qdir.h>

#if !defined(NDEBUG)

#include "TraceManager.h"

#include "TraceModule.h"

CTraceModule::CTraceModule(CTraceManager *mgr, const QString &name, int level)
{
   m_pManager = mgr;
   ModuleName = name;
   m_Level = level;
}


QString CTraceModule::GetName() const
{
   return ModuleName;
}

int CTraceModule::GetLevel() const
{
   return m_Level;
}


void CTraceModule::Enter(const QString &function_name)
{
   m_pManager->Log(">> " + function_name);
   m_pManager->IncIndent();
}

void CTraceModule::Enter(const QString &file_name, int line_number)
{
   int sep;
   //Enter(file_name.section(QDir::separator(), -1) + ":" + QString::number(line_number));
   sep = file_name.findRev(QDir::separator());
   Enter(file_name.mid(sep + 1) + ":" + QString::number(line_number));
}

void CTraceModule::Leave(const QString &function_name)
{
   m_pManager->DecIndent();
   m_pManager->Log("<< " + function_name);
}

void CTraceModule::Leave(const QString &file_name, int line_number)
{
   int sep;
   //Leave(file_name.section(QDir::separator(), - 1) + ":" + QString::number(line_number));
   sep = file_name.findRev(QDir::separator());
   Leave(file_name.mid(sep + 1) + ":" + QString::number(line_number));
}

void CTraceModule::Log(int level, const char *fmt, ...)
{
   va_list args;

   if (level > m_Level)
     return;

   /* Unfortunately we cannot propagate the ellipses (...), so we must build 
      the string here */   
   va_start(args, fmt);
#if defined(_WIN32)
   _vsnprintf(LargeBuffer, 2048, fmt, args);
#else
   vsnprintf(LargeBuffer, 2048, fmt, args);
#endif
   va_end(args);
   m_pManager->Log(LargeBuffer);
}


void CTraceModule::IncLevel()
{
   m_Level++;
}

void CTraceModule::DecLevel()
{
   if (m_Level > 0)
     m_Level--;
}

void CTraceModule::SetLevel(int level)
{
   if (level >= 0)
     m_Level = level;
}

#endif
