#ifndef VIDEOCOLLECTOR_HPP
#define VIDEOCOLLECTOR_HPP

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qmap.h>
#include <qlist.h>

#ifdef _OS_WIN32_
#include <windows.h>
#include <vfw.h>
class CVideoDeviceWin32;
#endif

#include "VideoDevice.h"

class CVideoCollector
{
private:
   static CVideoCollector *s_pVideoCollector;
   QList<CVideoDevice> m_Devices;
   
   CVideoCollector();
   void Scan();

public:
   static CVideoCollector *Instance();

   uint NumberOfVideoDevices() const;
   CVideoDevice *GetVideoDevice(uint n);

#ifdef _OS_WIN32_
   /* Windows uses callbacks. Callbacks suck. Windows sucks. Oh wait,
      you probably already knew that... :-)

      Anyway. Since CVideoCollector is singleton, we might as well use 
      it as our callback point. However, that requires some functions
      and member variables to be static.
    */
   static QMap<HWND, CVideoDeviceWin32 *>s_HWND2Video;

   void RegisterDevice(HWND, CVideoDeviceWin32 *);
   void UnregisterDevice(HWND);

//   static LRESULT CALLBACK AudioCallback(HWND, int. LPTSTR);
   static LRESULT CALLBACK ControlCallback(HWND, int);
   static LRESULT CALLBACK ErrorCallback(HWND, int, LPTSTR);
   static LRESULT CALLBACK StatusCallback(HWND, int, LPTSTR);
   static LRESULT CALLBACK VideoCallback(HWND, LPVIDEOHDR);
   static LRESULT CALLBACK YieldCallback(HWND);
#endif
};

#endif
