#ifndef VIDEOSETTINGSDLG_H
#define VIDEOSETTINGSDLG_H

#include <qarray.h>
#include <qdom.h>
#include <qsize.h>
#include <qtimer.h>

#include "VideoSettings.h"

class CVideoDeviceLinux;
class CVideoDeviceTuner;

class CVideoSettingsDlg: public CVideoSettings
{
   Q_OBJECT
private:
   CVideoDeviceLinux *pVideo;
   CVideoDeviceTuner *pTuner;

   bool m_InputTunerDone;
   bool m_Philips;
   int m_WBMode;
   int m_WBRed, m_WBBlue;
   QTimer m_AutoTimer;

   QSize sizes[7];
   QSize size, org_size, m_MaxSize, m_MinSize;
   int m_Fps, m_OrgFps;

   /// There will be 3 tables with these structs, one for each Grid system
   struct FrequencyTableEntry
   {
     QString Name;
     float Frequency;
   };

   QDomNode m_ConfigurationXML;

   void GetCamSizeFrame(bool First = FALSE);

private slots:
   // callback from CVideoDevice
   void Init();
   void SizeChanged(const QSize &);
   void FramerateChanged(int);
   void UpdateAuto();


protected:
   void hideEvent(QHideEvent *);
   void showEvent(QShowEvent *);

protected slots:
   // User actions
   // 1st group: Size & Frame
   virtual void ClickedSize(int);
   virtual void ClickedRate(int);

   // 2nd group: Video controls
   virtual void MovedBrightness(int);
   virtual void MovedContrast(int);
   virtual void MovedGamma(int);
   virtual void MovedSaturation(int);
   virtual void MovedHue(int);

   // 3rd group: Tuning
   virtual void ClickedInputSelector(int);
   virtual void ClickedTunerSelector(int);
   virtual void ClickedChannelSetup();

   // 4th group: Philips Extensions
   virtual void ToggledAGC(bool);
   virtual void MovedAGC(int);
   virtual void ToggledShutter(bool);
   virtual void MovedShutter(int);
   virtual void ToggledContour(bool);
   virtual void MovedContour(int);
   virtual void ToggledBacklight(bool);
   virtual void ToggledFlicker(bool);
   virtual void ChangedNoise(int);
   virtual void ChangedCompression(int);
   virtual void ChangedWB(int);
   virtual void MovedRed(int);
   virtual void MovedBlue(int);
   virtual void MovedWBSpeed(int);
   virtual void MovedWBDelay(int);
   virtual void ClickedSaveUser();
   virtual void ClickedRestoreUser();
   virtual void ClickedRestoreFactory();

   // 5th group: Pan & Tilt
   virtual void SetPanTiltAngle();
   virtual void ResetPanTilt();

public:
   CVideoSettingsDlg(CVideoDeviceLinux *video);
   virtual ~CVideoSettingsDlg();

   void SetConfiguration(const QDomNode &);
   QDomNode GetConfiguration(QDomDocument &) const;

   void ShowDisplayTab();
   void ShowFormatTab();
   void ShowSourceTab();

signals:
   void DialogClosed();
   void Changed(QSize, int);
};

#endif
