/*
 *  CaSU - communications & status utilities.
 *  Copyright (C) 1992, 1993, 1994 Luke Mewburn <lm@rmit.edu.au>
 *	incorporating:
 *	   flon - lists your friends who are logged on.
 *	   to - send a short message to a friend
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#include "patchlevel.h"		/* for VERSION && RELDATE */


#if STDC_HEADERS
#   define __PROT(prototype)	prototype
    typedef void *		voidptr;
#else
#   define __PROT(prototype)	()
    typedef char *		voidptr;
#endif /* STDC_HEADERS */


#include <stdio.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <sys/time.h>
#if HAVE_UNISTD_H
#   include <unistd.h>
#endif /* HAVE_UNISTD_H */
#if HAVE_STDLIB_H || STDC_HEADERS
#   include <stdlib.h>
#else  /* !HAVE_STDLIB_H && !STDC_HEADERS */
#   if !MALLOC_DECL
	extern void 	free	__PROT((voidptr));
	extern voidptr 	malloc	__PROT((size_t));
	extern voidptr 	calloc	__PROT((size_t, size_t));
#   endif /* !MALLOC_DECL */
#endif  /* !HAVE_STDLIB_H && !STDC_HEADERS */
#include <string.h>
#include <ctype.h>
#include <fcntl.h>
#include <errno.h>
#include <pwd.h>
#include <limits.h>
#if HAVE_PATHS_H
#   include <paths.h>		/* for _PATH_DEV */
#endif /* HAVE_PATHS_H */
#if NEED_NETDB_H
#   include <netdb.h>
#endif /* NEED_NETDB_H */
#if HAVE_UNAME && HAVE_SYS_UTSNAME_H
#   include <sys/utsname.h>
    extern int		uname		__PROT((struct utsname *));
#endif
#if HAVE_GETHOSTNAME && !GETHOSTNAME_DECL
    extern int		gethostname	__PROT((char *, size_t));
#endif /* HAVE_GETHOSTNAME && !GETHOSTNAME_DECL */

#ifndef MAXPATHLEN
#   ifdef PATH_MAX
#	define MAXPATHLEN	PATH_MAX
#   else
#	define MAXPATHLEN	256
#   endif
#endif

#ifndef MAXHOSTNAMELEN
#   define MAXHOSTNAMELEN	256
#endif

#if HAVE_UTMPX_H
#   include <utmpx.h>			/* assume includes <utmp.h> */
#   define PATH_UTMP		UTMPX_FILE
#   define getutent		getutxent
#   define endutent		endutxent
    typedef struct utmpx	utmp_s;
#   define UT_TIME		ut_tv.tv_sec
#else /* !HAVE_UTMPX_H */
#   include <utmp.h>
#   define UT_TIME		ut_time
    typedef struct utmp		utmp_s;
#endif /* !HAVE_UTMPX_H */
#ifndef PATH_UTMP			/* don'cha love standards? */
#   ifdef _PATH_UTMP
#       define PATH_UTMP _PATH_UTMP
#   else
#	ifdef UTMP_FILE
#	    define PATH_UTMP UTMP_FILE
#	else
#	    define PATH_UTMP "/etc/utmp"
#	endif
#   endif
#endif

#ifndef _PATH_PASSWD
#   define _PATH_PASSWD	"/etc/passwd"
#endif


extern utmp_s Kludge;
#ifndef UT_NAMESIZE
#   define UT_NAMESIZE	sizeof(Kludge.ut_name)
#endif

#ifndef UT_HOSTSIZE
#   if HAVE_UT_HOST
#	define UT_HOSTSIZE	sizeof(Kludge.ut_host)
#   else
#	define UT_HOSTSIZE	UT_NAMESIZE
#   endif
#endif /* not UT_HOSTSIZE */

#ifndef UT_LINESIZE
#   define UT_LINESIZE	sizeof(Kludge.ut_line)
#endif

		/* SYS V utmp format */
#if HAVE_UT_TYPE
#   define NULL_UTMP_ENTRY(x)	((x)->ut_type != USER_PROCESS \
				|| (x)->ut_name[0] == '\0')
#else
		/* BSD utmp format */
#   define NULL_UTMP_ENTRY(x)	((x)->ut_name[0] == '\0')
#endif


extern	char	*optarg;
extern	int	optind,	opterr, errno;


#if !HAVE_STRERROR
    extern char		*sys_errlist[];
#   define strerror(x)	sys_errlist[x]
#endif


#ifndef _PATH_DEV
#    define _PATH_DEV	"/dev/"
#endif /* _PATH_DEV */

#define	MINIDLE		300	/* 5 mins; flon: for `...', to: for idlereply */
#define	MAXIDLE		6000	/* 100 mins */
#define ONEDAY		60*60*24
#define IDLE_MULTIPLY	60	/* default unit for -p & -P is minutes */
#define NUM_SPECIFIERS	12	/* number of specifier types (%args) in -o */
#define ALIASLEN	16	/* len of `to' alias */
#define LINESIZ		256	/* nice figure */
#define BELL		7

#define STRuser		"USER"
#define	STRhome		"HOME"
#define	STRflon		"FLON"
#define STRsep		"\014\n\r\t "
#define STReoln		"\014\n\r"
#define STRtorc		"/.torc"
#define	STRdotfriends	".friends"
#define STRformat	"%-u | %p | %12l | %i | %t | %2mTalk"
#define STRyes		"On"
#define STRno		"No"

#define PWsep		":"
#define PWGCOSsep	":,"
#define PWeoln		STReoln

#define	WHO_PROG	"who"
#define WHO_NULLTTY	"tty??"
#define WHO_AM_I_FMT	"%.*s  %.7s  %.12s\n"
#if HAVE_UT_HOST
#   define WHO_FORMAT	"%u %7t %12l %.34b"
#else
#   define WHO_FORMAT	"%u %7t %12l"
#endif

#if TTY_RESTRICTED
#   define MESGS_ON	020
#else
#   define MESGS_ON	022		/* mask if messages are on */
#endif


enum			/* flon options */
{
    NO_HEADER=	(1<<0),		/* don't want header */
    NO_TAILER=	(1<<1),		/* don't want tailer */
    ONE_ONLY=	(1<<2),		/* remove duplicates */
    ALL_ON=	(1<<3),		/* list all on */
    NO_IDLE=	(1<<4),		/* remove idle entries */
    BEST_NAME=	(1<<5),		/* print real name if no pseudonym */
    NEED_STAT=	(1<<6),		/* need to stat() the ttys */
    NEED_FFILE=	(1<<7),		/* need to load ~/.friends */
    NEED_PASSWD=(1<<8),		/* need to load /etc/passwd */
    BLANKF=	(1<<9),		/* field is to be blanked */
    NO_MATES=	(1<<10),	/* exclude friends */
			    /* expansion room */
    ERROR_OPT=	(1<<14),	/* error somewhere */
    COPYLEFT=	(1<<15)		/* display copyleft */
};

enum			/* to options */
{
    DEBUG=	(1<<0),		/* print debug output */
    BEEP=	(1<<1),		/* beep the user */
    LISTALIAS=	(1<<2),		/* list your aliases */
    STATUS=	(1<<3),		/* show your status */
    MESG_N=	(1<<4),		/* turn off mesg */
    MESG_Y=	(1<<5),		/* turn on mesg */
    HELP=	(1<<6),		/* show help */
    LISTVERS=	(1<<7),		/* show version */
    ERROR=	(1<<8),		/* we have an error */
    DB_MOD=	(1<<9),		/* .torc modified */
    PSEUDO_MOD=	(1<<10)		/* pseudonym modified */
};

enum			/* to result/status codes */
{
    R_SENT=	(1<<0),		/* message sent */
    R_IS_ON=	(1<<1),		/* user is on */
    R_VALIDTTY=	(1<<2),		/* cur.tty is valid */
    R_EXCLUDE=	(1<<3),		/* user isn't excluding you */
    R_HAVETTY=	(1<<4)		/* user is logged on specific tty */
};

enum			/* contains printdat cmd info */
{
    MAX_WIDTH =	0x00FF,		/* max val of an 8 bit unsigned entity */
    C_WIDMASK =	0x00FF,		/* mask for widths */
    C_NULL =	0x0100,		/* empty space */
    C_USER =	0x0200,		/* username */
    C_PSEUDO =	0x0300,		/* pseudonym */
    C_REAL =	0x0400,		/* real name */
    C_COUNT =	0x0500,		/* # times on */
    C_X =	0x0600,		/* an 'x' */
    C_LOGIN =	0x0700,		/* login time */
    C_IDLE =	0x0800,		/* idle time */
    C_TTY =	0x0900,		/* terminal */
    C_MESG =	0x0A00,		/* mesg status */
    C_AVAIL =	0x0B00,		/* availability */
    C_HOST =	0x0C00,		/* remote host */
    C_HOSTBRK =	0x0D00,		/* remote host (in parenthesis) */
    C_CMDMASK =	0x3F00,		/* mask for cmds */
    C_VARIENT =	0x4000,		/* varient width */
    C_RIGHT =	0x8000		/* right align */
};


typedef struct		/* flon: name/pseudonym pair struct */
{
	char name[UT_NAMESIZE+1];
	char *pseudo;
} frend;

typedef struct		/* relevant info from passwd db */
{
    char *	username;	/* user name */
    uid_t	uid;		/* uid */
    char *	gcos;		/* real name */
} upwd;

typedef struct alist_S	/* to: linked list of alias/username for */
{
    char		userid[ UT_NAMESIZE + 1 ];
    char		alias[ ALIASLEN + 1 ];	/* [0] == 0 if exclude entry */
						/* otherwise, it's an alias */
    struct alist_S	*next;
} alist;

typedef struct		/* to: stores all info from ~/.torc for src & dest */
{			/*	an entry is unused if [0] == 0 */
    char	userid[ UT_NAMESIZE + 1];	/* username */
    char	name[ LINESIZ + 1 ];		/* realname or pseudo */
    char	homedir[ MAXPATHLEN + 1 ];	/* $HOME */
    char	dotuser[ UT_NAMESIZE + 1 ];	/* last user `.user' */
    char	dottty[ UT_LINESIZE + 1 ];	/* last user's tty  */
    char	yes[ LINESIZ + 1 ];		/* `yes' autoreply */
    char	no[ LINESIZ + 1 ];		/* `no' autoreply */
    char	gone[ LINESIZ + 1 ];		/* `gone' autoreply */
    char	idle[ LINESIZ + 1 ];		/* `idle' autoreply */
    char	exclude[ LINESIZ + 1 ];		/* `exclude' autoreply */
    char 	message[ LINESIZ + 1 ];		/* actual message to send */
    alist *	aliases;			/* linked list of aliases */
    char *	tty;				/* pointer to tty name */
} user_t;



#ifdef _MAIN_			/* only declare storage once for globals */
#   define GLOBAL
#else
#   define GLOBAL	extern
#endif

GLOBAL int	flags;			/* various flags */
GLOBAL char *	progname;		/* basename of this invocation */
GLOBAL int	min_idle, max_idle;	/* minimum & maximum idle cutouts */
GLOBAL struct				/* print buffer for flon */
    {
	int	*cmds;			/* 	command array */
	char	*form;			/* 	format/template array */
	char	*buf;			/* 	temp buffer */
    } printdat;

GLOBAL frend *	friends_list;		/* dynamic array of friends */
GLOBAL int	friends_count;		/* size of friends_list */

GLOBAL char *	utmp_file;		/* name of UTMP file to use */
GLOBAL utmp_s *	utmp_list;		/* dynamic array of UTMP entries */
GLOBAL int	utmp_count;		/* size of utmp_list */

GLOBAL upwd *	pw_list;		/* dynamic array of upwd entries */
GLOBAL int	pw_count;		/* size of pw_list */



/*
 *	library & system call prototypes
 */

extern int	atoi		__PROT((const char *));
extern int	chmod		__PROT((const char *, mode_t));
extern int	close		__PROT((int));
extern char	*ctime		__PROT((const time_t *));
extern void	exit		__PROT((int));
extern int	fstat		__PROT((int, struct stat *));
extern char	*getenv		__PROT((const char *));
extern void	nqsort		__PROT((void *, size_t, size_t, int (*)()));
extern void	*nbsearch	__PROT((const void *, const void *,
				    size_t, size_t, int (*)()));
#if !OPEN_DECL
    extern int	open		__PROT((const char *, int, ...));
#endif /* !OPEN_DECL */
#if !READ_DECL
    extern int	read		__PROT((int, void *, unsigned));
#endif /* !READ_DECL */
extern int	stat		__PROT((const char *, struct stat *));
extern char	*strcat		__PROT((char *, const char *));
extern int	strcmp		__PROT((const char *, const char *));
extern int	strncmp		__PROT((const char *, const char *, size_t));
extern size_t	strlen		__PROT((const char *));
extern time_t	time		__PROT((time_t *));
extern char	*getlogin	__PROT((void));
extern char	*strncpy	__PROT((char *, const char *, size_t));
extern char	*ttyname	__PROT((int));
extern uid_t	getuid		__PROT((void));
extern gid_t	getgid		__PROT((void));
extern int	setgid		__PROT((gid_t));
extern int	getopt		__PROT((int, char * const *, const char *));
extern utmp_s	*getutent	__PROT((void));
extern void	endutent	__PROT((void));
extern struct passwd  *getpwuid	__PROT((uid_t));
extern struct passwd  *getpwnam	__PROT((const char *));
#ifndef toupper			/* damn #defines in non __STDC__ ... */
    extern int	toupper		__PROT((int));
    extern int	tolower		__PROT((int));
#endif


/*
 *	local prototypes
 */

    /* main.c */
void	who_main		__PROT((int, char *[]));
    /* init.c */
void	add_envopt		__PROT((int *, char **[], char *));
void	parse_options		__PROT((int, int, char *[], char **,
					char **, char **, char **));
void	parse_format		__PROT((char *));
    /* getfile.c */
int	compare_utmp		__PROT((const void *, const void *));
int	compare_friends		__PROT((const void *, const void *));
int	compare_users		__PROT((const void *, const void *));
void	get_utmp		__PROT((int));
void	get_friends		__PROT((char *));
void	get_passwd		__PROT((char *));
    /* print.c */
void	print_output		__PROT((char *, char *));
void	who_am_I		__PROT((void));
    /* various.c */
void	errmesg			__PROT((char *, char *));
void	errexit			__PROT((char *, char *));
char	*get_username		__PROT((void));
char	*convert_realname	__PROT((char *, char *, int));
char	*strnc0py		__PROT((char *, char *, size_t));
