/*
 *  main.c - what's this?
 *
 *  Copyright (C) 1997-2004 John Coppens (john@jcoppens.com)
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <getopt.h>

#include "interface.h"
#include "support.h"
#include "global.h"
#include "conf.h"
#include "main.h"

GtkWidget *MainWindow;
GtkWidget *nav_window;

char	newbook[200] = "";


void
show_help(void)
{
  printf(_("\n------ .cbr/.cbz Pager %s ------\n"), prog_version);
  printf(_("(c) John Coppens 2004\n\n"));
  printf(_("Usage:  cbrpager [options] [file]\n\n"));
  printf(_("  -d         Enables extra debugging messages\n"));
  printf(_("  -? (or -h) This help text\n"));
  printf(_("  file       File to show\n\n"));
  gtk_exit(0);
}

void
check_params(int argc, char *argv[])
{
  int i, c;

  while ((i = getopt (argc, argv, "dh?")) != EOF) {
    switch (i) {
      case 'd': debug = 1;
	break;
      case '?':
      case 'h':
        show_help();
        break;
    }
  }

  // Process non-option argument(s)
  pref.explicit_file = FALSE;
  switch (argc - optind) {
    case 0: 		// no file specified
      break;
    case 1:		// exactly 1 filename
      strncpy(newbook, argv[optind], sizeof(newbook));
      pref.explicit_file = TRUE;
      break;
    default:
      show_help();
  }
}

int
main (int argc, char *argv[])
{

#ifdef ENABLE_NLS
  bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);
#endif

  check_params(argc, argv);

  gnome_program_init (PACKAGE, VERSION, LIBGNOMEUI_MODULE,
                      argc, argv,
                      GNOME_PARAM_APP_DATADIR, PACKAGE_DATA_DIR,
                      NULL);

  /*
   * The following code was added by Glade to create one of each component
   * (except popup menus), just so that you see something after building
   * the project. Delete any components that you don't want shown initially.
   */
  load_config();
  if (pref.explicit_file)
    strncpy(pref.lastbook, newbook, sizeof(pref.lastbook));

  MainWindow = create_MainWindow ();
  gtk_window_resize(GTK_WINDOW(MainWindow),
		pref.initwidth, pref.initheight);
  gtk_widget_show(MainWindow);

  nav_window = create_nav_window ();
  gtk_window_set_decorated(GTK_WINDOW(nav_window), FALSE);
  gtk_window_set_transient_for(GTK_WINDOW(nav_window), 
		GTK_WINDOW(MainWindow));
  if (!pref.nav_hidden) 
    gtk_widget_show(nav_window);

  update_nav_position();
  install_timer();

  gtk_main();
  return 0;
}

