/* cdw
 * Copyright (C) 2002 Varkonyi Balazs
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <ncursesw/ncurses.h>
#include <fcntl.h>
#include <nl_types.h>
#include <libintl.h>
#include "options.h"
#include "gettext.h"
#include "config.h"
#include "zlib.h"
#include "log.h"
#include "main.h"


struct conf config;
WINDOW *logwin, *logmain;
extern WINDOW* mainwin;






void read_lines(int pos, int left, char *infile)
{
    int linenum=0, x=0, fill;
    char *line, *oldline;
    FILE *log;

    if ( (log=fopen(infile,"r") )==NULL ) {
	endwin();
	fprintf(stderr, _("Cannot open file...\n"));
	exit(-1);
    }
    line=(char *)malloc(1024);
    oldline=(char *)malloc(1024);

    while ( (linenum <= pos+18) && ((line=fgets(line, 256, log))!=NULL) ){
	    if (linenum>=pos) {
		    for (fill=0; fill<strlen(line); fill++)
			    if ( line[fill]=='\t' ) {
				    line[fill]=' ';
				    strcpy(oldline, line);
				    oldline[fill]='\0';
				    sprintf(line, "%s", line+fill);
				    sprintf(oldline, "%s        %s", oldline, line);
				    sprintf(line, "%s", oldline);
			    }
		    if ( strlen(line)>=left )
			    mvwprintw(logmain, x++, 0, "%s", (char *)line+left);
		    else
			    mvwprintw(logmain, x++, 0, " ");
	    }
	    linenum++;
    }
    fclose(log);
    free(line);
}

void log_window(char *title, char *infile, int is_zipped)
{
    int c, pos=0, left=0, maxline=0;
    char *line;
    FILE *log;

    if ( (log=fopen(infile, "r"))!=NULL ) {
	line=(char *)malloc(256);
	while ( (fgets(line, 250, log)!=NULL) ){
		maxline++;
	}
	fclose(log);
	logwin=newwin(20,76,(LINES-20)/2,(COLS-76)/2);
	wbkgd(logwin, COLOR_PAIR(2));
	werase(logwin);
	box(logwin,0,0);
	keypad(logwin, TRUE);
	logmain=newwin(18,72,(LINES-18)/2,((COLS-72)/2)-1);
	wbkgd(logmain, COLOR_PAIR(6));
	werase(logmain);
	keypad(logmain, TRUE);
	mvwaddch(logwin, 0, 2, ACS_RTEE);
	mvwprintw(logwin, 0, 3, " %s ", title);
        waddch(logwin, ACS_LTEE);

	read_lines(pos, left, infile);
	wrefresh(logwin);
	wrefresh(logmain);

	while ( (c = wgetch(logmain)) != CDW_ESCAPE ){
	    switch(c){
		case KEY_DOWN:
		    if ( pos+18<maxline) {
			werase(logmain);
			read_lines(++pos, left, infile);
		    }
		    break;
		case KEY_UP:
		    if ( pos>0 ) {
			werase(logmain);
			read_lines(--pos, left, infile);
		    }
		    break;
		case KEY_RIGHT:
		    werase(logmain);
		    read_lines(pos, ++left, infile);
		    break;
		case KEY_LEFT:
		    if ( left>0 ) {
			werase(logmain);
			read_lines(pos, --left, infile);
		    }
		    break;
	    }
	    wrefresh(logmain);
	}
	delwin(logmain);
	delwin(logwin);
    }
    wrefresh(derwin(mainwin, LINES - 1, COLS - 1, 0, 0));
    select_window(FALSE);
    return;
}
