/* WorkingAreaPanel.m
 * Panel for input of working area
 *
 * Copyright 1996-2003 by vhf interservice GmbH
 * Author:   Georg Fleischmann
 *
 * created:  2000-08-24
 * modified: 2003-06-26
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the vhf Public License as
 * published by vhf interservice GmbH. Among other things, the
 * License requires that the copyright notices and this notice
 * be preserved on all copies.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the vhf Public License for more details.
 *
 * You should have received a copy of the vhf Public License along
 * with this program; see the file LICENSE. If not, write to vhf.
 *
 * vhf interservice GmbH, Im Marxle 3, 72119 Altingen, Germany
 * eMail: info@vhf.de
 * http://www.vhf.de
 */

#include <AppKit/AppKit.h>
#include <VHFShared/VHFSystemAdditions.h>
#include <VHFShared/vhfCommonFunctions.h>
#include "WorkingAreaPanel.h"
#include "App.h"
#include "functions.h"
#include "DocView.h"

@interface WorkingAreaPanel(PrivateMethods)
@end

@implementation WorkingAreaPanel


/*
 * modified: 1995-10-16
 */
- (void)setWorkingArea:sender
{   id		view = [[(App*)NSApp currentDocument] documentView];
    float	width, height, scale = [view scaleFactor];

    width  = convertFromUnit([[sizeMatrix cellAtRow:0 column:0] floatValue]) * scale;
    height = convertFromUnit([[sizeMatrix cellAtRow:1 column:0] floatValue]) * scale;
    [view setFrameSize:NSMakeSize(width, height)];
    [view drawAndDisplay];
    [[(App*)NSApp currentDocument] setDirty:YES];
}

/*
 * modified: 1995-10-16
 * updatePreferencesPanel: is used to copy the existing situation into
 * the Prefences panel.
 */
- (void)update:sender
{   id		view = [[(App*)NSApp currentDocument] documentView];
    NSRect	bRect = [view bounds];
    float	v;

    v = convertToUnit(bRect.size.width);
    [[sizeMatrix cellAtRow:0 column:0] setStringValue:buildRoundedString(v, 0.0, MMToInternal(10000.0))];
    v = convertToUnit(bRect.size.height);
    [[sizeMatrix cellAtRow:1 column:0] setStringValue:buildRoundedString(v, 0.0, MMToInternal(10000.0))];
}

@end
