import time
import thread

from lib.common import *
from lib.accountmanager import AccountManager

# checkers
from imapchecker import IMAPChecker
from pop3checker import POP3Checker
from gmailchecker import GmailChecker

		
class Checker:
	def __init__(self, notifier):
		self.notifier = notifier
		self.checkers = {} # account_id: checker, messages_count
		self.checking = False
		self.status_cbs = []
	
	def add_status_cb(self, cb):
		self.status_cbs.append(cb)
	
	def remove_status_cb(self,cb):
		self.status_cbs.remove(cb)

	def set_no_accounts_cb(self, cb):
		self.no_accounts_cb = cb

	def init_checkers(self, no_accounts_cb):
		"""
		Build checkers list.
		"""
		#self.checkers = []
		
		am = AccountManager().get_manager()
		accounts = am.get_accounts_dicts()
		if accounts is None or len(accounts) == 0:
			self.checkers = {}
			if no_accounts_cb is not None:
				no_accounts_cb()
			# nothing more to do
			return

		
		id_list = []
		for account in accounts:
			id_list.append(account["id"])

			needed_keys = ["type", "username", "password", "enabled"]
			has_needed = True
			for k in needed_keys:
				if not account.has_key(k):
					print "Warnig: bad configration"
					has_needed = False
					break

			if not has_needed: continue

			if account["enabled"] == "0":
				# we no more want this checker
				if self.checkers.has_key(account["id"]):
					del self.checkers[account["id"]]
				continue

			if account["id"] in self.checkers.keys():
				# We already have a checker for this account
				checker, msg_count = self.checkers[account["id"]]
				checker.update_info(account)
				continue

			if account["type"] == "gmail":
				tmp = GmailChecker(self.notifier, account["id"], self.set_status,
							account["username"], 
							account["password"])
				self.checkers[account["id"]] = [tmp, 0]
			elif account["type"] == "pop3" or account["type"] == "imap":
				user = account["username"]
				passw = account["password"]
				if not account.has_key("server"):
					print "Warnig: bad configration"
					continue
				server = account["server"]
				ssl = False
				if account.has_key("ssl"):
					if account["ssl"] == "1":
						ssl = True
					elif account["ssl"] == "0":
						ssl = False
				if account["type"] == "pop3":
					port = 110 # default pop3 port
					if account.has_key("port"):
						port = account["port"]

					tmp = POP3Checker(self.notifier, account["id"], self.set_status,
							user, passw, server, port, ssl)
				else:
					port = 143 # default imap port
					if account.has_key("port"):
						port = account["port"]
					#imap
					if account["use_default_mbox"] == "1":

						tmp = IMAPChecker(self.notifier, account["id"], 
								self.set_status,
								user, passw, 
								server, port, ssl, True)
					else:
						mbox = account["mbox"]
						tmp = IMAPChecker(user, passw, 
								server, port, 
								ssl, False, mbox)
				self.checkers[account["id"]] = [tmp, 0]
			else:
				print "Error: unrecognized account type"
		
		# remove checker if the account no more exist
		for id in self.checkers.keys():
			if id not in id_list:
				del self.checkers[id]

		
	def reset(self):
		for account_id, values in self.checkers.iteritems():
			checker = values[0]
			checker.reset()
		for cb in self.status_cbs:
			cb(0, None, None)
	
	def set_status(self, account_id, messages_count, title, message):
		"""
		This method is only called by BaseChecker
		"""
		checker, msgs = self.checkers[account_id]
		self.checkers[account_id] = [checker, messages_count]

		total = 0
		for checker, count in self.checkers.values():
			total += count

		if message != "":
			self.notifier.notify(title, message, msec = 10000)
		
			for cb in self.status_cbs:
				cb(total, title, message)
		else:
			# only update count
			for cb in self.status_cbs:
				cb(total, None, None)

	
	def check(self):
		self.init_checkers(None)

		mailslists = []
		for account_id, values in self.checkers.iteritems():
			checker = values[0]
			thread.start_new_thread(checker.check, ())
			#checker.check()
		
	
if __name__ == "__main__":
	c = Checker()
	c.check()
