/*
** This code is for the color information dialog box.
** ff, 1998.
*/

#include <gtk/gtk.h>

void delete_event (GtkWidget *widget, GdkEvent *event, gpointer *data);


void kill_box(GtkWidget *widget, GdkEvent *event, gpointer *data)
{
	gtk_main_quit();
	gtk_widget_destroy(GTK_WIDGET(widget));
}

void color_info(GtkWidget *widget, gpointer *colorsel)
{
	gdouble data[3];
	int red, green, blue;
	char rgb[32], hex[32];

	GtkWidget *window, *button, *title, *box, *values,
		*string, *separator, *quitbox;


	gtk_color_selection_get_color(GTK_COLOR_SELECTION(colorsel),
		(gdouble *)&data);
	

/* Put together the RGB values in base 10 */
	sprintf(rgb, "%.0f", data[0]*255.0);
	red = atoi(rgb);
	sprintf(rgb, "%.0f", data[1]*255.0);
	green = atoi(rgb);
	sprintf(rgb, "%.0f", data[2]*255.0);
	blue = atoi(rgb);

	sprintf(rgb, "\nRGB (base 10):   %.3d %.3d %.3d", red, green, blue);


/* Put together the RGB string in hex notation */
	sprintf(hex, "Hex string:   #%.2x%.2x%.2x\n", red, green, blue);


	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title (GTK_WINDOW(window), "Color Info");

	gtk_signal_connect (GTK_OBJECT (window), "delete_event",
		GTK_SIGNAL_FUNC (delete_event), NULL);
	gtk_container_border_width (GTK_CONTAINER (window), 15);

	box = gtk_vbox_new (FALSE, 0);
 
 	title = gtk_label_new("Color Information\n");
	gtk_box_pack_start (GTK_BOX (box), title, FALSE, FALSE, 0);
	gtk_widget_show (title);

	separator = gtk_hseparator_new ();
	gtk_box_pack_start (GTK_BOX (box), separator, FALSE, TRUE, 5);
	gtk_widget_show (separator);

	values = gtk_label_new(rgb);
	gtk_misc_set_alignment(GTK_MISC(values), 0, 0);
	gtk_box_pack_start (GTK_BOX (box), values, FALSE, FALSE, 0);
	gtk_widget_show (values);

	string = gtk_label_new(hex);
	gtk_misc_set_alignment(GTK_MISC(string), 0, 0);
	gtk_box_pack_start (GTK_BOX (box), string, FALSE, FALSE, 0);
	gtk_widget_show (string);

	separator = gtk_hseparator_new ();
	gtk_box_pack_start (GTK_BOX (box), separator, FALSE, TRUE, 5);
	gtk_widget_show (separator);

	quitbox = gtk_hbox_new (FALSE, 0);

	button = gtk_button_new_with_label ("   Got it   ");

	gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
		(GtkSignalFunc)kill_box, GTK_OBJECT(window));

	gtk_box_pack_start (GTK_BOX (quitbox), button, TRUE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (box), quitbox, FALSE, FALSE, 0);

	gtk_container_add (GTK_CONTAINER (window), box);

	gtk_widget_show (button);
	gtk_widget_show (quitbox);

	gtk_widget_show (box);
	gtk_widget_show (window);

	gtk_main ();
}
