#!/usr/bin/python

#~ JollyBOX chat+ client
#~ Copyright (C) 2006 Thomas Jollans
#~
#~ This program is free software; you can redistribute it and/or modify
#~ it under the terms of the GNU General Public License version 2 as 
#~ published by the Free Software Foundation
#~
#~ This program is distributed in the hope that it will be useful,
#~ but WITHOUT ANY WARRANTY; without even the implied warranty of
#~ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#~ GNU General Public License for more details.
#~
#~ You should have received a copy of the GNU General Public License
#~ along with this program; if not, write to the Free Software
#~ Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

from chatclient import *

import gobject
import gtk
import gtk.glade

HAVE_TRAY = True
try:
    # have gnome ?
    import egg.trayicon as trayicon
except:
    try:
        # have trayicon.so built (*nix after 'make' run)
        import trayicon
    except:
        HAVE_TRAY = False

HAVE_NOTIFY = HAVE_TRAY
try:
    import pynotify
except ImportError:
    HAVE_NOTIFY = False


class ConnectDialog:
    def __init__ ( self, glade, chatwin ) :
        self.glade = glade
        self.glade.signal_autoconnect ( self )
        self.me = self.glade.get_widget ( "connectdialog" )
        #self.chatwin = self.glade.get_widget ( "chatwindow" )
        self.chatwin = chatwin
        #self.chatwin.hide ()
        
    def show ( self ):
        self.me.show ()
        
    def die ( self, w = None, e = None ):
        sys.exit ( )
        
    def connect(  self, b=None ):
        server = self.glade.get_widget ( "txt_server" ).get_text ()
        port = self.glade.get_widget ( "txt_port" ).get_text ()
        name = self.glade.get_widget ( "txt_name" ).get_text ()
        portno = int ( port)
        c = ChatRoom ( server, portno, name )
        #cw = ChatWindow ( self.glade, c )
        #thread.start_new_thread( c.mainloop, (c,) ) 
        self.chatwin.show (c)
        self.me.hide ()

class ChatWindow:
    def __init__ (self, glade):
        self.glade = glade
        self.glade.signal_autoconnect ( self )
        self.me = self.glade.get_widget ( "chatwindow" )
        self.dcdialog = self.glade.get_widget ( "disconnectdialog" )
        self.textview = glade.get_widget ( "txt_chat" )
        self.textbuf = self.textview.get_buffer ()
        self.txt_msg = glade.get_widget ( "txt_msg" )
        self.cmb_sendto = glade.get_widget ( "cmb_sendto" )

        if HAVE_TRAY:
            tray = trayicon.TrayIcon("chat+")
            icon = gtk.Image()
            icon.set_from_file("pixmaps/icon.png")
            eb = gtk.EventBox()
            eb.set_visible_window(False)
            eb.set_events(gtk.gdk.POINTER_MOTION_MASK)
            eb.connect("button-press-event", self.tray_clicked)
            eb.add(icon)
            tray.add(eb)
            tray.show_all()
            self.icon = icon
            self.visible = True
            if HAVE_NOTIFY:
                pynotify.init("chat+")

    def tray_clicked(self, what, ev):
        if self.visible:
            self.me.hide()
        else:
            self.me.show()

        self.visible = not self.visible
        
    def set_cnndialog (self, cnndialog):
        self.cnndialog = cnndialog
        
    def show ( self, chatroom ):
        self.room = chatroom
        self.room.print_cb ( self.printline )
        self.room.info_cb ( self.got_info )
        self.room.user_status_cb ( self.new_userstat )
        self.room.shutdown_cb ( self.shutdown )
        self.room.request_info ( TJC_INFO_VERSION )
        self.room.request_info ( TJC_INFO_CLIENTS )
        
        loopfuncz.append ( chatroom.main_iteration )
        self.textbuf.set_text ( "" )
        port = self.room.get_port()
        if port == TJC_DEFAULT_PORT:
            self.glade.get_widget ( "lbl_server" ).set_markup ( "Connected to: <b>" +
                self.room.get_server() + "</b>" )
        else:
            self.glade.get_widget ( "lbl_server" ).set_markup ( "Connected to: <b>" +
                self.room.get_server() + "</b>:" + str ( port ) )
        self.glade.get_widget ( "lbl_name" ).set_markup ( "as: <b>" +
            self.room.get_name()+ "</b>" )
        self.init_sendto ( [] )
        self.me.show ()
        
    def init_sendto ( self, clients ):
        self.cmb_sendto.get_model().clear()
        self.cmb_sendto.append_text("to everyone")
        for cl in clients:
            self.cmb_sendto.append_text ('to "' + cl + '"')
        self.cmb_sendto.set_active (0)
            
    def got_info ( self, type, data ):
        if type == TJC_INFO_ROOMNAME:
            self.glade.get_widget ( "lbl_room" ).set_markup ( "Room Name: <b>" +
                data + "</b>" )
        elif type == TJC_INFO_VERSION:
            self.glade.get_widget ( "lbl_server_ver" ).set_markup (
                "Server ver.: <b>" + data + "</b>" )
        elif type == TJC_INFO_CLIENTS:
            self.init_sendto ( data )
    
    def new_userstat ( self, type, data ):
        if type == TJC_USER_NEW:
            self.printline ( '*** "' + data + '" joins chat.' )
            self.cmb_sendto.append_text ( 'to "' + data + '"' )
        elif type == TJC_USER_GONE:
            self.printline ( '*** "' + data + '" has left.' )
            model = self.cmb_sendto.get_model()
            #self.cmb_sendto.get_model().foreach (self.__userdel, 'to "' + data + '"' )
            #self.cmb_sendto.get_model().foreach (self.__userdel, None )
            
            #self.cmb_sendto.remove_text ( 'to "' + data + '"' )
            lookfor = 'to "' + data + '"'
            i = model.get_iter_first()
            while model.iter_is_valid(i):
                val = model.get_value(i,0)
                #print val
                if val == lookfor:
                    #print "gotcha"
                    break
                i = model.iter_next ( i )
            model.remove (i)
    
    def printline ( self, msg ):
        # stupid implementation.
        start,end = self.textbuf.get_bounds()
        self.textbuf.set_text ( self.textbuf.get_text (start, end) + msg + "\n")
        self.textview.scroll_to_iter(self.textbuf.get_end_iter(),0)
        
        if HAVE_NOTIFY and not self.visible:
            n = pynotify.Notification( msg.replace('<','&lt;').replace('>','&gt;'), '',
                    os.getcwd()+'/pixmaps/icon.svg',self.icon)
            n.show()
            sys.stdout.write('\a')
            sys.stdout.flush()
        
    def sendmsg (self, b=None):
        comboval = self.cmb_sendto.get_model().get_value(
            self.cmb_sendto.get_active_iter(), 0 )
        if comboval == "to everyone":
            self.room.send_msg ( self.txt_msg.get_text() )
        else:
            self.room.send_private_msg ( comboval[4:][:-1], self.txt_msg.get_text())
        self.txt_msg.set_text ( "" )
        self.cmb_sendto.set_active (0)
    
    def disconnect ( self, w=None, e = None ):
        self.dcdialog.show ()
        return True
        
    def disconnect_cancel ( self, b=None ):
        self.dcdialog.hide ()
        
    def disconnect_ok ( self, b=None ):
        self.dcdialog.hide ()
        self.room.disconnect ()
        self.shutdown ()
        
    def shutdown ( self ):
        self.me.hide ()
        loopfuncz.remove ( self.room.main_iteration )
        self.cnndialog.show ()

if __name__ == '__main__':
    gladexml = gtk.glade.XML ( "jollypychat.glade" )

    cw = ChatWindow ( gladexml )
    c = ConnectDialog ( gladexml, cw )
    cw.set_cnndialog ( c )


    while True:
        gtk.main_iteration ()
        for f in loopfuncz:
            f()
    

