/*
###
### This file is part of
###
###                        TurboLinux  ZWinPro
###
###                 Copyright (C) 1999-2000 TurboLinux, Inc.
###                        All Rights Reserved
### Distributed under the terms of the GNU General Public License (GPL)
###
###
### Authors:     TurboLinux Chinese Development Team:
###              Justin Yu   <justiny@turbolinux.com.cn>
###              Sean Chen   <seanc@turbolinux.com.cn>
###              Daniel Fang <danf@turbolinux.com.cn>
###
*/
/* KanjiPad - Japanese handwriting recognition front end
 * Copyright (C) 1997 Owen Taylor
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "all.h"


static int engine_pid;
static FILE *from_engine;
static FILE *to_engine;

int HZinitHWEngine(void)
{
	int in_fd[2];
	int out_fd[2];

	if (pipe(in_fd)) fprintf(stderr, "Can't create pipe.\n");
	if (pipe(out_fd)) fprintf(stderr, "Can't create pipe.\n");

	engine_pid = fork ();
	if (engine_pid == (pid_t) 0) { /* child */
		close (in_fd[1]);
		close (out_fd[0]);
      
		dup2 (in_fd[0], STDIN_FILENO);
		dup2 (out_fd[1], STDOUT_FILENO);

		if(getenv("LC_ALL") && strstr(getenv("LC_ALL"), "zh_TW"))
			execlp ("kpengine","/usr/bin/kpengine", 
				"/usr/lib/ZWinPro/hzbig5.dat", NULL);
		else
			execlp ("kpengine","/usr/bin/kpengine", 
				"/usr/lib/ZWinPro/hzgb.dat", NULL);
	} else if (engine_pid < (pid_t) 0) /* failure */
		fprintf(stderr, "Fork failed.\n");

	/* Parent process */

	close (in_fd[0]);
	close (out_fd[1]);

	if (!(to_engine = fdopen (in_fd[1], "w")))
		fprintf(stderr,"Couldn't create pipe to child process.\n");
	if (!(from_engine = fdopen (out_fd[0], "r")))
		fprintf(stderr,"Couldn't create pipe from child process.\n");

	return 1;
}

void HZhwToEnginePoint(int x, int y)
{
	if(to_engine){
		fprintf(to_engine, "%d %d ", x, y);
		fflush(to_engine);
	}

}

void HZhwToEngineNewLine(void)
{
	if(to_engine){
		fprintf(to_engine, "\n");
		fflush(to_engine);
	}
}

int HZhwRecognize(void)
{
	int i, num;
	char line[80];

	if(!from_engine) return 0;
	if(!fgets(line, 80, from_engine)) return 0;
	num = (strlen(line) - 1)/2;
	if(num == 0) return 0;
	if(num >  5) num = 5;
	hw_activekeys = num;
	for(i=0; i<num; i++){
		if(HZServer.encoding == HZSERVER_ENCODING_BIG5){
			hwkeys[8+i].blabel[0] = line[i*2];
			hwkeys[8+i].blabel[1] = line[i*2+1];
			hwkeys[8+i].blabel[2] = '\0';
		} else {
			hwkeys[8+i].label[0] = line[i*2];
			hwkeys[8+i].label[1] = line[i*2+1];
			hwkeys[8+i].label[2] = '\0';
		}
	}
	flag_sent = False;

  	return 1;
}
