#include "cp_types.h"
#include "cp_proto.h"

/* ======================= save adjacency matrix ============= */
/* Save adjacency matrix of packing (<= 300 verts) in form for
   matlab */

int adjacency(FILE *fp,struct p_data *p)
{
  int i,j;

  if (p->nodecount>300) 
    {
      sprintf(msgbuf,"Packing has over 300 vertices; too large "
	      "for 'adjacency' call.");
      emsg();
      return 0;
    }
  fprintf(fp,"%% adjacency matrix for a circle packing generated by "
	  "CirclePack; %d vertices\n\n",
	  p->nodecount);
  fprintf(fp,"A=zeros(%d,%d);\n",p->nodecount,p->nodecount);
  for (i=1;i<=p->nodecount;i++)
    for (j=1;j<=p->nodecount;j++)
      if (nghb(p,i,j)>=0) fprintf(fp,"A(%d,%d)=1;\n",i,j);
  fprintf(fp,"%% end\n");
  return 1;
} /* adjacency */



