#include "cp_types.h"
#include "cp_proto.h"

/* Note: inv_dist routines not very robust */

double comp_inv_dist(struct p_data *p,int v,int w)
{
  double erad1,erad2;
  complex ectr1,ectr2;

  if (v<1 || w<1 || v>p->nodecount || w>p->nodecount
      || nghb(p,v,w)< 0)
    return 1.0; /* tangency, default */
  if (p->hes<0) /* hyperbolic */
    {
      h_to_e_data(p->packR_ptr[v].center,
		  p->packR_ptr[v].rad,&ectr1,&erad1);
      h_to_e_data(p->packR_ptr[w].center,
		  p->packR_ptr[w].rad,&ectr2,&erad2);
    }
  else if (p->hes>0) /* spherical */
    {
      s_to_e_data(p->packR_ptr[v].center,
		  p->packR_ptr[v].rad,&ectr1,&erad1);
      s_to_e_data(p->packR_ptr[w].center,
		  p->packR_ptr[w].rad,&ectr2,&erad2);
    }
  else
    {
      ectr1=p->packR_ptr[v].center;
      erad1=p->packR_ptr[v].rad;
      ectr2=p->packR_ptr[w].center;
      erad2=p->packR_ptr[w].rad;
    }
  return (inv_dist(ectr1,fabs(erad1),ectr2,fabs(erad2)));
} /* comp_inv_dist */
