#include "cp_types.h"
#include "cp_proto.h"

/* Go through packing by drawing order or through given vert list
   and adjust centers based on locations of neighbors. Hope is to 
   correct defects.

   passes=n>0 means go through layout n times, adjusting each center
   based on average of all locations using pairs of neighbors. Leave
   'first_face' fixed. With several repeats, this may adjust global 
   problems (e.g., spread out errors, even perhaps for multiply-connected 
   cases without global embedding). */

int molify_pack_centers(struct p_data *p,int passes,
			struct Vertlist *vertlist)
{
  int nf,n,vert,count=1;
  struct Vertlist *vtrace;
  struct K_data *pK_ptr;
  f_data *faces;

  pK_ptr=p->packK_ptr;faces=p->faces;
  nf=p->first_face;

  if (passes<1) return 0;
  for (n=1;n<=passes;n++)
    {
      count=1;
      if ((vtrace=vertlist))
	{
	  while (vtrace)
	    {
	      count += molify_center(p,vtrace->v);
	      vtrace=vtrace->next;
	    }
	}
      else
	{
	  nf=p->first_face;
	  while ( (nf=faces[nf].next_face)!=p->first_face 
		  && nf>0 && nf<=p->facecount && count<2*p->facecount)
	    {
	      vert=p->faces[nf].vert[(p->faces[nf].index_flag +2) % 3];
	      count += molify_center(p,vert);
	    }
	}
    }
  return count;
} /* modify_pack_centers */
