C FISHPK10 FROM PORTLIB                                  12/30/83
      SUBROUTINE HSTSSP (A,B,M,MBDCND,BDA,BDB,C,D,N,NBDCND,BDC,BDD,
     1                   ELMBDA,F,IDIMF,PERTRB,IERROR,W)
C
C
C     * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
C     *                                                               *
C     *                        F I S H P A K                          *
C     *                                                               *
C     *                                                               *
C     *     A PACKAGE OF FORTRAN SUBPROGRAMS FOR THE SOLUTION OF      *
C     *                                                               *
C     *      SEPARABLE ELLIPTIC PARTIAL DIFFERENTIAL EQUATIONS        *
C     *                                                               *
C     *                  (VERSION 3.1 , OCTOBER 1980)                  *
C     *                                                               *
C     *                             BY                                *
C     *                                                               *
C     *        JOHN ADAMS, PAUL SWARZTRAUBER AND ROLAND SWEET         *
C     *                                                               *
C     *                             OF                                *
C     *                                                               *
C     *         THE NATIONAL CENTER FOR ATMOSPHERIC RESEARCH          *
C     *                                                               *
C     *                BOULDER, COLORADO  (80307)  U.S.A.             *
C     *                                                               *
C     *                   WHICH IS SPONSORED BY                       *
C     *                                                               *
C     *              THE NATIONAL SCIENCE FOUNDATION                  *
C     *                                                               *
C     * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
C
C
C    * * * * * * * * *  PURPOSE    * * * * * * * * * * * * * * * * * *
C
C     HSTSSP SOLVES THE STANDARD FIVE-POINT FINITE DIFFERENCE
C     APPROXIMATION ON A STAGGERED GRID TO THE HELMHOLTZ EQUATION IN
C     SPHERICAL COORDINATES AND ON THE SURFACE OF THE UNIT SPHERE
C     (RADIUS OF 1)
C
C             (1/SIN(THETA))(D/DTHETA)(SIN(THETA)(DU/DTHETA)) +
C
C       (1/SIN(THETA)**2)(D/DPHI)(DU/DPHI) + LAMBDA*U = F(THETA,PHI)
C
C     WHERE THETA IS COLATITUDE AND PHI IS LONGITUDE.
C
C    * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
C
C    * * * * * * * *    PARAMETER DESCRIPTION     * * * * * * * * * *
C
C            * * * * * *   ON INPUT    * * * * * *
C
C   A,B
C     THE RANGE OF THETA (COLATITUDE), I.E. A .LE. THETA .LE. B.  A
C     MUST BE LESS THAN B AND A MUST BE NON-NEGATIVE.  A AND B ARE IN
C     RADIANS.  A = 0 CORRESPONDS TO THE NORTH POLE AND B = PI
C     CORRESPONDS TO THE SOUTH POLE.
C
C
C                  * * *  IMPORTANT  * * *
C
C     IF B IS EQUAL TO PI, THEN B MUST BE COMPUTED USING THE STATEMENT
C
C     B = PIMACH(DUM)
C
C     THIS INSURES THAT B IN THE USER"S PROGRAM IS EQUAL TO PI IN THIS
C     PROGRAM WHICH PERMITS SEVERAL TESTS OF THE INPUT PARAMETERS THAT
C     OTHERWISE WOULD NOT BE POSSIBLE.
C
C                  * * * * * * * * * * * *
C
C
C
C   M
C     THE NUMBER OF GRID POINTS IN THE INTERVAL (A,B).  THE GRID POINTS
C     IN THE THETA-DIRECTION ARE GIVEN BY THETA(I) = A + (I-0.5)DTHETA
C     FOR I=1,2,...,M WHERE DTHETA =(B-A)/M.  M MUST BE GREATER THAN 2.
C
C   MBDCND
C     INDICATES THE TYPE OF BOUNDARY CONDITIONS AT THETA = A AND
C     THETA = B.
C
C     = 1  IF THE SOLUTION IS SPECIFIED AT THETA = A AND THETA = B.
C          (SEE NOTE 3 BELOW)
C
C     = 2  IF THE SOLUTION IS SPECIFIED AT THETA = A AND THE DERIVATIVE
C          OF THE SOLUTION WITH RESPECT TO THETA IS SPECIFIED AT
C          THETA = B (SEE NOTES 2 AND 3 BELOW).
C
C     = 3  IF THE DERIVATIVE OF THE SOLUTION WITH RESPECT TO THETA IS
C          SPECIFIED AT THETA = A (SEE NOTES 1, 2 BELOW) AND THETA = B.
C
C     = 4  IF THE DERIVATIVE OF THE SOLUTION WITH RESPECT TO THETA IS
C          SPECIFIED AT THETA = A (SEE NOTES 1 AND 2 BELOW) AND THE
C          SOLUTION IS SPECIFIED AT THETA = B.
C
C     = 5  IF THE SOLUTION IS UNSPECIFIED AT THETA = A = 0 AND THE
C          SOLUTION IS SPECIFIED AT THETA = B.  (SEE NOTE 3 BELOW)
C
C     = 6  IF THE SOLUTION IS UNSPECIFIED AT THETA = A = 0 AND THE
C          DERIVATIVE OF THE SOLUTION WITH RESPECT TO THETA IS
C          SPECIFIED AT THETA = B (SEE NOTE 2 BELOW).
C
C     = 7  IF THE SOLUTION IS SPECIFIED AT THETA = A AND THE
C          SOLUTION IS UNSPECIFIED AT THETA = B = PI. (SEE NOTE 3 BELOW)
C
C     = 8  IF THE DERIVATIVE OF THE SOLUTION WITH RESPECT TO
C          THETA IS SPECIFIED AT THETA = A (SEE NOTE 1 BELOW)
C          AND THE SOLUTION IS UNSPECIFIED AT THETA = B = PI.
C
C     = 9  IF THE SOLUTION IS UNSPECIFIED AT THETA = A = 0 AND
C          THETA = B = PI.
C
C     NOTES:  1.  IF A = 0, DO NOT USE MBDCND = 3, 4, OR 8,
C                 BUT INSTEAD USE MBDCND = 5, 6, OR 9.
C
C             2.  IF B = PI, DO NOT USE MBDCND = 2, 3, OR 6,
C                 BUT INSTEAD USE MBDCND = 7, 8, OR 9.
C
C             3.  WHEN THE SOLUTION IS SPECIFIED AT THETA = 0 AND/OR
C                 THETA = PI AND THE OTHER BOUNDARY CONDITIONS ARE
C                 COMBINATIONS OF UNSPECIFIED, NORMAL DERIVATIVE, OR
C                 PERIODICITY A SINGULAR SYSTEM RESULTS.  THE UNIQUE
C                 SOLUTION IS DETERMINED BY EXTRAPOLATION TO THE
C                 SPECIFICATION OF THE SOLUTION AT EITHER THETA = 0 OR
C                 THETA = PI.  BUT IN THESE CASES THE RIGHT SIDE OF THE
C                 SYSTEM WILL BE PERTURBED BY THE CONSTANT PERTRB.
C
C   BDA
C     A ONE-DIMENSIONAL ARRAY OF LENGTH N THAT SPECIFIES THE BOUNDARY
C     VALUES (IF ANY) OF THE SOLUTION AT THETA = A.  WHEN
C     MBDCND = 1, 2, OR 7,
C
C              BDA(J) = U(A,PHI(J)) ,              J=1,2,...,N.
C
C     WHEN MBDCND = 3, 4, OR 8,
C
C              BDA(J) = (D/DTHETA)U(A,PHI(J)) ,    J=1,2,...,N.
C
C     WHEN MBDCND HAS ANY OTHER VALUE, BDA IS A DUMMY VARIABLE.
C
C   BDB
C     A ONE-DIMENSIONAL ARRAY OF LENGTH N THAT SPECIFIES THE BOUNDARY
C     VALUES OF THE SOLUTION AT THETA = B.  WHEN MBDCND = 1,4, OR 5,
C
C              BDB(J) = U(B,PHI(J)) ,              J=1,2,...,N.
C
C     WHEN MBDCND = 2,3, OR 6,
C
C              BDB(J) = (D/DTHETA)U(B,PHI(J)) ,    J=1,2,...,N.
C
C     WHEN MBDCND HAS ANY OTHER VALUE, BDB IS A DUMMY VARIABLE.
C
C   C,D
C     THE RANGE OF PHI (LONGITUDE), I.E. C .LE. PHI .LE. D.
C     C MUST BE LESS THAN D.  IF D-C = 2*PI, PERIODIC BOUNDARY
C     CONDITIONS ARE USUALLY PRESCRIBED.
C
C   N
C     THE NUMBER OF UNKNOWNS IN THE INTERVAL (C,D).  THE UNKNOWNS IN
C     THE PHI-DIRECTION ARE GIVEN BY PHI(J) = C + (J-0.5)DPHI,
C     J=1,2,...,N, WHERE DPHI = (D-C)/N.  N MUST BE GREATER THAN 2.
C
C   NBDCND
C     INDICATES THE TYPE OF BOUNDARY CONDITIONS AT PHI = C
C     AND PHI = D.
C
C     = 0  IF THE SOLUTION IS PERIODIC IN PHI, I.E.
C          U(I,J) = U(I,N+J).
C
C     = 1  IF THE SOLUTION IS SPECIFIED AT PHI = C AND PHI = D
C          (SEE NOTE BELOW).
C
C     = 2  IF THE SOLUTION IS SPECIFIED AT PHI = C AND THE DERIVATIVE
C          OF THE SOLUTION WITH RESPECT TO PHI IS SPECIFIED AT
C          PHI = D (SEE NOTE BELOW).
C
C     = 3  IF THE DERIVATIVE OF THE SOLUTION WITH RESPECT TO PHI IS
C          SPECIFIED AT PHI = C AND PHI = D.
C
C     = 4  IF THE DERIVATIVE OF THE SOLUTION WITH RESPECT TO PHI IS
C          SPECIFIED AT PHI = C AND THE SOLUTION IS SPECIFIED AT
C          PHI = D (SEE NOTE BELOW).
C
C     NOTE:  WHEN NBDCND = 1, 2, OR 4, DO NOT USE MBDCND = 5, 6, 7, 8,
C     OR 9 (THE FORMER INDICATES THAT THE SOLUTION IS SPECIFIED AT
C     A POLE; THE LATTER INDICATES THE SOLUTION IS UNSPECIFIED).  USE
C     INSTEAD MBDCND = 1 OR 2.
C
C   BDC
C     A ONE DIMENSIONAL ARRAY OF LENGTH M THAT SPECIFIES THE BOUNDARY
C     VALUES OF THE SOLUTION AT PHI = C.   WHEN NBDCND = 1 OR 2,
C
C              BDC(I) = U(THETA(I),C) ,              I=1,2,...,M.
C
C     WHEN NBDCND = 3 OR 4,
C
C              BDC(I) = (D/DPHI)U(THETA(I),C),       I=1,2,...,M.
C
C     WHEN NBDCND = 0, BDC IS A DUMMY VARIABLE.
C
C   BDD
C     A ONE-DIMENSIONAL ARRAY OF LENGTH M THAT SPECIFIES THE BOUNDARY
C     VALUES OF THE SOLUTION AT PHI = D.  WHEN NBDCND = 1 OR 4,
C
C              BDD(I) = U(THETA(I),D) ,              I=1,2,...,M.
C
C     WHEN NBDCND = 2 OR 3,
C
C              BDD(I) = (D/DPHI)U(THETA(I),D) ,      I=1,2,...,M.
C
C     WHEN NBDCND = 0, BDD IS A DUMMY VARIABLE.
C
C   ELMBDA
C     THE CONSTANT LAMBDA IN THE HELMHOLTZ EQUATION.  IF LAMBDA IS
C     GREATER THAN 0, A SOLUTION MAY NOT EXIST.  HOWEVER, HSTSSP WILL
C     ATTEMPT TO FIND A SOLUTION.
C
C   F
C     A TWO-DIMENSIONAL ARRAY THAT SPECIFIES THE VALUES OF THE RIGHT
C     SIDE OF THE HELMHOLTZ EQUATION.  FOR I=1,2,...,M AND J=1,2,...,N
C
C              F(I,J) = F(THETA(I),PHI(J)) .
C
C     F MUST BE DIMENSIONED AT LEAST M X N.
C
C   IDIMF
C     THE ROW (OR FIRST) DIMENSION OF THE ARRAY F AS IT APPEARS IN THE
C     PROGRAM CALLING HSTSSP.  THIS PARAMETER IS USED TO SPECIFY THE
C     VARIABLE DIMENSION OF F.  IDIMF MUST BE AT LEAST M.
C
C   W
C     A ONE-DIMENSIONAL ARRAY THAT MUST BE PROVIDED BY THE USER FOR
C     WORK SPACE.  W MAY REQUIRE UP TO 13M + 4N + M*INT(LOG2(N))
C     LOCATIONS.  THE ACTUAL NUMBER OF LOCATIONS USED IS COMPUTED BY
C     HSTSSP AND IS RETURNED IN THE LOCATION W(1).
C
C
C            * * * * * *   ON OUTPUT   * * * * * *
C
C   F
C     CONTAINS THE SOLUTION U(I,J) OF THE FINITE DIFFERENCE
C     APPROXIMATION FOR THE GRID POINT (THETA(I),PHI(J)) FOR
C     I=1,2,...,M, J=1,2,...,N.
C
C   PERTRB
C     IF A COMBINATION OF PERIODIC, DERIVATIVE, OR UNSPECIFIED
C     BOUNDARY CONDITIONS IS SPECIFIED FOR A POISSON EQUATION
C     (LAMBDA = 0), A SOLUTION MAY NOT EXIST.  PERTRB IS A CON-
C     STANT, CALCULATED AND SUBTRACTED FROM F, WHICH ENSURES
C     THAT A SOLUTION EXISTS.  HSTSSP THEN COMPUTES THIS
C     SOLUTION, WHICH IS A LEAST SQUARES SOLUTION TO THE
C     ORIGINAL APPROXIMATION.  THIS SOLUTION PLUS ANY CONSTANT IS ALSO
C     A SOLUTION; HENCE, THE SOLUTION IS NOT UNIQUE.  THE VALUE OF
C     PERTRB SHOULD BE SMALL COMPARED TO THE RIGHT SIDE F.
C     OTHERWISE, A SOLUTION IS OBTAINED TO AN ESSENTIALLY DIFFERENT
C     PROBLEM.  THIS COMPARISON SHOULD ALWAYS BE MADE TO INSURE THAT
C     A MEANINGFUL SOLUTION HAS BEEN OBTAINED.
C
C   IERROR
C     AN ERROR FLAG THAT INDICATES INVALID INPUT PARAMETERS.
C     EXCEPT TO NUMBERS 0 AND 14, A SOLUTION IS NOT ATTEMPTED.
C
C     =  0  NO ERROR
C
C     =  1  A .LT. 0 OR B .GT. PI
C
C     =  2  A .GE. B
C
C     =  3  MBDCND .LT. 1 OR MBDCND .GT. 9
C
C     =  4  C .GE. D
C
C     =  5  N .LE. 2
C
C     =  6  NBDCND .LT. 0 OR NBDCND .GT. 4
C
C     =  7  A .GT. 0 AND MBDCND = 5, 6, OR 9
C
C     =  8  A = 0 AND MBDCND = 3, 4, OR 8
C
C     =  9  B .LT. PI AND MBDCND .GE. 7
C
C     = 10  B = PI AND MBDCND = 2,3, OR 6
C
C     = 11  MBDCND .GE. 5 AND NDBCND = 1, 2, OR 4
C
C     = 12  IDIMF .LT. M
C
C     = 13  M .LE. 2
C
C     = 14  LAMBDA .GT. 0
C
C     SINCE THIS IS THE ONLY MEANS OF INDICATING A POSSIBLY
C     INCORRECT CALL TO HSTSSP, THE USER SHOULD TEST IERROR AFTER
C     THE CALL.
C
C   W
C     W(1) CONTAINS THE REQUIRED LENGTH OF W.
C
C
C    * * * * * * *   PROGRAM SPECIFICATIONS    * * * * * * * * * * * *
C
C    DIMENSION OF   BDA(N),BDB(N),BDC(M),BDD(M),F(IDIMF,N),
C    ARGUMENTS      W(SEE ARGUMENT LIST)
C
C    LATEST         JUNE 1, 1977
C    REVISION
C
C    SUBPROGRAMS    HSTSSP,POISTG,POSTG2,GENBUN,POISD2,POISN2,POISP2,
C    REQUIRED       COSGEN,MERGE,TRIX,TRI3,PIMACH
C
C    SPECIAL        NONE
C    CONDITIONS
C
C    COMMON         NONE
C    BLOCKS
C
C    I/O            NONE
C
C    PRECISION      SINGLE
C
C    SPECIALIST     ROLAND SWEET
C
C    LANGUAGE       FORTRAN
C
C    HISTORY        WRITTEN BY ROLAND SWEET AT NCAR IN APRIL, 1977
C
C    ALGORITHM      THIS SUBROUTINE DEFINES THE FINITE-DIFFERENCE
C                   EQUATIONS, INCORPORATES BOUNDARY DATA, ADJUSTS THE
C                   RIGHT SIDE WHEN THE SYSTEM IS SINGULAR AND CALLS
C                   EITHER POISTG OR GENBUN WHICH SOLVES THE LINEAR
C                   SYSTEM OF EQUATIONS.
C
C    SPACE          8427(DECIMAL) = 20353(OCTAL) LOCATIONS ON THE
C    REQUIRED       NCAR CONTROL DATA 7600
C
C     TIMING AND        THE EXECUTION TIME T ON THE NCAR CONTROL DATA
C     ACCURACY       7600 FOR SUBROUTINE HSTSSP IS ROUGHLY PROPORTIONAL
C                    TO M*N*LOG2(N).  SOME TYPICAL VALUES ARE LISTED IN
C                    THE TABLE BELOW.
C                       THE SOLUTION PROCESS EMPLOYED RESULTS IN A LOSS
C                    OF NO MORE THAN FOUR SIGNIFICANT DIGITS FOR N AND M
C                    AS LARGE AS 64.  MORE DETAILED INFORMATION ABOUT
C                    ACCURACY CAN BE FOUND IN THE DOCUMENTATION FOR
C                    SUBROUTINE POISTG WHICH IS THE ROUTINE THAT
C                    ACTUALLY SOLVES THE FINITE DIFFERENCE EQUATIONS.
C
C
C                       M(=N)    MBDCND    NBDCND    T(MSECS)
C                       -----    ------    ------    --------
C
C                        32       1-9       1-4         56
C                        64       1-9       1-4        230
C
C    PORTABILITY    AMERICAN NATIONAL STANDARDS INSTITUTE FORTRAN.
C                   ALL MACHINE DEPENDENT CONSTANTS ARE LOCATED IN THE
C                   FUNCTION PIMACH.
C
C    REQUIRED       COS
C    RESIDENT
C    ROUTINES
C
C    REFERENCE      SCHUMANN, U. AND R. SWEET,"A DIRECT METHOD FOR
C                   THE SOLUTION OF POISSON"S EQUATION WITH NEUMANN
C                   BOUNDARY CONDITIONS ON A STAGGERED GRID OF
C                   ARBITRARY SIZE," J. COMP. PHYS. 20(1976),
C                   PP. 171-182.
C
C    * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
C
      DIMENSION       F(IDIMF,1) ,BDA(1)     ,BDB(1)     ,BDC(1)     ,
     1                BDD(1)     ,W(1)
      IERROR = 0
      PI = PIMACH(DUM)
      IF (A.LT.0. .OR. B.GT.PI) IERROR = 1
      IF (A .GE. B) IERROR = 2
      IF (MBDCND.LE.0 .OR. MBDCND.GT.9) IERROR = 3
      IF (C .GE. D) IERROR = 4
      IF (N .LE. 2) IERROR = 5
      IF (NBDCND.LT.0 .OR. NBDCND.GE.5) IERROR = 6
      IF (A.GT.0. .AND. (MBDCND.EQ.5 .OR. MBDCND.EQ.6 .OR. MBDCND.EQ.9))
     1    IERROR = 7
      IF (A.EQ.0. .AND. (MBDCND.EQ.3 .OR. MBDCND.EQ.4 .OR. MBDCND.EQ.8))
     1    IERROR = 8
      IF (B.LT.PI .AND. MBDCND.GE.7) IERROR = 9
      IF (B.EQ.PI .AND. (MBDCND.EQ.2 .OR. MBDCND.EQ.3 .OR. MBDCND.EQ.6))
     1    IERROR = 10
      IF (MBDCND.GE.5 .AND.
     1    (NBDCND.EQ.1 .OR. NBDCND.EQ.2 .OR. NBDCND.EQ.4)) IERROR = 11
      IF (IDIMF .LT. M) IERROR = 12
      IF (M .LE. 2) IERROR = 13
      IF (IERROR .NE. 0) RETURN
      DELTAR = (B-A)/FLOAT(M)
      DLRSQ = DELTAR**2
      DELTHT = (D-C)/FLOAT(N)
      DLTHSQ = DELTHT**2
      NP = NBDCND+1
      ISW = 1
      JSW = 1
      MB = MBDCND
      IF (ELMBDA .NE. 0.) GO TO 105
      GO TO (101,102,105,103,101,105,101,105,105),MBDCND
  101 IF (A.NE.0. .OR. B.NE.PI) GO TO 105
      MB = 9
      GO TO 104
  102 IF (A .NE. 0.) GO TO 105
      MB = 6
      GO TO 104
  103 IF (B .NE. PI) GO TO 105
      MB = 8
  104 JSW = 2
  105 CONTINUE
C
C     DEFINE A,B,C COEFFICIENTS IN W-ARRAY.
C
      IWB = M
      IWC = IWB+M
      IWR = IWC+M
      IWS = IWR+M
      DO 106 I=1,M
         J = IWR+I
         W(J) = SIN(A+(FLOAT(I)-0.5)*DELTAR)
         W(I) = SIN((A+FLOAT(I-1)*DELTAR))/DLRSQ
  106 CONTINUE
      MM1 = M-1
      DO 107 I=1,MM1
         K = IWC+I
         W(K) = W(I+1)
         J = IWR+I
         K = IWB+I
         W(K) = ELMBDA*W(J)-(W(I)+W(I+1))
  107 CONTINUE
      W(IWR) = SIN(B)/DLRSQ
      W(IWC) = ELMBDA*W(IWS)-(W(M)+W(IWR))
      DO 109 I=1,M
         J = IWR+I
         A1 = W(J)
         DO 108 J=1,N
            F(I,J) = A1*F(I,J)
  108    CONTINUE
  109 CONTINUE
C
C     ENTER BOUNDARY DATA FOR THETA-BOUNDARIES.
C
      GO TO (110,110,112,112,114,114,110,112,114),MB
  110 A1 = 2.*W(1)
      W(IWB+1) = W(IWB+1)-W(1)
      DO 111 J=1,N
         F(1,J) = F(1,J)-A1*BDA(J)
  111 CONTINUE
      GO TO 114
  112 A1 = DELTAR*W(1)
      W(IWB+1) = W(IWB+1)+W(1)
      DO 113 J=1,N
         F(1,J) = F(1,J)+A1*BDA(J)
  113 CONTINUE
  114 GO TO (115,117,117,115,115,117,119,119,119),MB
  115 A1 = 2.*W(IWR)
      W(IWC) = W(IWC)-W(IWR)
      DO 116 J=1,N
         F(M,J) = F(M,J)-A1*BDB(J)
  116 CONTINUE
      GO TO 119
  117 A1 = DELTAR*W(IWR)
      W(IWC) = W(IWC)+W(IWR)
      DO 118 J=1,N
         F(M,J) = F(M,J)-A1*BDB(J)
  118 CONTINUE
C
C     ENTER BOUNDARY DATA FOR PHI-BOUNDARIES.
C
  119 A1 = 2./DLTHSQ
      GO TO (129,120,120,122,122),NP
  120 DO 121 I=1,M
         J = IWR+I
         F(I,1) = F(I,1)-A1*BDC(I)/W(J)
  121 CONTINUE
      GO TO 124
  122 A1 = 1./DELTHT
      DO 123 I=1,M
         J = IWR+I
         F(I,1) = F(I,1)+A1*BDC(I)/W(J)
  123 CONTINUE
  124 A1 = 2./DLTHSQ
      GO TO (129,125,127,127,125),NP
  125 DO 126 I=1,M
         J = IWR+I
         F(I,N) = F(I,N)-A1*BDD(I)/W(J)
  126 CONTINUE
      GO TO 129
  127 A1 = 1./DELTHT
      DO 128 I=1,M
         J = IWR+I
         F(I,N) = F(I,N)-A1*BDD(I)/W(J)
  128 CONTINUE
  129 CONTINUE
C
C     ADJUST RIGHT SIDE OF SINGULAR PROBLEMS TO INSURE EXISTENCE OF A
C     SOLUTION.
C
      PERTRB = 0.
      IF (ELMBDA) 139,131,130
  130 IERROR = 14
      GO TO 139
  131 GO TO (139,139,132,139,139,132,139,132,132),MB
  132 GO TO (133,139,139,133,139),NP
  133 CONTINUE
      ISW = 2
      DO 135 J=1,N
         DO 134 I=1,M
            PERTRB = PERTRB+F(I,J)
  134    CONTINUE
  135 CONTINUE
      A1 = FLOAT(N)*(COS(A)-COS(B))/(2.*SIN(0.5*DELTAR))
      PERTRB = PERTRB/A1
      DO 137 I=1,M
         J = IWR+I
         A1 = PERTRB*W(J)
         DO 136 J=1,N
            F(I,J) = F(I,J)-A1
  136    CONTINUE
  137 CONTINUE
      A2 = 0.
      A3 = 0.
      DO 138 J=1,N
         A2 = A2+F(1,J)
         A3 = A3+F(M,J)
  138 CONTINUE
      A2 = A2/W(IWR+1)
      A3 = A3/W(IWS)
  139 CONTINUE
C
C     MULTIPLY I-TH EQUATION THROUGH BY  R(I)*DELTHT**2
C
      DO 141 I=1,M
         J = IWR+I
         A1 = DLTHSQ*W(J)
         W(I) = A1*W(I)
         J = IWC+I
         W(J) = A1*W(J)
         J = IWB+I
         W(J) = A1*W(J)
         DO 140 J=1,N
            F(I,J) = A1*F(I,J)
  140    CONTINUE
  141 CONTINUE
      LP = NBDCND
      W(1) = 0.
      W(IWR) = 0.
C
C     CALL POISTG OR GENBUN TO SOLVE THE SYSTEM OF EQUATIONS.
C
      IF (NBDCND .EQ. 0) GO TO 142
      CALL POISTG (LP,N,1,M,W,W(IWB+1),W(IWC+1),IDIMF,F,IERR1,W(IWR+1))
      GO TO 143
  142 CALL GENBUN (LP,N,1,M,W,W(IWB+1),W(IWC+1),IDIMF,F,IERR1,W(IWR+1))
  143 CONTINUE
      W(1) = W(IWR+1)+3.*FLOAT(M)
      IF (ISW.NE.2 .OR. JSW.NE.2) GO TO 150
      IF (MB .NE. 8) GO TO 145
      A1 = 0.
      DO 144 J=1,N
         A1 = A1+F(M,J)
  144 CONTINUE
      A1 = (A1-DLRSQ*A3/16.)/FLOAT(N)
      IF (NBDCND .EQ. 3) A1 = A1+(BDD(M)-BDC(M))/(D-C)
      A1 = BDB(1)-A1
      GO TO 147
  145 A1 = 0.
      DO 146 J=1,N
         A1 = A1+F(1,J)
  146 CONTINUE
      A1 = (A1-DLRSQ*A2/16.)/FLOAT(N)
      IF (NBDCND .EQ. 3) A1 = A1+(BDD(1)-BDC(1))/(D-C)
      A1 = BDA(1)-A1
  147 DO 149 I=1,M
         DO 148 J=1,N
            F(I,J) = F(I,J)+A1
  148    CONTINUE
  149 CONTINUE
  150 CONTINUE
      RETURN
      END
