C**** FILE  MI10MACH FORTRAN.
C
C
C  CONTENTS OF THIS AND OTHER MINOS SOURCE FILES
C  =============================================
C
C
C  0. FILE MI00MAIN   MAIN PROGRAM AND USER SUBROUTINES
C     -------------
C
C     MAIN     FUNOBJ   FUNCON   MATMOD
C
C
C  1. FILE MI10MACH   MACHINE-DEPENDENT ROUTINES
C     -------------
C
C     MIFILE   MINOS1   MINOS2
C     M1HASH   M1INIT   M1READ
C
C
C  2. FILE MI15BLAS   BASIC LINEAR ALGEBRA SUBPROGRAMS (A SUBSET).
C     -------------
C
C     DASUM    DAXPY    DCOPY    DDOT     DNRM2    DSCAL
C
C     THESE CORRESPOND TO MEMBERS OF THE BLAS PACKAGE (BASIC LINEAR
C     ALGEBRA SUBPROGRAMS, LAWSON ET AL (1979), ACM TOMS 5, 3).
C     IF POSSIBLE, THEY SHOULD BE REPLACED BY AUTHENTIC BLAS ROUTINES
C     TUNED TO THE MACHINE BEING USED.
C     BEWARE THAT THE VERSIONS HERE WORK CORRECTLY ONLY WHEN
C     INCX AND INCY ARE 1 (WHICH IS THE ONLY WAY MINOS USES THEM).
C
C
C     THE FOLLOWING UTILITIES ARE ALSO USED...
C
C     DZERO    HCOPY    ICOPY
C
C     THESE COULD BE TUNED TO THE MACHINE BEING USED.
C     DZERO  IS THE ONE THAT IS USED MOST.
C
C
C  3. FILE MI20AMAT   MATRIX ROUTINES FOR HANDLING THE CONSTRAINT
C     -------------   MATRIX  ( A  I ).
C
C     M2APRD   M2APR5   M2APR7   M2APR8   M2BSPR
C     M2CRSH   M2SCAL   M2UNPK   M2UNP2   MATCOL
C
C
C  4. FILE MI25BFAC   BASIS ROUTINES FOR HANDLING THE FACTORIZATION
C     -------------   OF THE BASIS MATRIX  B.
C
C     LU1FAC   LU2FAC   LU3CP    LU4AC    LU4AR
C     LU5PQ1   LU5PQ2   LU5PQ3   LU6SOL   LU7FOR
C     LU7MVR   LU7MVW   LU8RPC
C     M2BELM   M2BFAC   M2BMAP   M2BSOL   M2SING
C
C
C  5. FILE MI30SPEC   SPECS FILE ROUTINES.
C     -------------
C
C     M3SPC0   M3SPC1   M3SPC2
C
C
C  6. FILE MI35INPT   CORE ALLOCATION AND MPS FILE ROUTINES.
C     -------------
C
C     M3CORE   M3INPT   M3MPS    M3NAME   M3READ
C
C
C  7. FILE MI40BFIL   BASIS FILE AND SOLUTION OUTPUT ROUTINES.
C     -------------
C
C     M4GETB   M4DUMP   M4INST   M4LOAD   M4NEWB   M4OLDB
C     M4PNCH   M4SAVB   M4SOLN   M4SOL1   M4STAT
C
C
C  8. FILE MI50LP     ROUTINES FOR THE PRIMAL SIMPLEX METHOD.
C     -------------
C
C     M5CHZR   M5FRMC   M5LOG    M5LPIT   M5PRIC
C     M5SETP   M5SETX   M5SOLV
C
C
C  9. FILE MI60SRCH   ROUTINES FOR THE MERIT FUNCTION AND LINESEARCH.
C     -------------
C
C     GETPTC   GETPTQ   MERFUN   MERGRD   MERSAV   SEARCH
C     M6DCON   M6DOBJ   M6DMMY   M6FCON   M6FOBJ
C
C
C 10. FILE MI65RMOD   FOR MAINTAINING  R,  THE QUASI-NEWTON
C     -------------   APPROXIMATION TO THE REDUCED HESSIAN.
C
C     M6BFGS   M6BSWP   M6RADD   M6RCND   M6RDEL
C     M6RMOD   M6RSET   M6RSOL   M6SWAP
C
C
C 11. FILE MI70NOBJ   TO HANDLE A NONLINEAR OBJECTIVE FUNCTION
C     -------------   VIA THE REDUCED-GRADIENT ALGORITHM.
C
C     M7BSG    M7BSX    M7CHKD   M7CHKG   M7CHZQ
C     M7RG     M7RGIT   M7SDIR   M7SSCV
C
C
C 12. FILE MI80NCON   TO HANDLE NONLINEAR CONSTRAINTS
C     -------------   VIA THE PROJECTED AUGMENTED LAGRANGIAN ALGORITHM.
C
C     M8AJAC   M8AUGL   M8AUG1   M8CHKJ   M8PRTJ   M8SETJ
C
C  ******************************************************************
C
      SUBROUTINE MIFILE( MODE )
      COMMON    /M1FILE/ IREAD,IPRINT,ISUMM
      COMMON    /M2FILE/ IBACK,IDUMP,ILOAD,IMPS,INEWB,INSRT,
     *                   IOLDB,IPNCH,IPROB,ISCR,ISOLN,ISPECS,IREPRT
C
C     MIFILE  IS A MACHINE-DEPENDENT ROUTINE FOR DEFINING VARIOUS FILES.
C     SOME SYSTEMS (E.G. IBM) OPEN FILES AUTOMATICALLY.
C     OTHER SYSTEMS (E.G. DEC 10,20) REQUIRE EXPLICIT OPEN STATEMENTS.
C     THIS VERSION IS FOR THE
C---+ IBM 360 AND 370
C
      IF (MODE .NE. 1) GO TO 200
C
C     MODE 1 -- DEFINE GLOBAL FILES.
C     THESE REMAIN THE SAME THROUGHOUT THE RUN.
C     MINOS NORMALLY REWINDS FILES AFTER USING THEM, BUT NOT IF
C     THEIR UNIT NUMBERS ARE THE SAME AS  IREAD  OR  IPRINT.
C
C     IREAD  = NORMAL CARD INPUT STREAM (MUST BE POSITIVE).
C     IPRINT = NORMAL PRINTER OUTPUT STREAM (MUST BE POSITIVE).
C     ISCR   = SCRATCH FILE (MUST HAVE RECORD LENGTH 8).
C     ISPECS = SPECS FILE, CONTAINING ONE OR MORE PROBLEM SPECS.
C
      IREAD  = 5
      IPRINT = 6
      ISCR   = 8
      ISPECS = IREAD
C     OPEN( UNIT=IREAD, ... )
C     OPEN( UNIT=IPRINT,... )
C     OPEN( UNIT=ISCR,  ... )
      OPEN( UNIT=iscr, STATUS='NEW', DISPOSE='DELETE',
     1 FORM='FORMATTED', RECORDTYPE='FIXED', RECL=8,
     2 CARRIAGECONTROL='NONE' )
C     IF (ISPECS .NE. IREAD) OPEN( UNIT=ISPECS,... )
      RETURN
C
C
C     MODE 2 -- DEFINE FILES MENTIONED IN THE SPECS FILE JUST READ.
C
  200 IF (IMPS .LE. 0) IMPS = IREAD
C---- IF (IMPS .NE. IREAD) OPEN( UNIT=IMPS, ... )
C---- IF (IBACK .GT. 0) OPEN( UNIT=IBACK, ... )
C---- IF (IDUMP .GT. 0) OPEN( UNIT=IDUMP, ... )
C---- IF (ILOAD .GT. 0) OPEN( UNIT=ILOAD, ... )
C---- IF (INEWB .GT. 0) OPEN( UNIT=INEWB, ... )
C---- IF (INSRT .GT. 0) OPEN( UNIT=INSRT, ... )
C---- IF (IOLDB .GT. 0) OPEN( UNIT=IOLDB, ... )
C---- IF (IPNCH .GT. 0) OPEN( UNIT=IPNCH, ... )
C---- IF (ISOLN .GT. 0) OPEN( UNIT=ISOLN, ... )
      IF (ISUMM .EQ. IPRINT) ISUMM = 0
C---- IF (ISUMM .GT. 0) OPEN( UNIT=ISUMM, ... )
      RETURN
C
C     END OF MIFILE
      END
      SUBROUTINE MINOS1( Z,NWCORE )
      IMPLICIT           REAL*8(A-H,O-Z)
      DOUBLE PRECISION   Z(NWCORE)
C     ------------------------------------------------------------------
C     MINOS1  CALLS  MINOS2  ONCE FOR EACH PROBLEM FOUND IN THE SPECS
C     FILE.  IT TERMINATES WHEN  INFORM  RETURNS A NEGATIVE VALUE, WHICH
C     NORMALLY MEANS THAT ALL OF THE SPECS FILE HAS BEEN PROCESSED.
C     ------------------------------------------------------------------
C
C     DEFINE GLOBAL FILES (READER, PRINTER, ETC.)
C
      CALL MIFILE( 1 )
C
C     ============================
C     SOLVE PROBLEMS ONE AT A TIME
C     ============================
      NCALLS = 0
C
  100 NCALLS = NCALLS + 1
C
      CALL MINOS2( Z,NWCORE,NCALLS,INFORM )
C
      IF (INFORM .GE. 0) GO TO 100
C     ============================
C
      RETURN
C     END OF MINOS1
      END
      SUBROUTINE MINOS2( Z,NWCORE,NCALLS,INFORM )
      IMPLICIT           REAL*8(A-H,O-Z)
      DOUBLE PRECISION   Z(NWCORE)
C     ------------------------------------------------------------------
C
C     ALL COMMON BLOCKS ARE LISTED HERE FOR REFERENCE.
C
C**** FILE MCOMMON FORTRAN.
C
C
C  MACHINE-DEPENDENT ITEMS.
C
      COMMON    /M1EPS / EPS,EPS0,EPS1,EPS2,EPS3,EPS4,EPS5,PLINFY
      COMMON    /M1FILE/ IREAD,IPRINT,ISUMM
      COMMON    /M1WORD/ NWORDR,NWORDI,NWORDH
C
C
C  FILES, MAPS, PARAMETERS.
C
      COMMON    /M2FILE/ IBACK,IDUMP,ILOAD,IMPS,INEWB,INSRT,
     *                   IOLDB,IPNCH,IPROB,ISCR,ISOLN,ISPECS,IREPRT
      COMMON    /M2LU1 / MINLU,MAXLU,LENA,NBELEM,IP,IQ,LENC,LENR,
     *                   LOCC,LOCR,IPLOC,IQLOC,LUA,INDC,INDR
      COMMON    /M2LU2 / FACTOL(5),LAMIN,NSING1,NSING2
      COMMON    /M2LU3 / LENL,LENU,NCP,LROW,LCOL
      COMMON    /M2MAPA/ NE    ,NKA   ,LA    ,LHA   ,LKA
      COMMON    /M2MAPZ/ MAXW,MAXZ,LEN(30),LOC(60)
      COMMON    /M2PARM/ DPARM(30),IPARM(30)
C
C
C  PROBLEM SIZE, MPS NAMES, SCALE OPTIONS.
C
      COMMON    /M3LEN / M     ,N     ,NB    ,NSCL
      COMMON    /M3LOC / LASCAL,LBL   ,LBU   ,LBBL  ,LBBU  ,
     *                   LHRTYP,LHS   ,LKB
      COMMON    /M3MPS1/ LNAM1C,LNAM1R,LNAM2C,LNAM2R,LKEYNM
      COMMON    /M3MPS2/ LCNAM1,LRNAM1,LCNAM2,LRNAM2,LXS,LXL,LFREE
      COMMON    /M3MPS3/ AIJTOL,BSTRUC(2),MINMAX,MLST,MER,
     *                   NAME(2),MOBJ(2),MRHS(2),MRNG(2),MBND(2)
      COMMON    /M3MPS4/ AIJMIN,AIJMAX,NA0,LINE,IER(20),KEY(8)
      COMMON    /M3SCAL/ SCLTOL,LSCALE
C
C
C  LP ITEMS.
C
      COMMON    /M5LEN / MAXR  ,MAXS  ,MBS   ,NN    ,NN0   ,NR    ,NX
      COMMON    /M5LOC / LPI   ,LPI2  ,LW    ,LW2   ,
     *                   LX    ,LX2   ,LY    ,LY2   ,
     *                   LGMER ,LGMER2,LGRD  ,LGRD2 ,
     *                   LR    ,LRG   ,LRG2  ,LXN
      COMMON    /M5FREQ/ KCHK,KINV,KSAV,KLOG,KSUMM,I1FREQ,I2FREQ,MSOLN
      COMMON    /M5LOBJ/ SINF,WTOBJ,MINIMZ,NINF,IOBJ
      COMMON    /M5LOG1/ IDEBUG,IERR,LPRINT
      COMMON    /M5LOG2/ IHEAD,JQ1,JQ2,JR1,JR2
      COMMON    /M5LOG3/ DJQ,THETA,PIVOT,COND,NONOPT,JP,JQ,MODR1,MODR2
      COMMON    /M5LP1 / ITN,ITNLIM,NPHS,KMODLU,KMODPI
      COMMON    /M5LP2 / INVRQ,INVITN,INVMOD
      COMMON    /M5PRC / NPARPR,NMULPR,KPRC,NEWSB
      COMMON    /M5TOLS/ TOLDJ(3),TOLX,TOLPIV,TOLROW,ROWERR,XNORM
C
C
C  NONLINEAR OBJECTIVE.
C
      LOGICAL            CONV,RESTRT
      COMMON    /M7LEN / FOBJ  ,FOBJ2 ,NNOBJ ,NNOBJ0
      COMMON    /M7LOC / LGOBJ ,LGOBJ2
      COMMON    /M7CG1 / CGBETA,ITNCG,MSGCG,MODCG,RESTRT
      COMMON    /M7CG2 / LCG1,LCG2,LCG3,LCG4,MODTCG,NITNCG,NSUBSP
      COMMON    /M7CONV/ ETASH,ETARG,LVLTOL,NFAIL,CONV(4)
      COMMON    /M7PHES/ RGMIN1,RGNRM1,RGNRM2,JZ1,JZ2,LABZ,NFULLZ,MFULLZ
      COMMON    /M7TOLS/ XTOL(2),FTOL(2),GTOL(2),PINORM,RGNORM,TOLRG
C
C
C  NONLINEAR CONSTRAINTS.
C
      COMMON    /M8LEN / NJAC  ,NNCON ,NNCON0,NNJAC
      COMMON    /M8LOC / LFCON ,LFCON2,LFDIF ,LFDIF2,LFOLD ,
     *                   LBLSLK,LBUSLK,LXLAM ,LRHS  ,
     *                   LGCON ,LGCON2,LXDIF ,LXOLD
      COMMON    /M8AL1 / PENPAR,ROWTOL,NCOM,NDEN,NLAG,NMAJOR,NMINOR
      COMMON    /M8AL2 / RADIUS,RHSMOD,MODPEN,MODRHS
      COMMON    /M8DIFF/ DIFINT(2),GDUMMY,LDERIV,LVLDIF
      COMMON    /M8FUNC/ NFCON(4),NFOBJ(4),NPROB,NSTAT1,NSTAT2
      COMMON    /M8SAVE/ KMAJOR,KMINOR,NSSAVE
      COMMON    /M8VERI/ JVERIF(4),LVERIF(2)
C
C
C  MISCELLANEOUS.
C
      COMMON    /CYCLCM/ CNVTOL,JNEW,MATERR,MAXCY,NEPHNT,NPHANT,NPRINT
C**** END OF FILE MCOMMON FORTRAN.
C     ------------------------------------------------------------------
C
      INTEGER            JOBNAM(72)
      LOGICAL            FINISH, GOTLAM
C     ------------------------------------------------------------------
C
C
C     INPUT PARAMETERS
C     ----------------
C     Z            ARRAY USED FOR ALL WORKING STORAGE.
C
C     NWCORE       NO. OF WORDS OF CORE AVAILABLE (LENGTH OF ARRAY  Z).
C
C     NCALLS       THE NO. OF TIMES THIS SUBROUTINE HAS BEEN CALLED
C                  (SHOULD HAVE  NCALLS = 1  FOR THE FIRST ENTRY).
C                  IT ALLOWS  M3SPC1  TO PRINT AN ERROR MESSAGE IF IT
C                  FINDS ZERO PROBLEMS IN THE SPECS FILE.
C
C
C     OUTPUT PARAMETERS
C     -----------------
C     INFORM  = -1 IF EOF OCCURS ON FILE  ISPECS,
C             =  0 IF OPTIMAL SOLUTION WAS FOUND,
C             =  1 IF PROBLEM WAS INFEASIBLE,
C             =  2 IF PROBLEM WAS UNBOUNDED,
C             =  3 IF ITERATION LIMIT WAS EXCEEDED,
C          .GE.  4 IF ITNS WERE TERMINATED BY SOME OTHER ERROR CONDN
C                  (SEE MINOS USER'S GUIDE).
C     ------------------------------------------------------------------
C
C     SET DEFAULT VALUES FOR ALL PARAMETERS
C
      IERR   = 0
      MAXW   = 0
      MAXZ   = NWCORE
      CALL M1INIT( VERSN,MONTH,IYEAR )
      CALL M3SPC0( MROWS,MCOLS,MELMS )
C
C     ALTER AN ARBITRARY SET OF THE PARAMETERS.
C     M3SPC1  READS THE SPECS FILE AND WRITES IT IN SPECIAL FORMAT
C             TO THE SCRATCH FILE.
C     M3SPC2  THEN READS THE SCRATCH FILE AND EXTRACTS THE REQUIRED
C             PARAMETER VALUES.
C
      CALL M3SPC1( NCALLS,ISPECS,ISCR,VERSN,MONTH,IYEAR,
     *             IERR,JOBNAM,LENNAM,NSPEC )
      IF (IERR .LT. 0) GO TO 900
      CALL M3SPC2( NSPEC,MROWS,MCOLS,MELMS )
C
C     DEFINE FILES NEEDED FOR THIS PROBLEM
C
      CALL MIFILE( 2 )
      IF (ISUMM .GT. 0)
     *   WRITE(ISUMM, 1000) VERSN,MONTH,IYEAR,(JOBNAM(L),L=1,LENNAM)
C     ------------------------------------------------------------------
C
C     ESTIMATE CORE REQUIREMENTS
C
      NJAC   = 5*NNJAC
      CALL M3CORE( 1,MROWS,MCOLS,MELMS,MINCOR )
      NUSER  = MAX0( MAXZ,NWCORE )
      WRITE(IPRINT, 1100) MAXW,MINCOR,NUSER
C
C     ------------------------------------------------------------------
C     FOR SOME INSTALLATIONS, THIS IS AN APPROPRIATE PLACE TO
C     INCREASE THE SIZE OF THE WORKSPACE ARRAY  Z,  TO ALLOW
C     SOLUTION OF ARBITRARILY LARGE PROBLEMS WITHOUT RECOMPILING
C     THE MAIN PROGRAM (IN WHICH  Z  IS ORIGINALLY DECLARED).
C
C     Z  WILL PROBABLY HAVE TO BE IN BLANK COMMON IF IT IS TO BE
C     EXPANDED.  THE DEFAULT SIZE  NWCORE  SHOULD BE LARGE ENOUGH
C     TO SOLVE REASONABLY BIG PROBLEMS WITHOUT CHANGE (E.G. 25000).
C
C     AT THIS STAGE,  M3SPC1  AND  M3SPC2  HAVE READ THE SPECS FILE,
C     AND WE HAVE USED THE VALUES THERE TO DEFINE  MINCOR,  WHICH IS AN
C     ESTIMATE OF THE MINIMUM SENSIBLE VALUE FOR  MAXZ  AND  NWCORE.
C     IF  Z  CAN BE EXTENDED AT RUN-TIME, IT SHOULD BE MADE AT LEAST
C     AS LONG AS  MINCOR.
C
C     WE ALSO ALLOW THE USER TO ESTIMATE CORE REQUIREMENTS BY MEANS OF
C     TWO CARDS IN THE SPECS FILE OF THE FOLLOWING FORM...
C
C        WORKSPACE (USER)      10000 WORDS  (THIS SETS  MAXW = 10000)
C        WORKSPACE (TOTAL)     50000 WORDS  (THIS SETS  MAXZ = 50000)
C
C     MAXW  AND  MAXZ  ARE IN COMMON /M2MAPZ/.
C     THE DEFAULT VALUES ARE  MAXW = 0,  MAXZ = NWCORE.
C     MINOS WILL USE ONLY  Z(MAXW+1), ..., Z(MAXZ).  HENCE,
C     Z(1), ..., Z(MAXW)    AND POSSIBLY    Z(MAXZ+1), ..., Z(NWCORE)
C     MAY BE USED AS WORKSPACE BY THE USER DURING SOLUTION OF THIS
C     PARTICULAR PROBLEM.
C
C     IF  MAXW  IS SET AS ABOVE, IT MAY BE USED IN AN OBVIOUS WAY
C     TO PROVIDE WORKSPACE TO THE FUNCTION ROUTINES  FUNOBJ AND FUNCON.
C
C     IF  MAXZ  IS SET TO A VALUE LESS THAN  NWCORE,  IT WILL SERVE TO
C     REDUCE PAGING ACTIVITY ON A MACHINE WITH VIRTUAL MEMORY, BY
C     CONFINING MINOS (IN PARTICULAR THE BASIS-FACTORIZATION ROUTINES)
C     TO AN AREA OF CORE THAT IS SENSIBLE FOR THE CURRENT PROBLEM.
C     ON SOME SYSTEMS (E.G. BURROUGHS), THIS WILL ALLOW  NWCORE  TO BE
C     DECLARED ARBITRARILY LARGE AT COMPILE TIME.
C
C     IF THE SPECS FILE DEFINES  MAXZ .GT. NWCORE,  WE NORMALLY JUST
C     SET  MAXZ = NWCORE,  AND HOPE THAT IT IS BIG ENOUGH.
C     ON SYSTEMS THAT ALLOW  Z  TO BE EXTENDED AT RUN-TIME (E.G. CDC),
C     MAXZ  AND  NWCORE  COULD BE INCREASED USING CODE OF THE FOLLOWING
C     GENERAL FORM ...
C
C           NEXTRA = MAXZ - NWCORE
C           IF (NEXTRA .LE. 0) GO TO 200
C           LENOLD = NWCORE
C           LENNEW = MAXZ
C           CALL COMMON-MEMORY-MANAGER( LENOLD, NEXTRA, LENNEW )
C           MAXZ   = LENNEW
C           NWCORE = LENNEW
C     ------------------------------------------------------------------
C
      NEXTRA = MAXZ - NWCORE
      IF (NEXTRA .LE. 0) GO TO 200
      MAXZ   = NWCORE
  200 WRITE(IPRINT, 1200) MAXW,MAXZ,NWCORE
C
C     READ MPS DATA FROM FILE  IMPS.
C
      CALL M3INPT( MROWS,MCOLS,MELMS,NS,Z,NWCORE )
      IF (IERR .NE. 0) GO TO 900
C
C     ------------------------------------------------------------------
C     INPUT A BASIS OR CALL CRASH.
C     M4GETB  EVALUATES THE FIRST JACOBIAN AND STORES IT IN  A.
C     IT RETURNS WITH  X,  KB  AND  HS  SET TO DEFINE THE FIRST BASIS.
C     ------------------------------------------------------------------
      WRITE(IPRINT, 2000)
      NSTAT1 = 1
      NSTAT2 = 1
      CALL M4GETB( M,MBS,NX,N,NB,NN,NN0,MAXS,NS,NSCL,
     *             NE,NKA,Z(LA),Z(LHA),Z(LKA),
     *             Z(LHRTYP),Z(LHS),Z(LKB),Z(LASCAL),Z(LBL),Z(LBU),
     *             Z(LPI),Z(LX),Z(LXN),Z(LY),Z(LY2),Z,NWCORE )
C
      IF (IERR .NE. 0) GO TO 900
C
C     ------------------------------------------------------------------
C     M5SOLV  MAY NOW BE CALLED ONE OR MORE TIMES.
C     THE FIRST CALL TO  M5SOLV  MUST HAVE  NCYCLE = 1.
C     SUBSEQUENT CALLS WITH  NCYCLE = 2 OR MORE  WILL RESULT IN
C     A SO-CALLED FLYING START.  IN SUCH CASES,  M5SOLV  WILL
C     RETAIN THE CURRENT BASIS, THE LAGRANGE-MULTIPLIER ESTIMATES,
C     AND THE REDUCED-HESSIAN APPROXIMATION.
C     THIS FACILITATES THE SOLUTION OF A SEQUENCE OF RELATED PROBLEMS.
C
C     GOTLAM = .FALSE.  WILL BE USED FOR THE FIRST CALL TO  M5SOLV.
C     WHENEVER  M5SOLV  RETURNS,  GOTLAM = .TRUE.  MEANS THAT ESTIMATES
C     FOR THE LAGRANGE MULTIPLIERS ARE IN  Z(LXLAM).  THESE WILL BE
C     RETAINED FOR THE NEXT CALL TO  M5SOLV,  UNLESS  GOTLAM  IS RESET
C     TO .FALSE.
C     ------------------------------------------------------------------
C
      WRITE(IPRINT, 2100)
      FINISH = .FALSE.
      NSSAVE = NS
      JNEW   = N - NPHANT
      MATERR = 0
      NCYCLE = 1
      NPRNTD = 0
C
  500 IF (NCYCLE .GE. 2) WRITE(IPRINT, 2200) NCYCLE
      IF (NCYCLE .GE. 2  .AND.
     *    ISUMM  .GT. 0) WRITE(ISUMM,  2200) NCYCLE
      NSOLVD = NCYCLE
C
C     ******************************************************************
C     SOLVE THE CURRENT PROBLEM.
C     BALE OUT IF THERE IS A FATAL ERROR.
C     ******************************************************************
      CALL M5SOLV( NCYCLE,GOTLAM,OBJTRU,
     *             M,MBS,NX,N,NB,NR,NN,NN0,MAXR,MAXS,NS,NSCL,
     *             NE,NKA,Z(LA),Z(LHA),Z(LKA),
     *  Z(LHRTYP),Z(LHS),Z(LKB),Z(LASCAL),Z(LBL),Z(LBU),Z(LBBL),Z(LBBU),
     *   FMERIT,Z(LGMER),Z(LGMER2),Z(LGRD),Z(LGRD2),Z(LPI),Z(LR),
     *   Z(LRG),Z(LRG2),Z(LX),Z(LXN),Z(LY),Z(LY2),Z,NWCORE )
C
      IF (IERR .GE. 30) GO TO 900
C
C     ******************************************************************
C     SAVE BASIS FILES AND PREPARE TO PRINT THE SOLUTION.
C     WITH  MODE = 1,  MSOLN  IS NOT USED.
C     ******************************************************************
      MODE   = 1
      CALL M4SAVB( MODE,MSOLN,NS,OBJTRU,Z,NWCORE )
C
C     IN SOME CYCLING APPLICATIONS, IT MAY BE DESIRABLE TO SUPPRESS
C     THE PRINTING OF INTERMEDIATE SOLUTIONS.  OTHERWISE,
C     IF  MODE = 2,  M4SAVB  PRINTS THE SOLN UNDER THE CONTROL OF  MSOLN
C     (WHICH IS SET BY THE  SOLUTION  KEYWORD IN THE SPECS FILE).
C     THE PRINTED SOLUTION MAY OR MAY NOT BE WANTED, AS FOLLOWS...
C
C     MSOLN  = 0   MEANS      NO.
C            = 1   MEANS      IF OPTIMAL, INFEASIBLE OR UNBOUNDED.
C            = 2   MEANS      YES.
C            = 3   MEANS      IF ERROR CONDITION.
C
C     THIS CALL NORMALLY PRINTS THE SOLUTION WHEN THERE IS NO
C     CYCLING, BECAUSE THE DEFAULT VALUES ARE  MAXCY = NPRINT = 1.
C
      MODE   = 2
      IF (NCYCLE .LE. MAXCY - NPRINT) MODE = 0
      IF (MODE .EQ. 2) NPRNTD = NSOLVD
      IF (MODE .EQ. 2)
     *CALL M4SAVB( MODE,MSOLN,NS,OBJTRU,Z,NWCORE )
C
C     ******************************************************************
C     CALL FUNCTIONS ONE LAST TIME WITH  NSTATE .GE. 2.
C     USE WORK ARRAYS FOR GRADIENTS TO AVOID ALTERING
C     THE FINAL  GCON, GOBJ.
C     MODE = 0  SAYS GRADIENTS ARE NOT REQUIRED.
C     ******************************************************************
      NSTAT1 = 2 + IERR
      NSTAT2 = NSTAT1
      MODE   = 0
      IF (NNCON .GT. 0)
     *CALL M6FCON( MODE,NNCON,NNJAC,NJAC,
     *             Z(LFCON),Z(LGCON2),Z(LXN),Z,NWCORE )
      IF (MODE .LT. 0) GO TO 800
C
      IF (NNOBJ .GT. 0)
     *CALL M6FOBJ( MODE,NNOBJ,FOBJ,Z(LGOBJ2),Z(LXN),Z,NWCORE )
      IF (MODE .LT. 0) GO TO 800
      NSTAT1 = 0
      NSTAT2 = 0
C
C     ******************************************************************
C     TERMINATE CYCLES IF  M5SOLV  GAVE A SERIOUS ERROR.
C     OTHERWISE, LET THE USER MODIFY THE PROBLEM FOR THE NEXT CYCLE.
C     ******************************************************************
      IF (IERR   .GE.    20) GO TO 800
      IF (NCYCLE .GE. MAXCY) GO TO 800
      NCYCLE = NCYCLE + 1
      WRITE(IPRINT, 3000) NCYCLE
      IF (ISUMM .GT. 0) WRITE(ISUMM, 3000) NCYCLE
      CALL MATMOD( NCYCLE,NPROB,FINISH,
     *             M,N,NB,NE,NKA,NS,NSCL,
     *             Z(LA),Z(LHA),Z(LKA),Z(LBL),Z(LBU),
     *             Z(LASCAL),Z(LHS),Z(LCNAM1),Z(LCNAM2),
     *             Z(LXS),Z(LPI),Z,NWCORE )
      IF (.NOT. FINISH) GO TO 500
C     ------------------------------------------------------------------
C     THIS IS THE END OF THE CYCLING LOOP.
C     ------------------------------------------------------------------
C
C
C     PRINT THE FINAL SOLUTION IF IT HAS NOT ALREADY BEEN PRINTED.
C
  800 MODE   = 2
      IF (NPRNTD .NE. NSOLVD)
     *CALL M4SAVB( MODE,MSOLN,NS,OBJTRU,Z,NWCORE )
C
C     ------------------------------------------------------------------
C     EXIT
C     ------------------------------------------------------------------
C
  900 INFORM = IERR
      RETURN
C
 1000 FORMAT(/ ' MINOS (', F4.1, 1X, A3, I5, ' )' // 1X, 70A1)
 1100 FORMAT(/ ' REASONABLE WORKSPACE LIMITS ARE', I8, ' ...',
     *   I8, ' ...', I8, '  WORDS')
 1200 FORMAT(  ' ACTUAL     WORKSPACE LIMITS ARE', I8, ' ...',
     *   I8, ' ...', I8, '  WORDS')
 2000 FORMAT('1' / ' INITIAL BASIS' / ' -------------')
 2100 FORMAT(  /// ' ITERATIONS' / ' ----------')
 2200 FORMAT('1' / ' ITERATIONS FOR CYCLE NO.', I4
     *           / ' ----------------------------')
 3000 FORMAT(/ ' MATMOD CALLED WITH NCYCLE =', I3)
C     END OF MINOS2
      END
      SUBROUTINE M1HASH( LEN,NEN,NCOLL,
     *                   KEY1,KEY2,MODE,KEYTAB,NAME1,NAME2,KA,FOUND )
      INTEGER            KEYTAB(LEN),NAME1(NEN),NAME2(NEN)
      LOGICAL            FOUND
C
C     ROUTINE TO LOOK UP AND/OR INSERT INTEGER KEYS IN A TABLE.
C     REFERENCE  R.P. BRENT, CACM 16,2 (FEB 1973), PP. 105-109.
C     SIMPLIFIED FOR THE CASE WHERE NO ENTRIES ARE DELETED.
C     MODIFIED TO HASH TWO 4-CHAR IDENTIFIERS AS THOUGH THEY WERE
C     ONE 8-CHAR IDENTIFIER.
C     KEYTAB IS USED AS AN INDEX INTO A CONSECUTIVE LIST OF UNIQUE
C     IDENTIFIERS (NAME1 AND NAME2) WHICH ARE USED TO TEST FOR MATCH.
C
      LEN2 = LEN-2
      IC = -1
C     COMPUTE ADDRESS OF FIRST PROBE (IR) AND INCREMENT (IQ).
C     ******************************************************************
C     NOTE -- THE NEXT STATEMENTS ARE MACHINE DEPENDENT.  THE AIM
C     IS TO PRODUCE A VALID POSITIVE INTEGER  KEY  OUT OF THE
C     TWO WORDS  KEY1  AND  KEY2 .  THE LATTER CONTAIN FOUR
C     CHARACTERS LEFT-JUSTIFIED (READ UNDER A4 FORMAT).  THESE
C     MAY TURN ON THE SIGN BIT (E.G. IBM 360/370) OR GIVE A
C     NON-ZERO FLOATING POINT EXPONENT (E.G. BURROUGHS B6700).
C     ******************************************************************
C---+ IBM 360 AND 370
      K1  = IABS(KEY1)
      K2  = IABS(KEY2)
      KEY = IABS(K1 - K2)
C
      IQ = MOD(KEY, LEN2) + 1
      IR = MOD(KEY, LEN)  + 1
      KA = IR
C     LOOK IN THE TABLE.
   20 KT = KEYTAB(KA)
C     CHECK FOR AN EMPTY SPACE OR A MATCH.
      IF (KT.EQ.0) GO TO 30
      IF (KEY1.EQ.NAME1(KT) .AND. KEY2.EQ.NAME2(KT)) GO TO 60
      IC = IC + 1
      NCOLL = NCOLL+1
C     COMPUTE ADDRESS OF NEXT PROBE.
      KA = KA + IQ
      IF (KA.GT.LEN) KA = KA - LEN
C     SEE IF WHOLE TABLE HAS BEEN SEARCHED.
      IF (KA.NE.IR) GO TO 20
C     THE KEY IS NOT IN THE TABLE.
   30 FOUND = .FALSE.
C     RETURN WITH KA = 0 UNLESS AN ENTRY HAS TO BE MADE.
      IF ((MODE.EQ.2) .AND. (IC.LE.LEN2)) GO TO 70
      KA = 0
      RETURN
C
   60 FOUND = .TRUE.
      RETURN
C
C     LOOK FOR THE BEST WAY TO MAKE AN ENTRY.
   70 IF (IC.LE.0) RETURN
      IA = KA
      IS = 0
C     COMPUTE THE MAXIMUM LENGTH TO SEARCH ALONG CURRENT CHAIN.
   80 IX = IC - IS
      KT = KEYTAB(IR)
C     COMPUTE INCREMENT JQ FOR CURRENT CHAIN.
C     ******************************************************************
C     NOTE -- THE NEXT STATEMENTS ARE MACHINE DEPENDENT.  THE SAME
C     TRANSFORMATION AS DISCUSSED IN THE NOTE ABOVE SHOULD BE
C     APPLIED TO  NAME1(KT)  AND  NAME2(KT) .
C     ******************************************************************
C---+ IBM 360 AND 370
      K1  = IABS(NAME1(KT))
      K2  = IABS(NAME2(KT))
      KEY = IABS(K1 - K2)
C
      JQ = MOD(KEY, LEN2) + 1
      JR = IR
C     LOOK ALONG THE CHAIN.
   90 JR = JR + JQ
      IF (JR.GT.LEN) JR = JR - LEN
C     CHECK FOR A HOLE.
      IF (KEYTAB(JR).EQ.0) GO TO 100
      IX = IX - 1
      IF (IX.GT.0) GO TO 90
      GO TO 110
C     SAVE LOCATION OF HOLE.
  100 IA = JR
      KA = IR
      IC = IC - IX
C     MOVE DOWN TO THE NEXT CHAIN.
  110 IS = IS + 1
      IR = IR + IQ
      IF (IR.GT.LEN) IR = IR - LEN
C     GO BACK IF A BETTER HOLE MIGHT STILL BE FOUND.
      IF (IC.GT.IS) GO TO 80
C     IF NECESSARY MOVE AN OLD ENTRY.
      IF (IA.NE.KA) KEYTAB(IA) = KEYTAB(KA)
      RETURN
C
C     END OF M1HASH
      END
      SUBROUTINE M1INIT( VERSN,MONTH,IYEAR )
      IMPLICIT           REAL*8(A-H,O-Z)
      COMMON    /M1EPS / EPS,EPS0,EPS1,EPS2,EPS3,EPS4,EPS5,PLINFY
      COMMON    /M1WORD/ NWORDR,NWORDI,NWORDH
C
      INTEGER            MNTHS(12)
      DATA       MNTHS /'JAN', 'FEB', 'MAR', 'APR', 'MAY', 'JUN',
     *                  'JUL', 'AUG', 'SEP', 'OCT', 'NOV', 'DEC'/
C
C     THE FOLLOWING 4 NUMBERS ARE MACHINE-DEPENDENT --
C
C     EPS    = FLOATING-POINT PRECISION (E.G. 2.0**(-47) FOR CDC)
C     NWORDR = NO. OF  REALS          PER WORD OF  Z(*)
C     NWORDI = NO. OF  INTEGERS       PER WORD OF  Z(*)
C     NWORDH = NO. OF  HALF INTEGERS  PER WORD OF  Z(*)
C        WHERE  Z(*)  IS THE MAIN ARRAY OF STORAGE.
C
C
C---+ IBM 360 AND 370
C
      VERSN  = 5.0
      MONTH  = MNTHS(04)
      IYEAR  = 1984
C     IBM
C     EPS    = 16.0**(-13)
C     VAX 11/780 REAL*8  *** change ***
      EPS    = 2.0**(-55)
      NWORDR = 2
      NWORDI = 2
      NWORDH = 4
C
C     USE EPS TO SET OTHER MACHINE PRECISION CONSTANTS
C
      EPS0   = EPS**(4.0/5)
      EPS1   = EPS**(2.0/3)
      EPS2   = EPS**(1.0/2)
      EPS3   = EPS**(1.0/3)
      EPS4   = EPS**(1.0/4)
      EPS5   = EPS**(1.0/5)
      PLINFY = 1.0E+20
      RETURN
C
C     END OF M1INIT
      END
      SUBROUTINE M1READ( ISPECS,L,LINE,INFORM )
      INTEGER            L(72),LINE(8)
C
C     M1READ  IS A MACHINE-DEPENDENT INPUT ROUTINE,
C     CALLED BY  M3SPC1  TO READ THE SPECS FILE.
C     IF END-OF-FILE OCCURS IT SHOULD SET  INFORM = 1.
C
      READ(ISPECS, 1000, END=900) L,LINE
  100 RETURN
C
  900 INFORM = 1
      RETURN
C
 1000 FORMAT(80A1)
C     END OF M1READ
      END
