#!/usr/bin/env python

########################################################################
# Chris's Lame Filebrowser 4 (List View)
# Copyright 2004, Gabe Ginorio <gabe@zevallos.com.br>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
######################################################################

import gtk, pygtk, gtk.gdk, gobject
import commands, os, os.path, sys, stat, string, time
import mimetype, fstabreader, file_monitor, file_mover, menu, properties

IMAGE_DIRECTORY= os.path.abspath(string.replace(sys.argv[0],"claw4.py","") + "Images")

class create:
	def __init__(self, tab):
		self.tab = tab

		# Create the list store model and add it to the tree view
		self.list_store = gtk.ListStore(gtk.gdk.Pixbuf, str, int, str, str, str, str)
		self.tree_view = gtk.TreeView(self.list_store)
		tab.scroll.add_with_viewport(self.tree_view)

		 # Create the tree view columns
		self.tree_view.append_column(self.__createColumn__("", 0, True))
		self.tree_view.append_column(self.__createColumn__("Filename", 1, False))
		self.tree_view.append_column(self.__createColumn__("Filesize", 2, False))
		self.tree_view.append_column(self.__createColumn__("Permissions", 3, False))
		self.tree_view.append_column(self.__createColumn__("Owner", 4, False))
		self.tree_view.append_column(self.__createColumn__("Group", 5, False))

		# Allow multiple selections
		self.tree_selection = self.tree_view.get_selection()
		self.tree_selection.set_mode(gtk.SELECTION_MULTIPLE)
			
		# Set the tree view signals, sizing and then show it
		self.tree_view.connect("button-press-event", self.__mouseButtonPress__)				
		self.tree_view.connect("button-release-event", self.__mouseButtonRelease__)	
		self.tree_view.columns_autosize()

		self.tree_view.enable_model_drag_dest([("text/plain", 0, 80)], gtk.gdk.ACTION_COPY)
		self.tree_view.enable_model_drag_source(gtk.gdk.BUTTON1_MASK,  [("text/plain", 0, 80)], gtk.gdk.ACTION_COPY)
		self.tree_view.connect("drag-data-received", self.__getDroppedFile__)
		self.tree_view.connect("drag-data-get", self.__fileDropped__)

		self.tree_view.show_all()

		# Only the icon view cares if the notebook resizes (so create a bogus value)
		self.tab.Notebook.pages[tab] = None

		# Lastly, add the rows to the tree view
		self.__populate__(os.getcwd())


	def __createColumn__(self, name, position, pixbuf):
		'''This function creates a Tree View Column'''
		column = gtk.TreeViewColumn(name)
		
		# You can create a pixbuf or text column
		if pixbuf == True:
			cell_renderer = gtk.CellRendererPixbuf()
			column.pack_start(cell_renderer, False)
			column.add_attribute(cell_renderer, "pixbuf", position)
		else:
			cell_renderer = gtk.CellRendererText()
			column.pack_start(cell_renderer, False)
			column.add_attribute(cell_renderer, "text", position)

		return column


	def __populate__(self, location=None):
		'''This function adds the rows to the list store'''
		
		if location == None:
			location = os.getcwd()
	
		# This deletes any one file monitor on the old location
		file_monitor.delete(self.tab.file_descriptor)
		
		# Add the location to the history list (if this isn't a Back move)
		if self.tab.history[-1] != location:
			self.tab.history.append(location)
		
		# Prepare to list
		self.__populating__ = True
		self.list_store.clear()		
		os.chdir(location)
		locations = self.tab.__organizeContents__(location)
		
		# List
		for a_file in locations:
			if len(locations) < 100:
				try:
					stats = os.stat(a_file)
					new_iter = self.list_store.append()
					self.list_store.set_value(new_iter, 0, self.tab.__getPixbuf__(a_file, "small"))
					self.list_store.set_value(new_iter, 1, os.path.basename(a_file))
					self.list_store.set_value(new_iter, 2, stats[stat.ST_SIZE])
					self.list_store.set_value(new_iter, 3, oct(stats[stat.ST_MODE])[-3:])
					self.list_store.set_value(new_iter, 4, stats[stat.ST_UID])
					self.list_store.set_value(new_iter, 5, stats[stat.ST_GID])
					self.list_store.set_value(new_iter, 6, a_file)
				except:
					new_iter = self.list_store.append()
					self.list_store.set_value(new_iter, 0, self.tab.__getPixbuf__(a_file, "small"))
					self.list_store.set_value(new_iter, 1, os.path.basename(a_file))
					self.list_store.set_value(new_iter, 6, a_file)				
			else:
				try:
					stats = os.stat(a_file)
					new_iter = self.list_store.append()
					self.list_store.set_value(new_iter, 1, os.path.basename(a_file))
					self.list_store.set_value(new_iter, 2, stats[stat.ST_SIZE])
					self.list_store.set_value(new_iter, 3, oct(stats[stat.ST_MODE])[-3:])
					self.list_store.set_value(new_iter, 4, stats[stat.ST_UID])
					self.list_store.set_value(new_iter, 5, stats[stat.ST_GID])
					self.list_store.set_value(new_iter, 6, a_file)
				except:
					new_iter = self.list_store.append()
					self.list_store.set_value(new_iter, 1, os.path.basename(a_file))
					self.list_store.set_value(new_iter, 6, a_file)
	
		self.__populating__ = False

		# Create a file monitor for the current directory
		self.tab.file_descriptor = file_monitor.create(self, os.getcwd(), "list")

		# Set the tab label and tooltip
		self.tab.changeTabLabel(location)

		# Add images if we need to
		self.counter = 0
		source_id = gobject.timeout_add(100, self.__createImages__)


	def __createImages__(self):
		an_iter = self.list_store[self.counter].iter
		self.list_store.set_value(an_iter, 0, self.tab.__getPixbuf__(self.list_store.get_value(an_iter, 6), "small"))

		self.counter += 1
		if self.__populating__ == True or self.counter == len(self.list_store):
			self.counter = 0
			return False
		else:
			return True


	############################### MOUSE SECTION ###################################

	def __mouseButtonPress__(self, tree_view, event):
		x, y = tree_view.get_pointer()
		y -=20

		if self.tree_view.get_path_at_pos(x,y) == None and event.button == 3:
			self.__treeMenu__(event)
			return 0
		elif self.tree_view.get_path_at_pos(x,y) == None:
			return 0

		path = self.tree_view.get_path_at_pos(x,y-10)[0]
		selected_iter = self.list_store.get_iter(path)
		location = self.list_store.get_value(selected_iter, 6)

		if event.button == 1:
			if (self.tab.single_click == False and event.type == gtk.gdk._2BUTTON_PRESS) or self.tab.single_click ==True:
				if os.path.isdir(location):
					if os.access(location, os.R_OK):
						self.__populate__(location)
					else:
						self.tab.setInfoBarText("You Don't Have Permission To Enter " + os.path.basename(location) + "ERROR")
			else:
				menu.__menuClick__(None, self, self.tab, "Open", location, mimetype.getTypes(None,location)[location])

	def __mouseButtonRelease__(self, tree_view, event):
		x, y = tree_view.get_pointer()
		y -=20

		if self.tree_view.get_path_at_pos(x,y) == None and event.button == 3:
			self.__treeMenu__(event)
			return 0
		elif self.tree_view.get_path_at_pos(x,y) == None:
			return 0

		path = self.tree_view.get_path_at_pos(x,y-10)[0]
		selected_iter = self.list_store.get_iter(path)
		location = self.list_store.get_value(selected_iter, 6)	
		if event.button == 3:
			mime_type = mimetype.getTypes(None, location)[location]
			self.__rightClickMenu__(location, mime_type, event)

	def __rightClickMenu__(self, filename, mime, event):
		'''This functions creates the right click menu for the right click
		on an icon'''
		menu.icon(self, self.tab, event, filename, mime)

	def __treeMenu__(self, event):
		'''This function handles creating the layout menu for layout right clicks'''
		menu.layout(self, event)


	################################## DRAG AND DROP ########################################

	def __fileDropped__(self, tree_view, drag_context, selection_data, info, timestamp):
		'''This function handles getting the selected files put in the DND selection_data'''
		selection_data.set(gtk.gdk.TARGET_STRING, 8, self.__getSelectedFiles__())

	def __getDroppedFile__(self, tree_view, drag_context, x, y, selection_data, info, timestamp):
		'''This function retreives the selected files from the DND selection_data'''
		try:
			path, position = tree_view.get_dest_row_at_pos(x, y)
			selected_iter = self.list_store.get_iter(path)
			drop_location = self.list_store.get_value(selected_iter, 6)			
		except:
			drop_location = os.getcwd()		
	
		menu.drop(self.tab, timestamp, selection_data.data, drop_location)


	################################## FUNCTIONS ########################################

	def __getSelectedFiles__(self):
		'''This function gets the location of the files from the selected
		rows and returns a string with the locations seperated by three
		spaces (This is useful for DND)'''

		selected = ""
		model, rows = self.tree_selection.get_selected_rows()
		for row in rows:
			location = self.list_store.get_value(self.list_store.get_iter(row), 6)
			selected += location + "\t"

		return selected


	def __getMousePosition__(self):
		'''This functions returns the current mouse location
		relative to the upper left corner of the main window.'''
		
		main_window = self.tab.Notebook.main_notebook.get_toplevel()
		x, y = main_window.get_position()
		offset_x ,offset_y = main_window.get_pointer()
		return x + offset_x, y+offset_y


	def _destroy_(self):
		'''This function destroys the list view widgt'''
		self.tree_view.destroy()


def __returnClean__(text):
	'''This is a general function that takes text and makes it
	Bash command line compatible'''
	
	# Here are the bad characters
	badChars = [" ","\'","&","(",")"]
			
	# Here are the replacement characters
	goodChars=["\ ","\\'","\&","\(","\)"]
			
	# Replace the bad with the good
	for x in range(len(badChars)):
		text = string.replace(text, badChars[x], goodChars[x])		
		
	# Return the "cleaned", BASH friendly text
	return text
