#!/usr/bin/env python

########################################################################
# Chris's Lame Filebrowser 4 (Create Icon layouts, Detail View Lists and Associated Functions)
# Copyright 2004, Gabe Ginorio <gabe@zevallos.com.br>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
######################################################################


import commands, os, os.path, shutil, string, sys
import file_mover, fstabreader, mimetype, overwrite_dialog, properties
import gtk, pygtk

IMAGE_DIRECTORY = os.path.abspath(string.replace(sys.argv[0],"claw4.py","") + "Images")
clipboard = gtk.Clipboard()

def icon(parent, tab, event, filename, mime):
	'''This function creates a menu for a click on an icon'''
	menu = gtk.Menu()
	mountpoints = fstabreader.read()

	# Handle mounted file systems
	if os.path.ismount(filename):
		# Create an umount item
		unmountitem = gtk.MenuItem()
		unmountitem.add(__createMenuItem__("Unmount", "unmount"))			
		unmountitem.connect("activate", __menuClick__,  parent, tab, 'Umount', filename, mime)	
		menu.attach(unmountitem, 0,1,0,1)

		# Create an eject item
		ejectitem = gtk.MenuItem()
		ejectitem.add(__createMenuItem__("Eject", "eject"))			
		ejectitem.connect("activate", __menuClick__,  parent, tab, 'Eject', filename, mime)	
		menu.attach(ejectitem, 0,1,1,2)		

	# Handle unmounted file systems
	elif filename in mountpoints:
		# Create a mount item
		mountitem = gtk.MenuItem()
		mountitem.add(__createMenuItem__("Mount", "mount"))
		mountitem.connect("activate", __menuClick__,  parent, tab, 'Mount', filename, mime)	
		menu.attach(mountitem, 0,1,0,1)

		# Create an eject item
		ejectitem = gtk.MenuItem()
		ejectitem.add(__createMenuItem__("Eject", "eject"))			
		ejectitem.connect("activate", __menuClick__,  parent, tab, 'Eject', filename, mime)	
		menu.attach(ejectitem, 0,1,1,2)		

	elif os.access(filename, os.R_OK):
		# Create the Open item
		openitem = gtk.MenuItem()
		menu.attach(openitem, 0,1,0,1)
		openitem.add(__createMenuItem__("Open", "open"))
		openitem.connect("activate", __menuClick__,  parent, tab, 'Open',filename, mime)

		# Create Open With Item if this isn't a directory
		if not os.path.isdir(filename):
			openwithitem = gtk.MenuItem()
			openwithitem.add(__createMenuItem__("Open With", "open_with"))
			menu.attach(openwithitem, 0,1,1,2)

			openwithmenu = gtk.Menu()
			openwithitem.set_submenu(openwithmenu)

			# Create the apps for the Open With menu
			associated_applications = 	mimetype.get_associated_applications(mime)
			top, bottom=0,1
			for application in associated_applications:
				appitem = gtk.MenuItem(application)
				appitem.connect("activate", __menuClick__, parent, tab, application, filename)
				openwithmenu.attach(appitem,0,1,top,bottom)
				top+=1
				bottom+=1
			otherappitem = gtk.MenuItem("Other")
			otherappitem.connect("activate", __menuClick__, parent, tab, "Other", filename)
			openwithmenu.attach(otherappitem,0,1,top,bottom)

			openwithmenu.show_all()

			# Create an Edit Mimetype button
			mimeitem = gtk.MenuItem()
			mimeitem.add(__createMenuItem__("Edit Mimetype", "mimetype"))
			mimeitem.connect("activate", __menuClick__, parent, tab, "Edit Mimetype", filename, mime)
			menu.attach(mimeitem, 0,1,3,4)
		else:
			# Create the Open tab
			opentab = gtk.MenuItem()
			menu.attach(opentab, 0,1,1,2)
			opentab.add(__createMenuItem__("Open Tab Here", "open_with"))
			opentab.connect("activate", __menuClick__, parent, tab, 'Open Tab', filename, mime)	

		# Create a Properties item
		propertyitem = gtk.MenuItem()
		propertyitem.connect("activate", __menuClick__, parent, tab, "Properties", filename)
		propertyitem.add(__createMenuItem__("Properties", "properties"))		
		menu.attach(propertyitem, 0,1,2,3)

		# Create a Create Archive item
		archiveitem = gtk.MenuItem()
		archiveitem.connect("activate", __menuClick__, parent, tab, "Archive", filename)
		archiveitem.add(__createMenuItem__("Archive " + os.path.basename(filename), "archive"))
		menu.attach(archiveitem, 0,1,4,5)

		# A separator seems good here
		separatoritem =  gtk.SeparatorMenuItem()
		menu.attach(separatoritem, 0,1,5,6)

		# Create a Copy item
		copyitem = gtk.MenuItem()
		copyitem.connect("activate", __menuClick__, parent, tab, "Copy", filename)
		copyitem.add(__createMenuItem__("Copy", "copy"))
		menu.attach(copyitem, 0,1,6,7)

		# Create a Cut item
		cutitem = gtk.MenuItem()
		cutitem.connect("activate", __menuClick__, parent, tab, "Cut", filename)
		cutitem.add(__createMenuItem__("Cut", "cut"))
		menu.attach(cutitem, 0,1,7,8)

		# Create a Paste item
		pasteitem = gtk.MenuItem()
		pasteitem .connect("activate", __menuClick__, parent, tab, "Paste", filename)
		pasteitem .add(__createMenuItem__("Paste", "paste"))
		menu.attach(pasteitem , 0,1,8,9)


	# A separator seems good here
	separatoritem =  gtk.SeparatorMenuItem()
	menu.attach(separatoritem, 0,1,9,10)

	# Create a Delete item if the file or directory is writable
	if os.access(filename, os.W_OK):
		deleteitem = gtk.MenuItem()
		deleteitem.connect("activate", __menuClick__, parent, tab, "Delete", filename)
		deleteitem.add(__createMenuItem__("Delete " + os.path.basename(filename), "delete"))
		menu.attach(deleteitem, 0,1,10,11)

	menu.show_all()
	menu.popup(None, None, None, event.button, event.get_time())


def __menuClick__(menuitem, parent, tab, item_name, location, mime=None):
	'''This functions handles the callbacks for the icon right click menu'''

	if item_name == "Mount":
		status, output = commands.getstatusoutput("mount " + location)
		if status != 0:
			tab.setInfoBarText(output,"ERROR")
		else:
			tab.setInfoBarText("Mounted " + os.path.basename(location),"INFO")

	elif item_name == "Unmount":
		status, output = commands.getstatusoutput("umount " + location)
		if status != 0:
			tab.setInfoBarText(output,"ERROR")
		else:
			tab.setInfoBarText("Unmounted " + os.path.basename(location),"INFO")

	elif item_name == "Eject":
		status, output = commands.getstatusoutput("eject " + location)
		if status != 0:
			tab.setInfoBarText(output,"ERROR")
		else:
			tab.setInfoBarText("Ejected " + os.path.basename(location),"INFO")				

	# This section handles attempting to open a file with it's default program
	elif item_name == "Open":
		if os.path.isdir(location):
			if os.access(location, os.R_OK):
				parent.__populate__(location)
			else:
				tab.setInfoBarText("You Don't Have Permission To Enter " + os.path.basename(location) + "ERROR")
			return 0

		associated_applications = mimetype.get_associated_applications(mime)
		if associated_applications in [[],["EXECUTABLE"]]:
			if os.access(location, os.X_OK):
				try:
					os.popen2( __returnClean__(location))
				except:
					tab.setInfoBarText("Can't Execute " + location,"ERROR")					
		elif len(associated_applications) == 0:
			tab.setInfoBarText("No Associated Applications To Open " + os.path.basename(location),"ERROR")
		else:
			try:
				os.popen2(associated_applications[0] + " " + __returnClean__(location))
			except:
				tab.setInfoBarText("Can't Open "+location+" With "+associated_applications[0], "ERROR")

	# This selection  opens a new tab at the directory the mouse is over
	elif item_name == "Open Tab":
		if os.access(location, os.R_OK):
			tab.Notebook.newNotebookPage(location)

	elif item_name == "Delete":
		tab._deleteFile_(location)

	elif item_name == "Archive":
		# Create a window to say what is happening
		filename = __returnClean__(os.path.basename(location))
		notice = gtk.Window(gtk.WINDOW_POPUP)
		label = gtk.Label("Archiving " + filename)
		notice.add(label)
		label.show()
		notice.set_size_request(150, 30)
		x,y = tab.__getMousePosition__()
		notice.move(x+20, y)
		notice.show_all()

		while gtk.events_pending():
			gtk.main_iteration()

		# Archive the file
		if tab.archive_command == "zip":
			os.system("zip -r " + filename + ".zip " + filename)
		else:
			os.system("tar -cvf " + filename + ".tar " +  filename)
			os.system(tab.archive_command + " " + filename + ".tar ")
			
		tab.setInfoBarText("Archived " + os.path.basename(location),"INFO")			
			
		# Destroy the window and relist the window
		notice.destroy()
		#parent.__populate__()

	elif item_name == "Edit Mimetype":
		# Open the Mimetype Editor
		mimetype.editor(location, mime[0], mime[1],IMAGE_DIRECTORY)

	elif item_name == "Properties":
		# Open the properties dialog
		properties.set(IMAGE_DIRECTORY, string.split(parent.__getSelectedFiles__(), "\t"))

	elif item_name == "Other":
		# Opens the file dialog box to get an application
		file_chooser = gtk.FileChooserDialog("Choose Application", None, gtk.FILE_CHOOSER_ACTION_OPEN, ("Select",0, "Cancel",1))
		answer = file_chooser.run()

		if answer == 0:
			executable =  file_chooser.get_filename()

			try:
				os.popen2(executable + " " + __returnClean__(location))
			except:
				tab.setInfoBarText("Can't Open " + os.path.basename(location) + " With " + item_name,"ERROR")

		file_chooser.destroy()

	elif item_name == "Copy":
		clipboard.set_text(parent.__getSelectedFiles__())

	elif item_name == "Cut":
		if os.access(location, os.W_OK):
			clipboard.set_text(parent.__getSelectedFiles__())	

	elif item_name == "Paste":
		if os.access(location, os.W_OK) and os.path.isdir(location):
			drop_location = location
			dropped_files = clipboard.wait_for_text().split( "\t")
			dropped_files.pop()
			x,y = tab.__getMousePosition__()
			for start_location in dropped_files:
				if os.path.exists(start_location):
					filename = os.path.basename(start_location)
					file_mover.move("copy", x, y, "Pasting " + filename, start_location, location)
				else:
					tab.setInfoBarText("File Does Not Exist"  + os.path.basename(start_location) ,"ERROR")
			clipboard.clear()

	# This section handles open the file with a selected application
	else:
		try:
			os.popen2(item_name + " " + __returnClean__(location))
		except:
			tab.setInfoBarText("Can't Open " + os.path.basename(location) + " With " + item_name,"ERROR")


############################## LAYOUT MENU ##############################

def layout(parent, event):
	'''This function of this module creates a menu for a right click on the layout.'''
	if os.access(os.getcwd(), os.R_OK):
		layout_menu = gtk.Menu()

		# Create an show hidden item
		if parent.tab.show_hidden == False:
			text = "Show Hidden Files"
		else:
			text = "Hide Hidden Files"
		show_item = gtk.MenuItem()
		show_item.add(__createMenuItem__(text, "folder"))
		show_item.connect("activate", __layoutMenuClick__, "Show", parent)	
		layout_menu.attach(show_item, 0,1,0,1)	

		# Create a select all button
		select_item = gtk.MenuItem()
		select_item.add(__createMenuItem__("Select All", "folder"))
		select_item.connect("activate", __layoutMenuClick__, "Select_All", parent)	
		layout_menu.attach(select_item, 0,1,1,2)				
	
		# Create a new folder option
		if os.access(os.getcwd(), os.W_OK):
			# Create a Paste item
			pasteitem = gtk.MenuItem()
			pasteitem .connect("activate", __menuClick__, parent, parent.tab, "Paste", os.getcwd())
			pasteitem .add(__createMenuItem__("Paste", "paste"))
			layout_menu.attach(pasteitem , 0,1,2,3)
		
			# Create an new directory item
			directory_item = gtk.MenuItem()
			directory_item.add(__createMenuItem__("Create New Directory", "folder"))
			directory_item.connect("activate", __layoutMenuClick__, "Directory", parent)	
			layout_menu.attach(directory_item, 0,1,3,4)

			# A separator seems good here
			separatoritem =  gtk.SeparatorMenuItem()
			layout_menu.attach(separatoritem, 0,1,4,5)

			# Create an send to trash item
			trash_item = gtk.MenuItem()
			trash_item.add(__createMenuItem__("Send Selected Files to Trash", "trash"))
			trash_item.connect("activate", __layoutMenuClick__, "Trash", parent)
			layout_menu.attach(trash_item, 0,1,5,6)

		layout_menu.show_all()
		layout_menu.popup(None, None, None, event.button, event.get_time())


def __layoutMenuClick__(menu_item, selection, parent):
	'''This function handles selection from the layout right click menu'''

	location = os.getcwd()

	# Try and create a new directory
	if selection == "Directory":
		try:
			for x in range(100):
				if not os.path.exists(location + "/a_new_folder_" + str(x)):
					os.mkdir(location + "/a_new_folder_" + str(x))
					name = location + "/a_new_folder_" + str(x)
					break

			# Open the properties dialog
			properties.set(IMAGE_DIRECTORY, [name, ""])

		except:
			parent.tab.setInfoBarText("Can't Create Directory In " + os.path.basename(os.getcwd()), "ERROR")

	# Select all the files and folders
	elif selection == "Select_All":
		parent.selectAll()

	# Move the selected files into the ..Wastebasket file
	elif selection == "Trash":
		if not os.path.exists(os.environ['HOME'] + "/..Wastebasket"):
			os.mkdir(os.environ['HOME'] + "/..Wastebasket")

		selected_icons = parent.__getSelectedFiles__()
		selected_icons = selected_icons.split("\t")
		selected_icons.pop()

		x,y = parent.tab.__getMousePosition__()

		for icon in selected_icons:
			file_mover.move( "move", x, y, "Moving " + os.path.basename(icon) + "to ..Wastebasket", icon, os.environ['HOME'] + "/..Wastebasket")
		parent.tab.setInfoBarText(os.path.basename(icon) + " moved to ..Wastebasket.", "INFO")

	elif selection == "Show":
		if parent.tab.show_hidden == True:
			parent.tab.show_hidden = False
		else:
			parent.tab.show_hidden = True
		parent.__populate__()


############################## DROP MENU ##############################

def drop(tab, timestamp, dropped_files, drop_location):
	'''This function creates the drag and drop, drop menu' (Copy, Move, Link)'''
	
	# Get the dropped files
	files = dropped_files.split("\t")
	files.pop()
	locations = files[:]

	for location in locations:
		# First check for valid files (they exist, aren't links and you have permission)
		if not os.path.exists(location):
			tab.setInfoBarText(os.path.basename(location) + " Does Not Exist", "ERROR")
			files.remove(location)

		elif os.path.islink(location):
			tab.setInfoBarText(os.path.basename(location) + " Is A Link", "ERROR")
			files.remove(location)

		elif location == drop_location:
			files.remove(location)
			tab.setInfoBarText("You Can't Drop " + os.path.basename(location)+" Onto Itself", "ERROR")

		elif os.path.basename(location) in os.listdir(drop_location):
			# x,y = tab.__getMousePosition__()
			# Get the center of the widget
			main_window = tab.main_notebook.get_toplevel()
			x, y = main_window.get_position()
			x = x+int(main_window.allocation.width/2)
			y = y+int(main_window.allocation.height/2)
			
			# Use the over write dialog and then respond
			answer = overwrite_dialog.create(x, y, os.path.basename(location))

			if answer == "yes":
				if os.path.islink(drop_location + "/" + os.path.basename(location)):
					os.unlink(drop_location + "/" + os.path.basename(location))
				elif os.path.isdir(drop_location + "/" + os.path.basename(location)):
					shutil.rmtree(drop_location + "/" + os.path.basename(location))
				else:
					os.remove(drop_location + "/" + os.path.basename(location))
			else:
				files.remove(location)

	if len(files) == 0:
		#tab.setInfoBarText("No Valid Files Selected To Move", "ERROR")
		return 1

	menu = gtk.Menu()

	copyitem = gtk.MenuItem("Copy")
	cutitem = gtk.MenuItem("Move")
	linkitem = gtk.MenuItem("Link")

	copyitem.connect("activate", __dropMenuCallback__, "Copy", tab, files, drop_location)
	cutitem.connect("activate", __dropMenuCallback__, "Move", tab, files, drop_location)
	linkitem.connect("activate", __dropMenuCallback__, "Link", tab, files, drop_location)
		
	menu.attach(copyitem, 0,1,0,1)
	menu.attach(cutitem, 0,1,1,2)
	menu.attach(linkitem, 0,1,2,3)

	menu.show_all()
	menu.popup(None, None, None, 0, timestamp)

def __dropMenuCallback__(menu_item, move_type, tab, dropped_files, drop_location):
	'''This function is the callback for the drop menu'''

	x, y = tab.__getMousePosition__()

	# If valid files still exist, then move them
	if move_type == "Copy":
		for location in dropped_files:
			file_mover.move( "copy", x, y, "Copying " + os.path.basename(location), location, drop_location)
	elif move_type == "Move":
		for location in dropped_files:	
			file_mover.move( "move", x, y, "Copying " + os.path.basename(location), location, drop_location)
	elif move_type == "Link":
		for location in dropped_files:
			os.symlink(location, drop_location + "/" + os.path.basename(location))


	############################## FUNCTIONS ##############################

def __createMenuItem__(name, icon):
	'''This function creates menu items'''

	image = gtk.Image()
	pixbuf = gtk.gdk.pixbuf_new_from_file(IMAGE_DIRECTORY + "/Menu/"+ icon + ".png")
	image.set_from_pixbuf(pixbuf)
	label = gtk.Label("  " + name)

	box = gtk.HBox()	
	box.pack_start(image, False)
	box.pack_start(label, False, True)

	return box

def __returnClean__(text):
	'''This function returns Bash script command line friendly text'''	

	bad_chars = [" ","\'","&","(",")"]
	good_chars=["\ ","\\'","\&","\(","\)"]

	# Replace the bad with the good
	for x in range(len(bad_chars)):
		text = string.replace(text, bad_chars[x], good_chars[x])		
		
	# Return the "cleaned", BASH friendly text
	return text
